/*
 * Decompiled with CFR 0.152.
 */
package org.apache.velocity.spring;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.Arrays;
import org.apache.velocity.exception.ResourceNotFoundException;
import org.apache.velocity.runtime.resource.Resource;
import org.apache.velocity.util.ExtProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StringUtils;

public class SpringResourceLoader
extends org.apache.velocity.runtime.resource.loader.ResourceLoader {
    public static final String NAME = "spring";
    public static final String SPRING_RESOURCE_LOADER_CLASS = "spring.resource.loader.class";
    public static final String SPRING_RESOURCE_LOADER_CACHE = "spring.resource.loader.cache";
    public static final String SPRING_RESOURCE_LOADER = "spring.resource.loader";
    public static final String SPRING_RESOURCE_LOADER_PATH = "spring.resource.loader.path";
    protected final Logger logger = LoggerFactory.getLogger(((Object)((Object)this)).getClass());
    private ResourceLoader resourceLoader;
    private String[] resourceLoaderPaths;

    public void init(ExtProperties configuration) {
        this.resourceLoader = (ResourceLoader)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER);
        String resourceLoaderPath = (String)this.rsvc.getApplicationAttribute((Object)SPRING_RESOURCE_LOADER_PATH);
        if (this.resourceLoader == null) {
            throw new IllegalArgumentException("'resourceLoader' application attribute must be present for SpringResourceLoader");
        }
        if (resourceLoaderPath == null) {
            throw new IllegalArgumentException("'resourceLoaderPath' application attribute must be present for SpringResourceLoader");
        }
        this.resourceLoaderPaths = StringUtils.commaDelimitedListToStringArray((String)resourceLoaderPath);
        for (int i = 0; i < this.resourceLoaderPaths.length; ++i) {
            String path = this.resourceLoaderPaths[i];
            if (path.endsWith("/")) continue;
            this.resourceLoaderPaths[i] = path + "/";
        }
        if (this.logger.isInfoEnabled()) {
            this.logger.info("SpringResourceLoader for Velocity: using resource loader [{}] and resource loader paths {}", (Object)this.resourceLoader, Arrays.asList(this.resourceLoaderPaths));
        }
    }

    public Reader getResourceReader(String source, String encoding) throws ResourceNotFoundException {
        this.logger.debug("Looking for Velocity resource with name [{}]", (Object)source);
        for (String resourceLoaderPath : this.resourceLoaderPaths) {
            org.springframework.core.io.Resource resource = this.resourceLoader.getResource(resourceLoaderPath + source);
            try {
                if (resource == null) continue;
                return new InputStreamReader(resource.getInputStream(), encoding);
            }
            catch (IOException ex) {
                this.logger.debug("Could not find Velocity resource: {}", (Object)resource);
            }
        }
        throw new ResourceNotFoundException("Could not find resource [" + source + "] in Spring resource loader path");
    }

    public boolean isSourceModified(Resource resource) {
        return false;
    }

    public long getLastModified(Resource resource) {
        return 0L;
    }
}

