/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.core.stream.serializer.writer;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;
import org.apache.axiom.core.stream.serializer.writer.UnmappableCharacterHandler;
import org.apache.axiom.core.stream.serializer.writer.XmlWriter;
import org.apache.axiom.util.base64.AbstractBase64EncodingOutputStream;

final class OutputStreamXmlWriter
extends XmlWriter {
    private final OutputStream out;
    private final CharBuffer encoderIn;
    private final ByteBuffer encoderOut;
    private final CharsetEncoder encoder;
    private UnmappableCharacterHandler unmappableCharacterHandler = UnmappableCharacterHandler.THROW_EXCEPTION;
    private boolean processingUnmappableCharacter;
    private CharBuffer encoderInAlt;

    OutputStreamXmlWriter(OutputStream out, Charset charset) {
        this.out = out;
        this.encoderIn = CharBuffer.allocate(4096);
        this.encoderOut = ByteBuffer.allocate(4096);
        this.encoder = charset.newEncoder();
    }

    private void flushEncodingOut() throws IOException {
        this.out.write(this.encoderOut.array(), 0, this.encoderOut.position());
        ((Buffer)this.encoderOut).clear();
    }

    private CharBuffer getEncoderIn() throws IOException {
        if (this.processingUnmappableCharacter) {
            if (this.encoderInAlt == null) {
                this.encoderInAlt = CharBuffer.allocate(64);
            }
            return this.encoderInAlt;
        }
        return this.encoderIn;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void flush(CharBuffer encoderIn) throws IOException {
        ((Buffer)encoderIn).flip();
        while (true) {
            CoderResult coderResult;
            if ((coderResult = this.encoder.encode(encoderIn, this.encoderOut, false)).isUnderflow()) {
                encoderIn.compact();
                return;
            }
            if (coderResult.isOverflow()) {
                this.flushEncodingOut();
                continue;
            }
            if (!coderResult.isUnmappable()) throw new IOException("Malformed character sequence");
            if (this.processingUnmappableCharacter) {
                throw new IllegalStateException();
            }
            this.processingUnmappableCharacter = true;
            try {
                switch (coderResult.length()) {
                    case 1: {
                        this.unmappableCharacterHandler.processUnmappableCharacter(encoderIn.get(), this);
                        break;
                    }
                    case 2: {
                        throw new UnsupportedOperationException("TODO");
                    }
                    default: {
                        throw new IllegalStateException();
                    }
                }
                this.flush(this.encoderInAlt);
                continue;
            }
            finally {
                this.processingUnmappableCharacter = false;
                continue;
            }
            break;
        }
    }

    @Override
    public void setUnmappableCharacterHandler(UnmappableCharacterHandler unmappableCharacterHandler) throws IOException {
        if (unmappableCharacterHandler != this.unmappableCharacterHandler) {
            this.flush(this.encoderIn);
            this.unmappableCharacterHandler = unmappableCharacterHandler;
        }
    }

    @Override
    public void write(char c) throws IOException {
        CharBuffer encoderIn = this.getEncoderIn();
        if (!encoderIn.hasRemaining()) {
            this.flush(encoderIn);
        }
        encoderIn.put(c);
    }

    @Override
    public void write(String src) throws IOException {
        int c;
        CharBuffer encoderIn = this.getEncoderIn();
        int offset = 0;
        for (int length = src.length(); length > 0; length -= c) {
            if (!encoderIn.hasRemaining()) {
                this.flush(encoderIn);
            }
            c = Math.min(length, encoderIn.remaining());
            encoderIn.put(src, offset, length);
            offset += c;
        }
    }

    @Override
    public void write(char[] src, int offset, int length) throws IOException {
        CharBuffer encoderIn = this.getEncoderIn();
        while (length > 0) {
            if (!encoderIn.hasRemaining()) {
                this.flush(encoderIn);
            }
            int c = Math.min(length, encoderIn.remaining());
            encoderIn.put(src, offset, length);
            offset += c;
            length -= c;
        }
    }

    @Override
    public AbstractBase64EncodingOutputStream getBase64EncodingOutputStream() {
        return new AbstractBase64EncodingOutputStream(){

            @Override
            protected void doWrite(byte[] b) throws IOException {
                CharBuffer encoderIn = OutputStreamXmlWriter.this.getEncoderIn();
                if (encoderIn.remaining() < 4) {
                    OutputStreamXmlWriter.this.flush(encoderIn);
                }
                for (int i = 0; i < 4; ++i) {
                    encoderIn.put((char)(b[i] & 0xFF));
                }
            }

            @Override
            protected void flushBuffer() throws IOException {
            }

            @Override
            protected void doFlush() throws IOException {
            }

            @Override
            protected void doClose() throws IOException {
            }
        };
    }

    @Override
    public void flushBuffer() throws IOException {
        this.flush(this.encoderIn);
        this.flushEncodingOut();
    }
}

