/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.MalformedURLException;
import javax.xml.namespace.QName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DirectoryScanner;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.woden.ErrorHandler;
import org.apache.woden.WSDLException;
import org.apache.woden.WSDLFactory;
import org.apache.woden.WSDLReader;
import org.apache.woden.ant.Report;
import org.apache.woden.ant.WsdlCm;
import org.apache.woden.wsdl20.Binding;
import org.apache.woden.wsdl20.Description;
import org.apache.woden.wsdl20.ElementDeclaration;
import org.apache.woden.wsdl20.Interface;
import org.apache.woden.wsdl20.Service;
import org.apache.woden.wsdl20.TypeDefinition;

public class ValidateWSDL20
extends MatchingTask {
    private File dir;
    private boolean failOnError = false;
    private boolean verbose = false;
    private boolean cm = false;
    private File cmdir;
    private String cmext;
    private File report;
    private Report reportWriter;
    private String catalog;
    private String baseURI;
    private String implName;
    private static final String CMEXT_DEFAULT = ".wsdlcm";
    private static final Log logger = LogFactory.getLog(ValidateWSDL20.class);

    public File getDir() {
        return this.dir;
    }

    public void setDir(File dir) {
        this.dir = dir;
    }

    public void setFailOnError(boolean failOnError) {
        this.failOnError = failOnError;
    }

    public boolean isFailOnError() {
        return this.failOnError;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setCm(boolean cm) {
        this.cm = cm;
    }

    public boolean isCm() {
        return this.cm;
    }

    public void setCmdir(File cmdir) {
        this.cmdir = cmdir;
    }

    public File getCmdir() {
        return this.cmdir;
    }

    public void setCmext(String cmext) {
        this.cmext = cmext;
    }

    public String getCmext() {
        return this.cmext;
    }

    public File getReport() {
        return this.report;
    }

    public void setReport(File report) {
        this.report = report;
    }

    public void setImplName(String implName) {
        this.implName = implName;
    }

    public void execute() throws BuildException {
        if (this.isCm()) {
            String cmext;
            File cmdir = this.getCmdir();
            if (cmdir == null) {
                cmdir = this.getDir();
                this.setCmdir(cmdir);
            }
            if (!cmdir.isDirectory()) {
                logger.info((Object)("Invalid cm output directory: " + cmdir.toString()));
                this.setCm(false);
            }
            if ((cmext = this.getCmext()) == null) {
                this.setCmext(CMEXT_DEFAULT);
            }
        }
        WSDLReader reader = null;
        try {
            WSDLFactory factory;
            if (this.implName != null && !this.implName.equals("")) {
                logger.info((Object)("Using woden with implementation from " + this.implName));
                factory = WSDLFactory.newInstance((String)this.implName);
                reader = factory.newWSDLReader();
            } else {
                logger.info((Object)"Using default woden implementation.");
                factory = WSDLFactory.newInstance();
                reader = factory.newWSDLReader();
            }
        }
        catch (WSDLException e) {
            throw new BuildException((Throwable)e);
        }
        try {
            reader.setFeature("http://ws.apache.org/woden/features/validation", true);
            reader.setFeature("http://ws.apache.org/woden/features/verbose", this.isVerbose());
            reader.setFeature("http://ws.apache.org/woden/features/continue_on_error", !this.isFailOnError());
        }
        catch (IllegalArgumentException e) {
            logger.warn((Object)("warning: " + e.getMessage()));
        }
        if (this.isVerbose()) {
            logger.info((Object)("File dir = " + this.dir.getAbsolutePath()));
            Project project = this.getProject();
            File baseDir = project.getBaseDir();
            logger.info((Object)("File baseDir = " + baseDir.getAbsolutePath()));
        }
        DirectoryScanner directoryScanner = this.getDirectoryScanner(this.dir);
        String[] files = directoryScanner.getIncludedFiles();
        this.reportWriter = Report.openReport(this.report);
        reader.getErrorReporter().setErrorHandler((ErrorHandler)this.reportWriter);
        for (int i = 0; i < files.length; ++i) {
            block16: {
                File file = new File(this.dir, files[i]);
                String wsdlLoc = file.toURI().toString();
                logger.info((Object)("validating " + wsdlLoc));
                this.reportWriter.beginWsdl(wsdlLoc);
                try {
                    Description descComp = reader.readWSDL(wsdlLoc);
                    if (this.isCm()) {
                        this.writeCm(descComp, files[i]);
                    }
                    if (this.isVerbose()) {
                        this.writeVerbose(descComp);
                    }
                }
                catch (Exception e) {
                    if (!this.isFailOnError()) break block16;
                    this.reportWriter.endWsdl();
                    this.reportWriter.closeReport();
                    throw new BuildException((Throwable)e);
                }
            }
            this.reportWriter.endWsdl();
        }
        this.reportWriter.closeReport();
    }

    private void writeVerbose(Description descComp) {
        ElementDeclaration[] elementDeclarations = descComp.getElementDeclarations();
        logger.info((Object)("There are " + elementDeclarations.length + " ElementDeclaration components."));
        for (int j = 0; j < elementDeclarations.length; ++j) {
            ElementDeclaration elementDeclaration = elementDeclarations[j];
            QName name = elementDeclaration.getName();
            logger.info((Object)("ElementDeclaration[" + j + "] : name = " + name));
        }
        TypeDefinition[] typeDefinitions = descComp.getTypeDefinitions();
        logger.info((Object)("There are " + typeDefinitions.length + " TypeDefinition components."));
        for (int j = 0; j < typeDefinitions.length; ++j) {
            TypeDefinition typeDefinition = typeDefinitions[j];
            QName name = typeDefinition.getName();
            logger.info((Object)("TypeDefinition[" + j + "] : name = " + name));
        }
        Interface[] interfaces = descComp.getInterfaces();
        logger.info((Object)("There are " + interfaces.length + " Interface components."));
        for (int j = 0; j < interfaces.length; ++j) {
            logger.info((Object)("Interface[" + j + "] : name = " + interfaces[j].getName()));
        }
        Binding[] bindings = descComp.getBindings();
        logger.info((Object)("There are " + bindings.length + " Binding components."));
        for (int j = 0; j < bindings.length; ++j) {
            logger.info((Object)("Binding[" + j + "] : name = " + bindings[j].getName()));
        }
        Service[] services = descComp.getServices();
        logger.info((Object)("There are " + services.length + " Service components."));
        for (int j = 0; j < services.length; ++j) {
            logger.info((Object)("Service[" + j + "] : name = " + services[j].getName()));
        }
    }

    private void writeCm(Description descComp, String file) throws IOException {
        boolean created;
        int dot = file.lastIndexOf(46);
        String base = dot == -1 ? file : file.substring(0, dot);
        String ext = this.getCmext();
        String cmfilename = base + ext;
        File cmfile = new File(this.cmdir, cmfilename);
        File parent = cmfile.getParentFile();
        if (parent != null && !parent.exists() && !(created = parent.mkdirs())) {
            logger.warn((Object)("Unable to create directory: " + parent.toString()));
        }
        FileOutputStream fos = new FileOutputStream(cmfile);
        PrintWriter out = new PrintWriter(fos);
        WsdlCm wsdlCm = new WsdlCm(out);
        wsdlCm.write(descComp);
        out.close();
        fos.close();
    }

    public void setCatalog(String catalog) {
        this.catalog = this.getURLFilePath(catalog);
        System.setProperty("org.apache.woden.resolver.simpleresolver.catalog", this.catalog);
    }

    public void setBaseURI(String baseURI) {
        this.baseURI = this.getURLFilePath(baseURI);
        System.setProperty("org.apache.woden.resolver.simpleresolver.baseURIs", this.baseURI);
    }

    private String getURLFilePath(String localPath) {
        File localFile = new File(localPath);
        if (localFile.exists()) {
            try {
                return localFile.toURI().toURL().toString();
            }
            catch (MalformedURLException mue) {
                logger.error((Object)("Got MalformedURLException trying to create a URL from " + localPath));
                return localPath;
            }
        }
        return localPath;
    }
}

