/*
 * Decompiled with CFR 0.152.
 */
package org.apache.woden.ant.task;

import java.io.IOException;
import javax.wsdl.WSDLException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.taskdefs.MatchingTask;
import org.apache.woden.tool.converter.Convert;

public class ConverterTask
extends MatchingTask {
    private String wsdl;
    private String targetNS;
    private String targetDir;
    private String sourceDir;
    private boolean verbose;
    private boolean overwrite;
    private static final Log logger = LogFactory.getLog(ConverterTask.class);

    public void execute() throws BuildException {
        if (this.wsdl != null && !"".equals(this.wsdl)) {
            String[] wsdlFiles = this.wsdl.split(",");
            for (int i = 0; i < wsdlFiles.length; ++i) {
                if (wsdlFiles[i] == null || "".equals(wsdlFiles[i])) continue;
                this.convertEachFile(wsdlFiles[i].trim());
            }
        }
    }

    private void convertEachFile(String wsdlFile) {
        long startTime = System.currentTimeMillis();
        if (this.wsdl != null) {
            try {
                Convert convert = new Convert();
                convert.convertFile(this.targetNS, wsdlFile, this.targetDir, this.verbose, this.overwrite);
            }
            catch (WSDLException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
            catch (IOException e) {
                throw new BuildException(e.getMessage(), (Throwable)e);
            }
        } else {
            logger.info((Object)"No WSDL 1.1 document was specified (use the '-wsdl' argument.)");
        }
        long endTime = System.currentTimeMillis();
        if (this.verbose) {
            logger.info((Object)("Done.\nElapsed time: " + (endTime - startTime) + "ms"));
        }
    }

    public String getWsdl() {
        return this.wsdl;
    }

    public void setWsdl(String wsdl) {
        this.wsdl = wsdl;
    }

    public String getTargetNS() {
        return this.targetNS;
    }

    public void setTargetNS(String targetNS) {
        this.targetNS = targetNS;
    }

    public String getTargetDir() {
        return this.targetDir;
    }

    public void setTargetDir(String targetDir) {
        this.targetDir = targetDir;
    }

    public String getSourceDir() {
        return this.sourceDir;
    }

    public void setSourceDir(String sourceDir) {
        this.sourceDir = sourceDir;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }
}

