/*
 * Decompiled with CFR 0.152.
 */
import java.applet.Applet;
import java.awt.Button;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.transform.ErrorListener;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public final class TransformApplet
extends Applet {
    TransformerFactory tf;
    TransformDelegate transformThread;

    public synchronized String transform(Object arg1, Object arg2) {
        String stylesheetURL = (String)arg1;
        String documentURL = (String)arg2;
        this.transformThread.setStylesheetURL(stylesheetURL);
        this.transformThread.setDocumentURL(documentURL);
        this.transformThread.setWaiting(false);
        this.transformThread.wakeUp();
        try {
            this.wait();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.transformThread.getOutput();
    }

    @Override
    public void start() {
        this.transform(this.getParameter("stylesheet-name"), this.getParameter("input-document"));
    }

    @Override
    public void destroy() {
        this.transformThread.destroy();
    }

    @Override
    public void init() {
        this.tf = TransformerFactory.newInstance();
        try {
            this.tf.setAttribute("use-classpath", Boolean.TRUE);
        }
        catch (IllegalArgumentException iae) {
            System.err.println("Could not set XSLTC-specific TransformerFactory attributes.  Transformation failed.");
        }
        this.transformThread = new TransformDelegate(true);
        Thread t = new Thread(this.transformThread);
        t.setName("transformThread");
        t.start();
    }

    public String getOutput() {
        return this.transformThread.getOutput();
    }

    public synchronized void wakeUp() {
        this.notifyAll();
    }

    class TransformDelegate
    implements Runnable {
        private boolean isRunning;
        private boolean isWaiting;
        private String stylesheetURL;
        private String documentURL;
        private String outPut;

        public TransformDelegate(boolean arg) {
            this.isRunning = arg;
            this.isWaiting = true;
        }

        @Override
        public synchronized void run() {
            while (this.isRunning) {
                while (this.isWaiting) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                this.transform();
                this.isWaiting = true;
                TransformApplet.this.wakeUp();
            }
        }

        public void setStylesheetURL(String arg) {
            this.stylesheetURL = arg;
        }

        public void setDocumentURL(String arg) {
            this.documentURL = arg;
        }

        public String getStylesheetURL() {
            return this.stylesheetURL;
        }

        public String getDocumentURL() {
            return this.documentURL;
        }

        public void setWaiting(boolean arg) {
            this.isWaiting = arg;
        }

        public void destroy() {
            this.isRunning = false;
        }

        public synchronized void wakeUp() {
            this.notifyAll();
        }

        public String getOutput() {
            return this.outPut;
        }

        public void transform() {
            String xslURL = this.getStylesheetURL();
            String docURL = this.getDocumentURL();
            StringWriter sout = new StringWriter();
            PrintWriter out = new PrintWriter(sout);
            try {
                if (xslURL == null || docURL == null) {
                    out.println("<h1>Transformation error</h1>");
                    out.println("The parameters <b><tt>stylesheetURL</tt></b> and <b><tt>source</tt></b> must be specified");
                } else {
                    Transformer t = TransformApplet.this.tf.newTransformer(new StreamSource(xslURL));
                    t.setErrorListener(new AppletErrorListener());
                    long start = System.currentTimeMillis();
                    t.transform(new StreamSource(docURL), new StreamResult(out));
                    long done = System.currentTimeMillis() - start;
                    out.println("<!-- transformed by XSLTC in " + done + "msecs -->");
                }
                out.close();
                System.err.println("Transformation complete!");
                System.err.println(sout.toString());
                this.outPut = sout.toString();
                sout.close();
            }
            catch (RuntimeException e) {
                out.println("<h1>RTE</h1>");
                out.close();
                this.outPut = sout.toString();
            }
            catch (Exception e) {
                out.println("<h1>exception</h1>");
                out.println(e.toString());
                out.close();
                this.outPut = sout.toString();
            }
        }
    }

    public class AppletErrorListener
    implements ErrorListener {
        public void displayMessage(TransformerException e) {
            MessageFrame z = new MessageFrame("XSL transformation alert", e.getMessageAndLocation());
        }

        @Override
        public void error(TransformerException e) {
            this.displayMessage(e);
        }

        @Override
        public void fatalError(TransformerException e) {
            this.displayMessage(e);
        }

        @Override
        public void warning(TransformerException e) {
            this.displayMessage(e);
        }
    }

    public class MessageFrame
    extends Frame {
        public Frame frame;

        public MessageFrame(String title, String message) {
            super(title);
            this.frame = this;
            this.setSize(320, 200);
            Panel center = new Panel();
            center.add(new Label(message));
            Panel bottom = new Panel();
            Button okButton = new Button("   OK   ");
            okButton.addActionListener(new ButtonHandler());
            bottom.add(okButton);
            this.add((Component)center, "Center");
            this.add((Component)bottom, "South");
            this.setVisible(true);
        }

        public class ButtonHandler
        implements ActionListener {
            @Override
            public void actionPerformed(ActionEvent e) {
                MessageFrame.this.frame.setVisible(false);
            }
        }
    }
}

