/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.IOException;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;

public class SequenceRandomAccessRead
implements RandomAccessRead {
    private final List<RandomAccessRead> readerList;
    private final long[] startPositions;
    private final long[] endPositions;
    private final int numberOfReader;
    private int currentIndex = 0;
    private long currentPosition = 0L;
    private long totalLength = 0L;
    private boolean isClosed = false;
    private RandomAccessRead currentRandomAccessRead = null;

    public SequenceRandomAccessRead(List<RandomAccessRead> randomAccessReadList) {
        if (randomAccessReadList == null) {
            throw new IllegalArgumentException("Missing input parameter");
        }
        if (randomAccessReadList.isEmpty()) {
            throw new IllegalArgumentException("Empty list");
        }
        this.readerList = randomAccessReadList.stream().filter(r -> {
            try {
                return r.length() > 0L;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problematic list", e);
            }
        }).collect(Collectors.toList());
        this.currentRandomAccessRead = this.readerList.get(this.currentIndex);
        this.numberOfReader = this.readerList.size();
        this.startPositions = new long[this.numberOfReader];
        this.endPositions = new long[this.numberOfReader];
        for (int i = 0; i < this.numberOfReader; ++i) {
            try {
                this.startPositions[i] = this.totalLength;
                this.totalLength += this.readerList.get(i).length();
                this.endPositions[i] = this.totalLength - 1L;
                continue;
            }
            catch (IOException e) {
                throw new IllegalArgumentException("Problematic list", e);
            }
        }
    }

    @Override
    public void close() throws IOException {
        for (RandomAccessRead randomAccessRead : this.readerList) {
            randomAccessRead.close();
        }
        this.readerList.clear();
        this.currentRandomAccessRead = null;
        this.isClosed = true;
    }

    private RandomAccessRead getCurrentReader() throws IOException {
        if (this.currentRandomAccessRead.isEOF() && this.currentIndex < this.numberOfReader - 1) {
            ++this.currentIndex;
            this.currentRandomAccessRead = this.readerList.get(this.currentIndex);
            this.currentRandomAccessRead.seek(0L);
        }
        return this.currentRandomAccessRead;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        RandomAccessRead randomAccessRead = this.getCurrentReader();
        int value = randomAccessRead.read();
        if (value > -1) {
            ++this.currentPosition;
        }
        return value;
    }

    @Override
    public int read(byte[] b, int offset, int length) throws IOException {
        int bytesRead;
        this.checkClosed();
        int maxAvailBytes = Math.min(this.available(), length);
        if (maxAvailBytes == 0) {
            return -1;
        }
        RandomAccessRead randomAccessRead = this.getCurrentReader();
        for (bytesRead = randomAccessRead.read(b, offset, maxAvailBytes); bytesRead > -1 && bytesRead < maxAvailBytes; bytesRead += randomAccessRead.read(b, offset + bytesRead, maxAvailBytes - bytesRead)) {
            randomAccessRead = this.getCurrentReader();
        }
        this.currentPosition += (long)bytesRead;
        return bytesRead;
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.currentPosition;
    }

    @Override
    public void seek(long position) throws IOException {
        this.checkClosed();
        if (position < 0L) {
            throw new IOException("Invalid position " + position);
        }
        if (position >= this.totalLength) {
            this.currentIndex = this.numberOfReader - 1;
            this.currentPosition = this.totalLength;
        } else {
            int increment = position < this.currentPosition ? -1 : 1;
            for (int i = this.currentIndex; i < this.numberOfReader && i >= 0; i += increment) {
                if (position < this.startPositions[i] || position > this.endPositions[i]) continue;
                this.currentIndex = i;
                break;
            }
            this.currentPosition = position;
        }
        this.currentRandomAccessRead = this.readerList.get(this.currentIndex);
        this.currentRandomAccessRead.seek(this.currentPosition - this.startPositions[this.currentIndex]);
    }

    @Override
    public long length() throws IOException {
        this.checkClosed();
        return this.totalLength;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException("RandomAccessBuffer already closed");
        }
    }

    @Override
    public boolean isEOF() throws IOException {
        this.checkClosed();
        return this.currentPosition >= this.totalLength;
    }

    @Override
    public RandomAccessReadView createView(long startPosition, long streamLength) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName() + ".createView isn't supported.");
    }
}

