#!BPY
"""
Name: 'Geodesic_Domes'
Blender: 248
Group: 'Wizards'
Tip: 'Create Geodesic objects'
"""
__author__ = 'andy houston (serendipiti)'
__version__ = '2.0a'
__url__ = ("http://members.aol.com/demalion2/index.html" ,"http://wiki.blender.org/index.php/Scripts/Manual/Wizards/geodesic_dome")
__bpydoc__ = """\
This Script can be used to create Geodesic Objects, not limited to Domes or Spheres,
it can create several object types & even apply geodesic formula to your own mesh.
A very useful script..
"""
#author__ = ["andy houston (serendipiti)", "Brendon Murphy (Meta-Androcto)"]
#url__ = ("http://members.aol.com/demalion2/index.html" , #"http://blender.org/index.php/Scripts/Manual/Wizards/geodesic_dome)
#version__ = "2.0a"

#Geodesic Domes 2.0 mod
#Modifiy by Meta-Androcto
#Add Header to register script in Wizards. 02/15/2008
#Add & modify info text. 02/15/2008
#Add GPL LICENSE BLOCK. 02/15/2008
#Add Python Psyco Module for speed up. 02/15/2008 (optional)
#Extracted modules into .py files.02/15/2008

# ***** BEGIN GPL LICENSE BLOCK *****
#
# Script copyright (C) Andy Houston 
#
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; either version 2
# of the License, or (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software Foundation,
# Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
#
# ***** END GPL LICENCE BLOCK *****
# --------------------------------------------------------------------------

#This script Makes Geodesic Domes Based on Multiple Formula.
#Hit alt-p to start (if opened with test editor)
#		
#	Geodesic 2.0	
#			
#	andy houston 21st June, 2005
					
import Blender
from Blender  import NMesh ,Draw, BGL

import math
import goo
import geodesic
import forms
try:
    import psyco
    psyco.full
    print "psyco in use"
except:
    "Psyco Failed, will run slowly :( "
    

from vefm import mesh,average,facetype,strut,hub,importmesh

pi2=2*math.pi

mousex=1
mousey=1

rounded=[1,1,1,1]

#mainpageid=Draw.Create(3)
#subpageid=Draw.Create(0)
#pageflag=Draw.Create(4)
idtrack=[0,0]

impmesh=Draw.Create(0)
outputmeshname=Draw.Create("defaultimport")

##   Geodesic controls
polytype=Draw.Create(1)
shape=Draw.Create(0)
orientation=Draw.Create(0)
faceshape=Draw.Create(0)

klass=Draw.Create(0)

class1=Draw.Create(1)
class2=Draw.Create(0)

tetra=Draw.Create(0)
octa=Draw.Create(1)
ico=Draw.Create(0)

point=Draw.Create(1)
edge=Draw.Create(0)
face=Draw.Create(0)

sphere=Draw.Create(1)
dome=Draw.Create(0)
other=Draw.Create(0)

tri=Draw.Create(1)
hexa=Draw.Create(0)
star=Draw.Create(0)

dual=Draw.Create(0)
cart=Draw.Create(0)

frequency=Draw.Create(2)
baselevel=Draw.Create(5)
radius=Draw.Create(1.0)
eccentricity=Draw.Create(1.0)
squish=Draw.Create(1.0)

squareness=Draw.Create(2.0)
squarez=Draw.Create(2.0)

rotxy=Draw.Create(0.0)
rotz=Draw.Create(0.0)

parameters=[	frequency.val,eccentricity.val,squish.val,
		radius.val,squareness.val,squarez.val,
		cart.val,shape.val,baselevel.val,faceshape.val]

##   Grid controls
grxres=Draw.Create(5)
gryres=Draw.Create(5)
grxsz=Draw.Create(1.0)
grysz=Draw.Create(1.0)	
			
##   cylinder controls
cyxres=Draw.Create(5)
cyyres=Draw.Create(5)
cyxsz=Draw.Create(1.0)
cyysz=Draw.Create(1.0)	
cyxell=Draw.Create(1.0)
cygap=Draw.Create(1.0)
cygphase=Draw.Create(0.0)

##   Parabola controls
paxres=Draw.Create(5)
payres=Draw.Create(5)
paxsz=Draw.Create(0.30)
paysz=Draw.Create(1.0)
paxell=Draw.Create(1.0)
pagap=Draw.Create(1.0)
pagphase=Draw.Create(0.0)
			
##   Torus controls
ures=Draw.Create(8)
vres=Draw.Create(8)
urad=Draw.Create(1.0)
vrad=Draw.Create(0.250)
uellipse=Draw.Create(1.0)
vellipse=Draw.Create(1.0)
upart=Draw.Create(1.0)
vpart=Draw.Create(1.0)
ugap=Draw.Create(0.0)
vgap=Draw.Create(0.0)
uphase=Draw.Create(0.0)
vphase=Draw.Create(0.0)
uexp=Draw.Create(0)
vexp=Draw.Create(0)
usuper=Draw.Create(2.00)
vsuper=Draw.Create(2.00)
usupertwist=Draw.Create(0.0)
vsupertwist=Draw.Create(0.0)

##   Sphere controls
bradius=Draw.Create(1.0)
bures=Draw.Create(8)
bvres=Draw.Create(8)
burad=Draw.Create(1.0)
bupart=Draw.Create(1.0)
bvpart=Draw.Create(1.0)
buphase=Draw.Create(0.0)
bvphase=Draw.Create(0.0)
buellipse=Draw.Create(1.0)
bvellipse=Draw.Create(1.0)

			
##   Superformula controls
um=Draw.Create(3)
un1=Draw.Create(10.0)
un2=Draw.Create(10.0)
un3=Draw.Create(10.0)
ua=Draw.Create(1.0)
ub=Draw.Create(1.0)
vm=Draw.Create(4)
vn1=Draw.Create(10.0)
vn2=Draw.Create(10.0)
vn3=Draw.Create(10.0)
va=Draw.Create(1.0)
vb=Draw.Create(1.0)
uact=Draw.Create(0)
vact=Draw.Create(0)
uturn=Draw.Create(0.0)
vturn=Draw.Create(0.0)
utwist=Draw.Create(0.0)
vtwist=Draw.Create(0.0)

arbimptog=Draw.Create(0)
arbimpstring=Draw.Create("None")
select=Draw.Create("")

facetypes=Draw.Create(0)
facetoggle=Draw.Create(0)
faceimporttoggle=Draw.Create(0)
faceimportstring=Draw.Create("None")
facewidth=Draw.Create(.50)
fwtog=Draw.Create(0)
faceheight=Draw.Create(1.0)
fhtog=Draw.Create(0)
detatch=Draw.Create(0)
fmeshname=Draw.Create("defaultface")
	
struttype=Draw.Create(0)
struttoggle=Draw.Create(0)
strutimporttoggle=Draw.Create(0)
strutimpmesh=Draw.Create("None")
strutwidth=Draw.Create(1.0)
swtog=Draw.Create(0)
strutheight=Draw.Create(1.0)
shtog=Draw.Create(0)
strutshrink=Draw.Create(1.0)
sstog=Draw.Create(0)
stretch=Draw.Create(0)
lift=Draw.Create(0.0)
smeshname=Draw.Create("defaultstrut")


hubtype=Draw.Create(0)
hubtoggle=Draw.Create(0)
hubimporttoggle=Draw.Create(0)
hubimpmesh=Draw.Create("None")
hubwidth=Draw.Create(1.0)
hwtog=Draw.Create(0)
hubheight=Draw.Create(1.0)
hhtog=Draw.Create(0)
hublength=Draw.Create(1.0)
hstog=Draw.Create(0)
hmeshname=Draw.Create("defaulthub")


background=[0.7,0.7,0.7,0.0]
border=[0.0,0.0,0.0]
lowpane=[0.65,0.65,0.55]
black=[0.0,0.0,0.0]

maincol=[0.7,0.8,0.7]
formcol=[0.90,0.9,0.50]
facecol=[0.50,0.65,0.75]
strutcol=[0.50,0.60,0.7]
hubcol=[0.50,0.55,0.65]
helpcol=[0.59,0.59,0.59]

form1col=[0.8,0.7,0.6]
form2col=[0.70,0.60,0.5]

green0=[0.65,0.75,0.65]
green1=[0.6,0.7,0.6]
green2=[0.55,0.65,0.55]
green3=[0.5,0.6,0.5]
green4=[0.45,0.55,0.45]
green5=[0.40,0.50,0.40]	
green6=[0.35,0.45,0.35]
green7=[0.30,0.40,0.30]
palegreen=[0.7,0.9,0.7]	



maintitles=["Main","Formula","Faces","Struts","Hubs","Help"]
maincolours=[maincol,formcol,facecol,strutcol,hubcol,helpcol]
mainpageid=Draw.Create(5)

subtitles=["Geodesic","Grid","Cylinder","Parabola","Torus","Ball","Your Mesh"]
subcolours=[green0,green1,green2,green3,green4,green5,green6,green7]
subpageid=Draw.Create(0)

formulatitles=["Formula 1","Formula 2"]
formulacolours=[form1col,form2col]
formulapageid=Draw.Create(0)

maintabs=goo.tabs( 6, maintitles, maincolours, border, black, mainpageid)
subtabs=goo.tabs(7, subtitles, subcolours, border, black, subpageid)
formulatabs=goo.tabs(2,formulatitles,formulacolours,border,black,formulapageid)

def creategeo(polytype,orientation,parameters):



	if polytype==0:

		if orientation==0:

			geo=geodesic.tetrahedron(parameters)

			return geo

		elif orientation==1:

			geo=geodesic.tetraedge(parameters)

			return geo

		elif orientation==2:

			geo=geodesic.tetraface(parameters)

			return geo

	elif polytype==1:		# octahedron

		if orientation==0:

			geo=geodesic.octahedron(parameters)

		elif orientation==1:

			geo=geodesic.octaedge(parameters)

		elif orientation==2:

			geo=geodesic.octaface(parameters)
		
		return geo

	elif polytype==2:	# icosahedron

		if orientation==0:

			geo=geodesic.icosahedron(parameters)

		elif orientation==1:

			geo=geodesic.icoedge(parameters)

		elif orientation==2:

			geo=geodesic.icoface(parameters)

		return geo

def finalfill(source,target):
	count=0
	for point in source.verts:

		newvert=NMesh.Vert(point.x,point.y,point.z)
		target.verts.append(newvert)
		point.index=count
		count=count+1
	
	for facey in source.faces:

		row=len(facey.vertices)

		if row>=5:

			newvert=average(facey.vertices).centroid()

			centre=NMesh.Vert(newvert.x,newvert.y,newvert.z)
			target.verts.append(centre)

			for i in range(row):

				f=NMesh.Face()

				if i==row-1:

					a=target.verts[facey.vertices[-1].index]
					b=target.verts[facey.vertices[0].index]


				else:

					a=target.verts[facey.vertices[i].index]
					b=target.verts[facey.vertices[i+1].index]

				c=centre

				f.v.append(a)
				f.v.append(b)
				f.v.append(c)

				target.faces.append(f)

		else:

			f=NMesh.Face()

			for j in range(len(facey.vertices)):

				a=facey.vertices[j]

				f.v.append(target.verts[a.index])

			target.faces.append(f)

def edgefill(source,target):

	count=0
	for point in source.verts:

		newvert=NMesh.Vert(point.x,point.y,point.z)
		target.verts.append(newvert)
		point.index=count
		count=count+1
	
	for edj in source.edges:


		f=NMesh.Face()

		f.v.append(target.verts[edj.a.index])
		f.v.append(target.verts[edj.b.index])
		target.faces.append(f)

def leveldraw():
	
	basegeodesic.docart()
	Blender.Redraw()

def getselect():

	global select

	objsel=Blender.Object.GetSelected ()

	select.val=objsel[0].getName()

def getselectstrut():

	global strutmesh

	objsel=Blender.Object.GetSelected ()

	strutimpmesh.val=objsel[0].getName()
	print "strut",strutimpmesh.val
		
def getselecthub():

	global hubmesh

	objsel=Blender.Object.GetSelected ()

	hubimpmesh.val=objsel[0].getName()


def makeGeodesic():

	global basegeodesic,fmeshname,smeshname,hmeshname,outputmeshname,strutimpmesh,hubimpmesh

	superformparam=[um.val,un1.val,un2.val,un3.val,ua.val,ub.val,vm.val,vn1.val,vn2.val,vn3.val,va.val,vb.val,uact.val,vact.val,uturn.val*math.pi,vturn.val*(math.pi),utwist.val,vtwist.val]

	if subpageid.val==0:
		
		parameters=[frequency.val,eccentricity.val,squish.val,radius.val,squareness.val,squarez.val,cart.val,shape.val,baselevel.val,faceshape.val,dual.val,rotxy.val,rotz.val,klass.val,superformparam]

		basegeodesic=creategeo(polytype.val,orientation.val,parameters)

	elif subtabs.pageid.val==1:	

		basegeodesic=forms.grid(grxres.val,gryres.val,grxsz.val,grysz.val,1.0,1.0,0,0,0,0,1.0,1.0,superformparam)		

	elif subtabs.pageid.val==2:	

		basegeodesic=forms.cylinder(cyxres.val,cyyres.val,cyxsz.val,cyysz.val,cygap.val,1.0,cygphase.val,0,0,0,cyxell.val,1.0,superformparam)		

	elif subtabs.pageid.val==3:	

		basegeodesic=forms.parabola(paxres.val,payres.val,paxsz.val,paysz.val,pagap.val,1.0,pagphase.val,0,0,0,paxell.val,1.0,superformparam)		
					
	elif subtabs.pageid.val==4:

		basegeodesic=forms.torus(ures.val,vres.val,vrad.val,urad.val,upart.val,vpart.val,ugap.val,vgap.val,0,0,uellipse.val,vellipse.val,superformparam)		

	elif subtabs.pageid.val==5:

		basegeodesic=forms.sphere(bures.val,bvres.val,burad.val,1.0,bupart.val,bvpart.val,buphase.val,bvphase.val,0,0,buellipse.val,bvellipse.val,superformparam)	

	elif subtabs.pageid.val==6:

		basegeodesic=importmesh(select.val,0)

	basemesh=NMesh.GetRaw()
	facemesh=NMesh.GetRaw()
	strutmesh=NMesh.GetRaw()
	hubmesh=NMesh.GetRaw()


## The list below contains the facetype definitions

	if facetoggle.val:

		faceparams=				[[detatch.val,0,[[0.5,0.0]]],
								[detatch.val,0,[[0.0,0.5]]],
								[detatch.val,0,[[0.5,0.5]]],
								[detatch.val,1,[[0.25,0.25],[0.5,0.5]]],
								[detatch.val,1,[[0.1,0.03],[0.33,0.06],[0.0,0.1]]],
								[detatch.val,2,[[0.0,0.5]]],
								[detatch.val,2,[[0.0,0.25],[0.25,0.25],[0.25,0.5]]],
								[detatch.val,1,[[0.2,0.1],[0.4,0.2],[0.0,1.0]]],
								[detatch.val,3,[[0.25,0.0],[0.25,0.5],[0.0,0.5]]],							
								[detatch.val,3,[[0.25,0.5],[0.5,0.0],[0.25,-0.5]]],
								[detatch.val,4,[[0.5,0.0],[0.5,0.5],[0.0,0.5]]],
														]

		facedata=faceparams[facetypes.val]

		faceobject=facetype(basegeodesic,facedata,facewidth.val,faceheight.val,fwtog.val)
		
		finalfill(faceobject,facemesh)		

 	if struttoggle.val:
	
		try:

 			strutobject=strut(basegeodesic,struttype.val,strutwidth.val,strutheight.val,strutshrink.val,swtog.val,shtog.val,sstog.val,strutimpmesh.val,stretch.val,lift.val)
		
 			finalfill(strutobject,strutmesh)

		except:
			
			Draw.PupMenu("import a mesh or switch off struts")


 	if hubtoggle.val:
	
		try:
	
			hubl=hubwidth.val
 			hubobject=hub(basegeodesic,hubtype.val,hubwidth.val,hubheight.val,hubl,hwtog.val,hhtog.val,hstog.val,hubimpmesh.val)
		
 			finalfill(hubobject,hubmesh)

		except:
			
			error=Draw.PupMenu("import a mesh or switch off hubs")

	if facetoggle.val+struttoggle.val+hubtoggle.val==0:	## If nothing fancy is selected, do a plain vanilla geodesic

		finalfill(basegeodesic,basemesh)
		#edgefill(basegeodesic,basemesh)
		
	NMesh.PutRaw(basemesh,"Geodesic",1)
	NMesh.PutRaw(facemesh,fmeshname.val,1)
	NMesh.PutRaw(strutmesh,"Edges",1)
	NMesh.PutRaw(hubmesh,"Vertices",1)
    
	Blender.Redraw()

def drawgui():

	global mousex, mousey, click, gs, maintabs, subtabs,inpanel,rounded
	global background,border,idtrack,makeGeodesic
	
	gs=goo.guispace(background)

	click=goo.clicktracker()

	if gs.width<350:

		gs.width=350

	if gs.height<500:

		gs.height=500

	lowline=80

	lp=goo.panel(5, 5, 120, lowline-10, background, border,rounded)
	Draw.Button("EXIT", 1, lp.left+10, lp.base+10,lp.width-20,lp.height-20 )

	xstart=5
	maintabs.drawtabs(xstart, lowline, gs.width-xstart-5, gs.height-lowline-10, 50, click)

	if maintabs.pageid.val==0:
	

		subtabs.drawtabs(maintabs.left+5, maintabs.base+5, maintabs.width-10, maintabs.height-maintabs.tabheight-10, 50, click)
		if subtabs.pageid.val==0:

			idtrack[1]=idtrack[0]
			idtrack[0]=0

			geodesiccontrols()

			if idtrack[0]!=idtrack[1]:
				makeGeodesic()


		if subtabs.pageid.val==1:

			idtrack[1]=idtrack[0]
			idtrack[0]=1

			gridcontrols()

			if idtrack[0]!=idtrack[1]:
				makeGeodesic()


		if subtabs.pageid.val==2:
		
			idtrack[1]=idtrack[0]
			idtrack[0]=2

			cylindercontrols()

			if idtrack[0]!=idtrack[1]:
				makeGeodesic()				
			

		if subtabs.pageid.val==3:
			
			idtrack[1]=idtrack[0]
			idtrack[0]=3

			parabolacontrols()

			if idtrack[0]!=idtrack[1]:
				makeGeodesic()


		if subtabs.pageid.val==4:

			idtrack[1]=idtrack[0]
			idtrack[0]=4

			toruscontrols()

			if idtrack[0]!=idtrack[1]:
				makeGeodesic()



		if subtabs.pageid.val==5:
				
			idtrack[1]=idtrack[0]
			idtrack[0]=5

			ballcontrols()

			if idtrack[0]!=idtrack[1]:
				makeGeodesic()


		if subtabs.pageid.val==6:
				
			idtrack[1]=idtrack[0]
			idtrack[0]=6
						
			importcontrols()
			
		
	if maintabs.pageid.val==1:
		
		formulatabs.drawtabs(maintabs.left+5, maintabs.base+5,maintabs.width-10,maintabs.pane.height-10, 50,click)

		formulacontrols()

	if maintabs.pageid.val==2:

		facecontrols()


		
	if maintabs.pageid.val==3:

		strutcontrols()
	

 
	if maintabs.pageid.val==4:

		hubcontrols()
		
	    


	if maintabs.pageid.val==5:
		
			ds=goo.scaffold(maintabs.left+20, maintabs.pane.top-340, 400,320,16,2)

			BGL.glColor3f(black[0],black[1],black[2])
			
			BGL.glRasterPos2i(ds.col1[0],ds.row[0])
			Draw.Text("1. Start with the Main tab. Choose a shape to work on.")

			BGL.glRasterPos2i(ds.col1[0],ds.row[1])
			Draw.Text("2. The Formula tab has sliders that can warp and twist the object. (Optional) ")

			BGL.glRasterPos2i(ds.col1[0],ds.row[2])
			Draw.Text("3. The Faces page creates a new mesh based on the main one, with the")

			BGL.glRasterPos2i(ds.col1[0],ds.row[3]+5)
			Draw.Text("    faces altered according to the menu options. ie. spikes, holes, etc.")

			BGL.glRasterPos2i(ds.col1[0],ds.row[4])
			Draw.Text("4. On the Struts page, import a small Blender mesh. It will be recreated along")

			BGL.glRasterPos2i(ds.col1[0],ds.row[5]+3)
			Draw.Text("    each edge of the main mesh, suitably scaled and stretched.")

			BGL.glRasterPos2i(ds.col1[0],ds.row[6]+5)
			Draw.Text("    If both meshes have a lot of vertices, you may experience slowness.")
			
			BGL.glRasterPos2i(ds.col1[0],ds.row[7])
			Draw.Text("5. The Hubs page is similar, but the imported mesh is recreated at ")

			BGL.glRasterPos2i(ds.col1[0],ds.row[8]+5)
			Draw.Text("    the vertices of the main mesh.")
			
			BGL.glRasterPos2i(ds.col1[0],ds.row[10])
			Draw.Text("		Experiment and have fun.")
				
			BGL.glRasterPos2i(ds.col1[0],ds.row[12])
			Draw.Text("Bug reports to demalion2@aol.com")

			BGL.glRasterPos2i(ds.col1[0],ds.row[13])
			Draw.Text("or the Python and Plugins forum at Elysiun")
				


def geodesiccontrols():

	global polytype,shape,orientation,pattern,klass,cart,frequency,face,parameters
	global radius,eccentricity,squish,tetra,octa,ico,point,edge,sphere,dome,other,tri,hexa,star
	global squareness,squarez,supertoggle,baselevel,class1,class2,rounded,dual,rotxy,rotz

	midline=subtabs.width/2
	ds=goo.scaffold(subtabs.left+5, subtabs.base+5, subtabs.width-10, subtabs.pane.height-10,1,10,5)
	lpan=goo.panel(ds.col2[0], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	bs=goo.scaffold(lpan.left+5,lpan.base+5,lpan.width-10,lpan.height-10,8,10)

	frequency = 	Draw.Number("Frequency   ",3, bs.col1[0], bs.row[0], bs.full, bs.bheight[0], frequency.val, 1, 10,"Number of divisions of base polyhedron triangles")
	radius=		Draw.Slider("Radius : ", 	4, bs.col1[0], bs.row[1], bs.full, bs.bheight[0], radius.val, 0.1, 10.0,0,"The overall radius")
	eccentricity=	Draw.Slider("Stretch <-> : ", 	3, bs.col1[0], bs.row[2], bs.full, bs.bheight[0], eccentricity.val, 0.10, 2.0,0,"Scaling in the X plane")
	squish=		Draw.Slider("Flatten : ", 		3, bs.col1[0], bs.row[3], bs.full, bs.bheight[0],squish.val,0.1,2.0,0,"Scaling in the Z plane")
	squareness=	Draw.Slider("Square X/Y : ", 	3, bs.col1[0], bs.row[4], bs.full, bs.bheight[0], squareness.val, 0.10, 4.0,0,"Superellipse action in X/Y plane")
	rotxy=		Draw.Slider("Super Rotate: ", 3,bs.col1[0], bs.row[5], bs.full, bs.bheight[0],rotxy.val, 0.0, math.pi*0.25,0,"Rotate the squareness")
	squarez=		Draw.Slider("Square Z: ", 	3, bs.col1[0], bs.row[6], bs.full, bs.bheight[0], squarez.val, 0.1, 4.0,0,"Superellipse action in Z plane")
	rotz=		Draw.Slider("Super Rotate: ", 3,bs.col1[0], bs.row[7], bs.full, bs.bheight[0],rotz.val, 0.0, math.pi*0.25,0,"Rotate the squareness")

	rpan=goo.panel(ds.col2[1], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	cs=goo.scaffold(rpan.left+5,rpan.base+5,rpan.width-10,rpan.height-10,7,10)

	half=cs.half+cs.sidegap-1
	third=cs.third+cs.sidegap-1

	class1=		Draw.Toggle("Class I", 		  55, cs.col2[0], cs.row[0], half, cs.bheight[0],class1.val,"Subdivide basic triangle")
	class2=		Draw.Toggle("Class II",		56, cs.col2[1], cs.row[0], cs.half, cs.bheight[0],class2.val,"subdivide triacon style")

	tetra=		Draw.Toggle("Tetrahedron",   9, cs.col3[0], cs.row[1], third, cs.bheight[0],tetra.val,"basic polyhedron base")
	octa=		Draw.Toggle("Octahedron", 	10, cs.col3[1], cs.row[1], third, cs.bheight[0] ,octa.val,"basic polyhedron base")
	ico=			Draw.Toggle("Icosahedron", 11, cs.col3[2], cs.row[1], cs.third, cs.bheight[0],ico.val,"basic polyhedron base")

	point=		Draw.Toggle("Point Up", 	12, cs.col3[0], cs.row[2], third, cs.bheight[0],point.val,"Orientation of basic polyhedron")
	edge=		Draw.Toggle("Edge Up", 	13, cs.col3[1], cs.row[2], third, cs.bheight[0] ,edge.val,"Orientation of basic polyhedron")
	face=		Draw.Toggle("Face Up", 	14, cs.col3[2], cs.row[2], cs.third, cs.bheight[0],face.val,"Orientation of basic polyhedron")

	tri=			Draw.Toggle("Tri faces", 	15, cs.col3[0], cs.row[3], third, cs.bheight[0],tri.val,"Basic shape")
	hexa=		Draw.Toggle("Hex faces", 	16, cs.col3[1], cs.row[3], third, cs.bheight[0], hexa.val,"Basic shape")
	star=		Draw.Toggle("Star faces", 	17, cs.col3[2], cs.row[3], cs.third, cs.bheight[0],star.val,"Basic shape")

#	sphere=		Draw.Toggle("Full Sphere", 		18, cs.col3[0], cs.row[4], third, cs.bheight[0],sphere.val,"Basic shape")
#	dome=		Draw.Toggle("Dome", 		19, cs.col3[1], cs.row[4], third, cs.bheight[0],dome.val,"Basic shape")
#	other=		Draw.Toggle("In-between", 	20, cs.col3[2], cs.row[4], cs.third, cs.bheight[0],other.val,"Basic shape")

#	if octa.val:
#		baselimit=frequency.val*2

#	if ico.val:
#		baselimit=frequency.val*3

#	if other.val:

#		baselevel = Draw.Number("Baselevel   ", 3, cs.col1[0], cs.row[5], cs.full, cs.bheight[0], baselevel.val, 1, baselimit,"Divisions from top to cut off base")


	dual=Draw.Toggle("Dual", 3,cs.col1[0], cs.row[4], cs.full, cs.bheight[0] ,dual.val,"Faces become verts,verts become faces, edges flip")
	cartext=["Spherical","Flat polygon"]
	cart=Draw.Toggle(cartext[cart.val], 3,cs.col1[0], cs.row[5], cs.full, cs.bheight[0] ,cart.val,"Base polyhedron, subdivided but not sphericalized")

def gridcontrols():
	
	global grxres,gryres,grxsz,grysz
	
	ds=goo.scaffold(subtabs.left+5, subtabs.base+5, subtabs.width-10, subtabs.pane.height-50,1,10,5)
	
	lpan=goo.panel(ds.col2[0], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	bs=goo.scaffold(lpan.left+5, lpan.base+5, lpan.width-10, lpan.height-10, 7, 10)	

	rpan=goo.panel(ds.col2[1], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	cs=goo.scaffold(rpan.left+5, rpan.base+5, rpan.width-10, rpan.height-10, 7, 10)

	
	grxres=Draw.Slider("X res: ", 3,bs.col1[0],bs.row[0], bs.full, bs.bheight[0], grxres.val, 1, 100,0)
	gryres=Draw.Slider("Y res: ", 3,cs.col1[0],cs.row[0], cs.full, cs.bheight[0], gryres.val, 1, 100,0)
	grxsz=Draw.Slider("X size: ", 3,bs.col1[0],bs.row[1], bs.full, bs.bheight[0], grxsz.val, 0.01, 5.0,0) 
	grysz=Draw.Slider("Y size: ", 3,cs.col1[0],cs.row[1], cs.full, cs.bheight[0], grysz.val, 0.01, 5.0,0)




def cylindercontrols():			

	global cyxres,cyyres,cyxsz,cyysz,cyxell,cygap,cygphase

	ds=goo.scaffold(subtabs.left+5, subtabs.base+5, subtabs.width-10, subtabs.pane.height-50,1,10,5)
	
	lpan=goo.panel(ds.col2[0], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	bs=goo.scaffold(lpan.left+5, lpan.base+5, lpan.width-10, lpan.height-10, 7, 10)
	
	rpan=goo.panel(ds.col2[1], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	cs=goo.scaffold(rpan.left+5, rpan.base+5, rpan.width-10, rpan.height-10, 7, 10)

	cyxres=Draw.Slider("X res: ", 3,bs.col1[0],bs.row[0], bs.full, bs.bheight[0], cyxres.val, 1, 100,0)
	cyyres=Draw.Slider("Y res: ", 3,cs.col1[0],cs.row[0], cs.full, cs.bheight[0], cyyres.val, 1, 100,0)
	cyxsz=Draw.Slider("Radius: ", 3,bs.col1[0],bs.row[1], bs.full, bs.bheight[0], cyxsz.val, 0.01, 5.0,0) 
	cyysz=Draw.Slider("Height: ", 3,cs.col1[0],cs.row[1], cs.full, cs.bheight[0], cyysz.val, 0.01, 5.0,0)
	cyxell=Draw.Slider("Stretch: ", 3,bs.col1[0],bs.row[2], bs.full, bs.bheight[0], cyxell.val, 0.1, 5.0,0)
	cygap=Draw.Slider("Gap: ", 	3,bs.col1[0],bs.row[3], bs.full, bs.bheight[0], cygap.val, 0.1, 1.0,0)
	
	if cygap.val<1.0:
		
		cygphase=Draw.Slider("Gap Rotate: ", 	3,bs.col1[0],bs.row[4], bs.full, bs.bheight[0], cygphase.val, 0.1, 1.0,0)
		
		
def parabolacontrols():			

	global paxres,payres,paxsz,paysz,paxell,pagap,pagphase
	
	ds=goo.scaffold(subtabs.left+5, subtabs.base+5, subtabs.width-10, subtabs.pane.height-50,1,10,5)
	
	lpan=goo.panel(ds.col2[0], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	bs=goo.scaffold(lpan.left+5, lpan.base+5, lpan.width-10, lpan.height-10, 7, 10)
	
	rpan=goo.panel(ds.col2[1], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	cs=goo.scaffold(rpan.left+5, rpan.base+5, rpan.width-10, rpan.height-10, 7, 10)

	paxres=Draw.Slider("X res: ", 3,bs.col1[0],bs.row[0], bs.full, bs.bheight[0], paxres.val, 1, 100,0)
	payres=Draw.Slider("Y res: ", 3,cs.col1[0],cs.row[0], cs.full, cs.bheight[0], payres.val, 1, 100,0)
	paxsz=Draw.Slider("Radius: ", 3,bs.col1[0],bs.row[1], bs.full, bs.bheight[0], paxsz.val, 0.01, 5.0,0) 
	paysz=Draw.Slider("Height: ", 3,cs.col1[0],cs.row[1], cs.full, cs.bheight[0], paysz.val, 0.01, 5.0,0)
	paxell=Draw.Slider("Stretch: ", 3,bs.col1[0],bs.row[2], bs.full, bs.bheight[0], paxell.val, 0.1, 5.0,0)
	pagap=Draw.Slider("Gap: ", 	3,bs.col1[0],bs.row[3], bs.full, bs.bheight[0], pagap.val, 0.1, 1.0,0)
	
	if pagap.val<1.0:
		
		pagphase=Draw.Slider("Gap Rotate: ", 	3,bs.col1[0],bs.row[4], bs.full, bs.bheight[0], pagphase.val, 0.1, 1.0,0)
	

def toruscontrols():

	global ures,vres,urad,vrad,uellipse,vellipse,upart,vpart,uphase,vphase,usuper,vsuper,usupertwist,vsupertwist
	global textcol,ugap,vgap,uexp,vexp,rounded

	ds=goo.scaffold(subtabs.left+5, subtabs.base+5, subtabs.width-10, subtabs.pane.height-50,1,10,5)
	lpan=goo.panel(ds.col2[0], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	bs=goo.scaffold(lpan.left+5, lpan.base+5, lpan.width-10, lpan.height-10, 7, 10)

	rpan=goo.panel(ds.col2[1], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	cs=goo.scaffold(rpan.left+5, rpan.base+5, rpan.width-10, rpan.height-10, 7, 10)

	ures=	Draw.Slider("Resolution: ", 	3, bs.col1[0], bs.row[0], bs.full, bs.bheight[0],ures.val,2,100,0,"Divisions around big circle")
	urad=	Draw.Slider("Radius: ", 		3, bs.col1[0], bs.row[1], bs.full, bs.bheight[0], urad.val, 0.1, 20,0,"big radius")
	uellipse=	Draw.Slider("Stretch: ", 		3, bs.col1[0], bs.row[2], bs.full, bs.bheight[0], uellipse.val, 0.01, 5.0,0,"Scale in X direction")
	upart=	Draw.Slider("Gap: ", 		3, bs.col1[0], bs.row[3], bs.full, bs.bheight[0], upart.val, 0.01, 1.0,0,"Make a gap")
	if upart.val<1.0:

		ugap=Draw.Slider("Gap Rotate: ", 30, bs.col1[0], bs.row[4], bs.full, bs.bheight[0], ugap.val, 0.0, 1.0,0,"Move that gap around")

	vres=	Draw.Slider("Resolution: ", 	3, cs.col1[0], cs.row[0], cs.full, cs.bheight[0],vres.val,2,100,0,"Divisions around small circle")
	vrad=	Draw.Slider("Radius: ", 		3, cs.col1[0], cs.row[1], cs.full, cs.bheight[0], vrad.val, 0.1, 20,0,"Small radius")
	vellipse=	Draw.Slider("Stretch: ", 		3, cs.col1[0], cs.row[2], cs.full, cs.bheight[0], vellipse.val, 0.01, 5.0,0,"Scale in Z direction")
	vpart=	Draw.Slider("Gap: ", 		3, cs.col1[0], cs.row[3], cs.full, cs.bheight[0], vpart.val, 0.01, 1.0,0,"Make a gap")
	if vpart.val<1.0:
		vgap=Draw.Slider("Gap Rotate: ", 31, cs.col1[0], cs.row[4], cs.full, cs.bheight[0], vgap.val, 0.0, 1.0,0,"Move that gap around")



def ballcontrols():		## formula page now


 	global bradius,bures,burad,bvres,bupart,bvpart,buellipse,bvellipse,buphase,bvphase

	ds=goo.scaffold(subtabs.left+5, subtabs.base+5, subtabs.width-10, subtabs.pane.height-50,1,10,5)
	lpan=goo.panel(ds.col2[0], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	bs=goo.scaffold(lpan.left+5, lpan.base+5, lpan.width-10, lpan.height-10, 7, 10)

	rpan=goo.panel(ds.col2[1], ds.row[0], ds.half, ds.bheight[0], palegreen, border,rounded)
	cs=goo.scaffold(rpan.left+5, rpan.base+5, rpan.width-10, rpan.height-10, 7, 10)

	bures=Draw.Slider("X/Y resolution: ", 3,	bs.col1[0],bs.row[0], bs.full, bs.bheight[0],bures.val,4,100,0)
	burad=Draw.Slider("Radius: ", 3,	bs.col1[0],bs.row[1], bs.full, bs.bheight[0],burad.val,0.01,10.0,0)
	buellipse=Draw.Slider("Stretch : ", 3, bs.col1[0],bs.row[2], bs.full, bs.bheight[0], buellipse.val, 0.01, 5.0,0)
	bupart=Draw.Slider("Gap: ", 3,			bs.col1[0],bs.row[3], bs.full, bs.bheight[0] , bupart.val, 0.1, 1.0,0)

	if bupart.val<1.0:
		buphase=Draw.Slider("Gap Rotate: ", 31, bs.col1[0], bs.row[4], bs.full, bs.bheight[0], buphase.val, 0.0, 1.0,0,"Move that gap around")
	
	bvres=Draw.Slider("Z resolution: ", 3,		cs.col1[0],cs.row[0], cs.full, cs.bheight[0],bvres.val,4,100,0)
#	bvellipse=Draw.Slider("Stretch Height: ", 3,cs.col1[0],cs.row[1], cs.full, cs.bheight[0], bvellipse.val, 0.01, 5.0,0)	
	bvellipse=Draw.Slider("Stretch : ", 3,cs.col1[0],cs.row[2], cs.full, cs.bheight[0], bvellipse.val, 0.01, 5.0,0)
	bvpart=Draw.Slider("Gap: ", 3, 			cs.col1[0],cs.row[3], cs.full, cs.bheight[0], bvpart.val, 0.1, 1.0,0)
	if bvpart.val<1.0:
		bvphase=Draw.Slider("Gap Rotate: ", 31, cs.col1[0], cs.row[4], cs.full, cs.bheight[0], bvphase.val, 0.0, 1.0,0,"Move that gap around")

	
def formulacontrols():
	
	global um,un1,un2,un3,ua,ub,vm,vn1,vn2,vn3,va,vb,uact,vact,uturn,vturn,utwist,vtwist

	bs=goo.scaffold(formulatabs.left+5,formulatabs.base+5,formulatabs.width-10,formulatabs.pane.height-10,9,10)
	
	if formulatabs.pageid.val==0:

		utag=["formula 1 off","formula 1 on"]
		uact=Draw.Toggle(utag[uact.val],3,bs.col1[0],bs.row[0], bs.third, bs.bheight[0], uact.val)  
	
		if uact.val:
	
			um=Draw.Number("Sides Around: ", 3,bs.col1[0],bs.row[1], bs.full, bs.bheight[0] ,um.val,1,20)
			uturn=Draw.Slider("Phase: ", 3,bs.col1[0],bs.row[2], bs.full, bs.bheight[0], uturn.val, 0.0, 1.0,0)
			utwist=Draw.Slider("Twist: ",3,bs.col1[0],bs.row[3], bs.full, bs.bheight[0], utwist.val, -1.0, 1.0,0)
			un1=Draw.Slider("N 1: ", 3,bs.col1[0],bs.row[4], bs.full, bs.bheight[0], un1.val, 0.01, 100.0,0) 
			un2=Draw.Slider("N 2: ", 3,bs.col1[0],bs.row[5], bs.full, bs.bheight[0], un2.val, 0.01, 100.0,0)
			un3=Draw.Slider("N 3: ", 3,bs.col1[0],bs.row[6], bs.full, bs.bheight[0], un3.val, 0.01, 100.0,0)
			ua=Draw.Slider("a: ", 3,bs.col1[0],bs.row[7], bs.full, bs.bheight[0],ua.val, 0.01, 5.0,0) 
			ub=Draw.Slider("b: ", 3,bs.col1[0],bs.row[8], bs.full, bs.bheight[0] , ub.val, 0.01, 5.0,0)
	
	if formulatabs.pageid.val==1:
	
		vtag=["formula 2 off","formula 2 on"]
		vact=Draw.Toggle(vtag[vact.val],3,bs.col1[0],bs.row[0], bs.third, bs.bheight[0], vact.val)
	
		if vact.val:
	
			vm=Draw.Number("Sides Pole to Pole: ", 3,bs.col1[0],bs.row[1], bs.full, bs.bheight[0] ,vm.val,1,20)
			vturn=Draw.Slider("Phase: ",3,bs.col1[0],bs.row[2], bs.full, bs.bheight[0], vturn.val, 0.0, 1.0,0)
			vtwist=Draw.Slider("Twist: ",3,bs.col1[0],bs.row[3], bs.full, bs.bheight[0], vtwist.val, -1.0, 1.0,0)
			vn1=Draw.Slider("N 1: ", 3, bs.col1[0],bs.row[4], bs.full, bs.bheight[0], vn1.val, 0.01, 100.0,0)
			vn2=Draw.Slider("N 2: ", 3,bs.col1[0],bs.row[5], bs.full, bs.bheight[0] , vn2.val, 0.01, 100.0,0) 
			vn3=Draw.Slider("N 3: ", 3,bs.col1[0],bs.row[6], bs.full, bs.bheight[0] , vn3.val, 0.01, 100.0,0)
			va=Draw.Slider("a: ", 3,bs.col1[0],bs.row[7], bs.full, bs.bheight[0] , va.val, 0.01, 5.0,0)
			vb=Draw.Slider("b: ", 3,bs.col1[0],bs.row[8], bs.full, bs.bheight[0] , vb.val, 0.01, 5.0,0)

def facecontrols():

	global facetypes,facewidth,fwtog,faceheight
	global fhtog,facetoggle,faceimporttoggle,detatch,fmeshname

	ds=goo.scaffold(maintabs.left+20, maintabs.pane.top-270,400,230,7,5)

	facetext=["Faces are OFF","Faces are ON"]

 	facetoggle=Draw.Toggle(facetext[facetoggle.val], 3,ds.col1[0],ds.row[2], 120,ds.bheight[0],facetoggle.val)

	fmeshname=Draw.String("Meshname: ", 2,ds.col1[0],ds.row[1], 220,ds.bheight[1] ,fmeshname.val,30)


	if facetoggle.val:


 		facetypes=Draw.Menu("Facetype %t|strip%x0|open vertical%x1|open slanted%x2|closed point%x3|pillow%x4|closed vertical%x5|stepped%x6|spikes%x7|boxed%x8|diamond profile%x9|bar%x10" ,3, ds.col1[0],ds.row[3],ds.full,ds.bheight[0],facetypes.val)
 
		fwtext=["relative","absolute"]
 		fwtog=Draw.Toggle(fwtext[fwtog.val], 3,  ds.col4[3],ds.row[4],ds.quarter,ds.bheight[0],fwtog.val)

		if fwtog.val:
 				facewidth=Draw.Number("Width : ", 3, ds.col1[0],ds.row[4],ds.threequarter,ds.bheight[0], facewidth.val, 0.1, 100.0,)
		else:
 				facewidth=Draw.Slider("Width : ", 3, ds.col1[0],ds.row[4],ds.threequarter,ds.bheight[0], facewidth.val, 0.1, 2.0,0)

		fhtext=["relative","absolute"]
 		fhtog=Draw.Toggle(fhtext[fhtog.val], 3, ds.col4[3],ds.row[5],ds.quarter,ds.bheight[0],fhtog.val)

		if fhtog.val:

 				faceheight=Draw.Number("Height : ", 3,  ds.col1[0],ds.row[5],ds.threequarter,ds.bheight[0], faceheight.val, 0.1, 100.0,)			

		else:							

 				faceheight=Draw.Slider("Height : ", 3,  ds.col1[0],ds.row[5],ds.threequarter,ds.bheight[0], faceheight.val, 0.1, 2.0,0)

 		detatch=Draw.Toggle("Detatch", 3,ds.col1[0],ds.row[6],ds.half,ds.bheight[0],detatch.val,"use subdiv to see effect")


# #			faceimporttoggle=Draw.Toggle("Import", 2, 24, m-150, 100, 20,faceimporttoggle.val)
# #			faceimportstring=Draw.String("Import: ", 2, 24, m-180, 150, 20,faceimportstring.val,30)

def strutcontrols():

	global struttype,strutwidth,swtog,strutheight,smeshname
	global shtog,strutshrink,sstog,struttoggle,strutimporttoggle,stretch,lift

	ds=goo.scaffold(maintabs.left+20, maintabs.pane.top-270, 400,230,7,5)

	struttext=["Struts are OFF","Struts are ON"]
	
	strutimpmesh=Draw.Button("Import a selected mesh before activating struts", 6, ds.col1[0],ds.row[0],ds.threequarter,ds.bheight[0])
	
	smeshname=Draw.String("Output Meshname: ", 2,ds.col1[0],ds.row[1],ds.threequarter,ds.bheight[1] ,smeshname.val,30)

 	struttoggle=Draw.Toggle(struttext[struttoggle.val], 3,ds.col1[0],ds.row[2], 120,ds.bheight[0] ,struttoggle.val)

 
 	if struttoggle.val:

		
		swtext=["relative","absolute"]

		strutwidth=Draw.Slider("Width : ", 3,ds.col1[0],ds.row[3],ds.threequarter,ds.bheight[0], strutwidth.val, 0.1, 2.0,0)
 		swtog=Draw.Toggle(swtext[swtog.val], 3, ds.col4[3],ds.row[3],ds.quarter,ds.bheight[0],swtog.val)

 		strutheight=Draw.Slider("Height : ", 3,ds.col1[0],ds.row[4],ds.threequarter,ds.bheight[0], strutheight.val, 0.1, 2.0,0)
		shtog=Draw.Toggle(swtext[shtog.val], 3, ds.col4[3],ds.row[4],ds.quarter,ds.bheight[0],shtog.val)

 		strutshrink=Draw.Slider("Shrink : ", 3,ds.col1[0],ds.row[5],ds.threequarter,ds.bheight[0], strutshrink.val, 0.1, 2.0,0)
 		stretch=Draw.Toggle("stretch", 3,ds.col4[3],ds.row[5],ds.quarter,ds.bheight[0],stretch.val)

	  	lift=Draw.Slider("Raise/Lower : ", 3,ds.col1[0],ds.row[6],ds.threequarter,ds.bheight[0], lift.val, -2.0, 2.0,0)


def hubcontrols():

	global hubtype,hubwidth,hwtog,hubheight,hhtog,hublength
	global hubtoggle,hubimporttoggle
	global hubimportstring,strutmesh,faceimportstring,hmeshname

	ds=goo.scaffold(maintabs.left+20, maintabs.pane.top-270, 400,230,7,5)

	hubtext=["Hubs are OFF","Hubs are ON"]

 	hubimpmesh=Draw.Button("Import a selected mesh before activating hubs", 21, ds.col1[0],ds.row[0],ds.threequarter,ds.bheight[0])
	
	hubtoggle=Draw.Toggle(hubtext[hubtoggle.val],3,ds.col1[0],ds.row[2], 120,ds.bheight[0] ,hubtoggle.val)

	hmeshname=Draw.String("Output Meshname: ", 2,ds.col1[0],ds.row[1], ds.threequarter,ds.bheight[0] ,hmeshname.val,30)

 
 	if hubtoggle.val:
		
		
		hwtext=["relative","absolute"]

		hubwidth=Draw.Slider("Width : ", 3,ds.col1[0],ds.row[3],ds.threequarter,ds.bheight[0], hubwidth.val, 0.1, 2.0,0)
 		hubheight=Draw.Slider("Height : ", 3,ds.col1[0],ds.row[4],ds.threequarter,ds.bheight[0], hubheight.val, 0.1, 2.0,0) 	
	
def importcontrols():

	global outputmeshname,impmesh
	
	ds=goo.scaffold(subtabs.left+5, subtabs.base+subtabs.pane.height/2+5, subtabs.width/2-10, subtabs.pane.height/2-50,4,10,5)
	outputmeshname=Draw.String("Output mesh name: ", 2,ds.col1[0],ds.row[0], ds.full, ds.bheight[0] ,outputmeshname.val,30)
	impmesh=Draw.Button("Get Selected",5,ds.col1[0],ds.row[1], ds.full, ds.bheight[0])


def otherevents(evt, val):

	global mousex,mousey
   
	if (evt== Draw.QKEY and not val): 
		Draw.Exit()

	if (evt==Draw.MOUSEX):
		mousex=val-gs.left

	if (evt==Draw.MOUSEY):
		mousey=val-gs.base

	if (evt==Draw.LEFTMOUSE):

		click.clickcheck(mousex,mousey)

		Draw.Register(drawgui, otherevents, buttonevents)

def buttonevents(evt):

	global basegeodesic,getselect

	if   (evt== 1):

		Draw.Exit()

	elif (evt== 3):

		makeGeodesic()
		Draw.Redraw()


	elif (evt== 4):

		makeGeodesic()
		Draw.Redraw()

	elif (evt== 5):
		
		getselect()
		makeGeodesic()
		Draw.Redraw()	

	elif (evt== 6):
		
		getselectstrut()
		makeGeodesic()
		Draw.Redraw()	

	elif (evt==21):
		
		getselecthub()
		makeGeodesic()
		Draw.Redraw()		
	

	elif (evt==55):
		print "event7",klass.val,class1.val,class2.val

		klass.val=0

		class1.val=1
		class2.val=0
		print "event7a",klass.val,class1.val,class2.val
		
		makeGeodesic()
		Draw.Redraw()	

	elif (evt==56):
		print "event8",klass.val,class1.val,class2.val

		klass.val=1
		
		class1.val=0
		class2.val=1
		print "event8a",klass.val,class1.val,class2.val
		
		makeGeodesic()
		Draw.Redraw()	

	elif (evt== 9):

		polytype.val=0
		
		tetra.val=1
		octa.val=0
		ico.val=0
		makeGeodesic()		
		Draw.Redraw()

	

	elif (evt== 10 ):

		polytype.val=1
		
		tetra.val=0
		octa.val=1
		ico.val=0
		makeGeodesic()
		Draw.Redraw()

	

	elif (evt== 11):

		polytype.val=2

		tetra.val=0
		octa.val=0
		ico.val=1
		makeGeodesic()
		Draw.Redraw()





	elif (evt== 12):

		orientation.val=0
		
		point.val=1
		edge.val=0
		face.val=0
		
		makeGeodesic()

		Draw.Redraw()


	elif (evt== 13):

		orientation.val=1

		point.val=0
		edge.val=1
		face.val=0
		
		makeGeodesic()

		Draw.Redraw()

	elif (evt== 14):

		orientation.val=2

		point.val=0
		edge.val=0
		face.val=1
		
		makeGeodesic()

		Draw.Redraw()


	elif (evt==15):

		faceshape.val=0

		tri.val=1
		hexa.val=0
		star.val=0
		
		makeGeodesic()

		Draw.Redraw()

	elif (evt==16):

		faceshape.val=1

		tri.val=0
		hexa.val=1
		star.val=0
		
		makeGeodesic()

		Draw.Redraw()

	elif (evt==17):

		faceshape.val=2

		tri.val=0
		hexa.val=0
		star.val=1
		
		makeGeodesic()

		Draw.Redraw()
		
	elif (evt== 18):

		shape.val=0

		sphere.val=1
		dome.val=0
		other.val=0

		makeGeodesic()

		Draw.Redraw()


	elif (evt== 19):

		shape.val=1

		sphere.val=0
		dome.val=1
		other.val=0

		makeGeodesic()

		Draw.Redraw()


	elif (evt== 20):

		shape.val=2

		sphere.val=0
		dome.val=0
		other.val=1

		makeGeodesic()

		Draw.Redraw()


	elif (evt== 30):

		uphase.val=ugap.val*2.0*math.pi

		makeGeodesic()

		Draw.Redraw()

	elif (evt== 31):

		vphase.val=vgap.val*2.0*math.pi

		makeGeodesic()

		Draw.Redraw()


	elif (evt==100):

		Draw.Redraw()

makeGeodesic()

Draw.Register(drawgui, otherevents, buttonevents)