#
#
var ChartsList =
{
    'KATL':
    {
        STAR: ["STAR_CANUK1_RNAV", "STAR_ERLIN9_RNAV", "STAR_FLCON7_RNAV", "STAR_HERKO6_RNAV", "STAR_HONIE8_RNAV", "STAR_LA_GRANGE2", "STAR_PECHY7_RNAV", "STAR_ROME4", "STAR_RPTOR1_RNAV", "STAR_SINCA5", "STAR_VIKNN_3RNAV", "STAR_WHINZ1"],
        STARs: 12,
        IAP: ["ILS_8L_Cat II - III", "ILS_PRM_8L", "ILS_PRM_8L_CAT II - III", "ILS_PRM_8R", "ILS_PRM_9L", "ILS-LOC_8L", "ILS-LOC_8R", "ILS-LOC_9L"],
        IAPs: 8,
        SID: ["SID_ATL5", "SID_BRAV6_RNAV", "SID_CADIT6_RNAV", "SID_COKEM5_RNAV", "SID_DAWGS5_RNAV", "SID_DOOLY5_RNAV", "SID_GEETK6_RNAV", "SID_JCKTS6_RNAV", "SID_JOGOR4_RNAV", "SID_MUNSN5_RNAV", "SID_NOVSS4_RNAV", "SID_NUGGT5_RNAV"],
        SIDs: 12,
        APT: "APT_0",
        APTs: 1,
        LOCATION: "ATLANTA USA",
        NAME: "Hartsfield-Jackson"
    },
    'KLAX':
    {
        STAR: "REDEYE2",
        STARs: 1,
        IAP: ["06L-ILS", "06R-ILS", "07L-ILS", "07R-ILS"],
        IAPs: 4,
        SID: "SNGO6",
        SIDs: 1,
        APT: "APT_0",
        APTs: 1,
        LOCATION: "LOS ANGELES USA",
        NAME: "Intntl"
    },
    'KIAH':
    {
        STAR: ["RIICE3_1", "RIICE_2"],
        STARs: 2,
        IAP: ["09-ILS", "15R-ILS"],
        IAPs: 2,
        SID: "",
        SIDs: 0,
        APT: "APT_0",
        APTs: 1,
        LOCATION: "HOUSTON USA",
        NAME: "G. Bush Intctl"
    },
    'VABB':
    {
        STAR: "",
        STARs: 0,
        IAP: ["09-ILS-DME", "14-ILS-DME"],
        IAPs: 2,
        SID: "EKPOSxA",
        SIDs: 1,
        APT: "APT_0",
        APTs: 1,
        LOCATION: "MUMBAI IN",
        NAME: "Chhatrapati Shivaji"
    },
    'KMEM':
    {
        STAR: "BEERT4",
        STARs: 1,
        IAP: "09-ILS_LOC",
        IAPs: 1,
        SID: "",
        SIDs: 0,
        APT: "APT_0",
        APTs: 1,
        LOCATION: "MEMPHIS USA",
        NAME: "International"
    },
    'LFRB':
    {
        STAR: "STAR",
        STARs: 1,
        IAP: ["IAP_25L", "IAP_25L_RNAV", "ILS_Y_25L", "ILS_YZ_07R", "ILS_Z_25L", "NDB_25L", "RADAR", "RNAV_07R", "VFR_APP01", "VFR_LNDG_01"],
        IAPs: 11,
        SID: ["SID_07R", "SID_25L"],
        SIDs: 2,
        APT: ["APT_0", "APT_1"],
        APTs: 2,
        LOCATION: "BREST FR",
        NAME: "Guipavas"
    },
    'LFRM':
    {
        STAR: ["VFR_APP01", "VFR_LND01"],
        STARs: 2,
        IAP: "",
        IAPs: 0,
        SID: "",
        SIDs: 0,
        APT: "APT_0",
        APTs: 1,
        LOCATION: "LE MANS FR",
        NAME: "Arnage"
    },
    'LIME':
    {
        STAR: ["STAR_ASTIG_ODINA_1S", "STAR_ASTIG_ODINA_1T", "STAR_DIXER_GEN_IDONA_1S", "STAR_DIXER_GEN_IDONA_1T", "STAR_DORIN_LUSIL_OSKOR_1S", "STAR_DORIN_LUSIL_OSKOR_1T", "STAR_East", "STAR_West", "STAR_VOR_DME", "VOR_Y28", "VOR_Y28_2", "VOR_Z28"],
        STARs: 12,
        IAP: ["ILS-PAPA-28", "ILS-PAPA-28-CAT II", "ILS-SIERRA-28", "ILS-SIERRA-28-CAT II", "ILS-TANGO-28", "ILS-TANGO-28-CAT II", "ILS-X28", "ILS-Y28", "ILS-Z28"],
        IAPs: 9,
        SID: ["SID_10_BEKAN_DORIN_5S", "SID_10-28_BEKAN5T_DORIN5T_ORI5QT", "SID_10-28_Alternate", "SID_28_SRN5R_TZO5R_TZO5S", "SID_InitialClimb", "SID10_InitialClimb", "SID28_InitialClimb", "SID28_InitialClimb2", "DEP_North_East", "DEP_South", "DEP_West"],
        SIDs: 12,
        APT: ["APT_0", "APT_0_Small", "GROUND_East_Apron", "GROUND_North_Apron", "GROUND_West_Apron"],
        APTs: 6,
        LOCATION: "BERGAMO IT",
        NAME: "Orio al Serio"
    },
    'LOWI':
    {
        STAR: ["26-RTT", "STAR", "VFR_East", "VFR_West_KTI", "West-NDB_KYI"],
        STARs: 5,
        IAP: ["LOC_26_RNAV", "LOC_DME_East", "LOC_DME_West", "NDB_East", "RNAV_08", "RNAV_26", "SPEC_LOC_DME_East"],
        IAPs: 8,
        SID: ["08-RTT", "General Departure", "SID_08", "SID0_RTT1W", "SID_08_SPECPERF_KPT1Z", "SID_08_SPECPERF_RTT2Z", "SID-26", "SID_26_MOGTI1H_RTT1Y", "SID_26_RNAV"],
        SIDs: 9,
        APT: ["APT_0", "APT_1"],
        APTs: 2,
        LOCATION: "INNSBRUCK AT",
        NAME: "Kranebitten"
    },
    'WSSS':
    {
        STAR: ["BOBAG1A", "BOBAG1B", "LAVAX1A", "LAVAX1B"],
        STARs: 4,
        IAP: ["02C-VOR-DME", "02L-ILS", "02L-ILS-CATII", "20C-VOR-DME", "20R-ILS"],
        IAPs: 5,
        SID: "BOG1",
        SIDs: 1,
        APT: ["APT_0", "APT_1"],
        APTs: 2,
        LOCATION: "SINGAPORE SG",
        NAME: "Changi"
    },
};

var l0 = "";
var l1 = "";
var l2 = "";
var l3 = "";
var l4 = "";
var l5 = "";
var l6 = "";
var l7 = "";
var l8 = "";
var l9 = "";
var l10 = "";
var l11 = "";
var l12 = "";
var l13 = "";
var l14 = "";
var l15 = "";
var l16 = "";
var l17 = "";
var l18 = "";
var l19 = "";
var l20 = "";

var r1 = "";
var r2 = "";
var r3 = "";
var r4 = "";
var r5 = "";
var r6 = "";
var r7 = "";
var r8 = "";
var r9 = "";
var r10 = "";
var r11 = "";
var r12 = "";
var r13 = "";
var r14 = "";
var r15 = "";
var r16 = "";
var r17 = "";
var r18 = "";
var r19 = "";
var r20 = "";

var KCl0_0 = "";
var KCl0_1 = "";
var KCl0 = "";
var KCl1 = "";
var KCl2 = "";
var KCl3 = "";
var KCl4 = "";

var KCr1 = "";
var KCr2 = "";
var KCr3 = "";
var KCr4 = "";
var KCr5 = "";
var KCr6 = "";

var helper = "";
var keypress = "";
var lastlog = "";
var lastn = 0;
var hist1 = "";
var hist2 = "";
var hist3 = "";
var hist4 = "";
var hist5 = "";
var hist6 = "";
var nochart = "";
var ZoomFact = 0;
var PanHFact = 0;
var PanVFact = 0;

var ChartSelection = ["NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL"];
var ChartName = ["NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL", "NULL"];
var ChartDisp = ["NULL", "NULL", "NULL"];
var AptName = "Unknown";
var OriginApt = "NOT Set";
var DestinationApt = "NOT Set";
var ClosestName = "";
var ClosingFlightFlag = 0;
var lenght = 0;
var Temp_String = "";
var Cnv_Fact = 0;
var VK_Key = "";
var VK_Input_Mem = 0;
var VK_Output_Mem = 0;
var TMZ_Input_Lenght = 0;
var TMZ_Converted_ID = "";
var TMZ_Converted_Name = "";
var TMZ_Converted_OffSet = "";
var TMZ_zulu_HH = "";
var TMZ_Index = 0;
var TMZ_DB_Size = 0;
var TMZ_Index_Direction = 0;
var Output_TMZ_Line = "";
var TMZ_DATE = "";
var TMZ_TIME = "";
var Output_HH = 0;
var Output_MM = 0;
var Keyboard_Helper = "";
var Keyboard_Message = "";

var CUT = ["NULL", "NULL", "NULL"];
var Initial_FL = 0;
var Target_FL = 0;
var Initial_GS = 0;
var Target_GS = 0;
var DRC_Distance = 0;
var DRC_l3 = "";
var DRC_r3 = "";
var DRC_l5 = "";
var DRC_r5 = "";
var DRC_l7 = "";
var DRC_r8 = "";
var DRC_r9 = "";
var DRC_r10 ="";
DRC_String = "";
DRC_Input_Lenght = 0;

var Index_Max = 0;
var Index_Offset = 0;
var Chart_Pages = 1;
var PageList = 0;
var Page_Memory = 0;
var PageShow = "0/0";
var Chart_Selected ="";


var fuelrequired = 0;
var fuelrecommended = 0;


#___________________
#  Chart Properties |
#___________________|

ident = getprop("/sim/airport/closest-airport-id");

#AptName = getprop("/instrumentation/efb/chart/icao");

if (ident != nil)
{
    setprop("instrumentation/efb/chart/icao", ident);
    setprop("instrumentation/efb/chart/DEP_icao", getprop("/instrumentation/efb/chart/icao"));
} else setprop("/instrumentation/efb/chart/icao", "");

setprop("/instrumentation/efb/chart/type", "APT");
setprop("/instrumentation/efb/chart/newairport", 0);
setprop("/instrumentation/efb/FlightStatus", 0);        # INACTIVE

nochart = 0;



var efb = {
    init : func {
        me.UPDATE_INTERVAL = 0.05;
        me.loopid = 0;

#_____________
# INITIALIZE  |
#_____________|

setprop("/instrumentation/efb/page", "MENU");
setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");

# Chart Section Stuff

setprop("/instrumentation/efb/chart/type", "APT");
setprop("/instrumentation/efb/chart/selected", "APT_0");
setprop("/instrumentation/efb/VK_keypress", "");
setprop("/instrumentation/efb/Keyboard/CHART_Input_Line", "");
setprop("/instrumentation/efb/chart/rotation", 0);
setprop("/instrumentation/efb/diagram/rotation", 0);

AptName = getprop("/instrumentation/efb/chart/icao");

# Various Stuff

setprop("/instrumentation/efb/manual-page", 0);

setprop("/instrumentation/efb/vnav_autogen/first", 0);
setprop("/instrumentation/efb/vnav_autogen/gen", 0);
TMZ_DB_Size = getprop("/instrumentation/efb/TimeZonesDB/TMZ_DB_Size") - 1;
setprop("/instrumentation/efb/chart/PageList", 1);


        me.reset();
},
    searchairport : func(query) {

    setprop("/instrumentation/gps/scratch/query", query);
    setprop("/instrumentation/gps/scratch/type", "airport");

    setprop("/instrumentation/gps/command", "search");

setprop("/instrumentation/efb/selected-rwy/id", "");

},
    searchcomms : func(query) {

    setprop("/sim/gui/dialogs/scratch/airports/selected-airport/id", query);
#   setprop("/sim/gui/dialogs/airports/scratch/type", "airport");

    setprop("/sim/gui/dialogs/scratch/airports/mode", "search");

# setprop("/instrumentation/efb/selected-rwy/id", "");

},
    searchcharts : func(chart) {

    setprop("/sim/model/efb/chart", "Charts/" ~ chart ~ ".jpg");

},
    update : func {

var keypress = getprop("/instrumentation/efb/keypress");


if (getprop("/instrumentation/efb/page") == "MENU") {

# Make sure we know the APT's ICAO

    setprop("/instrumentation/gps/scratch/ident", getprop("/sim/airport/closest-airport-id"));

    if (getprop("/instrumentation/gps/scratch/ident") != nil) setprop("/instrumentation/efb/chart/icao", sprintf("%s", getprop("/instrumentation/gps/scratch/ident")));
    else setprop("/instrumentation/efb/chart/icao", "");
    AptName = sprintf("%s", getprop("/instrumentation/efb/chart/icao"));

    page.clearpage();
    page.index();

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
keypress = "";
}
if (keypress == "l1") { setprop("/instrumentation/efb/page", "CHARTS");
setprop("/instrumentation/efb/chart/chartmenu", 0);
setprop("/instrumentation/efb/chart/zoom-in", 0);
ZoomFact = 0;
PanHFact = 0;
PanVFact = 0;
keypress = "";
}
if (keypress == "r1") { setprop("/sim/model/efb/page", "Displays/Video_1.jpg");
setprop("/instrumentation/efb/page", "VIDEO");
keypress = "";
}
if (keypress == "l2") { setprop("/sim/model/efb/page", "Displays/Performance_1.jpg");
setprop("/instrumentation/efb/page", "PERFORMANCE");
keypress = "";
}
if (keypress == "r2") { setprop("/sim/model/efb/page", "Displays/Documents_1.jpg");
setprop("/instrumentation/efb/page", "DOCUMENTS");
keypress = "";
}
if (keypress == "l4") { setprop("/sim/model/efb/page", "Displays/Airport_Info.jpg");
setprop("/instrumentation/efb/page", "APT INFO");
keypress = "";
}
if (keypress == "l5") { setprop("/instrumentation/efb/page", "Airport Charts");
keypress = "";
}
if (keypress == "l7") { setprop("/sim/model/efb/page", "Displays/IDENT_1.jpg");
setprop("/instrumentation/efb/page", "IDENT");
keypress = "";
}
if (keypress == "l8") { setprop("/sim/model/efb/page", "Displays/System_1.jpg");
setprop("/instrumentation/efb/page", "SYSTEMS");
keypress = "";
}
if (keypress == "r4") { setprop("/instrumentation/efb/page", "Airport Diagram");
keypress = "";
}
if (keypress == "r5") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
keypress = "";
}
if (keypress == "r6") { setprop("/instrumentation/efb/page", "Flight Fuel Planner");
keypress = "";
}
if (keypress == "r7") { setprop("/sim/model/efb/page", "Displays/Monitor.jpg");
setprop("/instrumentation/efb/page", "MONITOR");
keypress = "";
}
if (keypress == "r8") { setprop("/instrumentation/efb/page", "INITIALIZE");
keypress = "";
}

#__________________________________________________________________________________________
# CHART SECTION Parser --------------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "CHARTS") {

    page.clearpage();

# setprop("/sim/model/efb/chart", "Displays/Help_1.jpg");
setprop("/instrumentation/efb/diagram/rotation", 0);
setprop("/instrumentation/efb/diagram/chartmenu", 0);
setprop("/instrumentation/efb/chartsDB", "Charts/");

#   helper = "";

# NOTE: this gives the Airport's name to be used on the bottom line of the Chart Display) has still to be checked: if RouteManager is not selected from the upper MENU, the property is not active...

AptName = getprop("/instrumentation/efb/chart/icao");

             #_____________________________
############## Chart Selection at Airport  |
             #_____________________________|


# Checks existence of Charts in the DB

if(ChartsList[AptName] == nil)
{
    setprop("/instrumentation/efb/chart_Found", "NOT_FOUND");
nochart = 1;
}
else
{
    setprop("/instrumentation/efb/chart_Found", "FOUND");
nochart = 0;
}

if (nochart == 0)
{



page.update();

    if (getprop("/instrumentation/efb/chart/type") == "APT")
    {
        l0 = "AIRPORT MAP";
    }
    else l0 = "";
l20 = AptName;

efb.searchcharts(AptName ~ "/" ~ getprop("/instrumentation/efb/chart/type") ~ "/" ~ getprop("/instrumentation/efb/chart/selected"));
#efb.searchcharts(AptName ~ "/" ~ getprop("/instrumentation/efb/chart/type") ~ "/" ~ getprop("instrumentation/efb/chart/selection2");
setprop("/sim/model/efb/chart", getprop("/sim/model/efb/chart"));
setprop("/sim/model/efb/chart_BKUP", getprop("/sim/model/efb/chart"));
setprop("/sim/model/efb/Chart_2", getprop("/sim/model/efb/chart_BKUP"));
setprop("/sim/model/efb/Chart_4", getprop("/sim/model/efb/chart_BKUP"));

setprop("/sim/model/efb/Ovlay_1", "Displays/drawing.png");
if (getprop("/instrumentation/efb/chart/chartmenu") == 0) setprop("/sim/model/efb/Ovlay_1", "Displays/drawing.png");
if (getprop("/instrumentation/efb/chart/chartmenu") == 1) setprop("/sim/model/efb/Ovlay_1", "Displays/drawing2.png");
} else { setprop("/sim/model/efb/chart", "Displays/NoCharts.jpg");
    setprop("/sim/model/efb/Ovlay_1", "Displays/drawingNULL.png");
    helper = "Airport:    " ~ AptName;
}

# Handles the Zoom-In and Zoom-Out EFB buttons on Charts Display; available ZoomFact is 2x and 4x only.

if ((ZoomFact >= 0) and (ZoomFact <= 4)) {
        if ((keypress == "Zin") and (nochart == 0)) { ZoomFact = ZoomFact + 2;
        setprop("/instrumentation/efb/chart/zoom-in", ZoomFact);
        keypress = "";
        }
        if ((keypress == "Zout") and (nochart == 0) and (ZoomFact > 0)) { ZoomFact = ZoomFact - 2;
        setprop("/instrumentation/efb/chart/zoom-in", ZoomFact);
        keypress = "";
        }
}

if (ZoomFact == 0) setprop("/instrumentation/efb/chart/zoom-in", 0);

# Handles the Pan-Right, Pan_Left, ScrollUP and ScrollDN EFB buttons on Charts Display; Pan Horizontal Factor is 100; Pan Vertical Factor is 100.

if ((ZoomFact == 2) or (ZoomFact == 4)) {
        if ((keypress == "Move_R") and (nochart == 0)) { PanHFact = PanHFact + 100;
        setprop("/instrumentation/efb/chart/panH", PanHFact);
        keypress = "";
        }
        if ((keypress == "Move_L") and (nochart == 0)) { PanHFact = PanHFact - 100;
        setprop("/instrumentation/efb/chart/panH", PanHFact);
        keypress = "";
        }
        if ((keypress == "ScrollUP") and (nochart == 0)) { PanVFact = PanVFact + 100;
        setprop("/instrumentation/efb/chart/panV", PanVFact);
        keypress = "";
        }
        if ((keypress == "ScrollDN") and (nochart == 0)) { PanVFact = PanVFact - 100;
        setprop("/instrumentation/efb/chart/panV", PanVFact);
        keypress = "";
        }
} elsif (ZoomFact == 0) { setprop("/instrumentation/efb/chart/panH", -PanHFact);
setprop("/instrumentation/efb/chart/panV", -PanVFact);
}

# Handles Chart Rotation counter-clockwise

if ((keypress == "l2") and (nochart == 0) and (getprop("/instrumentation/efb/chart/chartmenu")) == 0) toggle("/instrumentation/efb/chart/rotation");

# Toggles Overlay Menu On/OFF

if ((keypress == "r8")  and (nochart == 0)) toggle("/instrumentation/efb/chart/chartmenu");

# Calls Virtual Keyboard for Chart DB Selection by the Pilot

if (keypress == "l5") { setprop("/instrumentation/efb/page", "CHARTS_KEYBOARD");
    setprop("/instrumentation/efb/chart/zoom-in", 0);
    setprop("/instrumentation/efb/VKDRC_keypress", "");
    setprop("/instrumentation/efb/VK_Keyboard/Input_String", "");
    setprop("/instrumentation/efb/chart/Searchable", 0);

}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/chart/zoom-in", 0);
ZoomFact = 0;
PanHFact = -PanHFact;
PanVFact = -PanVFact;
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}
#__________________________________________________________________________________________
# AIRPORT INFO SECTION Parser -------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "APT INFO") {

    page.clearpage();
    efb.searchairport(getprop("/sim/airport/closest-airport-id"));
    efb.searchcomms(getprop("/sim/airport/closest-airport-id"));
    page.airportinfo();
    page.update();

# if (keypress == "r6") { setprop("/instrumentation/efb/page", "Runway Information");
# keypress = "";
# }
if (keypress == "r8") { setprop("/instrumentation/efb/page", "CHARTS");
keypress = "";
}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}
#__________________________________________________________________________________________
# MONITOR SECTION Parser --------------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "MONITOR") {

    page.clearpage();
    page.FlightMonitor();
    page.update();

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}
#__________________________________________________________________________________________
# VIDEO SECTION Parser --------------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "VIDEO") {

    page.clearpage();

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}

#__________________________________________________________________________________________
# DOCUMENTS SECTION Parser ----------------------------------------------------------------|
#__________________________________________________________________________________________|

}elsif (getprop("/instrumentation/efb/page") == "DOCUMENTS") {

    page.clearpage();

if (keypress == "l3") { setprop("/instrumentation/efb/page", "NORM PROC MANUAL");
keypress = "";
}
if (keypress == "r2") { setprop("/sim/model/efb/page", "Displays/Checklists_1.jpg");
setprop("/instrumentation/efb/page", "CHECKLISTS");
keypress = "";
}
if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}
#__________________________________________________________________________________________
# PERFORMANCE SECTION Parser --------------------------------------------------------------|
#__________________________________________________________________________________________|

}elsif (getprop("/instrumentation/efb/page") == "PERFORMANCE") {

    page.clearpage();

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}
#__________________________________________________________________________________________
# CHECKLISTS SECTION Parser ---------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "CHECKLISTS") {

    page.clearpage();

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}
if (keypress == "l2") { setprop("/sim/model/efb/page", "Displays/Checklists_1_1.jpg");
setprop("/instrumentation/efb/page", "CHECKLISTS");
keypress = "";
}
if (keypress == "r2") { setprop("/sim/model/efb/page", "Displays/Checklists_1_2.jpg");
setprop("/instrumentation/efb/page", "CHECKLISTS");
keypress = "";
}

#__________________________________________________________________________________________
# IDENT SECTION Parser -------------------------------------------------------------------|
#_________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "IDENT") {

    page.clearpage();

        IDENTl3 = getprop("/sim/description");
        IDENTl4 = substr(getprop("/sim/aircraft-operator"),0,3) ~ " / " ~ substr(getprop("/sim/multiplay/callsign"), 0,6); # this is to ensure that too long 'operator' and 'callsign' data can fit into the EFB display
        IDENTr4 = "VMEFB001"; # this is the EFb Seattle version's ID
        IDENTl5 = substr(getprop("environment/metar/data"),0,10);
        IDENTr5 = getprop("/instrumentation/clock/indicated-short-string") ~ "z";
        IDENTl8 = "AIRPORT MAP DATABASE    Seattle Data    APR1214-JUN3014"; # this is the DB version, which we will periodically update with better and new Charts

        setprop("/instrumentation/efb/display/IDENTline3-l", IDENTl3);
        setprop("/instrumentation/efb/display/IDENTline4-l", IDENTl4);
        setprop("/instrumentation/efb/display/IDENTline4-r", IDENTr4);
        setprop("/instrumentation/efb/display/IDENTline5-l", IDENTl5);
        setprop("/instrumentation/efb/display/IDENTline5-r", IDENTr5);
        setprop("/instrumentation/efb/display/IDENTline8-l", IDENTl8);

        setprop("/instrumentation/efb/display/input-helper", helper);
        setprop("/instrumentation/efb/keypress", keypress);

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");

        IDENTl3 = "";
        IDENTl4 = "";
        IDENTr4 = "";
        IDENTl5 = "";
        IDENTr5 = "";
        IDENTl8 = "";
        setprop("/instrumentation/efb/display/IDENTline3-l", IDENTl3);
        setprop("/instrumentation/efb/display/IDENTline4-l", IDENTl4);
        setprop("/instrumentation/efb/display/IDENTline4-r", IDENTr4);
        setprop("/instrumentation/efb/display/IDENTline5-l", IDENTl5);
        setprop("/instrumentation/efb/display/IDENTline5-r", IDENTr5);
        setprop("/instrumentation/efb/display/IDENTline8-l", IDENTl8);

keypress = "";
}

#__________________________________________________________________________________________
#  SYSTEM SECTION Parser ------------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "SYSTEMS") {

    page.clearpage();

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}
#__________________________________________________________________________________________
#  CHART SECTION Parser -------------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "CHARTS_KEYBOARD") {

    page.clearpage();
    page.update();
    page.charts_keyboard();

if (getprop("/instrumentation/efb/chart/Searchable") == 0) { setprop("/instrumentation/efb/Keyboard/CHART_Input_Line", "Enter ICAO");
}

# Get the ICAO to be searched for; "Virtual Keyboard" Keys Parser (see EFB_Chart_Keyboard.xml)

 if ((getprop("/instrumentation/efb/VKDRC_keypress") != "") and (getprop("/instrumentation/efb/VKDRC_keypress") != "SYMB") and (getprop("/instrumentation/efb/VKDRC_keypress") != "SHIFT")) {

        setprop("/instrumentation/efb/VK_Keyboard/Input_String", getprop("/instrumentation/efb/VK_Keyboard/Input_String") ~ getprop("/instrumentation/efb/VKDRC_keypress"));    # Build the Input String

        if (getprop("/instrumentation/efb/VKDRC_keypress") == "CLEAR") { setprop("/instrumentation/efb/VK_Keyboard/Input_String", "");                                          # CLEARs the whole Input Field and other stuff
        }
        if (getprop("/instrumentation/efb/VKDRC_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/VK_Keyboard/Input_String");                                 # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
        setprop("/instrumentation/efb/VK_Keyboard/Input_String", substr(Temp_String, 0, lenght));
        setprop("/instrumentation/efb/VKDRC_keypress", "");
        }
}
    setprop("/instrumentation/efb/VKDRC_keypress", "");

    TMZ_String = getprop("/instrumentation/efb/VK_Keyboard/Input_String");
    TMZ_Input_Lenght = size(TMZ_String);

        if (TMZ_Input_Lenght <= 3)  { setprop("/instrumentation/efb/Keyboard/CHART_Input_Line", getprop("/instrumentation/efb/VK_Keyboard/Input_String"));                      # Print it to the Keyboard Input Field

        } else { setprop("/instrumentation/efb/chart/Searchable", 1);
                setprop("/instrumentation/efb/Keyboard/CHART_Input_Line", "Press [Search IDENT] to search for: " ~ getprop("/instrumentation/efb/VK_Keyboard/Input_String"));
        }
        if ((getprop("/instrumentation/efb/chart/Searchable") == 1) and (keypress == "l3")) { # do SEARCH CHART
        setprop("/instrumentation/efb/chart/icao", getprop("/instrumentation/efb/VK_Keyboard/Input_String"));
        page.charts_keyboard();
        setprop("/instrumentation/efb/VKDRC_keypress", "");
        setprop("/instrumentation/efb/chart/Searchable", 0);
        setprop("/instrumentation/efb/VK_Keyboard/Input_String", "");
        }
    if ((keypress == "PGDN") and (getprop("/instrumentation/efb/chart/PageList") < Chart_Pages)) {
    setprop("/instrumentation/efb/chart/SetPage", "INCREASE");
    setprop("/instrumentation/efb/chart/PageList", getprop("/instrumentation/efb/chart/PageList") + 1);
    }
    if ((keypress == "PGUP") and (getprop("/instrumentation/efb/chart/PageList") > 1)) {
    setprop("/instrumentation/efb/chart/SetPage", "DECREASE");
    setprop("/instrumentation/efb/chart/PageList", getprop("/instrumentation/efb/chart/PageList") - 1);
    }

# Chart Selection - redirection to CHARTS...___________________________________________________________________________________

    if (keypress == "r1") { setprop("/instrumentation/efb/chart/selected", getprop("/instrumentation/efb/chart/Selection_0"));
    keypress = "MENU";
    }
    if (keypress == "r2") { setprop("/instrumentation/efb/chart/selected", getprop("/instrumentation/efb/chart/Selection_1"));
    keypress = "MENU";
    }
    if (keypress == "r3") { setprop("/instrumentation/efb/chart/selected", getprop("/instrumentation/efb/chart/Selection_2"));
    keypress = "MENU";
    }
# _____________________________________________________________________________________________________________________________

    if (keypress == "MENU") { # setprop("/sim/model/efb/page", "Displays/Blank_Test.jpg");
    setprop("/instrumentation/efb/chart/Status", "OFF");
    setprop("/instrumentation/efb/VK_Chart_Type", "APT"); # This starts and re-starts the Chart_Keyboard with active ICAO/APT Chart displayed ! (see B777 EFB Manual)
    Page_Memory = 1;
    setprop("/instrumentation/efb/VK_Keyboard/Input_String", "");
    setprop("/instrumentation/efb/page", "CHARTS");
        page.KCclearpage();
        page.KCupdate();
    keypress = "";
}
#__________________________________________________________________________________________
#  INITIALIZE SECTION Parser --------------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "INITIALIZE") {

    page.clearpage();

    if (getprop("/instrumentation/efb/FlightStatus") == 0) {
    if (getprop("/autopilot/route-manager/departure/airport") != "") {
        OriginApt = getprop("/autopilot/route-manager/departure/airport");
    } else {
        OriginApt = "NOT Set";
    }
    if (getprop("/autopilot/route-manager/destination/airport") != "") {
        DestinationApt= getprop("/autopilot/route-manager/destination/airport");
    } else {
        DestinationApt = "NOT Set";
    }

    if ((OriginApt != "NOT Set") and (DestinationApt != "NOT Set")) {
        OriginApt = getprop("/autopilot/route-manager/departure/airport");
        DestinationApt = getprop("/autopilot/route-manager/destination/airport");
        setprop("/sim/model/efb/page", "Displays/Initialize_1.jpg");
        ClosingFlightFlag = 1; # Flight INITIABLE

    } else {
            setprop("/sim/model/efb/page", "Displays/Initialize_2.jpg");
            setprop("/instrumentation/efb/FlightStatus", 0);
            ClosingFlightFlag = 0; # Flight NOT INITIABLE
    }

    } elsif ((getprop("/instrumentation/efb/FlightStatus") == 1) and (ClosingFlightFlag == 2)) {
            setprop("/instrumentation/efb/FlightStatus", 1); # Flight ACTIVE and CLOSABLE
            FlightStatus = 1;
            setprop("/sim/model/efb/page", "Displays/Initialize_3.jpg");
    }
            INITl4 = OriginApt;
            INITl5 = DestinationApt;
            setprop("/instrumentation/efb/display/INITline4-l", INITl4);
            setprop("/instrumentation/efb/display/INITline5-l", INITl5);
if ((keypress == "r8") and (ClosingFlightFlag == 1)) { setprop("/instrumentation/efb/FlightStatus", 1); # Flight INITIATED
ClosingFlightFlag = 2; # Flight CLOSABLE
keypress = "";
}
if ((keypress == "r8") and (FlightStatus == 1)) { setprop("/instrumentation/efb/FlightStatus", 0); # Flight NOT ACTIVE
setprop("/sim/model/efb/page", "Displays/Initialize_5.jpg");
FlightStatus = 0;
ClosingFlightFlag = 0; # Flight CLOSED
keypress = "";
}
if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";

INITl4 = "";
INITl5 = "";
        setprop("/instrumentation/efb/display/INITline4-l", INITl4);
        setprop("/instrumentation/efb/display/INITline5-l", INITl5);
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES SECTION Parser ----------------------------------------------------------|
#__________________________________________________________________________________________|

} elsif (getprop("/instrumentation/efb/page") == "UTILITIES") {

    page.clearpage();
    setprop("/instrumentation/efb/Keyboard/Input_String", "");
    setprop("/instrumentation/efb/Keyboard/Input_Line", "");
    setprop("/instrumentation/efb/Keyboard/Input_Line2", "");
    setprop("/instrumentation/efb/Keyboard/Input_Line3", "");
    setprop("/instrumentation/efb/VK_keypress", "");

    if (keypress == "l3") {
    setprop("/instrumentation/efb/page", "UTILITIES_DESC_RATE");
    setprop("/sim/model/efb/page", "Displays/PU_DRC.jpg");
    setprop("/instrumentation/efb/Keyboard/Input_String", "");
    setprop("/instrumentation/efb/VK_keypress", "");
    setprop("/instrumentation/efb/Input_Unit", "NO_INPUT");
    setprop("/instrumentation/efb/DRC_Initial_FL", "300");
    setprop("/instrumentation/efb/DRC_Target_FL", "30");
    setprop("/instrumentation/efb/DRC_Initial_GS", "250");
    setprop("/instrumentation/efb/DRC_Target_GS", "200");
    setprop("/instrumentation/efb/DRC_Distance", "50");
    setprop("/instrumentation/efb/DRC_Initial_FL_MEM", getprop("/instrumentation/efb/DRC_Initial_FL"));
    setprop("/instrumentation/efb/DRC_Target_FL_MEM", getprop("/instrumentation/efb/DRC_Target_FL"));
    setprop("/instrumentation/efb/DRC_Initial_GS_MEM", getprop("/instrumentation/efb/DRC_Initial_GS"));
    setprop("/instrumentation/efb/DRC_Target_GS_MEM", getprop("/instrumentation/efb/DRC_Target_GS"));
    setprop("/instrumentation/efb/DRC_Distance_MEM", getprop("/instrumentation/efb/DRC_Distance"));
    VK_Key = "";
#   setprop("/instrumentation/efb/VK_DRC_MarkerL", 1);
    Initial_FL = 300;
    Target_FL = 30;
    Initial_GS = 250;
    Target_GS = 200;
    DRC_Distance = 50;
    keypress = "";
    }
    if (keypress == "l4") {
    setprop("/instrumentation/efb/page", "GPS POSITION");
    }
    if (keypress == "r1") {
    setprop("/instrumentation/efb/page", "UTILITIES_CNV_SPD");
    setprop("/sim/model/efb/page", "Displays/PU_Cnv_Spd.jpg");
    setprop("/instrumentation/efb/VK_keypress", "");
    setprop("/instrumentation/efb/VK_IN_Marker", 1);
    setprop("/instrumentation/efb/VK_OUT_Marker", 1);
    VK_Input_Mem = 0;
    VK_Output_Mem = 0;
    }
    if (keypress == "r2") {
    setprop("/instrumentation/efb/page", "UTILITIES_CNV_LNG");
    setprop("/sim/model/efb/page", "Displays/PU_Cnv_Lng.jpg");
    setprop("/instrumentation/efb/VK_keypress", "");
    setprop("/instrumentation/efb/VK_IN_Marker", 1);
    setprop("/instrumentation/efb/VK_OUT_Marker", 1);
    VK_Input_Mem = 0;
    VK_Output_Mem = 0;
    }
    if (keypress == "r3") {
    setprop("/instrumentation/efb/page", "UTILITIES_CNV_WGT");
    setprop("/sim/model/efb/page", "Displays/PU_Cnv_Wgt.jpg");
    setprop("/instrumentation/efb/VK_keypress", "");
    setprop("/instrumentation/efb/VK_IN_Marker", 1);
    setprop("/instrumentation/efb/VK_OUT_Marker", 1);
    VK_Input_Mem = 0;
    VK_Output_Mem = 0;
    }
    if (keypress == "r4") {
    setprop("/instrumentation/efb/page", "UTILITIES_CNV_TMP");
    setprop("/sim/model/efb/page", "Displays/PU_Cnv_Tmp.jpg");
    setprop("/instrumentation/efb/VK_keypress", "");
    setprop("/instrumentation/efb/VK_IN_Marker", 1);
    setprop("/instrumentation/efb/VK_OUT_Marker", 1);
    VK_Input_Mem = 0;
    VK_Output_Mem = 0;
    }
    if (keypress == "r5") {
    setprop("/instrumentation/efb/page", "UTILITIES_CNV_VLM");
    setprop("/sim/model/efb/page", "Displays/PU_Cnv_Vlm.jpg");
    setprop("/instrumentation/efb/VK_keypress", "");
    setprop("/instrumentation/efb/VK_IN_Marker", 1);
    setprop("/instrumentation/efb/VK_OUT_Marker", 1);
    VK_Input_Mem = 0;
    VK_Output_Mem = 0;
    }
    if (keypress == "r6") {
    setprop("/instrumentation/efb/page", "UTILITIES_CNV_TMZ");
    setprop("/sim/model/efb/page", "Displays/PU_Cnv_Tmz.jpg");
    setprop("/instrumentation/efb/VK_keypress", "");
    setprop("/instrumentation/efb/VK_IN_Marker", 1);
    setprop("/instrumentation/efb/VK_OUT_Marker", 1);
    setprop("/instrumentation/efb/Keyboard/Input_String","");
    setprop("/instrumentation/efb/Keyboard/Input_HH", "--");
    setprop("/instrumentation/efb/Keyboard/Input_MM", "--");
    setprop("/instrumentation/efb/Keyboard/Output_HH", "");
    setprop("/instrumentation/efb/Keyboard/Output_MM", "");
    setprop("/instrumentation/efb/page/Cnv_Fact", "0");
    TMZ_String = "";
    TMZ_Index = 0;

#   Parsing for Month's names

    TMZ_DATE = substr(getprop("environment/metar/data"), 5, 5);

    if (substr(TMZ_DATE, 0, 2) == "01") { TMZ_DATE = "JAN" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "02") { TMZ_DATE = "FEB" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "03") { TMZ_DATE = "MAR" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "04") { TMZ_DATE = "APR" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "05") { TMZ_DATE = "MAY" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "06") { TMZ_DATE = "JUN" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "07") { TMZ_DATE = "JUL" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "08") { TMZ_DATE = "AUG" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "09") { TMZ_DATE = "SEP" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "10") { TMZ_DATE = "OCT" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "11") { TMZ_DATE = "NOV" ~ substr(TMZ_DATE, 2, 3);
    }
    if (substr(TMZ_DATE, 0, 2) == "12") { TMZ_DATE = "DEC" ~ substr(TMZ_DATE, 2, 3);
    }

    }
if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Main_Menu.jpg");
setprop("/instrumentation/efb/page", "MENU");
keypress = "";
}

#__________________________________________________________________________________________
# PILOT UTILITIES - GPS POSITION ----------------------------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "GPS POSITION") {

    page.clearpage();
    page.gps();

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - SPEED CONVERSION Parser -----------------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "UTILITIES_CNV_SPD") {

Input_Unit = getprop("/instrumentation/efb/VK_IN_Marker");
Output_Unit = getprop("/instrumentation/efb/VK_OUT_Marker");

# Input keys Check

if (getprop("/instrumentation/efb/VK_keypress") != "" or (Input_Unit != VK_Input_Mem) or (Output_Unit != VK_Output_Mem)) {

# Input Field Parser

        if (getprop("/instrumentation/efb/VK_keypress") == "CLEAR") { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                    # CLEARs the whole Input Field
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                           # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
        setprop("/instrumentation/efb/Keyboard/Input_String", substr(Temp_String, 0, lenght));
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "CHNGS") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                          # CHANGEs SIGN to the Input Field
            if (substr(Temp_String, 0, 1) == "-") { lenght = size(Temp_String) - 1;
            Temp_String = substr(Temp_String, 1, lenght);
            } else { Temp_String = "-" ~ Temp_String;
            }
        setprop("/instrumentation/efb/Keyboard/Input_String", Temp_String);
        setprop("/instrumentation/efb/VK_keypress", "");
        }

# Input Field Display

        setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String") ~ getprop("/instrumentation/efb/VK_keypress")); # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Input_Line", getprop("/instrumentation/efb/Keyboard/Input_String"));                                                 # Print it to the Keyboard Input Field

# ---------------> Conversion Table Selection

# ---------------> Input Unit 1 () FT/M ---> Output Unit: FT/M, KM/H, KT, MTS, MPH
        if (Input_Unit == 1) {
            if (Output_Unit == 1) { Cnv_Fact = 1;
            }
            if (Output_Unit == 2) { Cnv_Fact = 0.018288;
            }
            if (Output_Unit == 3) { Cnv_Fact = 0.0098747;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.0050800;
            }
            if (Output_Unit == 5) { Cnv_Fact = 0.011364;
            }
        }
# ---------------> Input Unit 2 () KM/H ---> Output Unit: FT/M, KM/H, KT, MTS, MPH
        if (Input_Unit == 2) {
            if (Output_Unit == 1) { Cnv_Fact = 54.68066;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1;
            }
            if (Output_Unit == 3) { Cnv_Fact = .5399568;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.2777778;
            }
            if (Output_Unit == 5) { Cnv_Fact = 0.6213712;
            }
        }
# ---------------> Input Unit 3 () KT ---> Output Unit: FT/M, KM/H, KT, MTS, MPH
        if (Input_Unit == 3) {
            if (Output_Unit == 1) { Cnv_Fact = 101.2686;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1.852000;
            }
            if (Output_Unit == 3) { Cnv_Fact = 1;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.5144444;
            }
            if (Output_Unit == 5) { Cnv_Fact = 1.150779;
            }
        }
# ---------------> Input Unit 4 () MTS ---> Output Unit: FT/M, KM/H, KT, MTS, MPH
        if (Input_Unit == 4) {
            if (Output_Unit == 1) { Cnv_Fact = 196.85;
            }
            if (Output_Unit == 2) { Cnv_Fact = 3.6000;
            }
            if (Output_Unit == 3) { Cnv_Fact = 1.9438;
            }
            if (Output_Unit == 4) { Cnv_Fact = 1;
            }
            if (Output_Unit == 5) { Cnv_Fact = 2.2369;
            }
        }
# ---------------> Input Unit 5 () MPH ---> Output Unit: FT/M, KM/H, KT, MTS, MPH
        if (Input_Unit == 5) {
            if (Output_Unit == 1) { Cnv_Fact = 88.0002;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1.609344;
            }
            if (Output_Unit == 3) { Cnv_Fact = 0.8689762;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.4470400;
            }
            if (Output_Unit == 5) { Cnv_Fact = 1;
            }
        }
        VK_Input_Mem = Input_Unit;
        VK_Output_Mem = Output_Unit;

# Output Field Display

        if ((getprop("/instrumentation/efb/Keyboard/Input_Line") == "") or (getprop("/instrumentation/efb/Keyboard/Input_Line") == ".") or (getprop("/instrumentation/efb/Keyboard/Input_Line") == "-")) { setprop("/instrumentation/efb/Keyboard/Output_Line", "");
        } else { Output_Line = getprop("/instrumentation/efb/Keyboard/Input_Line");
        Output_Line = Output_Line * Cnv_Fact;                                       # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Output_Line", Output_Line);          # Print it to the Keyboard Output Field
        }
        setprop("/instrumentation/efb/VK_keypress", "");
}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
setprop("/instrumentation/efb/Keyboard/Input_Line", "");
setprop("/instrumentation/efb/Keyboard/Output_Line", "");
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - LENGHT CONVERSION Parser ----------------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "UTILITIES_CNV_LNG") {

Input_Unit = getprop("/instrumentation/efb/VK_IN_Marker");
Output_Unit = getprop("/instrumentation/efb/VK_OUT_Marker");

# Input keys Check

if (getprop("/instrumentation/efb/VK_keypress") != "" or (Input_Unit != VK_Input_Mem) or (Output_Unit != VK_Output_Mem)) {

# Input Field Parser

        if (getprop("/instrumentation/efb/VK_keypress") == "CLEAR") { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                    # CLEARs the whole Input Field
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                           # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
        setprop("/instrumentation/efb/Keyboard/Input_String", substr(Temp_String, 0, lenght));
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "CHNGS") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                          # CHANGEs SIGN to the Input Field
            if (substr(Temp_String, 0, 1) == "-") { lenght = size(Temp_String) - 1;
            Temp_String = substr(Temp_String, 1, lenght);
            } else { Temp_String = "-" ~ Temp_String;
            }
        setprop("/instrumentation/efb/Keyboard/Input_String", Temp_String);
        setprop("/instrumentation/efb/VK_keypress", "");
        }

# Input Field Display

        setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String") ~ getprop("/instrumentation/efb/VK_keypress")); # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Input_Line", getprop("/instrumentation/efb/Keyboard/Input_String"));                                                 # Print it to the Keyboard Input Field

# ---------------> Conversion Table Selection

# ---------------> Input Unit 1 () FEET ---> Output Unit: FEET, KILOMETERS, METERS, NAUTICAL MILES, STATUTE MILES
        if (Input_Unit == 1) {
            if (Output_Unit == 1) { Cnv_Fact = 1;
            }
            if (Output_Unit == 2) { Cnv_Fact = 0.0003048;
            }
            if (Output_Unit == 3) { Cnv_Fact = 0.30480;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.000164579; # International and US Nautical Miles, NOT UK Nautical Miles !!
            }
            if (Output_Unit == 5) { Cnv_Fact = 0.000189394; # International Statute Miles
            }
        }
# ---------------> Input Unit 2 () KILOMETERS ---> Output Unit: FEET, KILOMETERS, METERS, NAUTICAL MILES, STATUTE MILES
        if (Input_Unit == 2) {
            if (Output_Unit == 1) { Cnv_Fact = 3280.83989501;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1;
            }
            if (Output_Unit == 3) { Cnv_Fact = 1000;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.539956803456; # International and US Nautical Miles, NOT UK Nautical Miles !!
            }
            if (Output_Unit == 5) { Cnv_Fact = 0.621371192237; # International Statute Miles
            }
        }
# ---------------> Input Unit 3 () METERS ---> Output Unit: FEET, KILOMETERS, METERS, NAUTICAL MILES, STATUTE MILES
        if (Input_Unit == 3) {
            if (Output_Unit == 1) { Cnv_Fact = 3.28083989501;
            }
            if (Output_Unit == 2) { Cnv_Fact = 0.001;
            }
            if (Output_Unit == 3) { Cnv_Fact = 1;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.000539956803456; # International and US Nautical Miles, NOT UK Nautical Miles !!
            }
            if (Output_Unit == 5) { Cnv_Fact = 0.000621371192237; # International Statute Miles
            }
        }
# ---------------> Input Unit 4 () NAUTICAL MILES (INTERNATIONAL!) ---> Output Unit: FEET, KILOMETERS, METERS, NAUTICAL MILES, STATUTE MILES
        if (Input_Unit == 4) {
            if (Output_Unit == 1) { Cnv_Fact = 6076.11548556;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1.852;
            }
            if (Output_Unit == 3) { Cnv_Fact = 1852;
            }
            if (Output_Unit == 4) { Cnv_Fact = 1;
            }
            if (Output_Unit == 5) { Cnv_Fact = 1.15077944802; # International Statute Miles
            }
        }
# ---------------> Input Unit 5 () STATUTE MILES ---> Output Unit: FEET, KILOMETERS, METERS, NAUTICAL MILES, STATUTE MILES
        if (Input_Unit == 5) {
            if (Output_Unit == 1) { Cnv_Fact = 5280;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1.609344;
            }
            if (Output_Unit == 3) { Cnv_Fact = 1609.344;
            }
            if (Output_Unit == 4) { Cnv_Fact = 0.868976241901; # International and US Nautical Miles, NOT UK Nautical Miles !!
            }
            if (Output_Unit == 5) { Cnv_Fact = 1;
            }
        }
        VK_Input_Mem = Input_Unit;
        VK_Output_Mem = Output_Unit;

# Output Field Display

        if ((getprop("/instrumentation/efb/Keyboard/Input_Line") == "") or (getprop("/instrumentation/efb/Keyboard/Input_Line") == ".") or (getprop("/instrumentation/efb/Keyboard/Input_Line") == "-")) { setprop("/instrumentation/efb/Keyboard/Output_Line", "");
        } else { Output_Line = getprop("/instrumentation/efb/Keyboard/Input_Line");
        Output_Line = Output_Line * Cnv_Fact;                                       # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Output_Line", Output_Line);          # Print it to the Keyboard Output Field
        }
        setprop("/instrumentation/efb/VK_keypress", "");
}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
setprop("/instrumentation/efb/Keyboard/Input_Line", "");
setprop("/instrumentation/efb/Keyboard/Output_Line", "");
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - WEIGHT CONVERSION Parser ----------------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "UTILITIES_CNV_WGT") {

Input_Unit = getprop("/instrumentation/efb/VK_IN_Marker");
Output_Unit = getprop("/instrumentation/efb/VK_OUT_Marker");

# Input keys Check

if (getprop("/instrumentation/efb/VK_keypress") != "" or (Input_Unit != VK_Input_Mem) or (Output_Unit != VK_Output_Mem)) {

# Input Field Parser

        if (getprop("/instrumentation/efb/VK_keypress") == "CLEAR") { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                    # CLEARs the whole Input Field
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                           # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
        setprop("/instrumentation/efb/Keyboard/Input_String", substr(Temp_String, 0, lenght));
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "CHNGS") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                          # CHANGEs SIGN to the Input Field
            if (substr(Temp_String, 0, 1) == "-") { lenght = size(Temp_String) - 1;
            Temp_String = substr(Temp_String, 1, lenght);
            } else { Temp_String = "-" ~ Temp_String;
            }
        setprop("/instrumentation/efb/Keyboard/Input_String", Temp_String);
        setprop("/instrumentation/efb/VK_keypress", "");
        }

# Input Field Display
        setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String") ~ getprop("/instrumentation/efb/VK_keypress")); # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Input_Line2", getprop("/instrumentation/efb/Keyboard/Input_String"));                                                # Print it to the Keyboard Input Field

# ---------------> Conversion Table Selection

# ---------------> Input Unit 1 () KILOGRAMS ---> Output Unit: KILOGRAMS, POUNDS
        if (Input_Unit == 1) {
            if (Output_Unit == 1) { Cnv_Fact = 1;
            }
            if (Output_Unit == 2) { Cnv_Fact = 2.20462262185;
            }
        }
# ---------------> Input Unit 2 () POUNDS ---> Output Unit: KILOGRAMS, POUNDS
        if (Input_Unit == 2) {
            if (Output_Unit == 1) { Cnv_Fact = 0.45359237;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1;
            }
        }
        VK_Input_Mem = Input_Unit;
        VK_Output_Mem = Output_Unit;

# Output Field Display

        if ((getprop("/instrumentation/efb/Keyboard/Input_Line2") == "") or (getprop("/instrumentation/efb/Keyboard/Input_Line2") == ".") or (getprop("/instrumentation/efb/Keyboard/Input_Line2") == "-")) { setprop("/instrumentation/efb/Keyboard/Output_Line2", "");
        } else { Output_Line2 = getprop("/instrumentation/efb/Keyboard/Input_Line2");
        Output_Line2 = Output_Line2 * Cnv_Fact;                                     # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Output_Line2", Output_Line2);        # Print it to the Keyboard Output Field
        }
        setprop("/instrumentation/efb/VK_keypress", "");
}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
setprop("/instrumentation/efb/Keyboard/Input_Line2", "");
setprop("/instrumentation/efb/Keyboard/Output_Line2", "");
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - TEMPERATURE CONVERSION Parser -----------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "UTILITIES_CNV_TMP") {

Input_Unit = getprop("/instrumentation/efb/VK_IN_Marker");
Output_Unit = getprop("/instrumentation/efb/VK_OUT_Marker");

# Input keys Check

if (getprop("/instrumentation/efb/VK_keypress") != "" or (Input_Unit != VK_Input_Mem) or (Output_Unit != VK_Output_Mem)) {

# Input Field Parser

        if (getprop("/instrumentation/efb/VK_keypress") == "CLEAR") { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                    # CLEARs the whole Input Field
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                           # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
        setprop("/instrumentation/efb/Keyboard/Input_String", substr(Temp_String, 0, lenght));
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "CHNGS") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                          # CHANGEs SIGN to the Input Field
            if (substr(Temp_String, 0, 1) == "-") { lenght = size(Temp_String) - 1;
            Temp_String = substr(Temp_String, 1, lenght);
            } else { Temp_String = "-" ~ Temp_String;
            }
        setprop("/instrumentation/efb/Keyboard/Input_String", Temp_String);
        setprop("/instrumentation/efb/VK_keypress", "");
        }

# Input Field Display
        setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String") ~ getprop("/instrumentation/efb/VK_keypress")); # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Input_Line2", getprop("/instrumentation/efb/Keyboard/Input_String"));                                                # Print it to the Keyboard Input Field



# Output Field Display

        if ((getprop("/instrumentation/efb/Keyboard/Input_Line2") == "") or (getprop("/instrumentation/efb/Keyboard/Input_Line2") == ".") or (getprop("/instrumentation/efb/Keyboard/Input_Line2") == "-")) { setprop("/instrumentation/efb/Keyboard/Output_Line2", "");
        } else { Output_Line2 = getprop("/instrumentation/efb/Keyboard/Input_Line2");
# ---------------> Conversion Table Selection

# ---------------> Input Unit 1 () CELSIUS (C) ---> Output Unit: CELSIUS (C), FAHRENHEIT (F)

        if (Input_Unit == 1) {
            if (Output_Unit == 1) { Cnv_Fact = Output_Line2;
            }
            if (Output_Unit == 2) { Cnv_Fact = (Output_Line2*1.8) + 32;
            }
        }
# ---------------> Input Unit 2 () FAHRENHEIT (F) ---> Output Unit: CELSIUS (C), FAHRENHEIT (F)
        if (Input_Unit == 2) {
            if (Output_Unit == 1) { Cnv_Fact = (Output_Line2 - 32)/1.8;
            }
            if (Output_Unit == 2) { Cnv_Fact = Output_Line2;
            }
        }
        VK_Input_Mem = Input_Unit;
        VK_Output_Mem = Output_Unit;

        Output_Line2 = Cnv_Fact;                                                    # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Output_Line2", Output_Line2);        # Print it to the Keyboard Output Field
        }
        setprop("/instrumentation/efb/VK_keypress", "");
}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
setprop("/instrumentation/efb/Keyboard/Input_Line2", "");
setprop("/instrumentation/efb/Keyboard/Output_Line2", "");
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - VOLUME CONVERSION Parser ----------------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "UTILITIES_CNV_VLM") {

Input_Unit = getprop("/instrumentation/efb/VK_IN_Marker");
Output_Unit = getprop("/instrumentation/efb/VK_OUT_Marker");

Output_TMZ_Line = "";

# Input keys Check

if (getprop("/instrumentation/efb/VK_keypress") != "" or (Input_Unit != VK_Input_Mem) or (Output_Unit != VK_Output_Mem)) {

# Input Field Parser

        if (getprop("/instrumentation/efb/VK_keypress") == "CLEAR") { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                    # CLEARs the whole Input Field
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                           # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
        setprop("/instrumentation/efb/Keyboard/Input_String", substr(Temp_String, 0, lenght));
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "CHNGS") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                          # CHANGEs SIGN to the Input Field
            if (substr(Temp_String, 0, 1) == "-") { lenght = size(Temp_String) - 1;
            Temp_String = substr(Temp_String, 1, lenght);
            } else { Temp_String = "-" ~ Temp_String;
            }
        setprop("/instrumentation/efb/Keyboard/Input_String", Temp_String);
        setprop("/instrumentation/efb/VK_keypress", "");
        }

# Input Field Display
        setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String") ~ getprop("/instrumentation/efb/VK_keypress")); # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Input_Line3", getprop("/instrumentation/efb/Keyboard/Input_String"));                                                # Print it to the Keyboard Input Field

# ---------------> Conversion Table Selection

# ---------------> Input Unit 1 () IMPERIAL GALLONS ---> Output Unit: IMPERIAL GALLONS, US GALLONS, LITERS
        if (Input_Unit == 1) {
            if (Output_Unit == 1) { Cnv_Fact = 1;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1.20095;
            }
            if (Output_Unit == 3) { Cnv_Fact = 4.54609;
            }
        }
# ---------------> Input Unit 2 () US GALLONS ---> Output Unit: IMPERIAL GALLONS, US GALLONS, LITERS
        if (Input_Unit == 2) {
            if (Output_Unit == 1) { Cnv_Fact = 0.832674;
            }
            if (Output_Unit == 2) { Cnv_Fact = 1;
            }
            if (Output_Unit == 3) { Cnv_Fact = 3.78541;
            }
        }
# ---------------> Input Unit 3 () LITERS ---> Output Unit: IMPERIAL GALLONS, US GALLONS, LITERS
        if (Input_Unit == 3) {
            if (Output_Unit == 1) { Cnv_Fact = 0.219969;
            }
            if (Output_Unit == 2) { Cnv_Fact = 0.264172;
            }
            if (Output_Unit == 3) { Cnv_Fact = 1;
            }
        }
        VK_Input_Mem = Input_Unit;
        VK_Output_Mem = Output_Unit;

# Output Field Display

        if ((getprop("/instrumentation/efb/Keyboard/Input_Line3") == "") or (getprop("/instrumentation/efb/Keyboard/Input_Line3") == ".") or (getprop("/instrumentation/efb/Keyboard/Input_Line3") == "-")) { setprop("/instrumentation/efb/Keyboard/Output_Line3", "");
        } else { Output_Line2 = getprop("/instrumentation/efb/Keyboard/Input_Line3");
        Output_Line2 = Output_Line2 * Cnv_Fact;                                     # Build the Input String
        setprop("/instrumentation/efb/Keyboard/Output_Line3", Output_Line2);        # Print it to the Keyboard Output Field
        }
        setprop("/instrumentation/efb/VK_keypress", "");
}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
setprop("/instrumentation/efb/Keyboard/Input_Line3", "");
setprop("/instrumentation/efb/Keyboard/Output_Line3", "");
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - TIME ZONE CONVERSION Parser -------------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "UTILITIES_CNV_TMZ") {

    TMZ_TIME = getprop("/instrumentation/clock/indicated-short-string") ~ "z";
    setprop("/instrumentation/efb/Keyboard/Current_DT_Line", TMZ_DATE ~ " " ~ TMZ_TIME);                                                                                                                # Print Current Date & Time
    setprop("/instrumentation/efb/Keyboard/Converted_Name_Line", "Use Keyboard to Input Time (HHMM)");

# Input keys Check

if (getprop("/instrumentation/efb/VK_keypress") != "") {

# Input Field Parser

        if (getprop("/instrumentation/efb/VK_keypress") == "CLEAR") { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                                                        # CLEARs the whole Input Field and other stuff
        setprop("/instrumentation/efb/Keyboard/Input_HH_Line", "--");
        setprop("/instrumentation/efb/Keyboard/Input_MM_Line", "--");
        setprop("/instrumentation/efb/Keyboard/Input_Zulu_Line", "--:--");
        setprop("/instrumentation/efb/Keyboard/Output_HH", "");
        setprop("/instrumentation/efb/Keyboard/Output_MM", "");
        setprop("/instrumentation/efb/Keyboard/Converted_ID_Line", "");
        setprop("/instrumentation/efb/Keyboard/Converted_Name_Line", "Use Keyboard to Input Time (HHMM)");
        setprop("/instrumentation/efb/Keyboard/Output_TMZ_Line", "--:--");
        setprop("/instrumentation/efb/Keyboard/Cnv_Fact", "");
        TMZ_index = 0;
        Output_TMz_Line = "--:--";
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                                                               # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
        setprop("/instrumentation/efb/Keyboard/Input_String", substr(Temp_String, 0, lenght));
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "CHNGS") { setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String"));                     # Bypasses CHANGEs SIGN
        setprop("/instrumentation/efb/VK_keypress", "");
        }

# Input Field Display

        TMZ_String = getprop("/instrumentation/efb/Keyboard/Input_String");
        TMZ_Input_Lenght = size(TMZ_String);

        if (TMZ_Input_Lenght <= 3)  {
            setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String") ~ getprop("/instrumentation/efb/VK_keypress"));                                 # Build the Input String

            if (TMZ_Input_Lenght > 1) { setprop("/instrumentation/efb/Keyboard/Input_HH_Line", substr(getprop("/instrumentation/efb/Keyboard/Input_String"), 0, 2));                                    # IF 3rd digit, Print HH to the Keyboard Input Field
            setprop("/instrumentation/efb/Keyboard/Output_HH", substr(getprop("/instrumentation/efb/Keyboard/Input_String"), 0, 2));                                                                    # Copy HH to Output_HH
            setprop("/instrumentation/efb/Keyboard/Input_MM_Line", substr(getprop("/instrumentation/efb/Keyboard/Input_String"), 2, TMZ_Input_Lenght));                                                 # IF 3rd digit, Print MM to the Keyboard Input Field
            setprop("/instrumentation/efb/Keyboard/Output_MM", substr(getprop("/instrumentation/efb/Keyboard/Input_String"), 2, TMZ_Input_Lenght));                                                     # Copy MM to Output_MM
            setprop("/instrumentation/efb/Keyboard/Input_Zulu_Line", (getprop("/instrumentation/efb/Keyboard/Input_HH_Line") ~ ":" ~ getprop("/instrumentation/efb/Keyboard/Input_MM_Line")));          # IF 3rd digit, Print "zulu Time" to the Keyboard Output "zulu to be converted" Field (see EFB Manual)
            } else { setprop("/instrumentation/efb/Keyboard/Input_HH_Line", getprop("/instrumentation/efb/Keyboard/Input_String"));                                                                                                                         # Print Blank HH to the Keyboard Input Field
                     setprop("/instrumentation/efb/Keyboard/Input_MM_Line", "--");                                                                                                                      # Print Blank HH to the Keyboard Input Field
                     setprop("/instrumentation/efb/Keyboard/Input_Zulu_Line", getprop("/instrumentation/efb/Keyboard/Input_HH_Line") ~ ":" ~ getprop("/instrumentation/efb/Keyboard/Input_MM_Line"));   # Print Blank "zulu Time" to the Keyboard Output "zulu to be converted" Field (see EFB Manual)                                                                                                                          # Print "" MM to the Keyboard Input Field
                     setprop("/instrumentation/efb/Keyboard/Output_HH", "");
                     setprop("/instrumentation/efb/Keyboard/Output_MM", "");
            }

        } # an 'else' clause should be set here, giving the Pilot an audible 'WARNING Beep', because we cannot accept more than 4 chars for Time Input!
        }
        setprop("/instrumentation/efb/VK_keypress", ""); # reset the VK keys to ""

# ---------------> Output Unit: Input Time Conversion --> TIME ZONES Time

        if (TMZ_Input_Lenght > 1) { # TMZ_Index = TMZ_Index;

            if ((keypress == "r3") and (TMZ_Index > 0)) { TMZ_Index = TMZ_Index - 1;
                keypress = "";
            } # an 'else' clause should be set here, giving the Pilot an audible 'WARNING Beep', because he reached Bottom End of DB File!
            if ((keypress == "r4") and (TMZ_Index < TMZ_DB_Size)) { TMZ_Index = TMZ_Index + 1;
                keypress = "";
            } # an 'else' clause should be set here, giving the Pilot an audible 'WARNING Beep', because he reached Top End of DB File!

#           setprop("/instrumentation/efb/Keyboard/Output_HH", "12");
#           setprop("/instrumentation/efb/Keyboard/Output_MM", "54");
            if (keypress == "r5") { setprop("/instrumentation/efb/Keyboard/Cnv_Fact", "0");                                 # RESET ALL
                setprop("/instrumentation/efb/Keyboard/Input_String", "");
                TMZ_String = "";
                TMZ_Index = 0;
                TMZ_Input_Lenght = 0;
                setprop("/instrumentation/efb/Keyboard/Current_DT_Line", "");
                setprop("/instrumentation/efb/Keyboard/Input_HH_Line", "");
                setprop("/instrumentation/efb/Keyboard/Input_MM_Line", "");
                setprop("/instrumentation/efb/Keyboard/Input_Zulu_Line", "");
                setprop("/instrumentation/efb/Keyboard/Output_HH", "0");
                setprop("/instrumentation/efb/Keyboard/Output_MM", "0");
                setprop("/instrumentation/efb/Keyboard/Converted_ID_Line", "");
                setprop("/instrumentation/efb/Keyboard/Converted_Name_Line", "Use Keyboard to Input Time (HHMM)");
                setprop("/instrumentation/efb/Keyboard/Output_TMZ_Line", "");
                setprop("/instrumentation/efb/Keyboard/Cnv_Fact", "0");
                TMZ_index = 0;
                Output_TMz_Line = "--:--";
            }

            if (getprop("/instrumentation/efb/Keyboard/Output_HH") != "0") {
                    TMZ_Converted_ID = getprop("/instrumentation/efb/TimeZonesDB/IDX[" ~ TMZ_Index ~ "]/ID");
                    TMZ_Converted_Name = getprop("/instrumentation/efb/TimeZonesDB/IDX[" ~ TMZ_Index ~ "]/Name");
                    TMZ_zulu_HH = getprop("/instrumentation/efb/Keyboard/Output_HH");
                    TMZ_Converted_OffSet = getprop("/instrumentation/efb/TimeZonesDB/IDX[" ~ TMZ_Index ~ "]/OffSet");
                    setprop("/instrumentation/efb/Keyboard/Converted_ID_Line", TMZ_Converted_ID);                           # Print Time Zone ID to the Keyboard Converted Time Field
                    setprop("/instrumentation/efb/Keyboard/Converted_Name_Line", TMZ_Converted_Name);                       # Print Time Zone Name to the Keyboard Converted Time Field
                    setprop("/instrumentation/efb/Keyboard/Cnv_Fact", (TMZ_zulu_HH + TMZ_Converted_OffSet));
                } else { setprop("/instrumentation/efb/Keyboard/Cnv_Fact", 0);
                        }

# HH Corrections for Time Zone's Conversion Factors

            if (getprop("/instrumentation/efb/Keyboard/Cnv_Fact") > 9) { setprop("/instrumentation/efb/Keyboard/Cnv_Fact", getprop("/instrumentation/efb/Keyboard/Cnv_Fact"));                                                                              # Print HH Converted Time to the Keyboard Converted Time Field
            } elsif (((getprop("/instrumentation/efb/Keyboard/Cnv_Fact") >= 0) and (getprop("/instrumentation/efb/Keyboard/Cnv_Fact") <= 9))) { setprop("/instrumentation/efb/Keyboard/Cnv_Fact", "0" ~ getprop("/instrumentation/efb/Keyboard/Cnv_Fact")); # Print H Converted Time to the Keyboard Converted Time Field
            } elsif (getprop("/instrumentation/efb/Keyboard/Cnv_Fact") < 0) { setprop("/instrumentation/efb/Keyboard/Cnv_Fact", (24 + getprop("/instrumentation/efb/Keyboard/Cnv_Fact")));                                                                  # Print (24 - HH) Converted Time to the Keyboard Converted Time Field
            }
        } else { setprop("/instrumentation/efb/Keyboard/Cnv_Fact", "--");
                }

# Output Converted Time Field Display

        if ((getprop("/instrumentation/efb/Keyboard/Input_HH_Line") == "") or (getprop("/instrumentation/efb/Keyboard/Input_HH_Line") == ".") or (getprop("/instrumentation/efb/Keyboard/Input_HH_Line") == "--")) { setprop("/instrumentation/efb/Keyboard/Output_TMZ_Line", "");
        Output_TMz_Line = "--:--";
        } else { Output_TMZ_Line = getprop("/instrumentation/efb/Keyboard/Cnv_Fact");
                 Output_TMZ_Line = substr(Output_TMZ_Line, 0, 2) ~ ":" ~ getprop("/instrumentation/efb/Keyboard/Output_MM");# Build the Output String
        }
        setprop("/instrumentation/efb/Keyboard/Output_TMZ_Line", Output_TMZ_Line);                                          # Print it to the Keyboard Output Converted Time Field

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/page", "UTILITIES");
setprop("/instrumentation/efb/Keyboard/Current_DT_Line", "");
setprop("/instrumentation/efb/Keyboard/Input_HH_Line", "");
setprop("/instrumentation/efb/Keyboard/Input_MM_Line", "");
setprop("/instrumentation/efb/Keyboard/Input_Zulu_Line", "");
setprop("/instrumentation/efb/Keyboard/Cnv_Fact", "");
setprop("/instrumentation/efb/Keyboard/Output_HH", "");
setprop("/instrumentation/efb/Keyboard/Output_MM", "");
setprop("/instrumentation/efb/Keyboard/Converted_ID_Line", "");
setprop("/instrumentation/efb/Keyboard/Converted_Name_Line", "");
setprop("/instrumentation/efb/Keyboard/Output_TMZ_Line", "");
setprop("/instrumentation/efb/Keyboard/Input_String", "");

keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - DESCENT RATE Calculator ----------------------------------------------|
#_________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "UTILITIES_DESC_RATE") {

page.clearpage();

# Input keys Check

    if (keypress == "l2") { setprop("/instrumentation/efb/Input_Unit", "Initial_FL");
    setprop("/instrumentation/efb/Keyboard/Input_String","");
    setprop("/instrumentation/efb/DRC_Initial_FL_MEM", getprop("/instrumentation/efb/DRC_Initial_FL"));
    setprop("/instrumentation/efb/VK_DRC_MarkerL", 1);
    setprop("/instrumentation/efb/VK_DRC_MarkerR", 0);
    }
    if (keypress == "r2") { setprop("/instrumentation/efb/Input_Unit", "Target_FL");
    setprop("/instrumentation/efb/Keyboard/Input_String","");
    setprop("/instrumentation/efb/DRC_Target_FL_MEM", getprop("/instrumentation/efb/DRC_Target_FL"));
    setprop("/instrumentation/efb/VK_DRC_MarkerR", 1);
    setprop("/instrumentation/efb/VK_DRC_MarkerL", 0);
    }
    if (keypress == "l3") { setprop("/instrumentation/efb/Input_Unit", "Initial_GS");
    setprop("/instrumentation/efb/Keyboard/Input_String","");
    setprop("/instrumentation/efb/DRC_Initial_GS_MEM", getprop("/instrumentation/efb/DRC_Initial_GS"));
    setprop("/instrumentation/efb/VK_DRC_MarkerL", 2);
    setprop("/instrumentation/efb/VK_DRC_MarkerR", 0);
    }
    if (keypress == "r3") { setprop("/instrumentation/efb/Input_Unit", "Target_GS");
    setprop("/instrumentation/efb/Keyboard/Input_String","");
    setprop("/instrumentation/efb/DRC_Target_GS_MEM", getprop("/instrumentation/efb/DRC_Target_GS"));
    setprop("/instrumentation/efb/VK_DRC_MarkerR", 2);
    setprop("/instrumentation/efb/VK_DRC_MarkerL", 0);
    }
    if (keypress == "l4") { setprop("/instrumentation/efb/Input_Unit", "Distance");
    setprop("/instrumentation/efb/Keyboard/Input_String","");
    setprop("/instrumentation/efb/DRC_Distance_MEM", getprop("/instrumentation/efb/DRC_Distance"));
    setprop("/instrumentation/efb/VK_DRC_MarkerL", 3);
    setprop("/instrumentation/efb/VK_DRC_MarkerR", 0);
    }


# Input keys Parser

if ((getprop("/instrumentation/efb/VK_keypress") != "") and (getprop("/instrumentation/efb/VK_keypress") != ".") and (getprop("/instrumentation/efb/VK_keypress") != "CHNGS") and (getprop("/instrumentation/efb/Input_Unit") != "NO_INPUT")) {

        if (getprop("/instrumentation/efb/VK_keypress") == "CLEAR") { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                                            # CLEARs the whole Input Field
        VK_Key = "VOID";
        setprop("/instrumentation/efb/VK_keypress", "");
        }
        if (getprop("/instrumentation/efb/VK_keypress") == "BKSP") { Temp_String = getprop("/instrumentation/efb/Keyboard/Input_String");                                                   # BACKSPACEs the Input Field
        lenght = size(Temp_String) - 1;
            if (lenght >= 1) {
                    setprop("/instrumentation/efb/Keyboard/Input_String", substr(Temp_String, 0, lenght));
                    setprop("/instrumentation/efb/VK_keypress", "");
            } elsif (lenght <= 0) { setprop("/instrumentation/efb/Keyboard/Input_String", "");                                                                                                          # CLEARs the whole Input Field
                    VK_Key = "VOID";
                }
        }

    DRC_String = getprop("/instrumentation/efb/Keyboard/Input_String");
    DRC_Input_Lenght = size(DRC_String);

        if (DRC_Input_Lenght < 3) {

                if (VK_Key != "VOID") { setprop("/instrumentation/efb/Keyboard/Input_String", getprop("/instrumentation/efb/Keyboard/Input_String") ~ getprop("/instrumentation/efb/VK_keypress"));                 # Build the Input String...
                }
                if ((getprop("/instrumentation/efb/Input_Unit") == "Initial_FL") and (VK_Key != "VOID")) { setprop("/instrumentation/efb/DRC_Initial_FL", getprop("/instrumentation/efb/Keyboard/Input_String"));   # ...For Initial FL
                } elsif ((getprop("/instrumentation/efb/Input_Unit") == "Initial_FL") and (VK_Key == "VOID")) { setprop("/instrumentation/efb/display/DRC_l3", "CLEAR");
                    setprop("/instrumentation/efb/DRC_Initial_FL", getprop("/instrumentation/efb/DRC_Initial_FL_MEM"));
                }
                if ((getprop("/instrumentation/efb/Input_Unit") == "Target_FL") and (VK_Key != "VOID")) { setprop("/instrumentation/efb/DRC_Target_FL", getprop("/instrumentation/efb/Keyboard/Input_String"));     # ...For Target FL
                } elsif ((getprop("/instrumentation/efb/Input_Unit") == "Target_FL") and (VK_Key == "VOID")) { setprop("/instrumentation/efb/display/DRC_r3", "CLEAR");
                    setprop("/instrumentation/efb/DRC_Target_FL", getprop("/instrumentation/efb/DRC_Target_FL_MEM"));
                }
                if ((getprop("/instrumentation/efb/Input_Unit") == "Initial_GS") and (VK_Key != "VOID")) { setprop("/instrumentation/efb/DRC_Initial_GS", getprop("/instrumentation/efb/Keyboard/Input_String"));   # ...For Initial GS
                } elsif ((getprop("/instrumentation/efb/Input_Unit") == "Initial_GS") and (VK_Key == "VOID")) { setprop("/instrumentation/efb/display/DRC_l5", "CLEAR");
                    setprop("/instrumentation/efb/DRC_Initial_GS", getprop("/instrumentation/efb/DRC_Initial_GS_MEM"));
                }
                if ((getprop("/instrumentation/efb/Input_Unit") == "Target_GS") and (VK_Key != "VOID")) { setprop("/instrumentation/efb/DRC_Target_GS", getprop("/instrumentation/efb/Keyboard/Input_String"));     # ...For Target GS
                } elsif ((getprop("/instrumentation/efb/Input_Unit") == "Target_GS") and (VK_Key == "VOID")) { setprop("/instrumentation/efb/display/DRC_r5", "CLEAR");
                setprop("/instrumentation/efb/DRC_Target_GS", getprop("/instrumentation/efb/DRC_Target_GS_MEM"));
                }
                if ((getprop("/instrumentation/efb/Input_Unit") == "Distance")  and (VK_Key != "VOID")) { setprop("/instrumentation/efb/DRC_Distance", getprop("/instrumentation/efb/Keyboard/Input_String"));      # ...For Distance
                } elsif ((getprop("/instrumentation/efb/Input_Unit") == "Distance")  and (VK_Key == "VOID")) { setprop("/instrumentation/efb/display/DRC_l7", "CLEAR");
                setprop("/instrumentation/efb/DRC_Distance", getprop("/instrumentation/efb/DRC_Distance_MEM"));
                }
        }
    }
    setprop("/instrumentation/efb/VK_keypress", ""); # reset the VK keys to ""
    VK_Key = "";
# Transfers Values to DRC variables as numbers

Initial_FL = num(getprop("/instrumentation/efb/DRC_Initial_FL"));
Target_FL = num(getprop("/instrumentation/efb/DRC_Target_FL"));
Initial_GS = num(getprop("/instrumentation/efb/DRC_Initial_GS"));
Target_GS = num(getprop("/instrumentation/efb/DRC_Target_GS"));
DRC_Distance = num(getprop("/instrumentation/efb/DRC_Distance"));

# Calculates Formulas
# Formula: [Angle of Descent (ft/NM) = ALT Gradient/Distance] |||| [SPD Factor (ft/min) = SPD Gradient/60] |||| [Target Descent Rate (Fpm) = Angle of Descent * SPD Factor]

var DRC_Angle = (Target_FL - Initial_FL)/DRC_Distance;
var DRC_AvgSpeed = (Initial_GS + Target_GS)/2;
var DRC_Fact = DRC_AvgSpeed/60;
var DRC_Output = DRC_Angle * DRC_Fact*100;
var DRC_Time = (Target_FL - Initial_FL)/(DRC_Output/100);

# Prepares Output Strings

DRC_l3 = substr(getprop("/instrumentation/efb/DRC_Initial_FL"), 0, 3);
CUT = split(".", DRC_l3);
DRC_l3 = CUT[0];

DRC_r3 = substr(getprop("/instrumentation/efb/DRC_Target_FL"), 0, 3);
CUT = split(".", DRC_r3);
DRC_r3 = CUT[0];

DRC_l5 = substr(getprop("/instrumentation/efb/DRC_Initial_GS"), 0, 3);
CUT = split(".", DRC_l5);
DRC_l5 = CUT[0];

DRC_r5 = substr(getprop("/instrumentation/efb/DRC_Target_GS"), 0, 3);
CUT = split(".", DRC_r5);
DRC_r5 = CUT[0];

DRC_l7 = substr(getprop("/instrumentation/efb/DRC_Distance"), 0, 3);
CUT = split(".", DRC_l7);
DRC_l7 = CUT[0];

setprop("/instrumentation/efb/DRC_Output", "100");
setprop("/instrumentation/efb/DRC_Output", DRC_Output);
DRC_r8 = substr(getprop("/instrumentation/efb/DRC_Output"), 0, 8);
CUT = split(".", DRC_r8);
DRC_r8 = CUT[0];

setprop("/instrumentation/efb/DRC_Angle", "100");
setprop("/instrumentation/efb/DRC_Angle", DRC_Angle);
DRC_r9 = substr(getprop("/instrumentation/efb/DRC_Angle"), 0, 5);
# CUT = split(".", DRC_r9);
# DRC_r9 = CUT[0];

setprop("/instrumentation/efb/DRC_Time", "100");
setprop("/instrumentation/efb/DRC_Time", DRC_Time);
DRC_r10 = substr(getprop("/instrumentation/efb/DRC_Time"), 0, 5);
#CUT = split(".", DRC_r10);
#DRC_r10 = CUT[0];


page.DRCupdate();   # Displays Output

if (keypress == "MENU") { page.DRCclearpage();
page.DRCupdate();
setprop("/sim/model/efb/page", "Displays/PU_1.jpg");
setprop("/instrumentation/efb/VK_DRC_MarkerR", 0);
setprop("/instrumentation/efb/VK_DRC_MarkerL", 0);
setprop("/instrumentation/efb/page", "UTILITIES");
keypress = "";
}
#__________________________________________________________________________________________
# PILOT UTILITIES - NORMAL PROCEDURES MANUAL ----------------------------------------------|
#__________________________________________________________________________________________|
} elsif (getprop("/instrumentation/efb/page") == "NORM PROC MANUAL") {

    page.clearpage();

if (keypress == "PGUP") { setprop("/instrumentation/efb/manual-page", getprop("/instrumentation/efb/manual-page") - 0.20);
keypress = "";
}
if (keypress == "ScrollUP") { setprop("/instrumentation/efb/manual-page", getprop("/instrumentation/efb/manual-page") - 0.02);
keypress = "";
}

if (keypress == "ScrollDN") { setprop("/instrumentation/efb/manual-page", getprop("/instrumentation/efb/manual-page") + 0.02);
keypress = "";
}

if (keypress == "PGDN") { setprop("/instrumentation/efb/manual-page", getprop("/instrumentation/efb/manual-page") + 0.20);
keypress = "";
}

if (keypress == "MENU") { setprop("/sim/model/efb/page", "Displays/Documents_1.jpg");
setprop("/instrumentation/efb/page", "DOCUMENTS");
keypress = "";
}

}
#___________________________________________________________________________________________
#_______________________________END of Parsers & SubParsers_________________________________|

    page.update();

if ((getprop("/instrumentation/efb/page") == "Airport Charts") or (getprop("/instrumentation/efb/page") == "Airport Diagram") or (getprop("/instrumentation/efb/page") == "NORM PROC MANUAL")) setprop("/instrumentation/efb/text-color", 0);
else setprop("/instrumentation/efb/text-color", 1);

},
    reset : func {
        me.loopid += 1;
        me._loop_(me.loopid);
    },
    _loop_ : func(id) {
        id == me.loopid or return;
        me.update();
        settimer(func { me._loop_(id); }, me.UPDATE_INTERVAL);
    }

};

var page = {
    update : func {

        setprop("/instrumentation/efb/display/line0-l", l0);
        setprop("/instrumentation/efb/display/line1-l", l1);
        setprop("/instrumentation/efb/display/line2-l", l2);
        setprop("/instrumentation/efb/display/line3-l", l3);
        setprop("/instrumentation/efb/display/line4-l", l4);
        setprop("/instrumentation/efb/display/line5-l", l5);
        setprop("/instrumentation/efb/display/line6-l", l6);
        setprop("/instrumentation/efb/display/line7-l", l7);
        setprop("/instrumentation/efb/display/line8-l", l8);
        setprop("/instrumentation/efb/display/line9-l", l9);
        setprop("/instrumentation/efb/display/line10-l", l10);
        setprop("/instrumentation/efb/display/line11-l", l11);
        setprop("/instrumentation/efb/display/line12-l", l12);
        setprop("/instrumentation/efb/display/line13-l", l13);
        setprop("/instrumentation/efb/display/line14-l", l14);
        setprop("/instrumentation/efb/display/line15-l", l15);
        setprop("/instrumentation/efb/display/line16-l", l16);
        setprop("/instrumentation/efb/display/line17-l", l17);
        setprop("/instrumentation/efb/display/line18-l", l18);
        setprop("/instrumentation/efb/display/line19-l", l19);
        setprop("/instrumentation/efb/display/line20-l", l20);

        setprop("/instrumentation/efb/display/line1-r", r1);
        setprop("/instrumentation/efb/display/line2-r", r2);
        setprop("/instrumentation/efb/display/line3-r", r3);
        setprop("/instrumentation/efb/display/line4-r", r4);
        setprop("/instrumentation/efb/display/line5-r", r5);
        setprop("/instrumentation/efb/display/line6-r", r6);
        setprop("/instrumentation/efb/display/line7-r", r7);
        setprop("/instrumentation/efb/display/line8-r", r8);
        setprop("/instrumentation/efb/display/line9-r", r9);
        setprop("/instrumentation/efb/display/line10-r", r10);
        setprop("/instrumentation/efb/display/line11-r", r11);
        setprop("/instrumentation/efb/display/line12-r", r12);
        setprop("/instrumentation/efb/display/line13-r", r13);
        setprop("/instrumentation/efb/display/line14-r", r14);
        setprop("/instrumentation/efb/display/line15-r", r15);
        setprop("/instrumentation/efb/display/line16-r", r16);
        setprop("/instrumentation/efb/display/line17-r", r17);
        setprop("/instrumentation/efb/display/line18-r", r18);
        setprop("/instrumentation/efb/display/line19-r", r19);
        setprop("/instrumentation/efb/display/line20-r", r20);

        setprop("/instrumentation/efb/display/input-helper", helper);
        setprop("/instrumentation/efb/keypress", keypress);

},
    clearpage : func {

        l0 = "";
        l1 = "";
        l2 = "";
        l3 = "";
        l4 = "";
        l5 = "";
        l6 = "";
        l7 = "";
        l8 = "";
        l9 = "";
        l10 = "";
        l11 = "";
        l12 = "";
        l13 = "";
        l14 = "";
        l15 = "";
        l16 = "";
        l17 = "";
        l18 = "";
        l19 = "";
        l20 = "";

        r1 = "";
        r2 = "";
        r3 = "";
        r4 = "";
        r5 = "";
        r6 = "";
        r7 = "";
        r8 = "";
        r9 = "";
        r10 = "";
        r11 = "";
        r12 = "";
        r13 = "";
        r14 = "";
        r15 = "";
        r16 = "";
        r17 = "";
        r18 = "";
        r19 = "";
        r20 = "";

        helper = "";

},

    index : func {

l0 = "";
l1 = "";
l2 = "";
l3 = "";
l4 = "";
l5 = "";
l6 = "";
l7 = "";
l8 = "";
l9 = "";
l10 = "";
l11 = "";
l12 = "";
l13 = "";
l14 = "";
l15 = "";
l16 = "";
l17 = "";
l18 = "";
l19 = "";
l20 = "";


r1 = "";
r2 = "";
r3 = "";
r4 = "";
r5 = "";
r6 = "";
r7 = "";
r8 = "";
r9 = "";
r10 = "";
r11 = "";
r12 = "";
r13 = "";
r14 = "";
r15 = "";
r16 = "";
r17 = "";
r18 = "";
r19 = "";
r20 = "";


},

    index_TEST : func {

l0 = "< TEST_L0";
l1 = "< TEST_L1";
l2 = "< TEST_L2";
l3 = "< TEST_L3";
l4 = "< TEST_L4";
l5 = "< TEST_L5";
l6 = "< TEST_L6";
l7 = "< TEST_L7";
l8 = "< TEST_L8";
l9 = "< TEST_L9";
l10 = "< TEST_L10";
l11 = "< TEST_L11";
l12 = "< TEST_L12";
l13 = "< TEST_L13";
l14 = "< TEST_L14";
l15 = "< TEST_L15";
l16 = "< TEST_L16";
l17 = "< TEST_L17";
l18 = "< TEST_L18";
l19 = "< TEST_L19";
l20 = "< TEST_L20";

r1 = "TEST >";
r2 = "TEST >";
r3 = "TEST >";
r4 = "TEST >";
r5 = "TEST >";
r6 = "TEST >";
r7 = "TEST >";
r8 = "TEST >";
r9 = "TEST >";
r10 = "TEST >";
r11 = "TEST >";
r12 = "TEST >";
r13 = "TEST >";
r14 = "TEST >";
r15 = "TEST_R15 >";
r16 = "TEST_R16 >";
r17 = "TEST_R17 >";
r18 = "TEST_R18 >";
r19 = "TEST_R19 >";
r20 = "TEST_R20 >";

},
    KCupdate : func {

        setprop("/instrumentation/efb/display/lineAPT_NAME", KCl0);
        setprop("/instrumentation/efb/display/lineAPT_LOCATION", KCl0_0);
        setprop("/instrumentation/efb/display/lineAPT_PAGESHOW", KCl0_1);
        setprop("/instrumentation/efb/display/lineSTAR", KCl1);
        setprop("/instrumentation/efb/display/lineIAP", KCl2);
        setprop("/instrumentation/efb/display/lineSID", KCl3);
        setprop("/instrumentation/efb/display/lineAPT", KCl4);

        setprop("/instrumentation/efb/display/lineCHART1-r", KCr1);
        setprop("/instrumentation/efb/display/lineCHART2-r", KCr2);
        setprop("/instrumentation/efb/display/lineCHART3-r", KCr3);

        setprop("/instrumentation/efb/Keyboard/CHART_Input_Line", Keyboard_Helper);
        setprop("/instrumentation/efb/Keyboard/CHART_Output_Line", Keyboard_Message);

},
    KCclearpage : func {

        KCl0 = "";
        KCl0_0 = "";
        KCl0_1 = "";
        KCl1 = "";
        KCl2 = "";
        KCl3 = "";
        KCl4 = "";

        KCr1 = "";
        KCr2 = "";
        KCr3 = "";

        Keyboard_Helper = "";
        Keyboard_Message = "";
        helper = "";

},
    DRCupdate : func {

        setprop("/instrumentation/efb/display/DRC_l3", DRC_l3);
        setprop("/instrumentation/efb/display/DRC_l5", DRC_l5);
        setprop("/instrumentation/efb/display/DRC_r3", DRC_r3);
        setprop("/instrumentation/efb/display/DRC_r5", DRC_r5);
        setprop("/instrumentation/efb/display/DRC_l7", DRC_l7);
        setprop("/instrumentation/efb/display/DRC_r8", DRC_r8);
        setprop("/instrumentation/efb/display/DRC_r9", DRC_r9);
        setprop("/instrumentation/efb/display/DRC_r10", DRC_r10);

},
    DRCclearpage : func {

        DRC_l3 = "";
        DRC_l5 = "";
        DRC_r3 = "";
        DRC_r5 = "";
        DRC_l7 = "";
        DRC_r8 = "";
        DRC_r9 = "";
        DRC_r10 = "";

},
    airportinfo : func {

if (getprop("/instrumentation/gps/scratch/name") == nil) { ClosestName = "";
} else ClosestName = getprop("/instrumentation/gps/scratch/name");

l2 = "Airport   : " ~ getprop("/instrumentation/gps/scratch/ident") ~ " (" ~ ClosestName ~ ")";
l3 = "Latitude  : " ~ sprintf("%3.4f", getprop("/instrumentation/gps/scratch/latitude-deg"));
l4 = "Longitude : " ~ sprintf("%3.4f", getprop("/instrumentation/gps/scratch/longitude-deg"));
l5 = "Elevation : " ~ sprintf("%3.4f", getprop("/instrumentation/gps/scratch/altitude-ft")) ~ " ft";
setprop("/environment/metar[6]/station-id", getprop("/instrumentation/gps/scratch/ident"));

l7 = "Runways : ";

l8 = "         ";

for (var n = 0; n < 12; n += 1) {

    if (getprop("/instrumentation/gps/scratch/runways[" ~ n ~ "]/id") != nil) {

        if (n <= 7) l7 = l7 ~ getprop("/instrumentation/gps/scratch/runways[" ~ n ~ "]/id") ~ " ";
        else l8 = l8 ~ getprop("/instrumentation/gps/scratch/runways[" ~ n ~ "]/id") ~ " ";
    }

l10 = "Weather Source: NOAA/METAR";
r10 = substr(getprop("/environment/metar[6]/data"),0,16) ~ "z";
l11 = substr(getprop("/environment/metar[6]/data"),17,41);

if (size(getprop("/environment/metar[6]/data")) > 41) l12 = substr(getprop("/environment/metar[6]/data"), 58, 41);

l13 = "           Current Weather Situation";
l14 = "Temperature : " ~ sprintf("%3.2f", getprop("/environment/metar[6]/temperature-degc")) ~ " C";
r14 = "Dewpoint : " ~ sprintf("%3.2f", getprop("/environment/metar[6]/dewpoint-degc")) ~ " C";
l15 = "Wind Direction : " ~ sprintf("%3.0f", getprop("/environment/metar[6]/base-wind-dir-deg")) ~ " degs";
r15 = "Wind Speed : " ~ sprintf("%3.0f", getprop("/environment/metar[6]/base-wind-speed-kt")) ~ " Kt";
l16 = "Max Visibility : " ~ sprintf("%3.0f", getprop("/environment/metar[6]/max-visibility-m")) ~ " ft";
r16 = "Min Visibility : " ~ sprintf("%3.0f", getprop("/environment/metar[6]/min-visibility-m")) ~ " ft";
l17 = "Relative Humidity : " ~ sprintf("%3.2f", getprop("/environment/metar[6]/rel-humidity-norm")) ~ " %";
l18 = "Pressure : " ~ sprintf("%3.2f", getprop("/environment/metar[6]/pressure-inhg")) ~ " inHg";
l20 = "Weather Report subject to Station availability";

}

},
    FlightMonitor : func {

if (getprop("/instrumentation/efb/FlightStatus") == 1) {
var FStatus = "ACTIVE";
} else FStatus = "INACTIVE";
if (getprop("/autopilot/route-manager/active") == 1) {
if (getprop("/autopilot/route-manager/departure/takeoff-time") != nil) { var TOT = getprop("/autopilot/route-manager/departure/takeoff-time") ~ "z";
} else TOT = "Unknown";
if (getprop("/autopilot/route-manager/destination/touchdown-time") != nil) { var TDT = getprop("/autopilot/route-manager/destination/touchdown-time") ~ "z";
} else TDT = "Unknown";
var OAPT = getprop("/autopilot/route-manager/departure/airport") ~ " " ~ getprop("/autopilot/route-manager/departure/runway");
var DAPT = getprop("/autopilot/route-manager/destination/airport") ~ " " ~ getprop("/autopilot/route-manager/destination/runway");
} else { OAPT = "NOT Set";
DAPT = "NOT Set";
TOT = "Unknown";
TDT = "Unknown";
}


l2 = "Aircraft: " ~ getprop("/sim/description") ~ " Seattle";
l3 = "Operator: " ~ substr(getprop("/sim/aircraft-operator"),0,3);
r3 = "CallSign: " ~ substr(getprop("/sim/multiplay/callsign"), 0,6);
l4 = "Flight No: " ~ "NOT Set"; # This will be set through CDU (To be done)
r4 = "Flight Status: " ~ FStatus;
l5 = "Origin APT: " ~ OAPT;
r5 = "TO Time: " ~ TOT;
l6 = "Destination APT: " ~ DAPT;
r6 = "TD Time: " ~ TDT;
l7 = "Date: " ~ substr(getprop("environment/metar/data"),0,10);
r7 = "Time: " ~ getprop("/instrumentation/clock/indicated-short-string") ~ "z";
l9 = "Ind. ALT: " ~ sprintf("%3.2f", getprop("/Instrumentation/altimeter/indicated-altitude-ft")) ~ " ft";
r9 = "Press. ALT: " ~ sprintf("%3.2f", getprop("/Instrumentation/altimeter/pressure-alt-ft")) ~ " ft";
l10 = "Press. hPa: " ~ sprintf("%3.2f", getprop("/Instrumentation/altimeter/setting-hpa"));
r10 = "Press. inHg: " ~ sprintf("%3.2f", getprop("/Instrumentation/altimeter/setting-inhg"));
l11 = "Speed Knots: " ~ sprintf("%3.0f", getprop("/Instrumentation/airspeed/indicated-speed-kt"));
r11 = "Speed Mach: " ~ sprintf("%3.0f", getprop("/Instrumentation/airspeed/indicated-mach"));
l12 = "Temperature C: " ~ sprintf("%3.2f", getprop("/environment/temperature-degc"));
r12 = "Temperature F: " ~ sprintf("%3.2f", getprop("/environment/temperature-degf"));
l13 = "Wind Dir.: " ~ sprintf("%3.0f", getprop("/environment/metar/base-wind-dir-deg")) ~ " degs";
r13 = "Wind Speed: " ~ sprintf("%3.0f", getprop("/environment/base-wind-speed-kt")) ~ " kts";
l14 = "Total Fuel: " ~ sprintf("%3.2f", getprop("/consumables/fuel/total-fuel-gals")) ~ " gals";
l14 = "Gross Weight: " ~ sprintf("%3.2f", getprop("/yasim/gross-weight-lbs")) ~ " lbs";

},
    gps : func {

l1 = "         GPS POSITION / SETTINGS";
l2 = "Latitude  : " ~ sprintf("%3.2f", getprop("/instrumentation/gps/indicated-latitude-deg")) ~ " degs";
r2 = "Longitude : " ~ sprintf("%3.2f", getprop("/instrumentation/gps/indicated-longitude-deg")) ~ " degs";

l13 = "GPS Mode: " ~ getprop("/instrumentation/gps/mode");
r13 = "WayPoint ID: " ~ getprop("/instrumentation/gps/wp/wp[1]/ID");
l14 = "Leg Distance: " ~ sprintf("%3.2f", getprop("/instrumentation/gps/wp/leg-distance-nm")) ~ " Nm";
l15 = "Leg Magnetic Course : " ~ sprintf("%3.2f", getprop("/instrumentation/gps/wp/leg-mag-course-deg")) ~ " degs";
l16 = "Leg True Heading: " ~ sprintf("%3.2f", getprop("/instrumentation/gps/wp/leg-true-course-deg")) ~ " degs";


},
    charts_keyboard : func {

setprop("/instrumentation/efb/chart/Status", "ON");
setprop("/instrumentation/efb/chart/type", "APT");
PageList = getprop("/instrumentation/efb/chart/PageList");

# Checks existence of Charts in the DB by chart's type ~ "-0"; example: "KSFO/type-0"

var Chart_Search = "";
Chart_Search = sprintf("%s", getprop("/instrumentation/efb/chart/icao"));

# HERE we need to launch the SEARCH into the ChartsList hash


#if (getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ getprop("/instrumentation/efb/chart/type") ~ "-0") == nil ) { setprop("/instrumentation/efb/chart_Found", "NOT_FOUND");
#nochart = 1;
#} else { setprop("/instrumentation/efb/chart_Found", "FOUND");
#nochart = 0;
#}
setprop("/instrumentation/efb/Keyboard/CHART_Input_Line", "Charts for " ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ ": " ~ getprop("/instrumentation/efb/chart_Found"));

if (nochart == 0) {

        # gets the APT's Name & Location

        setprop("/instrumentation/efb/chart/type", "NAME");
        KCl0 = getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ getprop("/instrumentation/efb/chart/type"));
        setprop("/instrumentation/efb/chart/type", "LOCATION");
        KCl0_0 = getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ getprop("/instrumentation/efb/chart/type"));

        setprop("/instrumentation/efb/chart/type", "APT");

        # Gets the number of charts (by Type) in the Charts DB

         STAR_Status = setprop("/instrumentation/efb/chart/NumSTARs", (getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ "STARs")));
         IAP_Status = setprop("/instrumentation/efb/chart/NumIAPs", (getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ "IAPs")));
         SID_Status = setprop("/instrumentation/efb/chart/NumSIDs", (getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ "SIDs")));
         APT_Status = setprop("/instrumentation/efb/chart/NumAPTs", (getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ "APTs")));

        # Gets the Type of chart from Pilot's Selection

        if (getprop("/instrumentation/efb/VK_Chart_Type") != "") {

        if (getprop("/instrumentation/efb/VK_Chart_Type") == "STAR") { setprop("/instrumentation/efb/chart/type", "STAR");
        Keyboard_Message = getprop("/instrumentation/efb/chart/NumSTARs") ~ " " ~ getprop("/instrumentation/efb/chart/type") ~ " Charts for " ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ " Apt - Select a Chart";
        STAR_Status = 1;
        } else STAR_STATUS = 0;
        if (getprop("/instrumentation/efb/VK_Chart_Type") == "IAP") { setprop("/instrumentation/efb/chart/type", "IAP");
        Keyboard_Message = getprop("/instrumentation/efb/chart/NumIAPs") ~ " " ~ getprop("/instrumentation/efb/chart/type") ~ " Charts for " ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ " Apt - Select a Chart";
        IAP_Status = 1;
        } else IAP_Status = 0;
        if (getprop("/instrumentation/efb/VK_Chart_Type") == "SID") { setprop("/instrumentation/efb/chart/type", "SID");
        Keyboard_Message = getprop("/instrumentation/efb/chart/NumSIDs") ~ " " ~ getprop("/instrumentation/efb/chart/type") ~ " Charts for " ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ " Apt - Select a Chart";
        SID_Status = 1;
        } else SID_Status = 0;
        if (getprop("/instrumentation/efb/VK_Chart_Type") == "APT") { setprop("/instrumentation/efb/chart/type", "APT");
        Keyboard_Message = getprop("/instrumentation/efb/chart/NumAPTs") ~ " " ~ getprop("/instrumentation/efb/chart/type") ~ " Charts for " ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ " Apt - Select a Chart";
        APT_Status = 1;
        } else APT_Status = 0;

        setprop("/instrumentation/efb/VK_Chart_Type", getprop("/instrumentation/efb/chart/type"));

        setprop("/instrumentation/efb/chartsDB", "ChartsDB/");

        #setprop("/instrumentation/efb/chart/selected", getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ getprop("/instrumentation/efb/chart/type") ~ "-1"));

        lastn = getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ getprop("/instrumentation/efb/chart/type") ~ "s") - 1;
        if (lastn <= 0) { lastn = 0;
        }

        if ((STAR_Status == 0) and (IAP_Status == 0) and (SID_Status == 0) and (APT_Status == 0)) { setprop("/instrumentation/efb/chart/Status", 0);
        Keyboard_Message = "No Charts available for: " ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ " Apt";
        setprop("/instrumentation/efb/chart/Status", "OFF");
        }

        # Gets the available ICAO/Type charts in the Charts DB

        for (var index = 0; index <= 29; index += 1) {
        ChartName[index] = ""
        }

        if (lastn > 0) {
                        for (var index = 0; index <= lastn; index += 1) {
                        setprop("/instrumentation/efb/chart/IDX", index);
                        setprop("/instrumentation/efb/chart/selected", (getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ getprop("/instrumentation/efb/chart/type") ~ "-" ~ getprop("/instrumentation/efb/chart/IDX"))));
                        ChartName[index] = getprop("/instrumentation/efb/chart/selected");
        }
        } else { setprop("/instrumentation/efb/chart/selected", (getprop("/instrumentation/efb/chartsDB/" ~ sprintf("%s", getprop("/instrumentation/efb/chart/icao")) ~ "/" ~ getprop("/instrumentation/efb/chart/type") ~ "-0")));
                ChartName[0] = getprop("/instrumentation/efb/chart/selected");
        }
        Keyboard_Helper = "Enter Airport ICAO";
        setprop("/instrumentation/efb/Keyboard/CHART_Input_Line", Keyboard_Helper);
        setprop("/instrumentation/efb/Keyboard/CHART_Output_Line", Keyboard_Message);

        # Prints Charts values to Upper Input Display
        if (getprop("/instrumentation/efb/chart/Status") == "ON") {

        KCl1 = sprintf(getprop("/instrumentation/efb/chart/NumSTARs"));
        KCl2 = sprintf(getprop ("/instrumentation/efb/chart/NumIAPs"));
        KCl3 = sprintf(getprop ("/instrumentation/efb/chart/NumSIDs"));
        KCl4 = sprintf(getprop ("/instrumentation/efb/chart/NumAPTs"));

        # Set Index Offset for proper Page Display (by 3 rows)

        if (lastn <=2) {
        Index_Max = 0;
        }
        if ((lastn > 2) and (lastn <=5)) {
        Index_Max = 3;
        }
        if ((lastn > 5) and (lastn <=8)) {
        Index_Max = 6;
        }
        if ((lastn > 8) and (lastn <=11)) {
        Index_Max = 9;
        }
        if ((lastn > 11) and (lastn <=14)) {
        Index_Max = 12;
        }
        if ((lastn > 14) and (lastn <=17)) {
        Index_Max = 15;
        }
        if ((lastn > 17) and (lastn <=20)) {
        Index_Max = 18;
        }
        if ((lastn > 20) and (lastn <=23)) {
        Index_Max = 21;
        }
        if ((lastn > 23) and (lastn <=26)) {
        Index_Max = 24;
        }
        if ((lastn > 26) and (lastn <=29)) {
        Index_Max = 27;
        }

        Chart_Pages = (Index_Max/3) + 1;

        # Displays Actual Chart Page/Total Pages

        Page_Show = "Page " ~ getprop("/instrumentation/efb/chart/PageList") ~ "/" ~ Chart_Pages;
        setprop("instrumentation/efb/chart/PageShow", Page_Show);
        KCl0_1 = getprop("/instrumentation/efb/chart/PageShow");

        # Build 3 rows of Chart Names

        for (var index = 0; index <= 2; index += 1) {
        Index_Offset = ((getprop("/instrumentation/efb/chart/PageList") - 1) * 3);
        Index_Offset = Index_Offset + index;
        ChartDisp[index] = ChartName[Index_Offset];
        }
        # Displays 3 Chart Names [MAX Lenght = 27 chars !], ready for Selection by the Pilot

        setprop("instrumentation/efb/chart/Selection_0", ChartDisp[0]);
        setprop("instrumentation/efb/chart/Selection_1", ChartDisp[1]);
        setprop("instrumentation/efb/chart/Selection_2", ChartDisp[2]);
        KCr1 = substr(getprop("instrumentation/efb/chart/Selection_0"), 0, 26);
        KCr2 = substr(getprop("instrumentation/efb/chart/Selection_1"), 0, 26);
        KCr3 = substr(getprop("instrumentation/efb/chart/Selection_2"), 0, 26);

        } else {

        KCl0 = "";
        KCl0_0 = "";
        KCl0_1 = "";
        KCl1 = "";
        KCl2 = "";
        KCl3 = "";
        KCl4 = "";

        KCr1 = "";
        KCr2 = "";
        KCr3 = "";
        setprop("instrumentation/efb/chart/Selection_0", "");
        setprop("instrumentation/efb/chart/Selection_1", "");
        setprop("instrumentation/efb/chart/Selection_2", "");
        }
        page.KCupdate();
        }
} # END of 'nochart == 0' Brace

}


};


var toggle = func(property) {

if (getprop(property) == 1) setprop(property, 0);
else setprop(property, 1);

}

setlistener("sim/signals/fdm-initialized", func
 {
 efb.init();
 });
