# Q100/200/300 EHSI by D-ECHO based on
# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)

#	Reference(s):
#		https://www.smartcockpit.com/docs/Dash8-200-300-Navigation.pdf
#		https://www.smartcockpit.com/docs/Dash8-200-300-Flight_Instruments.pdf

var EHSI_main = nil;
var EHSI_display = nil;
var page = "only";

#All properties used...
#...in fast update:
var IAS_bug1 = props.globals.getNode("/instrumentation/EHSI/ias-bugs/bug1",1);
var IAS_bug1diff = props.globals.getNode("/instrumentation/EHSI/ias-bugs/bug1-diff", 1);
var IAS_bug1 = props.globals.getNode("/instrumentation/EHSI/ias-bugs/bug2",1);
var IAS_bug2diff = props.globals.getNode("/instrumentation/EHSI/ias-bugs/bug2-diff", 1);
var IAS = props.globals.getNode("/instrumentation/airspeed-indicator/indicated-speed-kt", 1);
var IAS_10 = props.globals.getNode("/instrumentation/pfd/asi-10", 1);
var IAS_100 = props.globals.getNode("/instrumentation/pfd/asi-100", 1);
var Heading_magnetic = props.globals.getNode("/orientation/heading-magnetic-deg", 1);
var ALT_bugdiff = props.globals.getNode("/instrumentation/pfd/alt-bug-diff", 1);
var ALT = props.globals.getNode("/instrumentation/altimeter/indicated-altitude-ft", 1);
var ALT_1000 = props.globals.getNode("/instrumentation/EHSI/alt-1000", 1);
var ALT_100 = props.globals.getNode("/instrumentation/EHSI/alt-100", 1);
var ALT_AGL = props.globals.getNode("/position/gear-agl-ft", 1);
var VS = props.globals.getNode("/instrumentation/vertical-speed-indicator/indicated-speed-fpm", 1);
var VS_needle = props.globals.getNode("/instrumentation/pfd/vs-needle", 1);
var AI_pitch = props.globals.getNode("/orientation/pitch-deg", 1);
var AI_roll = props.globals.getNode("/orientation/roll-deg", 1);
var Slip_Skid = props.globals.getNode("/instrumentation/slip-skid-ball/indicated-slip-skid", 1);

#in slow update:
var Ground_Speed = props.globals.getNode("/velocities/groundspeed-kt", 1);
var AP_modelat = props.globals.getNode("/it-autoflight/mode/lat", 1);
var AP_modearm = props.globals.getNode("/it-autoflight/mode/arm", 1);
var AP_modevert = props.globals.getNode("/it-autoflight/mode/vert", 1);
var AP_vs = props.globals.getNode("/it-autoflight/input/vs", 1);
var AP_ias = props.globals.getNode("/it-autoflight/input/spd-kts", 1);
var AP_alt = props.globals.getNode("/it-autoflight/input/alt", 1);
var AP_hdg = props.globals.getNode("/it-autoflight/input/hdg", 1);
var AP_navsource = props.globals.getNode("/it-autoflight/settings/nav-source", 1);
var Heading_bugdiff = props.globals.getNode("/instrumentation/pfd/hdg-bug-diff", 1);

var nav = [ nil, nil ];
var adf = [ nil, nil ];
for( var i = 0; i <= 1; i += 1 ){
	nav[ i ] = {
		in_range:	props.globals.getNode("/instrumentation/nav["~ i ~"]/in-range", 1),
		defl:		props.globals.getNode("/instrumentation/nav["~ i ~"]/heading-needle-deflection", 1),
		freq:		props.globals.getNode("/instrumentation/nav["~ i ~"]/frequencies/selected-mhz", 1),
		rad:		props.globals.getNode("/instrumentation/nav["~ i ~"]/radials/selected-deg", 1),
		dme_in_range:	props.globals.getNode("/instrumentation/nav["~ i ~"]/dme-in-range", 1),
		dme:		props.globals.getNode("/instrumentation/nav["~ i ~"]/nav-distance", 1),
		to_from:	props.globals.getNode("/instrumentation/nav["~ i ~"]/from-flag", 1),
		is_loc:		props.globals.getNode("/instrumentation/nav["~ i ~"]/frequencies/is-localizer-frequency", 1),
		has_gs:		props.globals.getNode("/instrumentation/nav["~ i ~"]/has-gs", 1),
		gs_defl:	props.globals.getNode("/instrumentation/nav["~ i ~"]/gs-needle-deflection-norm", 1),
		bearing:	props.globals.getNode("/instrumentation/nav["~ i ~"]/heading-deg", 1),
	};
	adf[ i ] = {
		in_range:	props.globals.getNode("/instrumentation/adf["~ i ~"]/in-range", 1),
		brg:		props.globals.getNode("/instrumentation/adf["~ i ~"]/indicated-bearing-deg", 1),
	};
}
var DME_dist = props.globals.getNode("/instrumentation/dme[0]/indicated-distance-nm", 1);
var ALT_qnh = props.globals.getNode("/instrumentation/altimeter/setting-hpa", 1);
var DecHei = props.globals.getNode("/instrumentation/EHSI/DH", 1);
var RM_cur_wp = props.globals.getNode("/autopilot/route-manager/current-wp", 1);


#init
var IAS_bug1 = props.globals.initNode("/instrumentation/EHSI/ias-bugs/bug1", 0.0, "DOUBLE");
var IAS_bug2 = props.globals.initNode("/instrumentation/EHSI/ias-bugs/bug2", 0.0, "DOUBLE");
var IAS_10 = props.globals.initNode("/instrumentation/pfd/asi-10", 0.0, "DOUBLE");
var IAS_100 = props.globals.initNode("/instrumentation/pfd/asi-100", 0.0, "DOUBLE");
var ALT_bugdiff = props.globals.initNode("/instrumentation/pfd/alt-bug-diff", 0.0, "DOUBLE");
var ALT_1000 = props.globals.initNode("/instrumentation/EHSI/alt-1000", 0.0, "DOUBLE");
var ALT_100 = props.globals.initNode("/instrumentation/EHSI/alt-100", 0.0, "DOUBLE");
var VS_needle = props.globals.initNode("/instrumentation/pfd/vs-needle", 0.0, "DOUBLE");
var Heading_bugdiff = props.globals.initNode("/instrumentation/pfd/hdg-bug-diff", 0.0, "DOUBLE");

var Volts = props.globals.initNode("/systems/electrical/outputs/ehsi[0]", 0.0,  "DOUBLE");

var last_shown = -1;

var canvas_EHSI_base = {
	init: func(canvas_group, file, screen) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Regular.ttf";
		};

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		 
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}
		
			
		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if (Volts.getDoubleValue() >= 10 and last_shown != 1) {
			EHSI_main.page.show();
			last_shown = 1;
		} else if( Volts.getDoubleValue() < 10 and last_shown != 0 ){
			EHSI_main.page.hide();
			last_shown = 0;
		}
	},
};

var shown = {
	gs: 1,
	brg_wpt: 1,
};

var canvas_EHSI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_EHSI_main,canvas_EHSI_base] };
		m.init(canvas_group, file, "main");

		return m;
	},
	getKeys: func() {
		return [
			"compass","groundspeed",
			"nav.source","nav.dist","nav.crs",
			"heading.bug","heading.bug.text",
			"bearing.wpt","bearing.vor",
			"pointer.course","course_deviation_bar",
			"gs.scale","gs.ind"
		];
	},
	fast_update: func() {
	
		me["compass"].setRotation(Heading_magnetic.getValue()*-D2R);
		
		
		me["heading.bug"].setRotation(Heading_bugdiff.getValue()*-D2R);
		
		
	},
	slow_update: func() {
		
		me["groundspeed"].setText(sprintf("%3d", math.round(Ground_Speed.getValue())));
		
		var current_heading = Heading_magnetic.getDoubleValue();
		
		var navsrc = AP_navsource.getValue();
		var course = 0.0;
		#	Deviation Scale:
		#		NAV:	1 dot = 5 deg
		#		ILS:	1 dot = 1 deg
		#		FMS:	1 dot = distance from centerline depending on selected scale
		var deviation = 0.0;	# dots, range -2 to +2
		me["nav.source"].setText(navsrc);
		if ( navsrc=="NAV1" or navsrc == "NAV2" ) {
			var i = 0;
			if( navsrc == "NAV2" ){
				i = 1;
			}
			
			if( nav[ i ].dme_in_range.getBoolValue() ){
				var nav0_dist = nav[ i ].dme.getDoubleValue() * M2NM;
				if(nav0_dist>=10){
					me["nav.dist"].setText(sprintf("%3d", nav0_dist));
				}else{
					me["nav.dist"].setText(sprintf("%2.1f", nav0_dist));
				}
			}else{
				me["nav.dist"].setText("---");
			}
			course = nav[ i ].rad.getDoubleValue();
			if( nav[ i ].is_loc.getBoolValue() ){
				deviation = nav[ i ].defl.getDoubleValue();
				if( nav[ i ].has_gs.getBoolValue() ){
					if( !shown.gs ){
						me["gs.scale"].show();
						shown.gs = 1;
					}
					me["gs.ind"].setTranslation(0,-nav[0].gs_defl.getDoubleValue() * 149);
				} elsif( shown.gs ){
					me["gs.scale"].hide();
					shown.gs = 0;
				}
			} else {
				deviation = nav[ i ].defl.getDoubleValue() / 5;
				if( shown.gs ){
					me["gs.scale"].hide();
					shown.gs = 0;
				}
			}
		} else if(navsrc=="FMS") {
			print("Nav Source FMS: Not yet implemented");
			if( shown.gs ){
				me["gs.scale"].hide();
				shown.gs = 0;
			}
		}
		me["nav.crs"].setText(sprintf("%3d", math.round( course )));
		me["pointer.course"].setRotation( ( course - current_heading ) * D2R );
		me["course_deviation_bar"].setTranslation( math.clamp( deviation, -3, 3 ) * 70, 0 );
		
		me["bearing.vor"].setRotation( ( nav[0].bearing.getDoubleValue() - current_heading ) * D2R );
		var cur_wp = RM_cur_wp.getIntValue();
		if( cur_wp >= 0 ){
			if( !shown.brg_wpt ){
				me["bearing.wpt"].show();
				shown.brg_wpt = 1;
			}
			me["bearing.wpt"].setRotation( ( getprop("/autopilot/route-manager/wp[" ~ RM_cur_wp.getIntValue() ~ "]/bearing-deg") - current_heading ) * D2R );
		} elsif( shown.brg_wpt ) {
			me["bearing.wpt"].hide();
			shown.brg_wpt = 0;
		}
		
		var hdgbug = AP_hdg.getValue();
		me["heading.bug.text"].setText(sprintf("%3d", math.round(hdgbug)));
	},
};

var EHSI_main_fast = maketimer( 0.05, func () { EHSI_main.fast_update() } );
var EHSI_main_slow = maketimer( 0.1,  func () { EHSI_main.slow_update() } );
var EHSI_base      = maketimer( 0.05, func () { canvas_EHSI_base.update() } );

EHSI_main_fast.simulatedTime = 1;
EHSI_main_slow.simulatedTime = 1;
EHSI_base.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	EHSI_display = canvas.new({
		"name": "EHSI",
		"size": [675, 512],
		"view": [1350, 1024],
		"mipmapping": 1
	});
	EHSI_display.addPlacement({"node": "EHSI.screen"});
	var groupEHSImain = EHSI_display.createGroup();

	EHSI_main = canvas_EHSI_main.new(groupEHSImain, "Aircraft/QSeries/Models/Cockpit/Instruments/EHSI/EHSI.svg");

	EHSI_main_fast.start();
	EHSI_main_slow.start();
	EHSI_base.start();
});

var showEHSI = func {
	var dlg = canvas.Window.new([675, 512], "dialog").set("resize", 1);
	dlg.setCanvas(EHSI_display);
}
