# Pipistrel EPSI 570 EIS by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var epsi570_flight = nil;
var epsi570_system = nil;
var epsi570_start = nil;
var epsi570_display = nil;

var state = 0;	# 0 = off, 1 = starting, 2 = on

var base = props.globals.initNode("/instrumentation/epsi570/");

var path = "Aircraft/AlphaElectro/Models/Instruments/EPSI570C/";

var page_prop = base.initNode("page", "", "STRING");

var start_prop = base.initNode("start", 0.0, "DOUBLE");
var volt_prop = props.globals.getNode( "/systems/electrical/outputs/eis" );
var brightness_prop = base.initNode("brightness", 0.0, "DOUBLE");

var charge_front = props.globals.getNode("/systems/electrical/battery-charge-percent-front", 1);
var charge_rear = props.globals.getNode("/systems/electrical/battery-charge-percent-back", 1);
var aux_batt_volts = props.globals.getNode("/systems/electrical/battery-volts-aux", 1);

var environment_temp = props.globals.getNode("/environment/temperature-degc", 1);
var hv_amps = props.globals.getNode("/systems/electrical/hv-amps", 1);
var hv_volts = props.globals.getNode("/systems/electrical/hv-volts", 1);
var lv_amps = props.globals.getNode("/systems/electrical/lv-amps", 1);
var lv_volts = props.globals.getNode("/systems/electrical/lv-volts", 1);

var throttle_raw = props.globals.getNode("/fdm/jsbsim/fcs/epsi570/throttle-system-raw", 1);
var throttle_final = props.globals.getNode("/fdm/jsbsim/fcs/epsi570/throttle-system-final", 1);
var seenzero = props.globals.getNode("/fdm/jsbsim/fcs/epsi570/enable-throttle", 1);

var battery_volts = props.globals.getNode( "/systems/electrical/hv-volts", 1 );

var motor_temp = props.globals.getNode( "/engines/engine[0]/engine-temp-degc", 1);
var power_controller_temp = props.globals.getNode( "/engines/engine[0]/power-controller-temp-degc", 1);
var coolant_temp = [
	props.globals.getNode( "/engines/engine[0]/coolant-temp-before-cooler-degc", 1),
	props.globals.getNode( "/engines/engine[0]/coolant-temp-after-cooler-degc", 1),
];
var batt_temp = [
	props.globals.getNode( "/systems/electrical/battery-temp-degc[0]", 1 ),
	props.globals.getNode( "/systems/electrical/battery-temp-degc[1]", 1 ),
];
var batt_coolant_temp = props.globals.getNode("/systems/electrical/battery-coolant-temp-degc", 1);

var message_lines = [];

var colors = {
	red:	[ 0.9, 0.05, 0.05 ],
	amber:	[ 1.0, 0.5, 0.0 ],
	green:	[ 0.05, 0.9, 0.05 ],
	grey: 	[ 0.5, 0.5, 0.5 ],
	black:	[ 0, 0, 0 ],
	lightblue: [ 0.776, 0.902, 0.918 ],
};

var canvas_epsi570_base = {
	init: func(canvas_group, file) {
		
		canvas.parsesvg(canvas_group, file, {'font-mapper': global.canvas.FontMapper});

		var svg_keys = me.getKeys();
		
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();
				var clip_rect = sprintf("rect(%d,%d, %d,%d)", 
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		var volts = volt_prop.getDoubleValue();
		if ( volts > 10 and state == 2 ) {
			epsi570_start.page.hide();
			var act_page = page_prop.getValue();
			if(act_page=="flight"){
				epsi570_flight.page.show();
				epsi570_flight.update();
				epsi570_system.page.hide();
			}else{
				epsi570_flight.page.hide();
				epsi570_system.page.show();
				epsi570_system.update();
			}
		} else if ( volts > 10 and state == 1 ){
			epsi570_flight.page.hide();
			epsi570_system.page.hide();
			epsi570_start.page.show();
		} else {
			epsi570_flight.page.hide();
			epsi570_system.page.hide();
			epsi570_start.page.hide();
		}
	},
};

var color_state = {	# 0 = green, 1 = amber, 2 = red
	rpm: -1,
	power: -1,
	motor_temp: 0,
	power_controller_temp: 0,
	batt_temp: [ 0, 0 ],
};

var canvas_epsi570_flight = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_epsi570_flight , canvas_epsi570_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["rpm.needle","rpm.digits","rpm.box",
		"power.digits","power.needle","power.box",
		"aux.batt.volts","battery.volts","chargeF.bar","chargeF.digits","chargeR.bar","chargeR.digits", 
		"message0", "message0.box", "message0.text",
		"message1", "message1.box", "message1.text",
		"message2", "message2.box", "message2.text",
		"message3", "message3.box", "message3.text",
		"message4", "message4.box", "message4.text",
		"message5", "message5.box", "message5.text",
		"message6", "message6.box", "message6.text",
		"batt_front.temp.text","batt_front.temp.bar","batt_front.temp.symbol",
		"batt_rear.temp.text","batt_rear.temp.bar","batt_rear.temp.symbol",
		"power_controller.temp.bar","power_controller.temp.text","power_controller.temp.symbol",
		"motor.temp.bar","motor.temp.text","motor.temp.symbol",
		"annun_message","annun_message_text","annun_message_category","annun_message_symbol","annun_message_frame",
		"flighttime",
		];
	},
	update: func() {
		
		var rpm = alphaelectro.engine.rpm.getDoubleValue();
		me["rpm.digits"].setText(sprintf("%4d", math.round(rpm, 10)));
		var rpm_deg = rpm / 2500 * 238;
		
		me["rpm.needle"].setRotation(rpm_deg*D2R);
		
		if( rpm >= 2500 ) {
			if( color_state.rpm != 2 ){
				me["rpm.box"].show();
				me["rpm.box"].setColorFill( colors.red );
				me["rpm.digits"].setColor( colors.black );
				color_state.rpm = 2;
			}
		} elsif( rpm >= 2300 ) {
			if( color_state.rpm != 1 ){
				me["rpm.box"].show();
				me["rpm.box"].setColorFill( colors.amber );
				me["rpm.digits"].setColor( colors.black );
				color_state.rpm = 1;
			}
		} else {
			if( color_state.rpm != 0 ){
				me["rpm.box"].hide();
				me["rpm.digits"].setColor( colors.lightblue );
				color_state.rpm = 0;
			}
		}
			
		
		var power_kw = alphaelectro.engine.power_hp.getDoubleValue() * 0.7457;
		me["power.digits"].setText(sprintf("%2d", math.round(power_kw)));
		var power_deg = power_kw / 65 * 215; 
		
		me["power.needle"].setRotation(power_deg*D2R);
		
		if( power_kw > 65 ) {
			if( color_state.power != 2 ){
				me["power.box"].show();
				me["power.box"].setColorFill( colors.red );
				me["power.digits"].setColor( colors.black );
				color_state.power = 2;
			}
		} elsif( power_kw > 49 ) {
			if( color_state.power != 1 ){
				me["power.box"].show();
				me["power.box"].setColorFill( colors.amber );
				me["power.digits"].setColor( colors.black );
				color_state.power = 1;
			}
		} else {
			if( color_state.power != 0 ){
				me["power.box"].hide();
				me["power.digits"].setColor( colors.lightblue );
				color_state.power = 0;
			}
		}
		
		
		var battery_charge_front = charge_front.getDoubleValue() * !annunciator.batt_front_offline;
		var battery_charge_rear = charge_rear.getDoubleValue() * !annunciator.batt_rear_offline;
		
		me["chargeF.digits"].setText(sprintf("%3d", math.round(battery_charge_front*100)));
		me["chargeR.digits"].setText(sprintf("%3d", math.round(battery_charge_rear*100)));
		me["chargeF.bar"].setTranslation(0, (1-battery_charge_front)*200);
		me["chargeR.bar"].setTranslation(0, (1-battery_charge_rear)*200);
		
		me["battery.volts"].setText(sprintf("%3d", math.round(battery_volts.getDoubleValue() ))~" V");
		
		me["aux.batt.volts"].setText(sprintf("%4.2f", aux_batt_volts.getDoubleValue() )~" V");
		
		#	Rough approximation of the remaining flight time
		var remaining_flight_time = ( battery_charge_front + battery_charge_rear ) * 0.5 * 1;
		me["flighttime"].setText( sprintf("%02d", math.floor( remaining_flight_time ) ) ~":"~ sprintf("%02d", math.mod( remaining_flight_time, 1 ) * 60 ) );
		
		
		#	Temperatures
		var motor_temp_val = motor_temp.getDoubleValue();
		me["motor.temp.text"].setText( sprintf("%2d", math.round( motor_temp_val ) ) );
		me["motor.temp.bar"].setTranslation( 0, math.max( -( motor_temp_val - 19.56 ) * 1.935, -191.29 )  );
		if( motor_temp_val >= 110 ){
			if( color_state.motor_temp != 2 ){
				me["motor.temp.bar"].setColorFill( colors.red );
				me["motor.temp.text"].setColor( colors.red );
				me["motor.temp.symbol"].setColor( colors.red );
				color_state.motor_temp = 2;
			}
		} elsif( motor_temp_val >= 100 ){
			if( color_state.motor_temp != 1 ){
				me["motor.temp.bar"].setColorFill( colors.amber );
				me["motor.temp.text"].setColor( colors.amber );
				me["motor.temp.symbol"].setColor( colors.amber );
				color_state.motor_temp = 1;
			}
		} else {
			if( color_state.motor_temp != 0 ){
				me["motor.temp.bar"].setColorFill( colors.green );
				me["motor.temp.text"].setColor( colors.grey );
				me["motor.temp.symbol"].setColor( colors.grey );
				color_state.motor_temp = 0;
			}
		}
		
		var power_controller_temp_val = power_controller_temp.getDoubleValue();
		me["power_controller.temp.text"].setText( sprintf("%2d", math.round( power_controller_temp_val ) ) );
		me["power_controller.temp.bar"].setTranslation( 0, math.max( -( power_controller_temp_val + 17.46 ) * 2.05, -191.29 )  );
		if( power_controller_temp_val >= 70 ){
			if( color_state.power_controller_temp != 2 ){
				me["power_controller.temp.bar"].setColorFill( colors.red );
				me["power_controller.temp.text"].setColor( colors.red );
				me["power_controller.temp.symbol"].setColor( colors.red );
				color_state.power_controller_temp = 2;
			}
		} elsif( power_controller_temp_val >= 65 ){
			if( color_state.power_controller_temp != 1 ){
				me["power_controller.temp.bar"].setColorFill( colors.amber );
				me["power_controller.temp.text"].setColor( colors.amber );
				me["power_controller.temp.symbol"].setColor( colors.amber );
				color_state.power_controller_temp = 1;
			}
		} else {
			if( color_state.power_controller_temp != 0 ){
				me["power_controller.temp.bar"].setColorFill( colors.green );
				me["power_controller.temp.text"].setColor( colors.grey );
				me["power_controller.temp.symbol"].setColor( colors.grey );
				color_state.power_controller_temp = 0;
			}
		}
		
		var batt_temp_front = batt_temp[0].getDoubleValue();
		me["batt_front.temp.text"].setText( sprintf("%2d", math.round( batt_temp_front ) ) );
		me["batt_front.temp.bar"].setTranslation( 0, math.max( -( batt_temp_front + 10.6 ) * 2.248, -191.29 )  );
		if( batt_temp_front >= 58 or batt_temp_front <= 5 ){
			if( color_state.batt_temp[0] != 2 ){
				me["batt_front.temp.bar"].setColorFill( colors.red );
				me["batt_front.temp.text"].setColor( colors.red );
				me["batt_front.temp.symbol"].setColor( colors.red );
				color_state.batt_temp[0] = 2;
			}
		} elsif( batt_temp_front >= 51 or batt_temp_front <= 11 ){
			if( color_state.batt_temp[0] != 1 ){
				me["batt_front.temp.bar"].setColorFill( colors.amber );
				me["batt_front.temp.text"].setColor( colors.amber );
				me["batt_front.temp.symbol"].setColor( colors.amber );
				color_state.batt_temp[0] = 1;
			}
		} else {
			if( color_state.batt_temp[0] != 0 ){
				me["batt_front.temp.bar"].setColorFill( colors.green );
				me["batt_front.temp.text"].setColor( colors.grey );
				me["batt_front.temp.symbol"].setColor( colors.grey );
				color_state.batt_temp[0] = 0;
			}
		}
		
		var batt_temp_rear = batt_temp[1].getDoubleValue();
		me["batt_rear.temp.text"].setText( sprintf("%2d", math.round( batt_temp_rear ) ) );
		me["batt_rear.temp.bar"].setTranslation( 0, math.max( -( batt_temp_rear + 10.6 ) * 2.248, -191.29 ) );
		if( batt_temp_rear >= 58 or batt_temp_rear <= 5 ){
			if( color_state.batt_temp[1] != 2 ){
				me["batt_rear.temp.bar"].setColorFill( colors.red );
				me["batt_rear.temp.text"].setColor( colors.red );
				me["batt_rear.temp.symbol"].setColor( colors.red );
				color_state.batt_temp[1] = 2;
			}
		} elsif( batt_temp_rear >= 51 or batt_temp_rear <= 11 ){
			if( color_state.batt_temp[1] != 1 ){
				me["batt_rear.temp.bar"].setColorFill( colors.amber );
				me["batt_rear.temp.text"].setColor( colors.amber );
				me["batt_rear.temp.symbol"].setColor( colors.amber );
				color_state.batt_temp[1] = 1;
			}
		} else {
			if( color_state.batt_temp[1] != 0 ){
				me["batt_rear.temp.bar"].setColorFill( colors.green );
				me["batt_rear.temp.text"].setColor( colors.grey );
				me["batt_rear.temp.symbol"].setColor( colors.grey );
				color_state.batt_temp[1] = 0;
			}
		}
		
		#	Annunciator Messages
		
		var i = 0;
		var shown_message = nil;
		while( i < size(message_lines) ){
			me["message"~ i].show();
			if( message_lines[i][0] == 0 ){
				me["message"~ i ~".box"].setColorFill( 1,0,0 );
			} else {
				me["message"~ i ~".box"].setColorFill( 1,1,0 );
			}
			me["message"~ i ~".text"].setText( string.replace( string.replace( message_lines[i][1], "-\n", "" ), "\n", " " ) );
			if( !message_lines[i][2] and shown_message == nil ){	# message not yet acknowledged
				shown_message = message_lines[i]
			}
			i += 1;
		}
		while( i <= 6 ){
			me["message"~ i].hide();
			i += 1;
		}
		if( shown_message != nil ){
			me["annun_message"].show();				
			me["annun_message_text"].setText( shown_message[1] );
			if( shown_message[0] == 0 ){	# warning message
				me["annun_message_category"].setText("WARNING");
				me["annun_message_frame"].setColor( colors.red );
				me["annun_message_symbol"].setColorFill( colors.red );
			} elsif( shown_message[0] == 1 ){	# caution message
				me["annun_message_category"].setText("CAUTION");
				me["annun_message_frame"].setColor( colors.amber );
				me["annun_message_symbol"].setColorFill( colors.amber );
			} else {
				die( "Shown annun message: unknown category: "~ shown_message[0] );
			}
		} else {
			me["annun_message"].hide();
		}
	}
	
};


var canvas_epsi570_start = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_epsi570_start , canvas_epsi570_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
	}
	
};

var batt_status = [ "Error", "Ready", "Active" ];
var canvas_epsi570_system = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_epsi570_system , canvas_epsi570_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["battery.front.mode","battery.front.socsoh","battery.front.maxtemp","battery.front.minu","battery.front.maxu","battery.front.busu","battery.front.battu","battery.front.batti","battery.front.pcerr","battery.front.balancing","battery.front.uptime","battery.rear.mode","battery.rear.socsoh","battery.rear.maxtemp","battery.rear.minu","battery.rear.maxu","battery.rear.busu","battery.rear.battu","battery.rear.batti","battery.rear.pcerr","battery.rear.balancing","battery.rear.uptime","drive.nmtstate","drive.status","drive.tempmi","drive.rpm","drive.coolant","drive.hobbs","dcdc.presence","dcdc.state","dcdc.outputu","dcdc.outputi","dcdc.inputu","dcdc.inputi","powerlever.presence","powerlever.output","powerlever.scaled","powerlever.final","powerlever.seenzero"];
	},
	update: func() {
		var hvv = hv_volts.getValue();
		var hva = hv_amps.getValue();
		
		me["battery.front.mode"].setText( batt_status[ alphaelectro.batt.status[0].getIntValue() ] );
		me["battery.front.socsoh"].setText(sprintf("%3d",charge_front.getValue()*100)~"/99"); #TODO Calculate and display State of Health (SOH)
		me["battery.front.maxtemp"].setText(sprintf("%2d", environment_temp.getValue() + 10)~"° (0)"); #TODO Calculate battery temperature correctly
		me["battery.front.minu"].setText("4100mV");
		me["battery.front.maxu"].setText("4100mV");
		me["battery.front.busu"].setText(sprintf("%4.1f",hvv/2)~"V");
		me["battery.front.battu"].setText(sprintf("%4.1f",hvv/2)~"V");
		me["battery.front.batti"].setText(sprintf("%3.1f",hva/2)~"A");
		me["battery.front.pcerr"].setText("0");
		me["battery.front.balancing"].setText("0");
		me["battery.front.uptime"].setText("1234"); #TODO calculate uptime correctly
		
		me["battery.rear.mode"].setText( batt_status[ alphaelectro.batt.status[1].getIntValue() ] );
		me["battery.rear.socsoh"].setText(sprintf("%3d",charge_rear.getValue()*100)~"/99"); #TODO Calculate and display State of Health (SOH)
		me["battery.rear.maxtemp"].setText(sprintf("%2d", environment_temp.getValue() + 10)~"° (0)"); #TODO Calculate battery temperature correctly
		me["battery.rear.minu"].setText("4100mV");
		me["battery.rear.maxu"].setText("4100mV");
		me["battery.rear.busu"].setText(sprintf("%4.1f",hvv/2)~"V");
		me["battery.rear.battu"].setText(sprintf("%4.1f",hvv/2)~"V");
		me["battery.rear.batti"].setText(sprintf("%3.1f",hva/2)~"A");
		me["battery.rear.pcerr"].setText("0");
		me["battery.rear.balancing"].setText("0");
		me["battery.rear.uptime"].setText("1234"); #TODO calculate uptime correctly
		
		
		me["drive.nmtstate"].setText("1"); 	#TODO: What is this?
		me["drive.status"].setText("63");	#TODO: What is this?
		me["drive.tempmi"].setText( math.round( motor_temp.getDoubleValue() ) ~"°/"~ math.round( power_controller_temp.getDoubleValue() ) ~"°");
		me["drive.rpm"].setText(sprintf("%4d", alphaelectro.engine.rpm.getValue())~"/min");
		me["drive.coolant"].setText( math.round( coolant_temp[0].getDoubleValue() ) ~"°/"~ math.round( coolant_temp[1].getDoubleValue() ) ~"°");
		me["drive.hobbs"].setText("1234min");	#TODO calculate hobbs correctly (of power controller)
		
		
		me["dcdc.presence"].setText("yes");	#TODO code correctly
		me["dcdc.state"].setText("1");		#TODO: What is this?
		me["dcdc.outputu"].setText(sprintf("%2.1f", lv_volts.getValue())~"V");
		me["dcdc.outputi"].setText(sprintf("%2.1f", lv_amps.getValue())~"A");
		me["dcdc.inputu"].setText(sprintf("%4.1f", hvv)~"V");
		me["dcdc.inputi"].setText(sprintf("%2.1f", hva)~"A");
		
		
		me["powerlever.presence"].setText("yes");	#TODO code correctly
		var throttle_raw_value = throttle_raw.getValue();
		me["powerlever.output"].setText(sprintf("%4d", throttle_raw_value));
		me["powerlever.scaled"].setText(sprintf("%4d", throttle_raw_value));	#TODO apply conversion map
		me["powerlever.final"].setText(sprintf("%4d", throttle_final.getValue()));
		if(seenzero.getValue()){
			me["powerlever.seenzero"].setText("yes");
		}else{
			me["powerlever.seenzero"].setText("no");
		}
	}
	
};

var base_updater = maketimer( 0.1, func(){ canvas_epsi570_base.update() } );
base_updater.simulatedTime = 1;

var ls = setlistener("sim/signals/fdm-initialized", func {
	removelistener( ls );
	epsi570_display = canvas.new({
		"name": "EPSI570",
		"size": [1024, 776],
		"view": [1024, 776],
		"mipmapping": 1
	});
	epsi570_display.addPlacement({"node": "EPSI570.screen"});
	var groupFlight = epsi570_display.createGroup();
	var groupSystem = epsi570_display.createGroup();
	var groupStart = epsi570_display.createGroup();


	epsi570_flight = canvas_epsi570_flight.new(groupFlight, path~"epsi570-flight.svg");
	epsi570_system = canvas_epsi570_system.new(groupSystem, path~"epsi570-system.svg");
	epsi570_start = canvas_epsi570_start.new(groupStart, path~"epsi570-start.svg");
	
	base_updater.start();
});


var showEPSI570 = func {
	var dlg = canvas.Window.new([320, 243], "dialog").set("resize", 1);
	dlg.setCanvas(epsi570_display);
}

var power_btn = func (){
	if( state == 0 and volt_prop.getDoubleValue() > 10 ){
		state = 1;
		settimer( func{ state = 2 }, 3 );
	}
}

setlistener(volt_prop, func{
	if( volt_prop.getDoubleValue() < 10 ){
		state = 0;
	}
});

setlistener( alphaelectro.switches.avionics, func {
	power_btn();
});
