#	FCS Functions that I don't currently know how to write in JSBSim
var brake_left = props.globals.getNode("/controls/gear/brake-left", 1);
var brake_right = props.globals.getNode("/controls/gear/brake-right", 1);
var out_brake_left = props.globals.getNode("/controls/gear/brake-left-int", 1);
var out_brake_right = props.globals.getNode("/controls/gear/brake-right-int", 1);
var brake_parking = props.globals.getNode("/controls/gear/brake-parking", 1);

setlistener( brake_left, func {
	if( !brake_parking.getBoolValue() ){
		out_brake_left.setDoubleValue( brake_left.getDoubleValue() );
	} else {
		if( brake_left.getDoubleValue() > out_brake_left.getDoubleValue() ){
			out_brake_left.setDoubleValue( brake_left.getDoubleValue() );
		}
	}
});

setlistener( brake_parking, func {
	if( !brake_parking.getBoolValue() ){
		out_brake_left.setDoubleValue( brake_left.getDoubleValue() );
		if( variant ) out_brake_right.setDoubleValue( brake_right.getDoubleValue() );
	}
});

if( variant ){
	setlistener( brake_right, func {
		if( !brake_parking.getBoolValue() ){
			out_brake_right.setDoubleValue( brake_right.getDoubleValue() );
		} else {
			if( brake_right.getDoubleValue() > out_brake_right.getDoubleValue() ){
				out_brake_right.setDoubleValue( brake_right.getDoubleValue() );
			}
		}
	});
}

var auto_set_parking_brake = func( a ){
	if( a == 0 ){
		brake_parking.setBoolValue( 0 );
	} else {
		brake_parking.setBoolValue( 1 );
		brake_left.setDoubleValue( 1.0 );
		brake_right.setDoubleValue( 1.0 );
	}
}

#	Haptic Stall Warning
var stick_shake_pitch = props.globals.initNode("/systems/stall-warning/shake-pitch", 0.0, "DOUBLE");
var haptic_stall_warn = props.globals.initNode("/systems/stall-warning/haptic-enable", 0, "BOOL");

var last = -1;
var shake_loop = func {
	if( last != 0 ){
		stick_shake_pitch.setDoubleValue( 1 + rand() * 0.1 );
		last = 0;
	} else {
		stick_shake_pitch.setDoubleValue( -1 - rand() * 0.1 );
		last = 1;
	}
}

var shake_timer = maketimer( 0.05, shake_loop );
shake_timer.simulatedTime = 1;

var last_state = -1;

setlistener( haptic_stall_warn, func {
	if( haptic_stall_warn.getBoolValue() ){
		if( last_state != 1 ){
			shake_timer.start();
			last_state = 1;
		}
	} else {
		if( last_state !=0 ){
			shake_timer.stop();
			stick_shake_pitch.setDoubleValue( 0.0 );
			last_state = 0;
		}
	}
});
