#	This script triggers the CED caution light
var ced_caution_light	=	props.globals.initNode("/instrumentation/ced/caution-light", 0, "BOOL");
var caution_triggered = 0;
var ced_timer		=	nil;
var ced_volts		=	props.globals.getNode("/systems/electrical/outputs/indicators", 1);
var rpm			=	props.globals.getNode("/engines/engine[0]/thruster/rpm", 1);
var ot			=	props.globals.getNode("/engines/engine[0]/oil-temp-c", 1);
var op			=	props.globals.getNode("/engines/engine[0]/oil-press-bar", 1);
var ct			=	props.globals.getNode("/engines/engine[0]/coolant-temp-c", 1);
var gt			=	props.globals.getNode("/engines/engine[0]/gearbox-temp-c", 1);

var ced_loop	=	func	{
	if(ced_volts.getValue() > 8 and caution_triggered == 0){
		# Check for out-of-order conditions
		if( rpm.getValue() > 2400 or op.getValue() < 1.1 or op.getValue() > 6.0 or ot.getValue() < -32 or ot.getValue() > 105 or ct.getValue() < -32 or ct.getValue() > 105 or gt.getValue() > 120 ){
			ced_caution_light.setBoolValue(1);
			caution_triggered = 1;
		}
	}
}

var ced_ack	=	func	{
	ced_caution_light.setBoolValue(0);
	caution_triggered = 0;	
}

setlistener("/sim/signals/fdm-initialized",	func	{
	ced_timer = maketimer(0.5, ced_loop);
	ced_timer.start();
	print("CED loaded");
});
