var base		=	props.globals.initNode("/sim/model/shake-effect");
var shakeEffect	= 	base.initNode("effect", 0, "BOOL");
var shake 		= 	base.initNode("shaking", 0, "DOUBLE");
var amplitude	=	base.initNode("amplitude", 0.001, "DOUBLE");

var shakeFunc = func{
		if(shakeEffect.getValue()){
			var sf = amplitude.getValue();
			interpolate("/sim/model/shake-effect/shaking", sf, 0.03);
			settimer(func{
				interpolate("/sim/model/shake-effect/shaking", -sf*2, 0.03); 
			}, 0.03);
			settimer(func{
				interpolate("/sim/model/shake-effect/shaking", sf, 0.03);
			}, 0.06);
			settimer(shakeFunc, 0.09);	
		}else{
			shake.setValue(0);	
		}	    
}

### When to start the shake effect
# 1. propeller stopping
# 2. engine catching
# 3. starter
var was_above_100 = 0;
var was_running = 0;

setlistener("/engines/engine[0]/rpm", func(i){
	if(i.getValue() <= 100 and was_above_100){
		was_above_100=0;
		amplitude.setValue(0.0025);
		shakeEffect.setBoolValue(1);
		shakeFunc();
		settimer(func(){shakeEffect.setBoolValue(0);}, 0.2);
	}else if(i.getValue() > 100 and !was_above_100){
		was_above_100=1;
	}
});
setlistener("/engines/engine[0]/running", func(i){
	if(i.getValue() and !was_running){
		was_running=1;
		amplitude.setValue(0.0025);
		shakeEffect.setBoolValue(1);
		shakeFunc();
		settimer(func(){shakeEffect.setBoolValue(0);}, 0.2);
	}else if(!i.getValue() and was_running){
		was_running=0;
	}
});
setlistener("/engines/engine[0]/starter", func(i){
	if(i.getValue() == 1){
		amplitude.setValue(0.0002);
		shakeEffect.setBoolValue(1);
		shakeFunc();
	}else{
		shakeEffect.setBoolValue(0);
	}
});

