// -*- mode: C; -*-
// Licence: GPL v2
// based on
// © Emilian Huminiuc and Vivian Meazza 2011
// addition for wingflex mesh distortion by Thorsten Renk 2015

#version 120

varying	vec3	rawpos;
varying	vec3	VNormal;
varying	vec3	VTangent;
varying	vec3	VBinormal;
varying	vec3	vViewVec;
varying vec3 	vertVec;

varying	float	alpha;

varying float flogz;

attribute	vec3	tangent;
attribute	vec3	binormal;

uniform	float		pitch;
uniform	float		roll;
uniform	float		hdg;
uniform float 		fuel_level_norm;
uniform float		front_low_x_m;
uniform float		front_high_x_m;
uniform float		rear_x_m;
uniform float 		z_min_m;
uniform float 		z_max_m;
uniform	int  		refl_dynamic;
uniform int  		shader_qual;
uniform int		rembrandt_enabled;

//////Fog Include///////////
// uniform	int 	fogType;
// void	fog_Func(int type);
////////////////////////////

void	main(void)
{
		vec4 vertex = gl_Vertex;

		if ( vertex.z > ( z_min_m + 0.03 ) ) {
			float height = z_max_m - z_min_m;
			float norm = (vertex.z - z_min_m) / height;
			if ( vertex.x < front_high_x_m ) {
				float xdiff = front_high_x_m - front_low_x_m;
				vertex.x = vertex.x - norm * ( 1 - fuel_level_norm ) * xdiff;
			}
			float mid_x = ( front_low_x_m + rear_x_m ) / 2;
			float delta_x = ( vertex.x - mid_x ); // offset from center of tank
			vertex.z = ( norm * height * fuel_level_norm + z_min_m );
			vertex.z = min( vertex.z + tan( roll ) * vertex.y + tan( pitch ) * delta_x , z_max_m - 0.03);
		}
		
		// logarithmic depth
		flogz = 1.0 + gl_Position.w;
		//gl_Position = ftransform();
		
		
		

		rawpos = vertex.xyz;
		vec4 ecPosition = gl_ModelViewMatrix * vertex;

		VNormal = normalize(gl_NormalMatrix * gl_Normal);

		vec3 n = normalize(gl_Normal);
		vec3 tempTangent = cross(n, vec3(1.0,0.0,0.0));
		vec3 tempBinormal = cross(n, tempTangent);

		VTangent = normalize(gl_NormalMatrix * tempTangent);
		VBinormal = normalize(gl_NormalMatrix * tempBinormal);
		vec3 t = tempTangent;
		vec3 b = tempBinormal;
		// Super hack: if diffuse material alpha is less than 1, assume a
		// transparency animation is at work
		if (gl_FrontMaterial.diffuse.a < 1.0)
			alpha = gl_FrontMaterial.diffuse.a;
		else
			alpha = gl_Color.a;

		// Vertex in eye coordinates
		vertVec = ecPosition.xyz;
		vViewVec.x = dot(t, vertVec);
		vViewVec.y = dot(b, vertVec);
		vViewVec.z = dot(n, vertVec);

		if(rembrandt_enabled < 1){
			gl_FrontColor = gl_FrontMaterial.emission + gl_Color
					  * (gl_LightModel.ambient + gl_LightSource[0].ambient);
		} else {
			gl_FrontColor = gl_Color;
		}
		gl_Position = gl_ModelViewProjectionMatrix * vertex;
}
