﻿********************************************************************************
Piper J-3 Cub for FlightGear
********************************************************************************
Authors: Don Lavelle (model) David Megginson (FDM) Jim Wilson (instruments)
License: GPL (see file "COPYING.txt" for details)
********************************************************************************

INTRODUCTION
This light aircraft was fully modelled specially for FlightGear by Don Lavelle using Blender http://www.blender.org  The project was started using drawings with permission from Toni Clark of
http://www.toni-clark.com and the many images that can be obtained from the net were used for details as the project developed; no direct copying of files was involved.
The XML files from the original FGFS aircraft, produced in 2002,
 were used with small changes. The project took over 100 hours to complete.

REQUIREMENTS
You will probably need a decent PC to fly this aircraft; if the F-14 flies OK on your machine it will fly the Cub.


INSTALLATION
The Cub folder should contain everything necessary to fly this 'plane. If you have a compressed file, uncompress it to your data/Aircraft folder in FlightGear. An uncompressed Cub folder should likewise be moved to your FG%ROOT/Aircraft folder.


FEATURES
animated pilot
control surfaces
detailed 3D cabin interior
detailed canvas wings
eco-friendly exhaust fumes
high resolution details
'high tech' fuel indicator
joystick animation
opening door and window
optional tyre smoke (code in Cub.xml file)
paint livery template
spinning propeller
spinning wheels
tailwheel and rudder link
throttle animation
undercarriage suspension
user input registration markings
water spray on wheels

PILOT
See Pilot_Notes.txt for performance and other information.

PAINT KIT
To paint a new livery you can use paint_kit.xcf, which is a Gimp file. Labels are included to help you find your way round it, some of the objects are not orientated in an ideal manner, but should be useful anyway. An unsaturated layer has also been included.


MODELLING
The aircraft was modelled in Blender 2.49a. The philosophy behind the modelling was to create as much detail as possible - down to nuts and bolts – but minimizing vertices at the same time. It was decided to model the wing as fully as possible and avoid using the simplistic method of using textures to simulate the sagged canvas effect. Many small parts were based on cubes and complex shapes were avoided where possible; for example, cables were square sectioned rather than polygons. Some objects, such as the instrument panel, were constructed to higher resolution because they would be viewed close up. The panels around the nose were opened slightly to create small gaps usually seen on the fullsize aircraft and consequently black bulkheads had to be added to avoid light leakage. The fuselage was constructed as a whole and not in halves (so it is not exactly symmetrical) and there are several other examples of 'built by eye' objects. The vertex count is well over 10,000 which is ten times the original J3 Cub model but roughly equal to the 737 and less than the 747 and F-14. The model was built on
Toni Clark's drawing and over 70 photographs were used for details. UV maps were created from most objects using either smart projections or seams and straight unwrap. Less important objects eg. hinges, were moved to another layer and just coloured. After filesave and .ac export, a combined uv map was made by joining all objects which was exported to create a .tga guide. 

IDEAS FOR THE FUTURE
animated figure to start the propeller
appropriate radio set
carb heater operation
change aerofoil from Clark Y to USA 35-B
change mesh to equal actual structure
change eg. cables and struts, to higher resolution
floats
fuel primer
improved engine details
interior lighting
magneto switch
new sounds
optional passenger
reflective glass on gauges
separate cabin model with extra detail
solidify selected panels


CREDITS
Emmanuel Baranger and Bertrand Augras for the model pilot
Dave Megginson for the FDM and his friendly support
Jim Wilson for instruments
Toni Clark for accurate drawings
The FlightGear community for inspiration and comradeship
In the spirit of FGFS, many of the Cub's elements were inspired or based on solutions found in open source aircraft. Thanks chaps.


If you have any queries contact 'karla' through FlightGear Forum.

LINKS
http://www.cub-club.com
http://www.j3-cub.com
http://www.legend.aero
http://www.fiddlersgreen.net

VERSION
1.110901 Panel update, various minor improvements.
1.110103 textures broken links, scaling and animated objects fixes
1.100910 gauges reflectivities corrected, ground shadow added
1.100408 fully remodelled aircraft, details above
1.0 first release in 2002

