##This file includes various helpers
var windcheck = func{
	wd=getprop("/environment/wind-from-heading-deg");
	ch=getprop("/orientation/heading-deg");
	ws=getprop("/environment/wind-speed-kt");
	var wdi=wd-ch;
	if(wdi<0){
		gui.popupTip(sprintf("Wind from %d degrees left at %.1f knots", -wdi, ws));
	}else{
		gui.popupTip(sprintf("Wind from %d degrees right at %.1f knots", wdi, ws));
	}
}
var msg = func ( destination, string ) {
	setprop("/sim/messages/"~destination, string);
}
 
##################
#### Liveries ####
##################
aircraft.livery.init("Aircraft/LS4/Models/Liveries/"~ getprop("/sim/aero") );

##############
#### Bugs ####
##############

# Slowly increase the bug coverage to reach 1 (100%) after 20 hours of flying at an airspeed of 100 kph
# Airsped is accounted for (condition: airspeed > 10 kph, increment factor dependent on airspeed), altitude, weather, geography etc. not (yet)

var bug_coverage = props.globals.initNode("/fdm/jsbsim/systems/bug-coverage-norm", 0.0, "DOUBLE");
var airspeed = props.globals.getNode("/velocities/airspeed-kt", 1);

var bug_loop = func {
	
	var airspeed_kph = airspeed.getDoubleValue() * 1.8;
	if( airspeed_kph > 10 ){
		bug_coverage.setDoubleValue( math.min( 1.0, bug_coverage.getDoubleValue() + math.min( airspeed_kph * 8.33 * math.pow( 10, -6 ), 0.002 ) ) );
	}
	
}

var bug_timer = maketimer( 60, bug_loop );
bug_timer.simulatedTime = 1;

#####################
#### Update Loop ####
#####################

var update_systems = func {
	#Breakage code
	if(getprop("/controls/breakage/enabled") and getprop("/controls/breakage/altitude-m")!=nil and getprop("/sim/hitches/winch/open")==0 ){
		if(getprop("/position/gear-agl-m")>=getprop("/controls/breakage/altitude-m") ) {
			setprop("/sim/hitches/winch/open", 1);
		}
	}
}

var systems_updater = maketimer( 0.0, update_systems);
systems_updater.simulatedTime = 1;

setlistener("/sim/signals/fdm-initialized", func {
	if( !systems_updater.isRunning ){ systems_updater.start(); }
	if( !bug_timer.isRunning ){ bug_timer.start(); }
});


################
#### States ####
################
var first_flight_of_day = func{
	setprop("/controls/electric/battery-switch", 0);
	setprop("/controls/electric/turn-slip-switch", 0);
	setprop("/controls/electric/vario-switch", 0);
	setprop("/controls/electric/radio-switch", 0);
}

var ready_sitin = func{
	setprop("/controls/electric/battery-switch", 1);
	setprop("/controls/electric/turn-slip-switch", 1);
	setprop("/controls/electric/vario-switch", 1);
	setprop("/controls/electric/radio-switch", 1);
	setprop("/instrumentation/ilec-sc7/audio", 2);
	setprop("/instrumentation/ilec-sc7/volume", 0);
	setprop("/instrumentation/AR-3201/power", 1);
	setprop("/sim/model/door-positions/canopy/position-norm", 1);
	setprop("/instrumentation/altimeter/setting-hpa", getprop("/environment/pressure-sea-level-hpa"));
}

var ready_takeoff = func{
	setprop("/controls/electric/battery-switch", 1);
	setprop("/controls/electric/turn-slip-switch", 1);
	setprop("/controls/electric/vario-switch", 1);
	setprop("/controls/electric/radio-switch", 1);
	setprop("/instrumentation/ilec-sc7/audio", 2);
	setprop("/instrumentation/ilec-sc7/volume", 0);
	setprop("/instrumentation/AR-3201/power", 1);
	setprop("/sim/model/door-positions/canopy/position-norm", 0);
	setprop("/instrumentation/altimeter/setting-hpa", getprop("/environment/pressure-sea-level-hpa"));
	setprop("/sim/messages/ground", "All set up, you're ready for departure! Press Ctrl-w to start winch launch or Ctrl-o to hook to an aerotow aircraft!");
}
