##	Water Ballast	##

var wing_outflow_rate = [
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[0]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[1]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[2]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[3]"),
];
var tank_level_p = [
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[2]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[3]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[4]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[5]"),
];
var tank_level_lbs = [ 0.0, 0.0, 0.0, 0.0 ];
var delta_time = props.globals.getNode("/sim/time/delta-sec");

var update_waterballast = func () {
	var dt = delta_time.getDoubleValue();
	for( var i=0; i<=3; i=i+1 ){
		tank_level_lbs[ i ] = tank_level_p[ i ].getDoubleValue();
		tank_level_p[ i ].setDoubleValue( math.max( tank_level_lbs[ i ] - wing_outflow_rate[ i ].getDoubleValue()  * dt, 0.0 ) );
	}
}
var waterballast_timer = maketimer( 0.05, update_waterballast );
waterballast_timer.simulatedTime = 1;


##	Start updates when FDM is initialized	##
var wb_ls = setlistener("/sim/signals/fdm-initialized", func() {
	waterballast_timer.start();
	removelistener( wb_ls );
}); 
