# Bombardier Q400 IESI
# by Bea Wolf, based on
# A32X IESI by Joshua Davidson

var IESI = nil;
var IESI_display = nil;

#	Properties Setup
var volts = props.globals.getNode( "systems/electrical/outputs/stby-att", 1 );

var airspeed = props.globals.getNode( "instrumentation/airspeed-indicator/indicated-speed-kt", 1 );
var pitch_deg = props.globals.getNode( "orientation/pitch-deg", 1 );
var roll_deg = props.globals.getNode( "orientation/roll-deg", 1 );
var slipskid = props.globals.getNode( "instrumentation/slip-skid-ball/indicated-slip-skid", 1 );
var qnh_setting = [
	props.globals.getNode( "instrumentation/altimeter/setting-hpa" ),
	props.globals.getNode( "instrumentation/altimeter/setting-inhg" ),
];
var altitude = props.globals.getNode( "instrumentation/altimeter/indicated-altitude-ft" );


var canvas_IESI_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Regular.ttf";
		};
		
		canvas.parsesvg(canvas_group, file, {"font-mapper": font_mapper});
		
		var svg_keys = me.getKeys();

		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);

			var clip_el = canvas_group.getElementById(key ~ "_clip");
			if (clip_el != nil) {
				clip_el.setVisible(0);
				var tran_rect = clip_el.getTransformedBounds();

				var clip_rect = sprintf("rect(%d,%d, %d,%d)",
				tran_rect[1], # 0 ys
				tran_rect[2], # 1 xe
				tran_rect[3], # 2 ye
				tran_rect[0]); #3 xs
				#   coordinates are top,right,bottom,left (ys, xe, ye, xs) ref: l621 of simgear/canvas/CanvasElement.cxx
				me[key].set("clip", clip_rect);
				me[key].set("clip-frame", canvas.Element.PARENT);
			}
		}
		
		me.h_trans = me["horizon"].createTransform();
		me.h_rot = me["horizon"].createTransform();
		
		me.page = canvas_group;
		
		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if ( volts.getDoubleValue() >= 10 ) {
			IESI.page.show();
			IESI.update();
		} else {
			IESI.page.hide();
		}
	},
};

# Reused variables
# the idea behind this is to lessen the garbage collector load, but I don't know whether this works or can work
var pitch = nil;
var roll = nil;
var altitude_ft = nil;
var altOffset = nil;
var middleAltText = nil;
var middleAltOffset = nil;

# Helper functions
var roundaboutAlt = func(x) {
	var y = x * 0.2 - int(x * 0.2);
	return y < 0.5 ? 5 * int(x*0.2) : 5 + 5 * int(x*0.2);
};

var canvas_IESI = {
	new: func(canvas_group, file) {
		var m = {parents: [canvas_IESI, canvas_IESI_base]};
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["horizon","asi.tape","qnh.text","rollpointer","rollpointer2","metricalt","alt.tape","alt.1","alt.2","alt.3","alt.4","alt.5","alt.text"];
	},
	update: func() {
		# Airspeed
		me["asi.tape"].setTranslation(0, math.min( airspeed.getDoubleValue(), 420 ) *2.381);
		
		# Artificial Horizon
		pitch = pitch_deg.getDoubleValue();
		roll =  roll_deg.getDoubleValue();
		
		me.h_trans.setTranslation(0,pitch*4.23);
		me.h_rot.setRotation(-roll*D2R,me["horizon"].getCenter());
		
		me["rollpointer"].setRotation(roll*(-D2R));
		me["rollpointer2"].setTranslation( slipskid.getDoubleValue() * 5 , 0);
		
		
		# QNH
		me["qnh.text"].setText(sprintf("%4.0f", qnh_setting[0].getDoubleValue() ) ~ "hPa / " ~ sprintf("%2.2f", qnh_setting[1].getDoubleValue() ));
		
		# Altimeter
		altitude_ft = altitude.getDoubleValue();
		me["metricalt"].setText( sprintf( "%4d", altitude_ft * FT2M ) );
		altOffset = altitude_ft / 500 - int(altitude_ft / 500);
		middleAltText = roundaboutAlt(altitude_ft / 100);
		if (altOffset > 0.5) {
			middleAltOffset = -(altOffset - 1) * 87;
		} else {
			middleAltOffset = -altOffset * 87;
		}
		me["alt.tape"].setTranslation(0, -middleAltOffset);
		me["alt.5"].setText(sprintf("%03d", abs(middleAltText+10)));
		me["alt.4"].setText(sprintf("%03d", abs(middleAltText+5)));
		me["alt.3"].setText(sprintf("%03d", abs(middleAltText)));
		me["alt.2"].setText(sprintf("%03d", abs(middleAltText-5)));
		me["alt.1"].setText(sprintf("%03d", abs(middleAltText-10)));
		me["alt.text"].setText(sprintf("%5d", altitude_ft));
		
	},
};

setlistener("sim/signals/fdm-initialized", func {
	IESI_display = canvas.new({
		"name": "IESI",
		"size": [1024, 1024],
		"view": [270,270],
		"mipmapping": 1
	});
	IESI_display.addPlacement({"node": "IESI.screen"});
	
	IESI = canvas_IESI.new( IESI_display.createGroup(), "Aircraft/QSeries/Models/Cockpit/Instruments/IESI/IESI.svg" );
	
	IESI_update.start();
});

var IESI_update = maketimer(0.05, func {
	canvas_IESI_base.update();
});

var showIESI = func {
	var dlg = canvas.Window.new([256, 256], "dialog").set("resize", 1);
	dlg.setCanvas(IESI_display);
}
