##	Water Ballast	##
var wing_outflow_rate = [
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[0]"),
	props.globals.getNode("fdm/jsbsim/systems/water-ballast/wing-outflow-rate-pps[1]"),
];
var tank_level_p = [
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[5]"),
	props.globals.getNode("fdm/jsbsim/inertia/pointmass-weight-lbs[6]"),
];
var tank_level_lbs = [ 0.0, 0.0 ];
var delta_time = props.globals.getNode("/sim/time/delta-sec");

var update_waterballast = func () {
	var dt = delta_time.getDoubleValue();
	for( var i=0; i<=1; i=i+1 ){
		tank_level_lbs[ i ] = tank_level_p[ i ].getDoubleValue();
		tank_level_p[ i ].setDoubleValue( math.max( tank_level_lbs[ i ] - wing_outflow_rate[ i ].getDoubleValue()  * dt, 0.0 ) );
	}
}
var waterballast_timer = maketimer( 0.0, update_waterballast );
waterballast_timer.simulatedTime = 1;
waterballast_timer.start();
