# ILEC Engine Instrument by D-ECHO based on

# A3XX Lower ECAM Canvas
# Joshua Davidson (it0uchpods)
#######################################

var ILEC_only = nil;
var ILEC_display = nil;

var rpm = props.globals.getNode("engines/engine[0]/rpm", 1);
var fuel_m3 = props.globals.getNode("consumables/fuel/tank/level-m3", 1);

var canvas_ILEC_base = {
	init: func(canvas_group, file) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach(var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}

		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if (getprop("/controls/electric/battery-switch") == 1) {
			ILEC_only.page.show();
			ILEC_only.update();
		} else {
			ILEC_only.page.hide();
		}
	},
};
	
	
var canvas_ILEC_only = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_ILEC_only , canvas_ILEC_base] };
		m.init(canvas_group, file);

		return m;
	},
	getKeys: func() {
		return ["LeftInd", "RightInd"];
	},
	update: func() {
		
		if( rpm.getDoubleValue() >= 1000 ){
			me["LeftInd"].setText( sprintf( "%04d", math.round( rpm.getDoubleValue(), 100 ) ) );
		} else {
			me["LeftInd"].setText( sprintf( "%04d", 0 ) );
		}
		me["RightInd"].setText( sprintf( "%1d", math.round( fuel_m3.getDoubleValue() * 1000 ) ) );
		
	},
};

var ilec_display_update = maketimer( 0.02, func { canvas_ILEC_base.update(); } );
ilec_display_update.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	ILEC_display = canvas.new({
		"name": "ILEC",
		"size": [320, 128],
		"view": [320, 128],
		"mipmapping": 1
	});
	ILEC_display.addPlacement({"node": "ILEC.screen"});
	var groupOnly = ILEC_display.createGroup();

	ILEC_only = canvas_ILEC_only.new(groupOnly, "Aircraft/Arcus/Models/Interior/Panel/Instruments/ILEC/ILEC-display.svg");

	ilec_display_update.start();
});

var showILEC = func {
	var dlg = canvas.Window.new([128, 512], "dialog").set("resize", 1);
	dlg.setCanvas(ILEC_display);
}
