#	DHC-8 -100 -200 -300
#	Warning Systems
#
#	Gear Warning Horn
#	
#		References
#			https://www.smartcockpit.com/my-aircraft/bombardier-dash-8-200-300/
#				Dash 8 200 300 Landing Gear (PDF)
#				Dash 8 200 300 Warning Systems (PDF)
#
#		Conditions
#			- Landing Gear not DOWN and LOCKED 
#				and either
#				1. ( Flaps Sel 15 deg or 35 deg ) and ( Both Power Levers < 50 pct torque )
#				2. ( One or Both Power Levers at/near FLT IDLE ) and ( Airspeed < 130 kts )
#
#			- Condition 2 can be canceled (muted) if only One Power Lever is at/near FLT IDLE
#				( for single engine training )
#				

var flaps_sel = props.globals.getNode("/controls/flight/flaps", 1);
var power_lvr = [
		props.globals.getNode("/controls/engines/engine[0]/throttle", 1),
		props.globals.getNode("/controls/engines/engine[1]/throttle", 1),
	];
var ind_airsp = props.globals.getNode("/instrumentation/airspeed-indicator/indicated-speed-kt", 1);
var gear_down = [
	props.globals.getNode("gear/gear[0]/position-norm", 1),
	props.globals.getNode("gear/gear[1]/position-norm", 1),
	props.globals.getNode("gear/gear[2]/position-norm", 1),
];

var gear_horn_volts = props.globals.getNode("/systems/electrical/outputs/gear-horn", 1);

var gear_horn_out = props.globals.initNode("/gear/warning-horn", 0, "BOOL");

var gear_horn_mute_test_sw = props.globals.initNode("/controls/gear/warn-horn-test-mute-switch", 0, "INT"); # -1 = TEST, 0 = NORM, 1 = MUTE
var gear_horn_test = 0;

var gear_horn_muted = props.globals.initNode("/gear/warning-horn-muted", 0, "BOOL");
var gear_horn_mutable = 0;

var gear_warning_loop = func{
	
	var prev_value = gear_horn_out.getBoolValue();
	var new_value = 0;
	
	if( gear_horn_volts.getDoubleValue() > 15.0 ){
		
		if( gear_horn_test ){
			new_value = 1;
		} else {
		
			if( gear_down[0].getDoubleValue() < 0.9999 or gear_down[1].getDoubleValue() < 0.9999 or gear_down[2].getDoubleValue() < 0.9999 ){
				
				if( flaps_sel.getDoubleValue() >= 0.5 and power_lvr[0].getDoubleValue() < 0.05 and power_lvr[1].getDoubleValue() < 0.05 ){
					gear_horn_mutable = 0;
					gear_horn_muted.setBoolValue( 0 );
					new_value = 1;
				} elsif( ind_airsp.getDoubleValue() < 130 ){
					if( power_lvr[0].getDoubleValue() < 0.05 and power_lvr[1].getDoubleValue() < 0.05 ){
						gear_horn_mutable = 0;
						gear_horn_muted.setBoolValue( 0 );
						new_value = 1;
					} elsif( power_lvr[0].getDoubleValue() < 0.05 or power_lvr[1].getDoubleValue() < 0.05 ){
						gear_horn_mutable = 1;
						new_value = 1;
					}
				}
			}
			
			if( gear_horn_mutable and new_value and gear_horn_muted.getBoolValue() ){
				new_value = 0;
			}
		}
	}
	
	if( new_value != prev_value ){
		
		gear_horn_out.setBoolValue( new_value );
		
	}
	
	
}

var gear_warning_timer = maketimer( 0.5, gear_warning_loop );
gear_warning_timer.simulatedTime = 1;
gear_warning_timer.start();

# Function called by the Mute Switch, momentary action
var gear_horn_mute = func{
	if( gear_horn_mutable ){
		gear_horn_muted.setBoolValue( 1 );
	}	
}
setlistener( gear_horn_mute_test_sw, func{
	if( gear_horn_mute_test_sw.getIntValue() == -1 ){
		gear_horn_test = 1;
	} elsif( gear_horn_mute_test_sw.getIntValue() == 1 ){
		gear_horn_mute();
	} else {
		gear_horn_test = 0;
	}
});
