#	DHC-8-400
#	Warning Systems
#
#	Gear Warning Horn
#	
#		References
#			https://www.smartcockpit.com/my-aircraft/bombardier-dash-8-400/
#				Q400 Landing Gear (PDF)
#
#		Conditions
#			- Landing Gear not DOWN and LOCKED 
#				and either
#				1. ( Flaps > 8.5 deg ) and ( either engine torque < 50 pct ) and ( Both Power Levers < rating detent )
#				2. ( Both Power Levers < FLT IDLE + 12 deg ) and ( Airspeed < 156 kts ) and ( Radio Alt < 1053 ft if valid )
#				3. ( One Power Lever < FLT IDLE + 12 deg ) and ( Both Power Levers < rating detent ) and ( HORN switch not set to MUTE )
#					and ( Airspeed < 156 kts ) and ( Radio Alt < 1053 ft if valid )
#				

var flaps_act = props.globals.getNode("/surface-positions/flap-pos-norm", 1);
var power_lvr = [
		props.globals.getNode("/controls/engines/engine[0]/throttle", 1),
		props.globals.getNode("/controls/engines/engine[1]/throttle", 1),
	];
var ind_airsp = props.globals.getNode("/instrumentation/airspeed-indicator/indicated-speed-kt", 1);
var rad_alt = props.globals.getNode("/instrumentation/radar-altimeter/radar-altitude-ft", 1);
var gear_down = [
	props.globals.getNode("gear/gear[0]/position-norm", 1),
	props.globals.getNode("gear/gear[1]/position-norm", 1),
	props.globals.getNode("gear/gear[2]/position-norm", 1),
];
var eng_trq = [
	props.globals.getNode("engines/engine[0]/thruster/torque", 1),
	props.globals.getNode("engines/engine[1]/thruster/torque", 1),
];

var gear_horn_volts = props.globals.getNode("/systems/electrical/outputs/gear-horn", 1);

var gear_horn_out = props.globals.initNode("/gear/warning-horn", 0, "BOOL");

var gear_horn_mute_test_sw = props.globals.initNode("/controls/gear/warn-horn-test-mute-switch", 0, "INT"); # -1 = TEST, 0 = NORM, 1 = MUTE

var gear_warning_loop = func{
	
	var prev_value = gear_horn_out.getBoolValue();
	var new_value = 0;
	
	if( gear_horn_volts.getDoubleValue() > 15.0 ){
		
		if( gear_horn_mute_test_sw.getIntValue() == -1 ){
			new_value = 1;
		} else {
		
			if( gear_down[0].getDoubleValue() < 0.9999 or gear_down[1].getDoubleValue() < 0.9999 or gear_down[2].getDoubleValue() < 0.9999 ){
				
				if( flaps_act.getDoubleValue() > 0.243 and 
						( ( eng_trq[0].getDoubleValue() / (-26110) ) < 0.5 or ( eng_trq[1].getDoubleValue() / (-26110) ) < 0.5
						power_lvr[0].getDoubleValue() < 0.75 and power_lvr[1].getDoubleValue() < 0.75 ){
					gear_horn_mutable = 0;
					gear_horn_muted.setBoolValue( 0 );
					new_value = 1;
				} elsif( ind_airsp.getDoubleValue() < 156 and rad_alt.getDoubleValue() < 1053 ){ # TODO Check if Radar Alt is valid
					if( power_lvr[0].getDoubleValue() < 0.1 and power_lvr[1].getDoubleValue() < 0.1 ){
						new_value = 1;
					} elsif( ( power_lvr[0].getDoubleValue() < 0.1 or power_lvr[1].getDoubleValue() < 0.1 ) 
							and ( power_lvr[0].getDoubleValue() < 0.75 and power_lvr[1].getDoubleValue() < 0.75 )
							and gear_horn_mute_test_sw.getIntValue() != 1 ){
						new_value = 1;
					}
				}
			}
		}
	}
	
	if( new_value != prev_value ){
		
		gear_horn_out.setBoolValue( new_value );
		
	}
	
	
}

var gear_warning_timer = maketimer( 0.5, gear_warning_loop );
gear_warning_timer.simulatedTime = 1;
gear_warning_timer.start();
