#########################################################
############## General initializers #####################
#########################################################
#                                                        M2/AN Browning .50 BMG
var n_gun1_ammo_count = "ai/submodels/submodel[0]/count";
var n_gun2_ammo_count = "ai/submodels/submodel[1]/count";
var n_gun3_ammo_count = "ai/submodels/submodel[2]/count";
var n_gun4_ammo_count = "ai/submodels/submodel[3]/count";
#                                                        AIM-9 sidewinder (unguided) pylon 3 rockets by wing
var l_roc1_ammo_count = "ai/submodels/submodel[4]/count";
var l_roc2_ammo_count = "ai/submodels/submodel[5]/count";
var l_roc3_ammo_count = "ai/submodels/submodel[6]/count";
var r_roc1_ammo_count = "ai/submodels/submodel[7]/count";
var r_roc2_ammo_count = "ai/submodels/submodel[8]/count";
var r_roc3_ammo_count = "ai/submodels/submodel[9]/count";
#                                                        MK-82 500 pound bomb
var l_bomb_ammo_count = "ai/submodels/submodel[10]/count";
var r_bomb_ammo_count = "ai/submodels/submodel[11]/count";

#########################################################
##################### reload guns #######################
#########################################################
# Guns generally cannot be reloaded in flight.  It requires landing,
# stop, and reload before taking off again.
#
# Note that tracers are modeled as bullets that include a visual model but
# no impact.  They fire along with 1 of every three or four bullets to simulate
# a tracer round every 4 rounds.

reload_guns  = func {

  groundspeed = getprop("velocities/groundspeed-kt");
  engine_rpm  = getprop("engines/engine/rpm");

  #only allow it if on ground, stopped OR if it's already set to unlimited mode
  if ( ( groundspeed < 5 and engine_rpm < 5 ) or getprop( r_gun1_ammo_count) == -1 ) {

    #                                           M2/AN Browning .50 BMG
    setprop ( n_gun1_ammo_count, 400);
    setprop ( n_gun2_ammo_count, 400);
    setprop ( n_gun3_ammo_count, 400);
    setprop ( n_gun4_ammo_count, 400);
    #                                           AIM-9 sidewinder (unguided) pylon 3 rockets by wing
    setprop ( l_roc1_ammo_count, 1);
    setprop ( l_roc2_ammo_count, 1);
    setprop ( l_roc3_ammo_count, 1);
    setprop ( r_roc1_ammo_count, 1);
    setprop ( r_roc2_ammo_count, 1);
    setprop ( r_roc3_ammo_count, 1);
    #                                           MK-82 500 pound bomb
    setprop ( l_bomb_ammo_count, 1);
    setprop ( r_bomb_ammo_count, 1);

    gui.popupTip ("Guns reloaded--400 rounds in each gun.", 5)
  } else {
    gui.popupTip ("You must be on the ground and engines dead stopped to re-load guns.",5)
  }
}

#########################################################
################ unlimited ammo #########################
#########################################################
# For testing only, of course!
#

unlimited_guns = func {

  groundspeed = getprop("velocities/groundspeed-kt");
  engine_rpm  = getprop("engines/engine/rpm");

  #                                           M2/AN Browning .50 BMG
  setprop ( n_gun1_ammo_count, -1);
  setprop ( n_gun2_ammo_count, -1);
  setprop ( n_gun3_ammo_count, -1);
  setprop ( n_gun4_ammo_count, -1);
  #                                           AIM-9 sidewinder (unguided) pylon 3 rockets by wing
  setprop ( l_roc1_ammo_count, 1);
  setprop ( l_roc2_ammo_count, 1);
  setprop ( l_roc3_ammo_count, 1);
  setprop ( r_roc1_ammo_count, 1);
  setprop ( r_roc2_ammo_count, 1);
  setprop ( r_roc3_ammo_count, 1);
  #                                           MK-82 500 pound bomb
  setprop ( l_bomb_ammo_count, 1);
  setprop ( r_bomb_ammo_count, 1);

  gui.popupTip ("Guns set to unlimited mode--definitely not realistic and only for testing!  Select 'Reload Guns' to revert to limited ammo.",7)
}
