##################################################################
####      propellers.nas - ePilot                             ####
####                                                          ####
####    Propeller blade angle animations                      ####
####    and Feather / Reverse Thrust control                  ####
##################################################################


########################  Left Feather  ##########################

togglefeatherleft = func {

  throttle1 = "/controls/engines/engine[0]/throttle";
  engine1 = "/fdm/jsbsim/propulsion/engine[0]";
  control1 = "/controls/engines/engine[0]/propeller-feather";
  cspeed1 = "/fdm/jsbsim/propulsion/engine[0]/constant-speed-mode";
  engselect = "/sim/input/selected";
  pitch1 = "/fdm/jsbsim/propulsion/engine[0]/blade-angle";
  pitchcontrol1 = "/controls/engines/engine[0]/propeller-pitch";

  if (getprop(control1)) {

      setprop(cspeed1, 0);
      setprop(pitch1, 90);
      setprop(engselect,"engine[0]", 1);
      setprop("throttle1", 0);
      setprop(pitchcontrol1, getprop(pitchcontrol1));

    } else {

      setprop(pitch1, 16);
      setprop(engselect,"engine[0]", 1);
      setprop(throttle1, 0);
      setprop(cspeed1, 1);
      setprop(pitchcontrol1, getprop(pitchcontrol1));

    }
}

setlistener("/controls/engines/engine[0]/propeller-feather", togglefeatherleft, 0, 0);


########################  Right Feather  ##########################

togglefeatherright = func {

  throttle2 = "/controls/engines/engine[1]/throttle";
  engine2 = "/fdm/jsbsim/propulsion/engine[1]";
  control2 = "/controls/engines/engine[1]/propeller-feather";
  cspeed2 = "/fdm/jsbsim/propulsion/engine[1]/constant-speed-mode";
  engselect = "/sim/input/selected";
  pitch2 = "/fdm/jsbsim/propulsion/engine[1]/blade-angle";
  pitchcontrol2 = "/controls/engines/engine[1]/propeller-pitch";

  if (getprop(control2)) {

      setprop(cspeed2, 0);
      setprop(pitch2, 90);
      setprop(engselect,"engine[1]", 1);
      setprop("throttle2", 0);
      setprop(pitchcontrol2, getprop(pitchcontrol2));

    } else {

      setprop(pitch2, 16);
      setprop(engselect,"engine[1]", 1);
      setprop(throttle2, 0);
      setprop(cspeed2, 1);
      setprop(pitchcontrol2, getprop(pitchcontrol2));

    }
}

setlistener("/controls/engines/engine[1]/propeller-feather", togglefeatherright, 0, 0);


#################################  Left Pitch  #################################


var proppitchleft = func {

  throttle1 = "/controls/engines/engine[0]/throttle";
  engine1 = "/fdm/jsbsim/propulsion/engine[0]";
  control1 = "/sim/model/BladeAngleLeft";
  setting1 = "/controls/engines/engine[0]/propeller-pitch";
  cspeed1 = "/fdm/jsbsim/propulsion/engine[0]/constant-speed-mode";
  engselect = "/sim/input/selected";
  reversed1 = "/controls/engines/engine[0]/reverser";
  feathered1 = "/controls/engines/engine[0]/propeller-feather";

  if (getprop(feathered1)) {

      interpolate(control1, 78, 1);

  } else if (getprop(reversed1)) {

      interpolate(control1, -30, 1);

  } else {

    var1 = getprop(setting1);
    interpolate(control1, (abs(var1 -1) * 45) - 15, 1);

  }

}

setlistener("/controls/engines/engine[0]/propeller-pitch", proppitchleft, 1, 1);

#################################  Right Pitch  #################################

var proppitchright = func {

  throttle2 = "/controls/engines/engine[1]/throttle";
  engine2 = "/fdm/jsbsim/propulsion/engine[1]";
  control2 = "/sim/model/BladeAngleRight";
  setting2 = "/controls/engines/engine[1]/propeller-pitch";
  cspeed2 = "/fdm/jsbsim/propulsion/engine[1]/constant-speed-mode";
  engselect = "/sim/input/selected";
  reversed2 = "/controls/engines/engine[1]/reverser";
  feathered2 = "/controls/engines/engine[1]/propeller-feather";

  if (getprop(feathered2)) {

      interpolate(control2, 78, 1);

  } else if (getprop(reversed2)) {

      interpolate(control2, -30, 1);

  } else {

    var2 = getprop(setting2);
    interpolate(control2, (abs(var2 -1) * 45) - 15, 1);

  }

}

setlistener("/controls/engines/engine[1]/propeller-pitch", proppitchright, 1, 1);

#################################  Left Reverse  #################################

togglereverseleft = func {

  throttle1 = "/controls/engines/engine[0]/throttle";
  engine1 = "/fdm/jsbsim/propulsion/engine[0]";
  control1 = "/controls/engines/engine[0]/reverser";
  cspeed1 = "/fdm/jsbsim/propulsion/engine[0]/constant-speed-mode";
  engselect = "/sim/input/selected";
  pitch1 = "/fdm/jsbsim/propulsion/engine[0]/blade-angle";
  pitchcontrol1 = "/controls/engines/engine[0]/propeller-pitch";
  gearL = "/gear/gear[1]/wow";
  gearR = "/gear/gear[2]/wow";


  # The reverse can only be actuated while the engine is idling and both main gear compressed
  # or while false bow bouyancy bogey compressed? Check if fg says WOW for bouyancy bogey. it doesn't so screw it.

  if (getprop(throttle1) < 0.01 ) {

    val1 = getprop(pitch1);
    if (val1 >= 0) {
      setprop(cspeed1, 0);
      interpolate(pitch1, -12, 2);
      setprop(control1, 1);
      setprop(engselect,"engine[0]", 1);
      setprop(throttle1, 0);
      setprop(pitchcontrol1, getprop(pitchcontrol1));

    } else {

      interpolate(pitch1, 16, 2);
      setprop(control1, 0);
      setprop(engselect,"engine[0]", 1);
      setprop(throttle1, 0);
      setprop(cspeed1, 1);
      setprop(pitchcontrol1, getprop(pitchcontrol1));
    }
  }
}

#################################  Right Reverse  #################################

togglereverseright = func {

  throttle2 = "/controls/engines/engine[1]/throttle";
  engine2 = "/fdm/jsbsim/propulsion/engine[1]";
  control2 = "/controls/engines/engine[1]/reverser";
  cspeed2 = "/fdm/jsbsim/propulsion/engine[1]/constant-speed-mode";
  engselect = "/sim/input/selected";
  pitch2 = "/fdm/jsbsim/propulsion/engine[1]/blade-angle";
  pitchcontrol2 = "/controls/engines/engine[1]/propeller-pitch";
  gearL = "/gear/gear[1]/wow";
  gearR = "/gear/gear[2]/wow";


  # The reverse can only be actuated while the engine is idling and both main gear compressed
  # or while false bow bouyancy bogey compressed? Check if fg says WOW for bouyancy bogey. it doesn't so screw it.

  if (getprop(throttle2) < 0.01 ) {

    val2 = getprop(pitch2);
    if (val2 >= 0) {
      setprop(cspeed2, 0);
      interpolate(pitch2, -12, 2);
      setprop(control2, 1);
      setprop(engselect,"engine[1]", 1);
      setprop(throttle2, 0);
      setprop(pitchcontrol2, getprop(pitchcontrol2));

    } else {

      interpolate(pitch2, 16, 2);
      setprop(control2, 0);
      setprop(engselect,"engine[1]", 1);
      setprop(throttle2, 0);
      setprop(cspeed2, 1);
      setprop(pitchcontrol2, getprop(pitchcontrol2));
    }
  }
}

#################################  Both Reverse  #################################

togglereversers = func {

  throttle1 = "/controls/engines/engine[0]/throttle";
  engine1 = "/fdm/jsbsim/propulsion/engine[0]";
  control1 = "/controls/engines/engine[0]/reverser";
  cspeed1 = "/fdm/jsbsim/propulsion/engine[0]/constant-speed-mode";
  pitch1 = "/fdm/jsbsim/propulsion/engine[0]/blade-angle";
  pitchcontrol1 = "/controls/engines/engine[0]/propeller-pitch";
#  gearL = "/gear/gear[1]/wow";
#  gearR = "/gear/gear[2]/wow";


  # The reverse can only be actuated while the engine is idling and both main gear compressed
  # or while false bow bouyancy bogey compressed? Check if fg says WOW for bouyancy bogey. it doesn't so screw it.

  if (getprop(throttle1) < 0.01 ) {

    val1 = getprop(pitch1);
    if (val1 >= 0) {
      setprop(cspeed1, 0);
      setprop(pitch1, -12);
      setprop(control1, 1);
      setprop(throttle1, 0);
      setprop(pitchcontrol1, getprop(pitchcontrol1));

    } else {

      setprop(pitch1, 16);
      setprop(control1, 0);
      setprop(throttle1, 0);
      setprop(cspeed1, 1);
      setprop(pitchcontrol1, getprop(pitchcontrol1));
    }
  }

  throttle2 = "/controls/engines/engine[1]/throttle";
  engine2 = "/fdm/jsbsim/propulsion/engine[1]";
  control2 = "/controls/engines/engine[1]/reverser";
  cspeed2 = "/fdm/jsbsim/propulsion/engine[1]/constant-speed-mode";
  pitch2 = "/fdm/jsbsim/propulsion/engine[1]/blade-angle";
  pitchcontrol2 = "/controls/engines/engine[1]/propeller-pitch";
#  gearL = "/gear/gear[1]/wow";
#  gearR = "/gear/gear[2]/wow";

  # The reverse can only be actuated while the engine is idling and both main gear compressed
  # or while false bow bouyancy bogey compressed? Check if fg says WOW for bouyancy bogey. it doesn't so screw it.

  if (getprop(throttle2) < 0.01 ) {

    val2 = getprop(pitch2);
    if (val2 >= 0) {
      setprop(cspeed2, 0);
      setprop(pitch2, -12);
      setprop(control2, 1);
      setprop(throttle2, 0);
      setprop(pitchcontrol2, getprop(pitchcontrol2));

    } else {

      setprop(pitch2, 16);
      setprop(control2, 0);
      setprop(throttle2, 0);
      setprop(cspeed2, 1);
      setprop(pitchcontrol2, getprop(pitchcontrol2));

    }
  }

}
