# Q100/200/300 VSI by Bea Wolf based on
# A3XX Lower ECAM Canvas
# by Joshua Davidson

#sources: http://www.smartcockpit.com/docs/Dash8-200-300-Flight_Instruments.pdf

var VSI_main = nil;
var VSI_display = nil;

var VS_needle = props.globals.initNode("/instrumentation/vertical-speed-indicator/vsi-needle", 0.0, "DOUBLE");
var Volts = props.globals.initNode("/systems/electrical/outputs/vertical-speed-indicator", 0.0,  "DOUBLE");

var canvas_VSI_base = {
	init: func(canvas_group, file, screen) {
		var font_mapper = func(family, weight) {
			return "LiberationFonts/LiberationSans-Bold.ttf";
		};

		canvas.parsesvg(canvas_group, file, {'font-mapper': font_mapper});

		var svg_keys = me.getKeys();
		foreach (var key; svg_keys) {
			me[key] = canvas_group.getElementById(key);
		}
		
		me.page = canvas_group;

		return me;
	},
	getKeys: func() {
		return [];
	},
	update: func() {
		if (Volts.getValue() >= 10) {
			VSI_main.page.show();
			VSI_main.update();
		} else {
			VSI_main.page.hide();
		}
	},
};

var canvas_VSI_main = {
	new: func(canvas_group, file) {
		var m = { parents: [canvas_VSI_main,canvas_VSI_base] };
		m.init(canvas_group, file, "main");

		return m;
	},
	getKeys: func() {
		return ["vsi.needle"];
	},
	update: func() {
		me["vsi.needle"].setRotation( VS_needle.getDoubleValue() * D2R);
	},
};

var vsi_update = maketimer( 0.05, func{ canvas_VSI_base.update() } );
vsi_update.simulatedTime = 1;

setlistener("sim/signals/fdm-initialized", func {
	VSI_display = canvas.new({
		"name": "VSI",
		"size": [512, 512],
		"view": [512, 512],
		"mipmapping": 1
	});
	VSI_display.addPlacement({"node": "VSI.screen"});

	VSI_main = canvas_VSI_main.new( VSI_display.createGroup(), "Aircraft/QSeries/Models/Cockpit/Instruments/VSI/VSI.svg");

	vsi_update.start();
});

var showVSI = func {
	var dlg = canvas.Window.new([512, 512], "dialog").set("resize", 1);
	dlg.setCanvas(VSI_display);
}
