# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=enchant
VER=1.5.0
REV=1
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

DEPS=`latest --arch=${ARCH} glib`

PKG_CONFIG_PATH=/dummy
for D in $DEPS; do
    PATH="/devel/dist/${ARCH}/$D/bin:$PATH"
    PKG_CONFIG_PATH=/devel/dist/${ARCH}/$D/lib/pkgconfig:$PKG_CONFIG_PATH
done

# Avoid libtool relinking.
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

patch --verbose -p0 <<'EOF'
--- configure
+++ configure
@@ -17334,7 +17334,7 @@
 
 { $as_echo "$as_me:$LINENO: checking for native Win32" >&5
 $as_echo_n "checking for native Win32... " >&6; }
-case "$target" in
+case "$host" in
   *-*-mingw*)
     native_win32=yes
     SOCKET_LIBS='-lws2_32 -ldnsapi'
--- /dev/null
+++ compile-resource
@@ -0,0 +1,46 @@
+#!/bin/sh
+
+# Script to compile a resource file for a DLL if there is a .rc file
+# for it. The resource source file is supposed to contain a version
+# info section, that uses the string BUILDNUMBER as the least
+# significant part of the version numbers. This script replaces that
+# string with a "build number" before compiling the binary resource
+# file. The build number is kept between builds in a "stamp" file, and
+# incremented each time. (If there is no stamp file, build number 0 is
+# used.) The intention is that only the "official" maintainer of a DLL
+# keeps such a stamp file, and thus the DLLs he releases have
+# increasing version number resources, which can be used by an
+# installer program to decide whether to replace an existing DLL with
+# the same name.
+
+# This is just my (tml@iki.fi) idea, if somebody comes up with a
+# better way to generate version number resources, don't hesitate to
+# suggest.
+
+# The command line arguments are:
+# $1: the name of the .rc file to check
+# $2: the name of the resource object file to produce, if the rc file exists
+
+# Check if we have a resource file for this DLL.
+rcfile=$1
+resfile=$2
+if [ -f $rcfile ]; then
+    # Check if we have a build number stamp file.
+    basename=`basename $rcfile .rc`
+    if [ -f $basename-build.stamp ]; then
+	read number <$basename-build.stamp
+	buildnumber=$[number]
+	echo Build number $buildnumber
+	rm -rf $basename-build.stamp
+    else
+	echo Using zero as build number
+        buildnumber=0
+    fi
+
+    m4 -DBUILDNUMBER=$buildnumber <$rcfile >$$.rc &&
+	${WINDRES-windres} $$.rc $resfile &&
+	rm $$.rc
+else
+    # Return failure
+    exit 1
+fi
EOF

PATH=/opt/pthread/bin:$PATH # Needed by aspell.exe...

lt_cv_deplibs_check_method='pass_all' \
CC='gcc -mtune=pentium3' \
LDFLAGS='-L/opt/proxy-libintl/lib -Wl,--exclude-libs=libintl.a' \
CFLAGS=-O2 \
./configure --disable-static --prefix=c:/devel/target/$HEX &&
libtoolcacheize &&

make -j3 &&

make -j3 install &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&
(cd /devel/target/$HEX &&
zip /tmp/$RUNZIP bin/libenchant.dll
zip /tmp/$RUNZIP lib/enchant/*.dll
zip -r -D /tmp/$RUNZIP share/enchant

zip /tmp/$DEVZIP bin/enchant.exe bin/enchant-lsmod.exe
zip -r -D /tmp/$DEVZIP include
zip /tmp/$DEVZIP lib/libenchant.dll.a
zip /tmp/$DEVZIP lib/pkgconfig/enchant.pc
zip -r -D /tmp/$DEVZIP share/man
zip /tmp/$DEVZIP lib/pkgconfig/enchant.pc
)

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP
