# This is a shell script that calls functions and scripts from
# tml@iki.fi's personal work environment. It is not expected to be
# usable unmodified by others, and is included only for reference.

MOD=libpng
VER=1.2.29
THIS=$MOD-$VER
HEX=`echo $THIS | md5sum | cut -d' ' -f1`

TARGET=c:/devel/target/$HEX
ZLIB=`/devel/src/tml/latest.sh zlib`

# Avoid the silly "relink" stuff in libtool
sed -e 's/need_relink=yes/need_relink=no # no way --tml/' <ltmain.sh >ltmain.temp && mv ltmain.temp ltmain.sh

usedev
usemsvs6

CC='gcc -mtune=pentium3 -mthreads' CPPFLAGS="-I /devel/dist/$ZLIB/include" LDFLAGS="-L/devel/dist/$ZLIB/lib -Wl,--enable-auto-image-base" CFLAGS=-O2 ./configure --disable-static --without-libpng-compat --prefix=$TARGET &&
make install &&

(cd /devel/target/$HEX &&
zip /tmp/$MOD-$VER.zip bin/libpng12-0.dll &&
zip /tmp/$MOD-dev-$VER.zip include/png.h include/pngconf.h  &&
zip /tmp/$MOD-dev-$VER.zip lib/libpng12.dll.a &&
pexports bin/libpng12-0.dll >lib/libpng.def &&
lib -def:lib/libpng.def -out:lib/libpng.lib &&
zip /tmp/$MOD-dev-$VER.zip lib/libpng.def lib/libpng.lib &&
zip /tmp/$MOD-dev-$VER.zip lib/pkgconfig/libpng*.pc &&
zip -r -D /tmp/$MOD-dev-$VER.zip share/man
) &&

(cd /devel/src/tml && zip /tmp/$MOD-dev-$VER.zip make/$THIS.sh) &&
manifestify /tmp/$MOD*-$VER.zip

