# This is a shell script that is sourced, not executed. It uses
# functions and scripts from tml@iki.fi's work envronment and is
# included only for reference

MOD=pixman
VER=0.18.4
REV=2
ARCH=win32

THIS=${MOD}_${VER}-${REV}_${ARCH}

RUNZIP=${MOD}_${VER}-${REV}_${ARCH}.zip
DEVZIP=${MOD}-dev_${VER}-${REV}_${ARCH}.zip

HEX=`echo $THIS | md5sum | cut -d' ' -f1`
TARGET=c:/devel/target/$HEX

usedev

(

set -x

patch --verbose -p1 <<'EOF' &&
diff --git a/configure.ac b/configure.ac
index 8b2b024..d9f9718 100644
--- a/configure.ac
+++ b/configure.ac
@@ -145,6 +145,9 @@ have_gcc4=no
 AC_MSG_CHECKING(for -fvisibility)
 AC_COMPILE_IFELSE([
 #if defined(__GNUC__) && (__GNUC__ >= 4)
+#ifdef _WIN32
+error Have -fvisibility but it is ignored and generates a warning
+#endif
 #else
 error Need GCC 4.0 for visibility
 #endif
@@ -524,8 +527,8 @@ support_for__thread=no
 
 AC_MSG_CHECKING(for __thread)
 AC_COMPILE_IFELSE([
-#ifdef __MINGW32__
-#error MinGW has broken __thread support
+#if defined __MINGW32__ && !(__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 5))
+#error This MinGW version has broken __thread support
 #endif
 __thread int x ;
 int main () { return 0; }
diff --git a/pixman/pixman-compiler.h b/pixman/pixman-compiler.h
index 26f7071..affb236 100644
--- a/pixman/pixman-compiler.h
+++ b/pixman/pixman-compiler.h
@@ -60,7 +60,7 @@
 #endif
 
 /* GCC visibility */
-#if defined(__GNUC__) && __GNUC__ >= 4
+#if defined(__GNUC__) && __GNUC__ >= 4 && !defined(_WIN32)
 #   define PIXMAN_EXPORT __attribute__ ((visibility("default")))
 /* Sun Studio 8 visibility */
 #elif defined(__SUNPRO_C) && (__SUNPRO_C >= 0x550)
EOF

sleep 2

patch --verbose -p0 <<'EOF' &&
--- configure
+++ configure
@@ -11167,6 +11167,9 @@
 /* end confdefs.h.  */
 
 #if defined(__GNUC__) && (__GNUC__ >= 4)
+#ifdef _WIN32
+error Have -fvisibility but it is ignored and generates a warning
+#endif
 #else
 error Need GCC 4.0 for visibility
 #endif
@@ -11910,8 +11910,8 @@
 cat confdefs.h - <<_ACEOF >conftest.$ac_ext
 /* end confdefs.h.  */
 
-#ifdef __MINGW32__
-#error MinGW has broken __thread support
+#if defined __MINGW32__ && !(__GNUC__ > 4 || (__GNUC__ == 4 && __GNUC_MINOR__ >= 5))
+#error This MinGW version has broken __thread support
 #endif
 __thread int x ;
 int main () { return 0; }
--- Makefile.in
+++ Makefile.in
@@ -317,11 +317,6 @@
 	    cd $(top_builddir) && $(SHELL) ./config.status $@ $(am__depfiles_maybe);; \
 	esac;
 
-$(top_builddir)/config.status: $(top_srcdir)/configure $(CONFIG_STATUS_DEPENDENCIES)
-	$(SHELL) ./config.status --recheck
-
-$(top_srcdir)/configure:  $(am__configure_deps)
-	$(am__cd) $(srcdir) && $(AUTOCONF)
 $(ACLOCAL_M4):  $(am__aclocal_m4_deps)
 	$(am__cd) $(srcdir) && $(ACLOCAL) $(ACLOCAL_AMFLAGS)
 $(am__aclocal_m4_deps):
EOF

touch aclocal.m4 config.h.in

BUILDDEPS=`latest --arch=${ARCH} glib pkg-config`

for D in $BUILDDEPS; do
    PATH=/devel/dist/${ARCH}/$D/bin:$PATH
done

CC='gcc -mms-bitfields' CFLAGS=-O2 ./configure --disable-shared --prefix=c:/devel/target/$HEX &&
make &&
make install &&

rm -f /tmp/$RUNZIP /tmp/$DEVZIP &&

(cd /devel/target/$HEX &&

# I build pixman as a static library only, so the "run-time" package
# is actually empty. I create it here anyway to be able to use some
# scripts that assume each library has both a run-time and developer
# version.

zip /tmp/$RUNZIP nul &&
zip -d /tmp/$RUNZIP nul &&
zip -r -D /tmp/$DEVZIP include/pixman-1 &&
zip /tmp/$DEVZIP lib/libpixman-1.a &&
zip -r -D /tmp/$DEVZIP lib/pkgconfig &&

: )

) 2>&1 | tee /devel/src/tml/packaging/$THIS.log &&

(cd /devel && zip /tmp/$DEVZIP src/tml/packaging/$THIS.{sh,log}) &&
manifestify /tmp/$RUNZIP /tmp/$DEVZIP &&

:
