/*
 * Decompiled with CFR 0.152.
 */
package com.ice.jni.registry;

import com.ice.jni.registry.RegistryKey;
import java.io.PrintWriter;

public abstract class RegistryValue {
    public static final int REG_NONE = 0;
    public static final int REG_SZ = 1;
    public static final int REG_EXPAND_SZ = 2;
    public static final int REG_BINARY = 3;
    public static final int REG_DWORD = 4;
    public static final int REG_DWORD_LITTLE_ENDIAN = 4;
    public static final int REG_DWORD_BIG_ENDIAN = 5;
    public static final int REG_LINK = 6;
    public static final int REG_MULTI_SZ = 7;
    public static final int REG_RESOURCE_LIST = 8;
    public static final int REG_FULL_RESOURCE_DESCRIPTOR = 9;
    public static final int REG_RESOURCE_REQUIREMENTS_LIST = 10;
    protected static char[] hexChars = new char[20];
    int type;
    String name;
    RegistryKey key;

    public RegistryValue(RegistryKey registryKey, String string, int n) {
        this.key = registryKey;
        this.name = string;
        this.type = n;
    }

    public RegistryKey getKey() {
        return this.key;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public void export(PrintWriter printWriter) {
        printWriter.print("\"" + this.getName() + "\"=");
        printWriter.println("\"ERROR called RegistryValue.export()!\"");
    }

    public String toString() {
        return "[type=" + this.type + ",name=" + this.name + "]";
    }

    public static void exportHexData(PrintWriter printWriter, byte[] byArray) {
        int n = byArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            byte by = byArray[i];
            char c = hexChars[by & 0xF];
            char c2 = hexChars[by >> 4 & 0xF];
            if (n2 == 0) {
                printWriter.print("  ");
            }
            printWriter.print(c2);
            printWriter.print(c);
            if (i < n - 1) {
                printWriter.print(",");
            }
            if (++n2 <= 15) continue;
            n2 = 0;
            if (i >= n - 1) continue;
            printWriter.println("\\");
        }
        printWriter.println("");
    }

    public abstract byte[] getByteData();

    public abstract int getByteLength();

    public abstract void setByteData(byte[] var1);

    static {
        RegistryValue.hexChars[0] = 48;
        RegistryValue.hexChars[1] = 49;
        RegistryValue.hexChars[2] = 50;
        RegistryValue.hexChars[3] = 51;
        RegistryValue.hexChars[4] = 52;
        RegistryValue.hexChars[5] = 53;
        RegistryValue.hexChars[6] = 54;
        RegistryValue.hexChars[7] = 55;
        RegistryValue.hexChars[8] = 56;
        RegistryValue.hexChars[9] = 57;
        RegistryValue.hexChars[10] = 97;
        RegistryValue.hexChars[11] = 98;
        RegistryValue.hexChars[12] = 99;
        RegistryValue.hexChars[13] = 100;
        RegistryValue.hexChars[14] = 101;
        RegistryValue.hexChars[15] = 102;
    }
}

