/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import org.jrobin.core.FetchData;
import org.jrobin.core.RrdException;
import org.jrobin.core.Util;
import org.jrobin.graph.Source;

class ValueExtractor {
    private String[] varNames;
    private int reduceFactor = 1;
    private int[] tPos;
    private long[] steps;
    private long[][] timestamps;
    private double[][][] dsValues;

    ValueExtractor(String[] stringArray, FetchData[] fetchDataArray, int n) {
        this.varNames = stringArray;
        this.reduceFactor = n;
        this.tPos = new int[fetchDataArray.length];
        this.steps = new long[fetchDataArray.length];
        this.timestamps = new long[fetchDataArray.length][];
        this.dsValues = new double[fetchDataArray.length][][];
        for (int i = 0; i < this.timestamps.length; ++i) {
            if (fetchDataArray[i] == null) continue;
            this.timestamps[i] = fetchDataArray[i].getTimestamps();
            this.dsValues[i] = fetchDataArray[i].getValues();
            if (this.timestamps[i].length < 2) continue;
            this.steps[i] = this.timestamps[i][1] - this.timestamps[i][0];
        }
    }

    int prepareSources(Source[] sourceArray, int n) {
        int n2 = n;
        for (int i = 0; i < this.dsValues.length; ++i) {
            if (this.dsValues[i] == null) continue;
            for (int j = 0; j < this.dsValues[i].length; ++j) {
                sourceArray[n2++].setFetchedStep(this.steps[i]);
            }
        }
        return n2;
    }

    int extract(long l, Source[] sourceArray, int n, int n2) throws RrdException {
        int n3 = n2;
        for (int i = 0; i < this.dsValues.length; ++i) {
            int n4;
            int n5;
            if (this.dsValues[i] == null) continue;
            int n6 = this.tPos[i];
            double[] dArray = new double[this.dsValues[i].length];
            int[] nArray = new int[dArray.length];
            for (n5 = 0; n5 < dArray.length; ++n5) {
                dArray[n5] = Double.NaN;
            }
            for (n5 = 0; n5 < this.reduceFactor && this.timestamps[i][n6] <= l; ++n5) {
                block9: for (n4 = 0; n4 < this.dsValues[i].length; ++n4) {
                    if (Double.isNaN(this.dsValues[i][n4][n6])) continue;
                    int n7 = n4;
                    nArray[n7] = nArray[n7] + 1;
                    if (Double.isNaN(dArray[n4])) {
                        dArray[n4] = this.dsValues[i][n4][n6];
                        continue;
                    }
                    switch (i) {
                        case 0: {
                            int n8 = n4;
                            dArray[n8] = dArray[n8] + this.dsValues[i][n4][n6];
                            continue block9;
                        }
                        case 1: {
                            dArray[n4] = Util.max(dArray[n4], this.dsValues[i][n4][n6]);
                            continue block9;
                        }
                        case 2: {
                            dArray[n4] = Util.min(dArray[n4], this.dsValues[i][n4][n6]);
                            continue block9;
                        }
                        case 3: {
                            dArray[n4] = this.dsValues[i][n4][n6];
                        }
                    }
                }
                ++n6;
            }
            if (n5 == 0 && n > 0) {
                sourceArray[n3++].set(n, l, Double.POSITIVE_INFINITY);
            } else {
                for (n4 = 0; n4 < this.dsValues[i].length; ++n4) {
                    if (i == 0) {
                        int n9 = n4;
                        dArray[n9] = dArray[n9] / (double)nArray[n4];
                    }
                    sourceArray[n3++].set(n, l, dArray[n4]);
                }
            }
            this.tPos[i] = n6;
        }
        return n3;
    }

    String[] getNames() {
        return this.varNames;
    }
}

