/*
 * Decompiled with CFR 0.152.
 */
package org.videolan.vlma.daemon;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.videolan.vlma.daemon.IVlStreamWatcher;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlExtremeWatcher
implements IVlStreamWatcher {
    private static final Logger logger = Logger.getLogger(VlExtremeWatcher.class);
    private static final int TELNET_DEFAULT_WAIT = 100;
    private static final int TELNET_DEFAULT_DELAY = 1000;
    private static final String ROUTER_HOST = "138.195.131.126";
    private static final int ROUTER_PORT = 23;
    private static final String ROUTER_USER = "user";
    private static final String ROUTER_PASSWORD = "via";
    private static final String ROUTER_VLAN = "vlip-videolan";

    @Override
    public Map<InetAddress, InetAddress> getStreams() {
        String toParse = "";
        logger.log(Level.DEBUG, "Connexion au routeur pour r\u00e9cup\u00e9ration de l'\u00e9tat de flux");
        try {
            Socket socket = new Socket(ROUTER_HOST, 23);
            PrintWriter out = new PrintWriter(socket.getOutputStream(), true);
            BufferedReader in = new BufferedReader(new InputStreamReader(socket.getInputStream()));
            out.println(ROUTER_USER);
            out.println(ROUTER_PASSWORD);
            out.println("show igmp snooping vlip-videolan");
            out.println("          ");
            Thread.sleep(100L);
            int m = 1000;
            while (!in.ready() && (m -= 100) > 0) {
                Thread.sleep(100L);
            }
            while (in.ready()) {
                toParse = toParse + (char)in.read();
            }
            out.close();
            in.close();
            socket.close();
        }
        catch (UnknownHostException e) {
            logger.log(Level.ERROR, "Erreur lors de l'interrogation du routeur", e);
        }
        catch (IOException e) {
            logger.log(Level.ERROR, "Erreur lors de l'interrogation du routeur", e);
        }
        catch (InterruptedException e) {
            logger.log(Level.ERROR, "Le thread a \u00e9t\u00e9 interrompu", e);
        }
        HashMap<InetAddress, InetAddress> streams = new HashMap<InetAddress, InetAddress>();
        Matcher m = Pattern.compile("\\s+\\w+\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)\\s+(\\d+\\.\\d+\\.\\d+\\.\\d+)").matcher(toParse);
        while (m.find()) {
            try {
                InetAddress ip1 = InetAddress.getByName(m.group(1));
                InetAddress ip2 = InetAddress.getByName(m.group(2));
                if (!ip1.isMulticastAddress() || ip2.isMulticastAddress()) continue;
                streams.put(ip1, ip2);
                logger.log(Level.DEBUG, "Le serveur " + ip2.getHostName() + " diffuse " + ip1.getHostName());
            }
            catch (UnknownHostException e) {
                logger.log(Level.ERROR, "Impossible de r\u00e9soudre une adresse", e);
            }
        }
        return streams;
    }
}

