/*
 * Decompiled with CFR 0.152.
 */
package org.jrobin.graph;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.Stroke;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.LinkedList;
import javax.imageio.ImageIO;
import org.jrobin.core.RrdException;
import org.jrobin.graph.ChartGraphics;
import org.jrobin.graph.Comment;
import org.jrobin.graph.FetchSourceList;
import org.jrobin.graph.Gprint;
import org.jrobin.graph.GridRange;
import org.jrobin.graph.Legend;
import org.jrobin.graph.LegendMarker;
import org.jrobin.graph.PlotDef;
import org.jrobin.graph.RrdExporter;
import org.jrobin.graph.RrdGraph;
import org.jrobin.graph.RrdGraphDef;
import org.jrobin.graph.Source;
import org.jrobin.graph.TimeGrid;
import org.jrobin.graph.TimeMarker;
import org.jrobin.graph.Title;
import org.jrobin.graph.ValueFormatter;
import org.jrobin.graph.ValueGrid;
import org.jrobin.graph.ValueMarker;

class Grapher
extends RrdExporter {
    protected static final String SPACER = "  ";
    protected static final int GRAPH_RESOLUTION = 400;
    protected static final int DEFAULT_WIDTH = 400;
    protected static final int DEFAULT_HEIGHT = 100;
    protected static final int UBORDER_SPACE = 10;
    protected static final int BBORDER_SPACE = 10;
    protected static final int LBORDER_SPACE = 10;
    protected static final int RBORDER_SPACE = 13;
    protected static final int CHART_UPADDING = 5;
    protected static final int CHART_BPADDING = 25;
    protected static final int CHART_RPADDING = 10;
    protected static final int CHART_LPADDING = 50;
    protected static final int CHART_BPADDING_NM = 10;
    protected static final int CHART_LPADDING_NM = 10;
    protected static final int LINE_PADDING = 4;
    protected static final Font TITLE_FONT = new Font("Lucida Sans Typewriter", 1, 12);
    protected static final Font NORMAL_FONT = new Font("Lucida Sans Typewriter", 0, 10);
    private Font title_font = TITLE_FONT;
    private Font normal_font = NORMAL_FONT;
    private Color normalFontColor = null;
    private int numPoints = 400;
    private int chart_lpadding;
    private int chart_bpadding;
    private int imgWidth;
    private int imgHeight;
    private int chartWidth;
    private int chartHeight;
    private int nfont_width;
    private int nfont_height;
    private int tfont_width;
    private int tfont_height;
    private int commentBlock;
    private int graphOriginX;
    private int graphOriginY;
    private int x_offset;
    private int y_offset;
    private RrdGraphDef graphDef;
    private PlotDef[] plotDefs;
    private long[] tsChart;
    private ValueFormatter valueFormat;
    private BasicStroke defaultStroke;
    private ValueGrid vGrid;
    private TimeGrid tGrid;

    Grapher(RrdGraphDef rrdGraphDef, RrdGraph rrdGraph) {
        super(rrdGraphDef, rrdGraph);
        this.graphDef = rrdGraphDef;
        if (rrdGraphDef.getDefaultFont() != null) {
            this.normal_font = rrdGraphDef.getDefaultFont();
        }
        if (rrdGraphDef.getTitleFont() != null) {
            this.title_font = rrdGraphDef.getTitleFont();
        }
        this.normalFontColor = rrdGraphDef.getDefaultFontColor();
        this.nfont_height = this.normal_font.getSize();
        this.nfont_width = this.nfont_height / 2 + 1;
        this.tfont_height = this.title_font.isBold() ? this.title_font.getSize() + 2 : this.title_font.getSize();
        this.tfont_width = this.title_font.isBold() ? this.tfont_height / 2 : this.tfont_height / 2 + 1;
        this.valueFormat = new ValueFormatter(rrdGraphDef.getBaseValue(), rrdGraphDef.getScaleIndex());
        this.defaultStroke = new BasicStroke();
        this.startTime = rrdGraphDef.getStartTime();
        this.endTime = rrdGraphDef.getStartTime();
    }

    private void calculateDimensions(int n, int n2) {
        this.chartWidth = n == 0 ? 400 : n;
        int n3 = this.chartHeight = n2 == 0 ? 100 : n2;
        if (n > 0) {
            this.numPoints = n;
        }
        this.chart_lpadding = this.graphDef.showMajorGridY() ? this.graphDef.getChartLeftPadding() : 10;
        this.chart_bpadding = this.graphDef.showMajorGridX() ? 25 : 10;
        this.commentBlock = 0;
        if (this.graphDef.showLegend()) {
            this.commentBlock = this.graphDef.getCommentLineCount() * (this.nfont_height + 4) - 4;
        }
        this.x_offset = 10;
        if (this.graphDef.getVerticalLabel() != null) {
            this.x_offset += this.nfont_height + 4;
        }
        this.imgWidth = this.chartWidth + this.x_offset + 13 + this.chart_lpadding + 10;
        this.y_offset = 10;
        if (this.graphDef.getTitle() != null) {
            this.y_offset += (this.tfont_height + 4) * this.graphDef.getTitle().getLineCount() + this.tfont_height + 4;
        }
        this.imgHeight = this.chartHeight + this.commentBlock + this.y_offset + 10 + 5 + 25;
    }

    private void calculateDimensionsGlobal(int n, int n2) {
        this.imgWidth = n;
        this.imgHeight = n2;
        if (n > 0) {
            this.numPoints = n;
        }
        this.chart_lpadding = this.graphDef.showMajorGridY() ? this.graphDef.getChartLeftPadding() : 10;
        this.chart_bpadding = this.graphDef.showMajorGridX() ? 25 : 10;
        this.commentBlock = 0;
        if (this.graphDef.showLegend()) {
            this.commentBlock = this.graphDef.getCommentLineCount() * (this.nfont_height + 4) - 4;
        }
        this.x_offset = 10;
        if (this.graphDef.getVerticalLabel() != null) {
            this.x_offset += this.nfont_height + 4;
        }
        this.chartWidth = this.imgWidth - this.x_offset - 13 - this.chart_lpadding - 10;
        this.y_offset = 10;
        if (this.graphDef.getTitle() != null) {
            this.y_offset += (this.tfont_height + 4) * this.graphDef.getTitle().getLineCount() + this.tfont_height + 4;
        }
        this.chartHeight = this.imgHeight - this.commentBlock - this.y_offset - 10 - 5 - 25;
    }

    protected BufferedImage createImage(int n, int n2, int n3) throws RrdException, IOException {
        this.calculateDimensions(n, n2);
        BufferedImage bufferedImage = new BufferedImage(this.imgWidth, this.imgHeight, n3);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.render(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected BufferedImage createImageGlobal(int n, int n2, int n3) throws RrdException, IOException {
        this.calculateDimensionsGlobal(n, n2);
        BufferedImage bufferedImage = new BufferedImage(this.imgWidth, this.imgHeight, n3);
        Graphics2D graphics2D = (Graphics2D)bufferedImage.getGraphics();
        this.render(graphics2D);
        graphics2D.dispose();
        return bufferedImage;
    }

    protected void renderImage(int n, int n2, Graphics2D graphics2D, boolean bl) throws RrdException, IOException {
        if (bl) {
            this.calculateDimensionsGlobal(n, n2);
        } else {
            this.calculateDimensions(n, n2);
        }
        this.render(graphics2D);
    }

    protected boolean shouldGenerate(long l) throws RrdException, IOException {
        FetchSourceList fetchSourceList = this.graphDef.getFetchSources();
        fetchSourceList.setRrdOpener(this.getRrdOpener());
        fetchSourceList.openAll();
        if (this.graphDef.isLazy() && fetchSourceList.getLastUpdateTime() * 1000L < l) {
            fetchSourceList.releaseAll();
            return false;
        }
        return true;
    }

    private void render(Graphics2D graphics2D) throws RrdException, IOException {
        this.calculateSeries();
        this.plotImageBackground(graphics2D);
        this.plotChart(graphics2D);
        this.plotComments(graphics2D);
        this.plotOverlay(graphics2D);
        this.plotSignature(graphics2D);
        graphics2D.dispose();
    }

    private void calculateSeries() throws RrdException, IOException {
        int n;
        super.calculateSeries(this.chartWidth);
        this.numPoints = this.numRows;
        this.tsChart = new long[this.chartWidth];
        this.plotDefs = this.graphDef.getPlotDefs();
        for (n = 0; n < this.plotDefs.length; ++n) {
            this.plotDefs[n].setSource(this.sources, this.sourceIndex);
            this.plotDefs[n].prepareValues(this.chartWidth);
        }
        for (n = 0; n < this.chartWidth; ++n) {
            long l = (long)((double)this.startTime + (double)n * ((double)(this.endTime - this.startTime) / (double)(this.chartWidth - 1)));
            for (int i = 0; i < this.plotDefs.length; ++i) {
                this.plotDefs[i].setValue(n, l, this.timestamps);
            }
            this.tsChart[n] = l;
        }
    }

    private void plotImageBackground(Graphics2D graphics2D) {
        Object object;
        Serializable serializable;
        graphics2D.setColor(this.graphDef.getBackColor());
        graphics2D.fillRect(0, 0, this.imgWidth, this.imgHeight);
        try {
            serializable = this.graphDef.getBackground();
            if (serializable != null) {
                object = ImageIO.read(serializable);
                graphics2D.drawRenderedImage((RenderedImage)object, null);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        serializable = this.graphDef.getBorderColor();
        object = this.graphDef.getBorderStroke();
        if (object != null && serializable != null) {
            graphics2D.setColor((Color)serializable);
            graphics2D.setStroke((Stroke)object);
            int n = new Float(((BasicStroke)object).getLineWidth()).intValue();
            if (n > 0) {
                graphics2D.drawRect(n / 2, n / 2, this.imgWidth - n, this.imgHeight - n);
            }
            graphics2D.setStroke(this.defaultStroke);
        } else {
            graphics2D.setColor(new Color(220, 220, 220));
            graphics2D.fillRect(0, 0, 2, this.imgHeight - 1);
            graphics2D.fillRect(0, 0, this.imgWidth - 1, 2);
            graphics2D.setColor(Color.GRAY);
            graphics2D.drawLine(0, this.imgHeight - 1, this.imgWidth, this.imgHeight - 1);
            graphics2D.drawLine(this.imgWidth - 1, 0, this.imgWidth - 1, this.imgHeight);
            graphics2D.drawLine(1, this.imgHeight - 2, this.imgWidth, this.imgHeight - 2);
            graphics2D.drawLine(this.imgWidth - 2, 1, this.imgWidth - 2, this.imgHeight);
        }
        this.plotImageTitle(graphics2D);
        this.plotVerticalLabel(graphics2D);
    }

    private void plotChart(Graphics2D graphics2D) throws RrdException {
        int n;
        int n2 = this.x_offset + this.chart_lpadding;
        int n3 = this.y_offset + 5;
        if (this.graphDef.getBackground() == null) {
            graphics2D.setColor(this.graphDef.getCanvasColor());
            graphics2D.fillRect(n2, n3, this.chartWidth, this.chartHeight);
        }
        graphics2D.setColor(this.graphDef.getFrameColor());
        graphics2D.drawRect(n2, n3, this.chartWidth, this.chartHeight);
        double[] dArray = new double[this.numPoints];
        boolean bl = false;
        double d = Double.MAX_VALUE;
        double d2 = Double.MIN_VALUE;
        GridRange gridRange = this.graphDef.getGridRange();
        if (gridRange != null) {
            bl = gridRange.isRigid();
            d = gridRange.getLowerValue();
            d2 = gridRange.getUpperValue();
            if (Double.isNaN(d)) {
                d = Double.MAX_VALUE;
            }
            if (Double.isNaN(d2)) {
                d2 = Double.MIN_VALUE;
            }
        }
        for (int i = 0; i < this.plotDefs.length; ++i) {
            Source source = this.plotDefs[i].getSource();
            if (bl || source == null) continue;
            double d3 = source.getAggregate(0);
            double d4 = source.getAggregate(1);
            if (this.plotDefs[i].plotType == 2 && i >= 1) {
                double d5;
                if (this.plotDefs[i - 1].plotType == 2) {
                    for (n = 0; n < dArray.length; ++n) {
                        d5 = dArray[n] + this.plotDefs[i].getValue(n, this.timestamps);
                        if (d5 < d) {
                            d = d5;
                        }
                        if (d5 > d2) {
                            d2 = d5;
                        }
                        dArray[n] = d5;
                    }
                    continue;
                }
                for (n = 0; n < dArray.length; ++n) {
                    d5 = this.plotDefs[i - 1].getValue(n, this.timestamps) + this.plotDefs[i].getValue(n, this.timestamps);
                    if (d5 < d) {
                        d = d5;
                    }
                    if (d5 > d2) {
                        d2 = d5;
                    }
                    dArray[n] = d5;
                }
                continue;
            }
            if (d3 < d) {
                d = d3;
            }
            if (!(d4 > d2)) continue;
            d2 = d4;
        }
        this.vGrid = new ValueGrid(gridRange, d, d2, this.graphDef.getValueAxis(), this.graphDef.getBaseValue());
        this.tGrid = new TimeGrid(this.startTime, this.endTime, this.graphDef.getTimeAxis(), this.graphDef.getFirstDayOfWeek());
        d = this.vGrid.getLowerValue();
        d2 = this.vGrid.getUpperValue();
        ChartGraphics chartGraphics = new ChartGraphics(graphics2D);
        chartGraphics.setDimensions(this.chartWidth, this.chartHeight);
        chartGraphics.setXRange(this.tGrid.getStartTime(), this.tGrid.getEndTime());
        chartGraphics.setYRange(d, d2);
        double d6 = 1.0;
        if (d < 0.0) {
            d6 = 1.0 - d / (-d2 + d);
        }
        this.graphOriginX = n2;
        this.graphOriginY = new Double((double)n3 + (double)this.chartHeight * d6).intValue();
        if (!this.graphDef.isFrontGrid()) {
            this.plotChartGrid(chartGraphics);
        }
        if (this.graphDef.useAntiAliasing()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        }
        graphics2D.setClip(n2, n3, this.chartWidth, this.chartHeight);
        graphics2D.translate(this.graphOriginX, this.graphOriginY);
        int n4 = 0;
        double[] dArray2 = new double[this.tsChart.length];
        int[] nArray = new int[this.tsChart.length];
        for (n = 0; n < this.tsChart.length; ++n) {
            nArray[n] = chartGraphics.getX(this.tsChart[n]);
        }
        for (n = 0; n < this.plotDefs.length; ++n) {
            this.plotDefs[n].draw(chartGraphics, nArray, dArray2, n4);
            if (this.plotDefs[n].plotType == 2) continue;
            n4 = this.plotDefs[n].plotType;
        }
        graphics2D.translate(-this.graphOriginX, -this.graphOriginY);
        graphics2D.setClip(0, 0, this.imgWidth, this.imgHeight);
        graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        if (this.graphDef.isFrontGrid()) {
            this.plotChartGrid(chartGraphics);
        }
    }

    private void plotChartGrid(ChartGraphics chartGraphics) {
        int n;
        Object[] objectArray;
        Graphics2D graphics2D = chartGraphics.getGraphics();
        graphics2D.setFont(this.normal_font);
        int n2 = this.x_offset + this.chart_lpadding;
        int n3 = this.y_offset + 5;
        boolean bl = this.graphDef.showMinorGridX();
        boolean bl2 = this.graphDef.showMinorGridY();
        boolean bl3 = this.graphDef.showMajorGridX();
        boolean bl4 = this.graphDef.showMajorGridY();
        Color color = this.graphDef.getMinorGridColor();
        Color color2 = this.graphDef.getMajorGridColor();
        float[] fArray = new float[]{1.0f, 1.0f};
        BasicStroke basicStroke = new BasicStroke(1.0f, 0, 0, 10.0f, fArray, 0.0f);
        int n4 = n2 + this.chartWidth;
        int n5 = n3 + this.chartHeight;
        graphics2D.setColor(this.graphDef.getAxisColor());
        graphics2D.drawLine(n2 - 4, n5, n4 + 4, n5);
        graphics2D.setColor(this.graphDef.getArrowColor());
        graphics2D.drawLine(n4 + 4, n5 - 3, n4 + 4, n5 + 3);
        graphics2D.drawLine(n4 + 4, n5 - 3, n4 + 9, n5);
        graphics2D.drawLine(n4 + 4, n5 + 3, n4 + 9, n5);
        if (this.graphDef.showGridX()) {
            objectArray = this.tGrid.getTimeMarkers();
            n = this.tGrid.centerLabels();
            long l = this.tGrid.getMajorGridWidth();
            int n6 = 0;
            if (n != 0) {
                n6 = chartGraphics.getX(l) - chartGraphics.getX(0L);
            }
            for (int i = 0; i < objectArray.length; ++i) {
                long l2 = ((TimeMarker)objectArray[i]).getTimestamp();
                int n7 = chartGraphics.getX(l2);
                int n8 = n2 + n7;
                String string = ((TimeMarker)objectArray[i]).getLabel();
                if (n7 < 0) continue;
                if (bl3 && ((TimeMarker)objectArray[i]).isLabel()) {
                    graphics2D.setColor(color2);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.drawLine(n8, n3, n8, n3 + this.chartHeight);
                    graphics2D.setStroke(this.defaultStroke);
                    graphics2D.drawLine(n8, n3 - 2, n8, n3 + 2);
                    graphics2D.drawLine(n8, n3 + this.chartHeight - 2, n8, n3 + this.chartHeight + 2);
                    int n9 = string.length() * this.nfont_width / 2;
                    if (n != 0) {
                        if (n8 + n6 > n2 + this.chartWidth) continue;
                        this.graphString(graphics2D, string, n8 + 2 + n6 / 2 - n9, n3 + this.chartHeight + this.nfont_height + 4);
                        continue;
                    }
                    if (n8 - n2 <= n9 + 2 || n8 + n9 + 2 >= n2 + this.chartWidth) continue;
                    this.graphString(graphics2D, string, n8 - n9, n3 + this.chartHeight + this.nfont_height + 4);
                    continue;
                }
                if (!bl) continue;
                graphics2D.setColor(color);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawLine(n8, n3, n8, n3 + this.chartHeight);
                graphics2D.setStroke(this.defaultStroke);
                graphics2D.drawLine(n8, n3 - 1, n8, n3 + 1);
                graphics2D.drawLine(n8, n3 + this.chartHeight - 1, n8, n3 + this.chartHeight + 1);
            }
        }
        this.valueFormat.setScaling(true, false);
        if (this.graphDef.showGridY()) {
            objectArray = this.vGrid.getValueMarkers();
            for (n = 0; n < objectArray.length; ++n) {
                int n10 = chartGraphics.getY(((ValueMarker)objectArray[n]).getValue());
                this.valueFormat.setFormat(((ValueMarker)objectArray[n]).getValue(), 2, 0);
                String string = (this.valueFormat.getScaledValue() + " " + this.valueFormat.getPrefix()).trim();
                if (bl4 && ((ValueMarker)objectArray[n]).isMajor()) {
                    graphics2D.setColor(color2);
                    graphics2D.setStroke(basicStroke);
                    graphics2D.drawLine(this.graphOriginX, this.graphOriginY - n10, this.graphOriginX + this.chartWidth, this.graphOriginY - n10);
                    graphics2D.setStroke(this.defaultStroke);
                    graphics2D.drawLine(this.graphOriginX - 2, this.graphOriginY - n10, this.graphOriginX + 2, this.graphOriginY - n10);
                    graphics2D.drawLine(this.graphOriginX + this.chartWidth - 2, this.graphOriginY - n10, this.graphOriginX + this.chartWidth + 2, this.graphOriginY - n10);
                    this.graphString(graphics2D, string, this.graphOriginX - string.length() * this.nfont_width - 7, this.graphOriginY - n10 + this.nfont_height / 2 - 1);
                    continue;
                }
                if (!bl2) continue;
                graphics2D.setColor(color);
                graphics2D.setStroke(basicStroke);
                graphics2D.drawLine(this.graphOriginX, this.graphOriginY - n10, this.graphOriginX + this.chartWidth, this.graphOriginY - n10);
                graphics2D.setStroke(this.defaultStroke);
                graphics2D.drawLine(this.graphOriginX - 1, this.graphOriginY - n10, this.graphOriginX + 1, this.graphOriginY - n10);
                graphics2D.drawLine(this.graphOriginX + this.chartWidth - 1, this.graphOriginY - n10, this.graphOriginX + this.chartWidth + 1, this.graphOriginY - n10);
            }
        }
    }

    private void plotComments(Graphics2D graphics2D) throws RrdException {
        if (!this.graphDef.showLegend()) {
            return;
        }
        LinkedList<LegendMarker> linkedList = new LinkedList<LegendMarker>();
        int n = this.y_offset + this.chartHeight + 5 + 25 + (this.graphDef.showMajorGridX() ? this.nfont_height : 0);
        int n2 = 10;
        graphics2D.setColor(this.normalFontColor);
        graphics2D.setFont(this.normal_font);
        Comment[] commentArray = this.graphDef.getComments();
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        boolean bl2 = false;
        for (int i = 0; i < commentArray.length; ++i) {
            if (commentArray[i].commentType == 1) {
                linkedList.addLast(new LegendMarker(stringBuffer.length() * this.nfont_width, ((Legend)commentArray[i]).getColor()));
                stringBuffer.append("   ");
            } else if (commentArray[i].commentType == 2) {
                ((Gprint)commentArray[i]).setValue(this.sources, this.sourceIndex, this.valueFormat);
            }
            ArrayList arrayList = commentArray[i].getTokens();
            for (int j = 0; j < arrayList.size(); ++j) {
                String string = (String)arrayList.get(j++);
                Byte by = (Byte)arrayList.get(j);
                if (commentArray[i].trimString()) {
                    stringBuffer.append(string.trim());
                } else {
                    stringBuffer.append(string);
                }
                if (by != Comment.TKN_NULL) {
                    bl2 = true;
                    if (by == Comment.TKN_ALF) {
                        bl = true;
                        n2 = 10;
                    } else if (by == Comment.TKN_ARF) {
                        bl = true;
                        n2 = this.imgWidth - 13 - stringBuffer.length() * this.nfont_width;
                    } else if (by == Comment.TKN_ACF) {
                        bl = true;
                        n2 = this.imgWidth / 2 - stringBuffer.length() * this.nfont_width / 2;
                    } else if (by == Comment.TKN_AL) {
                        n2 = 10;
                    } else if (by == Comment.TKN_AR) {
                        n2 = this.imgWidth - 13 - stringBuffer.length() * this.nfont_width;
                    } else if (by == Comment.TKN_AC) {
                        n2 = this.imgWidth / 2 - stringBuffer.length() * this.nfont_width / 2;
                    }
                }
                if (!bl && commentArray[i].addSpacer()) {
                    stringBuffer.append(SPACER);
                }
                if (bl2) {
                    this.graphString(graphics2D, stringBuffer.toString(), n2, n);
                    stringBuffer = new StringBuffer("");
                    bl2 = false;
                    while (!linkedList.isEmpty()) {
                        LegendMarker legendMarker = (LegendMarker)linkedList.removeFirst();
                        graphics2D.setColor(legendMarker.getColor());
                        graphics2D.fillRect(n2 + legendMarker.getXPosition(), n - 9, 10, 10);
                        graphics2D.setColor(this.normalFontColor);
                        graphics2D.drawRect(n2 + legendMarker.getXPosition(), n - 9, 10, 10);
                    }
                }
                if (!bl) continue;
                n += this.nfont_height + 4;
                bl = false;
            }
        }
        if (stringBuffer.length() > 0) {
            n2 = 10;
            this.graphString(graphics2D, stringBuffer.toString(), n2, n);
            stringBuffer = new StringBuffer("");
            bl2 = false;
            while (!linkedList.isEmpty()) {
                LegendMarker legendMarker = (LegendMarker)linkedList.removeFirst();
                graphics2D.setColor(legendMarker.getColor());
                graphics2D.fillRect(n2 + legendMarker.getXPosition(), n - 9, 10, 10);
                graphics2D.setColor(this.normalFontColor);
                graphics2D.drawRect(n2 + legendMarker.getXPosition(), n - 9, 10, 10);
            }
        }
    }

    private void plotOverlay(Graphics2D graphics2D) {
        try {
            File file = this.graphDef.getOverlay();
            if (file != null) {
                BufferedImage bufferedImage = ImageIO.read(file);
                int n = bufferedImage.getWidth();
                int n2 = bufferedImage.getHeight();
                int n3 = Color.WHITE.getRGB();
                for (int i = 0; i < n; ++i) {
                    for (int j = 0; j < n2; ++j) {
                        int n4 = bufferedImage.getRGB(i, j);
                        if (n4 == n3) continue;
                        int n5 = n4 >> 16 & 0xFF;
                        int n6 = n4 >> 8 & 0xFF;
                        int n7 = n4 & 0xFF;
                        graphics2D.setColor(new Color(n5, n6, n7));
                        graphics2D.drawLine(i, j, i, j);
                    }
                }
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void plotImageTitle(Graphics2D graphics2D) {
        Title title = this.graphDef.getTitle();
        if (title == null) {
            return;
        }
        int n = this.tfont_height - 1 + 10;
        int n2 = 10;
        graphics2D.setColor(this.graphDef.getTitleFontColor());
        graphics2D.setFont(this.title_font);
        StringBuffer stringBuffer = new StringBuffer("");
        boolean bl = false;
        ArrayList arrayList = title.getTokens();
        for (int i = 0; i < arrayList.size(); ++i) {
            String string = (String)arrayList.get(i++);
            Byte by = (Byte)arrayList.get(i);
            stringBuffer.append(string);
            if (by != Comment.TKN_NULL) {
                if (by == Comment.TKN_ALF) {
                    bl = true;
                    n2 = 10;
                } else if (by == Comment.TKN_ARF) {
                    bl = true;
                    n2 = this.imgWidth - 13 - stringBuffer.length() * this.tfont_width - this.tfont_width;
                } else if (by == Comment.TKN_ACF) {
                    bl = true;
                    n2 = this.imgWidth / 2 - stringBuffer.length() * this.tfont_width / 2;
                } else if (by == Comment.TKN_AL) {
                    n2 = 10;
                } else if (by == Comment.TKN_AR) {
                    n2 = this.imgWidth - 13 - stringBuffer.length() * this.tfont_width - this.tfont_width;
                } else if (by == Comment.TKN_AC) {
                    n2 = this.imgWidth / 2 - stringBuffer.length() * this.tfont_width / 2;
                }
            } else {
                n2 = this.imgWidth / 2 - stringBuffer.length() * this.tfont_width / 2;
            }
            graphics2D.drawString(stringBuffer.toString(), n2, n);
            stringBuffer = new StringBuffer("");
            if (!bl) continue;
            n += this.tfont_height + 4;
            bl = false;
        }
    }

    private void plotVerticalLabel(Graphics2D graphics2D) {
        String string = this.graphDef.getVerticalLabel();
        if (string == null) {
            return;
        }
        graphics2D.setColor(this.normalFontColor);
        int n = string.length() * this.nfont_width;
        graphics2D.setFont(this.normal_font);
        graphics2D.rotate(-1.5707963267948966);
        this.graphString(graphics2D, string, -this.y_offset - 5 - this.chartHeight / 2 - n / 2, 10 + this.nfont_height);
        graphics2D.rotate(1.5707963267948966);
    }

    private void plotSignature(Graphics2D graphics2D) {
        if (!this.graphDef.showSignature()) {
            return;
        }
        String string = "www.jrobin.org";
        graphics2D.setColor(Color.GRAY);
        graphics2D.setFont(new Font("Courier", 0, 10));
        graphics2D.rotate(1.5707963267948966);
        graphics2D.drawString(string, 5, -this.imgWidth + 9);
        graphics2D.rotate(-1.5707963267948966);
    }

    private void graphString(Graphics2D graphics2D, String string, int n, int n2) {
        Color color = graphics2D.getColor();
        graphics2D.setColor(this.normalFontColor);
        graphics2D.drawString(string, n, n2);
        graphics2D.setColor(color);
    }
}

