/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.SocketException;
import java.util.Vector;
import snmp.SNMPBERCodec;
import snmp.SNMPBadValueException;
import snmp.SNMPMessage;
import snmp.SNMPTrapListener;
import snmp.SNMPTrapPDU;

public class SNMPv1TrapListenerInterface
implements Runnable {
    public static final int SNMP_TRAP_PORT = 162;
    public static final int MAXSIZE = 512;
    private DatagramSocket dSocket = new DatagramSocket(162);
    private Thread receiveThread;
    private Vector listenerVector = new Vector();

    public SNMPv1TrapListenerInterface() throws SocketException {
        this.receiveThread = new Thread(this);
    }

    public void addTrapListener(SNMPTrapListener sNMPTrapListener) {
        for (int i = 0; i < this.listenerVector.size(); ++i) {
            if (sNMPTrapListener != this.listenerVector.elementAt(i)) continue;
            return;
        }
        this.listenerVector.add(sNMPTrapListener);
    }

    public void removeTrapListener(SNMPTrapListener sNMPTrapListener) {
        for (int i = 0; i < this.listenerVector.size(); ++i) {
            if (sNMPTrapListener != this.listenerVector.elementAt(i)) continue;
            this.listenerVector.removeElementAt(i);
            break;
        }
    }

    public void startReceiving() {
        if (!this.receiveThread.isAlive()) {
            this.receiveThread = new Thread(this);
            this.receiveThread.start();
        }
    }

    public void stopReceiving() throws SocketException {
        this.receiveThread.interrupt();
    }

    public void run() {
        boolean bl = false;
        boolean bl2 = false;
        try {
            while (!this.receiveThread.isInterrupted()) {
                DatagramPacket datagramPacket = new DatagramPacket(new byte[512], 512);
                this.dSocket.receive(datagramPacket);
                byte[] byArray = datagramPacket.getData();
                SNMPMessage sNMPMessage = new SNMPMessage(SNMPBERCodec.extractNextTLV((byte[])byArray, (int)0).value);
                SNMPTrapPDU sNMPTrapPDU = sNMPMessage.getTrapPDU();
                for (int i = 0; i < this.listenerVector.size(); ++i) {
                    SNMPTrapListener sNMPTrapListener = (SNMPTrapListener)this.listenerVector.elementAt(i);
                    sNMPTrapListener.processTrap(sNMPTrapPDU);
                }
            }
        }
        catch (IOException iOException) {
        }
        catch (SNMPBadValueException sNMPBadValueException) {
            // empty catch block
        }
    }

    private String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = string + Integer.toHexString(n2 / 16);
        string = string + Integer.toHexString(n2 % 16);
        return string;
    }

    private String getHex(byte n) {
        String string;
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        if ((string = new String(Integer.toHexString(n2))).length() % 2 == 1) {
            string = "0" + string;
        }
        return string;
    }
}

