/*
 * Decompiled with CFR 0.152.
 */
package snmp;

import snmp.SNMPBERCodec;
import snmp.SNMPCounter32;
import snmp.SNMPCounter64;
import snmp.SNMPGauge32;
import snmp.SNMPIPAddress;
import snmp.SNMPInteger;
import snmp.SNMPMessage;
import snmp.SNMPNSAPAddress;
import snmp.SNMPObject;
import snmp.SNMPObjectIdentifier;
import snmp.SNMPOctetString;
import snmp.SNMPPDU;
import snmp.SNMPSequence;
import snmp.SNMPTimeTicks;
import snmp.SNMPUInteger32;

public class TestSNMP {
    public static void main(String[] stringArray) {
        try {
            SNMPObject sNMPObject = new SNMPCounter32(127L);
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPCounter64(16384L);
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPGauge32(-1073741824L);
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPInteger(128L);
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPIPAddress("128.20.255.13");
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPNSAPAddress("12.34.56.78.90.AB");
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPObjectIdentifier("1.3.2.4.8.16.32.64.128.256.512.1024");
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPOctetString("Howdy doody!");
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPTimeTicks(12345L);
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            sNMPObject = new SNMPUInteger32(12345L);
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            SNMPSequence sNMPSequence = new SNMPSequence();
            sNMPSequence.addSNMPObject(new SNMPCounter32(127L));
            sNMPSequence.addSNMPObject(new SNMPOctetString("abc"));
            sNMPSequence.addSNMPObject(new SNMPNSAPAddress("12.34.56.78.90.AB"));
            sNMPObject = sNMPSequence;
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            SNMPPDU sNMPPDU = new SNMPPDU(-96, 64, 0, 0, sNMPSequence);
            sNMPObject = sNMPPDU;
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
            SNMPMessage sNMPMessage = new SNMPMessage(0, "community", sNMPPDU);
            sNMPObject = sNMPMessage;
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            sNMPObject = SNMPBERCodec.extractEncoding(SNMPBERCodec.extractNextTLV(sNMPObject.getBEREncoding(), 0));
            System.out.println("Object: " + sNMPObject.getClass().toString() + ", value " + sNMPObject.toString());
            TestSNMP.printBEREncoding(sNMPObject);
        }
        catch (Exception exception) {
            System.out.println("Exception during SNMP operation:  " + exception + "\n");
        }
    }

    private static void printBEREncoding(SNMPObject sNMPObject) {
        byte[] byArray = sNMPObject.getBEREncoding();
        System.out.println("BER encoding:");
        for (int i = 0; i < byArray.length; ++i) {
            System.out.print(TestSNMP.hexByte(byArray[i]) + " ");
        }
        System.out.println("\n");
    }

    private static String hexByte(byte n) {
        int n2 = n;
        if (n2 < 0) {
            n2 += 256;
        }
        String string = new String();
        string = string + Integer.toHexString(n2 / 16);
        string = string + Integer.toHexString(n2 % 16);
        return string;
    }
}

