# v1.6 to 1.7

## AppProject tokens moved to status field

In order to address [argoproj/argo-cd#2718](https://github.com/argoproj/argo-cd/issues/2718) the JWT tokens stored in
AppProject CRD have been moved from `spec` to `status` field. The migration is performed automatically during upgrade
and might cause few seconds delay. No additional side effects besides the delay are expected. It is acceptable to
rollback to previous version - no data loss is expected.

## Resources like ConfigMap might become out-of-sync due to YAML library upgrade

As part of v1.7 release, the Kubernetes client library have been upgrade to v1.18.8 as well as we've started using
https://github.com/kubernetes-sigs/yaml for YAML handling to be consistent with `kubectl` behavior.
This introduced a change of multiline string handling in resource manifests. As a result, YAML manifests with multiline
strings might become out-of-sync after upgrading and you might have to trigger the synchronization once to resolve it.

Affected resource example:

```yaml
---
apiVersion: v1
kind: ConfigMap
metadata:
  name: my-config-map
data:
  value: |+ # block chomping indicator is dropped by Argo CD v1.7 ( same as kubectl apply)
  hello
```

## New RBAC rules for GnuPG related features

The [GnuPG feature](../../../user-guide/gpg-verification) has introduced a new
RBAC resource in Argo CD, `gpgkeys`.

Please adapt your RBAC rules with the appropriate permissions. The least set of
permissions every role should have is:

```
p, <your-role>, gpgkeys, get, *, allow
```

More information can be found in the
[documentation](../../../user-guide/gpg-verification#rbac-rules-for-managing-gnupg-keys)

From here on you can follow the [regular upgrade process](./overview.md).
