# v3.0 to 3.1

## No more KubeVersions variable modification

Until v3.0, Argo CD removed `+` identifier from `kubeVersions` in Helm, Kustomize and Plugins. For example, if Argo CD receive `kubeVersions` as vX.Y.Z+, we convert to vX.Y.Z internally. Starting with v3.1, the internal conversation is entirely removed.

### Detection

To detect if you are affected, check the `kubeVersions` you are using. If you use `kubeVersions` including `+` identifier, the application must be failed when you upgrade from v3.0 to v3.1.

### Remediation

The plus symbol was originally removed [because Helm did not support it](https://github.com/argoproj/argo-cd/issues/2303). Helm no longer enforces this restriction, so apps should work fine even if your kubeVersions include `+`.

However, since Argo CD now sends unmodified kubeVersions to Helm, the generated manifests may differ due to the changed kubeVersions. For apps which require extra caution, it may be advisable to disable auto-sync, upgrade, check any diffs, and then reenable auto-sync.

## Symlink protection in API `--staticassets` directory

The `--staticassets` directory in the API server (`/app/shared` by default) is now protected against out-of-bounds
symlinks. This is to help protect against symlink attacks. If you have any symlinks in your `--staticassets` directory
to a location outside the directory, they will return a 500 error starting with 3.1.

## v1 Actions API Deprecated

The `/api/v1/applications/{name}/resource/actions` endpoint is deprecated in favor of `/api/v1/applications/{name}/resource/actions/v2`.

This endpoint allows API users to run a custom resource action on a specific resource in an application.

The old endpoint accepted various parameters as query parameters. The POST body was the action name.

The new endpoint accepts all parameters as part of the POST body as a JSON object. The new endpoint also supports a new
`resourceActionParameters` field to parameterize action runs.

The old endpoint will be removed in a future release, so users should migrate to the new endpoint as soon as possible.
API clients will just need to change the endpoint URL and switch query string parameters to a JSON body.

If the old endpoint is used, the API will log a warning message:

> RunResourceAction was called. RunResourceAction is deprecated and will be removed in a future release. Use RunResourceActionV2 instead.

The CLI will fall back to the old endpoint if the new one is not available. If it falls back, it will log a warning message:

> RunResourceActionV2 is not supported by the server, falling back to RunResourceAction.

## OpenID Connect authorization code flow with PKCE is now handled by the server instead of the UI

Previously, when PKCE was enabled, the authorization code flow (the process which happens when you log in to Argo CD using OpenID Connect) was handled by the UI, whereas this flow was handled by the server if PKCE was not enabled. The server now always handles this flow, PKCE being enabled or not.

### Detection

To check whether PKCE is used or not, run the following command:

```shell
kubectl get cm argocd-cm -o=jsonpath="{.data.oidc\.config}" | grep enablePKCEAuthentication
```

If it returns `"enablePKCEAuthentication": true`, then PKCE is used.

### Remediation

On your identity provider, ensure that the OIDC client used for Argo CD has the `/auth/callback` endpoint of your Argo CD URL (e.g. https://argocd.example.com/auth/callback) in the redirect URIs.

## Helm Upgraded to 3.18.4

Argo CD v3.1 upgrades the bundled Helm version to 3.18.4. There are no breaking changes in Helm 3.18 according to the
[release notes](https://github.com/helm/helm/releases/tag/v3.18.0).

## Kustomize Upgraded to 5.7.0

Argo CD v3.1 upgrades the bundled Kustomize version to 5.7.0. There are no breaking changes in Kustomize 5.7 according
to the [release notes](https://github.com/kubernetes-sigs/kustomize/releases/tag/kustomize%2Fv5.7.0).
