# v3.1 to 3.2

## Breaking Changes

### Hydration paths must now be non-root

Source hydration now requires that every application specify a non-root path.
Using the repository root (for example, "" or ".") is no longer supported. This change ensures
that hydration outputs are isolated to a dedicated subdirectory and prevents accidental overwrites
or deletions of important files stored at the root, such as CI pipelines, documentation, or configuration files.

Previously, it was possible for hydration to write manifests directly into the repository root. While convenient, this had two major drawbacks:

1. Hydration would wipe and replace files at the root on every run, which risked deleting important files such as CI/CD workflows, project-level READMEs, or other configuration.
2. It made it harder to clearly separate hydrated application outputs from unrelated repository content.

To identify affected applications, review your Application manifests and look for `.spec.sourceHydrator.syncSource.path` values that are empty, missing,
`"."`, or otherwise point to the repository root. These applications must be updated to use a subdirectory path, such as `apps/guestbook`.

After migration, check your repository root for any stale hydration output from earlier versions.
Common leftovers include files such as `manifest.yaml` or `README.md`. These will not be cleaned up
automatically and should be deleted manually if no longer needed.

## Argo CD Now Respects Kustomize Version in `.argocd-source.yaml`

Argo CD provides a way to [override Application `spec.source` values](../../user-guide/parameters.md#store-overrides-in-git)
using the `.argocd-source.yaml` file.

Before Argo CD v3.2, you could set the Kustomize version in the Application's `.spec.source.kustomize.version` field,
but you could not set it in the `.argocd-source.yaml` file.

Starting with Argo CD v3.2, you can now set the Kustomize version in the `.argocd-source.yaml` file like this:

```yaml
kustomize:
  version: v4.5.7
```

## Deprecated fields in the repo-server GRPC service

The repo-server's GRPC service is generally considered an internal API and is not recommended for use by external
clients. No user-facing services or functionality have changed. However, if you are using the repo-server's GRPC service
directly, please note field deprecations in the following messages.

The `kustomizeOptions.binaryPath` field in the `ManifestRequest` and `RepoServerAppDetailsQuery` messages has been
deprecated. Instead of calculating the correct binary path client-side, the client is expected to populate the
`kustomizeOptions.versions` field with the [configured Kustomize binary paths](../../user-guide/kustomize.md#custom-kustomize-versions).
This allows the repo-server to select the correct binary path based on the Kustomize version configured in the
Application's source field as well as any [overrides configured via git](../../user-guide/parameters.md#store-overrides-in-git).

The `kustomizeOptions.binaryPath` will continue to be respected when `kustomizeOptions.versions` is not set, but this is
not recommended. It will prevent overrides configured via git from being respected. The `kustomizeOptions.binaryPath`
field will be removed in a future release.

If the repo-server encounters a request with the `kustomizeOptions.binaryPath` field set, it will log a warning message:

> kustomizeOptions.binaryPath is deprecated, use KustomizeOptions.versions instead

The `ManifestRequest` and `RepoServerAppDetailsQuery` messages are used by the following GRPC services:
`GenerateManifest`, `GenerateManifestWithFiles`, and `GetAppDetails`.

## CronJob Health

After the upgrade, Application's status may transition to `Degraded` depending on the CronJob health.

!!! note "CronJob with running jobs"

    If the CronJob is `Degraded` and a new job is scheduled, the health will change to `Healthy` until the active job completes.
    This may cause your application to go from `Degraded` to `Healthy` to `Degraded` again. The CronJob status does not contain enough
    information to infer the health of the last completed job if there are active jobs.

    If the CronJob constantly has active jobs, the health will be constantly `Healthy` even if the last job failed.

!!! note "CronJob with suspended state"

    If the CronJob is in a suspended state, the CronJob status will remain Healthy. You can override this behaviour by configuring the
    health check using the `resource.customizations.health.batch_CronJob` key in the argocd-cm ConfigMap.

    If you decide to do so and the CronJob is `Suspended`, then the aggregated health of the Application will now be `Suspended` instead of `Healthy`.

If you do not want your CronJob to affect the Application's aggregated Health, you can configure the annotation
`argocd.argoproj.io/ignore-healthcheck: "true"` on the CronJob resource.

## Sanitized project API response

Due to security reasons ([GHSA-786q-9hcg-v9ff](https://github.com/argoproj/argo-cd/security/advisories/GHSA-786q-9hcg-v9ff)),
the project API response was sanitized to remove sensitive information. This includes
credentials of project-scoped repositories and clusters.
