// Code generated by go-swagger; DO NOT EDIT.

// Copyright Authors of Cilium
// SPDX-License-Identifier: Apache-2.0

package policy

// This file was generated by the swagger tool.
// Editing this file might prove futile when you re-run the swagger generate command

import (
	"context"
	"net/http"
	"time"

	"github.com/go-openapi/errors"
	"github.com/go-openapi/runtime"
	cr "github.com/go-openapi/runtime/client"
	"github.com/go-openapi/strfmt"
)

// NewGetIPParams creates a new GetIPParams object,
// with the default timeout for this client.
//
// Default values are not hydrated, since defaults are normally applied by the API server side.
//
// To enforce default values in parameter, use SetDefaults or WithDefaults.
func NewGetIPParams() *GetIPParams {
	return &GetIPParams{
		timeout: cr.DefaultTimeout,
	}
}

// NewGetIPParamsWithTimeout creates a new GetIPParams object
// with the ability to set a timeout on a request.
func NewGetIPParamsWithTimeout(timeout time.Duration) *GetIPParams {
	return &GetIPParams{
		timeout: timeout,
	}
}

// NewGetIPParamsWithContext creates a new GetIPParams object
// with the ability to set a context for a request.
func NewGetIPParamsWithContext(ctx context.Context) *GetIPParams {
	return &GetIPParams{
		Context: ctx,
	}
}

// NewGetIPParamsWithHTTPClient creates a new GetIPParams object
// with the ability to set a custom HTTPClient for a request.
func NewGetIPParamsWithHTTPClient(client *http.Client) *GetIPParams {
	return &GetIPParams{
		HTTPClient: client,
	}
}

/*
GetIPParams contains all the parameters to send to the API endpoint

	for the get IP operation.

	Typically these are written to a http.Request.
*/
type GetIPParams struct {

	/* Cidr.

	   A CIDR range of IPs
	*/
	Cidr *string

	timeout    time.Duration
	Context    context.Context
	HTTPClient *http.Client
}

// WithDefaults hydrates default values in the get IP params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIPParams) WithDefaults() *GetIPParams {
	o.SetDefaults()
	return o
}

// SetDefaults hydrates default values in the get IP params (not the query body).
//
// All values with no default are reset to their zero value.
func (o *GetIPParams) SetDefaults() {
	// no default values defined for this parameter
}

// WithTimeout adds the timeout to the get IP params
func (o *GetIPParams) WithTimeout(timeout time.Duration) *GetIPParams {
	o.SetTimeout(timeout)
	return o
}

// SetTimeout adds the timeout to the get IP params
func (o *GetIPParams) SetTimeout(timeout time.Duration) {
	o.timeout = timeout
}

// WithContext adds the context to the get IP params
func (o *GetIPParams) WithContext(ctx context.Context) *GetIPParams {
	o.SetContext(ctx)
	return o
}

// SetContext adds the context to the get IP params
func (o *GetIPParams) SetContext(ctx context.Context) {
	o.Context = ctx
}

// WithHTTPClient adds the HTTPClient to the get IP params
func (o *GetIPParams) WithHTTPClient(client *http.Client) *GetIPParams {
	o.SetHTTPClient(client)
	return o
}

// SetHTTPClient adds the HTTPClient to the get IP params
func (o *GetIPParams) SetHTTPClient(client *http.Client) {
	o.HTTPClient = client
}

// WithCidr adds the cidr to the get IP params
func (o *GetIPParams) WithCidr(cidr *string) *GetIPParams {
	o.SetCidr(cidr)
	return o
}

// SetCidr adds the cidr to the get IP params
func (o *GetIPParams) SetCidr(cidr *string) {
	o.Cidr = cidr
}

// WriteToRequest writes these params to a swagger request
func (o *GetIPParams) WriteToRequest(r runtime.ClientRequest, reg strfmt.Registry) error {

	if err := r.SetTimeout(o.timeout); err != nil {
		return err
	}
	var res []error

	if o.Cidr != nil {

		// query param cidr
		var qrCidr string

		if o.Cidr != nil {
			qrCidr = *o.Cidr
		}
		qCidr := qrCidr
		if qCidr != "" {

			if err := r.SetQueryParam("cidr", qCidr); err != nil {
				return err
			}
		}
	}

	if len(res) > 0 {
		return errors.CompositeValidationError(res...)
	}
	return nil
}
