// Code generated by protoc-gen-validate. DO NOT EDIT.
// source: cilium/api/nphds.proto

package cilium

import (
	"bytes"
	"errors"
	"fmt"
	"net"
	"net/mail"
	"net/url"
	"regexp"
	"sort"
	"strings"
	"time"
	"unicode/utf8"

	"google.golang.org/protobuf/types/known/anypb"
)

// ensure the imports are used
var (
	_ = bytes.MinRead
	_ = errors.New("")
	_ = fmt.Print
	_ = utf8.UTFMax
	_ = (*regexp.Regexp)(nil)
	_ = (*strings.Reader)(nil)
	_ = net.IPv4len
	_ = time.Duration(0)
	_ = (*url.URL)(nil)
	_ = (*mail.Address)(nil)
	_ = anypb.Any{}
	_ = sort.Sort
)

// Validate checks the field values on NetworkPolicyHosts with the rules
// defined in the proto definition for this message. If any rules are
// violated, the first error encountered is returned, or nil if there are no violations.
func (m *NetworkPolicyHosts) Validate() error {
	return m.validate(false)
}

// ValidateAll checks the field values on NetworkPolicyHosts with the rules
// defined in the proto definition for this message. If any rules are
// violated, the result is a list of violation errors wrapped in
// NetworkPolicyHostsMultiError, or nil if none found.
func (m *NetworkPolicyHosts) ValidateAll() error {
	return m.validate(true)
}

func (m *NetworkPolicyHosts) validate(all bool) error {
	if m == nil {
		return nil
	}

	var errors []error

	// no validation rules for Policy

	_NetworkPolicyHosts_HostAddresses_Unique := make(map[string]struct{}, len(m.GetHostAddresses()))

	for idx, item := range m.GetHostAddresses() {
		_, _ = idx, item

		if _, exists := _NetworkPolicyHosts_HostAddresses_Unique[item]; exists {
			err := NetworkPolicyHostsValidationError{
				field:  fmt.Sprintf("HostAddresses[%v]", idx),
				reason: "repeated value must contain unique items",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		} else {
			_NetworkPolicyHosts_HostAddresses_Unique[item] = struct{}{}
		}

		if utf8.RuneCountInString(item) < 1 {
			err := NetworkPolicyHostsValidationError{
				field:  fmt.Sprintf("HostAddresses[%v]", idx),
				reason: "value length must be at least 1 runes",
			}
			if !all {
				return err
			}
			errors = append(errors, err)
		}

	}

	if len(errors) > 0 {
		return NetworkPolicyHostsMultiError(errors)
	}

	return nil
}

// NetworkPolicyHostsMultiError is an error wrapping multiple validation errors
// returned by NetworkPolicyHosts.ValidateAll() if the designated constraints
// aren't met.
type NetworkPolicyHostsMultiError []error

// Error returns a concatenation of all the error messages it wraps.
func (m NetworkPolicyHostsMultiError) Error() string {
	var msgs []string
	for _, err := range m {
		msgs = append(msgs, err.Error())
	}
	return strings.Join(msgs, "; ")
}

// AllErrors returns a list of validation violation errors.
func (m NetworkPolicyHostsMultiError) AllErrors() []error { return m }

// NetworkPolicyHostsValidationError is the validation error returned by
// NetworkPolicyHosts.Validate if the designated constraints aren't met.
type NetworkPolicyHostsValidationError struct {
	field  string
	reason string
	cause  error
	key    bool
}

// Field function returns field value.
func (e NetworkPolicyHostsValidationError) Field() string { return e.field }

// Reason function returns reason value.
func (e NetworkPolicyHostsValidationError) Reason() string { return e.reason }

// Cause function returns cause value.
func (e NetworkPolicyHostsValidationError) Cause() error { return e.cause }

// Key function returns key value.
func (e NetworkPolicyHostsValidationError) Key() bool { return e.key }

// ErrorName returns error name.
func (e NetworkPolicyHostsValidationError) ErrorName() string {
	return "NetworkPolicyHostsValidationError"
}

// Error satisfies the builtin error interface
func (e NetworkPolicyHostsValidationError) Error() string {
	cause := ""
	if e.cause != nil {
		cause = fmt.Sprintf(" | caused by: %v", e.cause)
	}

	key := ""
	if e.key {
		key = "key for "
	}

	return fmt.Sprintf(
		"invalid %sNetworkPolicyHosts.%s: %s%s",
		key,
		e.field,
		e.reason,
		cause)
}

var _ error = NetworkPolicyHostsValidationError{}

var _ interface {
	Field() string
	Reason() string
	Key() bool
	Cause() error
	ErrorName() string
} = NetworkPolicyHostsValidationError{}
