// SPDX-License-Identifier: Apache-2.0
// Copyright Authors of Cilium

// Code generated by client-gen. DO NOT EDIT.

package v2

import (
	"context"

	v2 "github.com/cilium/cilium/pkg/k8s/apis/cilium.io/v2"
	scheme "github.com/cilium/cilium/pkg/k8s/client/clientset/versioned/scheme"
	v1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// CiliumExternalWorkloadsGetter has a method to return a CiliumExternalWorkloadInterface.
// A group's client should implement this interface.
type CiliumExternalWorkloadsGetter interface {
	CiliumExternalWorkloads() CiliumExternalWorkloadInterface
}

// CiliumExternalWorkloadInterface has methods to work with CiliumExternalWorkload resources.
type CiliumExternalWorkloadInterface interface {
	Create(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.CreateOptions) (*v2.CiliumExternalWorkload, error)
	Update(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.UpdateOptions) (*v2.CiliumExternalWorkload, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, ciliumExternalWorkload *v2.CiliumExternalWorkload, opts v1.UpdateOptions) (*v2.CiliumExternalWorkload, error)
	Delete(ctx context.Context, name string, opts v1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts v1.DeleteOptions, listOpts v1.ListOptions) error
	Get(ctx context.Context, name string, opts v1.GetOptions) (*v2.CiliumExternalWorkload, error)
	List(ctx context.Context, opts v1.ListOptions) (*v2.CiliumExternalWorkloadList, error)
	Watch(ctx context.Context, opts v1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts v1.PatchOptions, subresources ...string) (result *v2.CiliumExternalWorkload, err error)
	CiliumExternalWorkloadExpansion
}

// ciliumExternalWorkloads implements CiliumExternalWorkloadInterface
type ciliumExternalWorkloads struct {
	*gentype.ClientWithList[*v2.CiliumExternalWorkload, *v2.CiliumExternalWorkloadList]
}

// newCiliumExternalWorkloads returns a CiliumExternalWorkloads
func newCiliumExternalWorkloads(c *CiliumV2Client) *ciliumExternalWorkloads {
	return &ciliumExternalWorkloads{
		gentype.NewClientWithList[*v2.CiliumExternalWorkload, *v2.CiliumExternalWorkloadList](
			"ciliumexternalworkloads",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v2.CiliumExternalWorkload { return &v2.CiliumExternalWorkload{} },
			func() *v2.CiliumExternalWorkloadList { return &v2.CiliumExternalWorkloadList{} }),
	}
}
