#!/bin/bash

#   Copyright The containerd Authors.

#   Licensed under the Apache License, Version 2.0 (the "License");
#   you may not use this file except in compliance with the License.
#   You may obtain a copy of the License at

#       http://www.apache.org/licenses/LICENSE-2.0

#   Unless required by applicable law or agreed to in writing, software
#   distributed under the License is distributed on an "AS IS" BASIS,
#   WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#   See the License for the specific language governing permissions and
#   limitations under the License.

echo "Verifying that ./pkg/... is decoupled from the CLI packages"
set -eux -o pipefail

if go list -f '{{join .Deps "\n"}}' ./pkg/... | grep -E '^(github.com/spf13/cobra|github.com/spf13/pflag|github.com/containerd/nerdctl/cmd)'; then
	echo >&2 "ERROR: ./pkg/... is not decoupled from the CLI packages"
	exit 1
fi

echo "OK"
