// Code generated by protoc-gen-go. DO NOT EDIT.
// source: oc.proto

/*
Package telemetry is a generated protocol buffer package.

It is generated from these files:
	oc.proto

It has these top-level messages:
	SubscriptionRequest
	SubscriptionInput
	Collector
	Path
	SubscriptionAdditionalConfig
	SubscriptionReply
	SubscriptionResponse
	OpenConfigData
	KeyValue
	Delete
	Eom
	CancelSubscriptionRequest
	CancelSubscriptionReply
	GetSubscriptionsRequest
	GetSubscriptionsReply
	GetOperationalStateRequest
	GetOperationalStateReply
	DataEncodingRequest
	DataEncodingReply
*/
package telemetry

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

import (
	context "golang.org/x/net/context"
	grpc "google.golang.org/grpc"
)

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// Result of the operation
type ReturnCode int32

const (
	ReturnCode_SUCCESS               ReturnCode = 0
	ReturnCode_NO_SUBSCRIPTION_ENTRY ReturnCode = 1
	ReturnCode_UNKNOWN_ERROR         ReturnCode = 2
)

var ReturnCode_name = map[int32]string{
	0: "SUCCESS",
	1: "NO_SUBSCRIPTION_ENTRY",
	2: "UNKNOWN_ERROR",
}
var ReturnCode_value = map[string]int32{
	"SUCCESS":               0,
	"NO_SUBSCRIPTION_ENTRY": 1,
	"UNKNOWN_ERROR":         2,
}

func (x ReturnCode) String() string {
	return proto.EnumName(ReturnCode_name, int32(x))
}
func (ReturnCode) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Verbosity Level
type VerbosityLevel int32

const (
	VerbosityLevel_DETAIL VerbosityLevel = 0
	VerbosityLevel_TERSE  VerbosityLevel = 1
	VerbosityLevel_BRIEF  VerbosityLevel = 2
)

var VerbosityLevel_name = map[int32]string{
	0: "DETAIL",
	1: "TERSE",
	2: "BRIEF",
}
var VerbosityLevel_value = map[string]int32{
	"DETAIL": 0,
	"TERSE":  1,
	"BRIEF":  2,
}

func (x VerbosityLevel) String() string {
	return proto.EnumName(VerbosityLevel_name, int32(x))
}
func (VerbosityLevel) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// Encoding Type Supported
type EncodingType int32

const (
	EncodingType_UNDEFINED EncodingType = 0
	EncodingType_XML       EncodingType = 1
	EncodingType_JSON_IETF EncodingType = 2
	EncodingType_PROTO3    EncodingType = 3
)

var EncodingType_name = map[int32]string{
	0: "UNDEFINED",
	1: "XML",
	2: "JSON_IETF",
	3: "PROTO3",
}
var EncodingType_value = map[string]int32{
	"UNDEFINED": 0,
	"XML":       1,
	"JSON_IETF": 2,
	"PROTO3":    3,
}

func (x EncodingType) String() string {
	return proto.EnumName(EncodingType_name, int32(x))
}
func (EncodingType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// Message sent for a telemetry subscription request
type SubscriptionRequest struct {
	// Data associated with a telemetry subscription
	Input *SubscriptionInput `protobuf:"bytes,1,opt,name=input" json:"input,omitempty"`
	// List of data models paths and filters
	// which are used in a telemetry operation.
	PathList []*Path `protobuf:"bytes,2,rep,name=path_list,json=pathList" json:"path_list,omitempty"`
	// The below configuration is not defined in Openconfig RPC.
	// It is a proposed extension to configure additional
	// subscription request features.
	AdditionalConfig *SubscriptionAdditionalConfig `protobuf:"bytes,3,opt,name=additional_config,json=additionalConfig" json:"additional_config,omitempty"`
}

func (m *SubscriptionRequest) Reset()                    { *m = SubscriptionRequest{} }
func (m *SubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionRequest) ProtoMessage()               {}
func (*SubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

func (m *SubscriptionRequest) GetInput() *SubscriptionInput {
	if m != nil {
		return m.Input
	}
	return nil
}

func (m *SubscriptionRequest) GetPathList() []*Path {
	if m != nil {
		return m.PathList
	}
	return nil
}

func (m *SubscriptionRequest) GetAdditionalConfig() *SubscriptionAdditionalConfig {
	if m != nil {
		return m.AdditionalConfig
	}
	return nil
}

// Data associated with a telemetry subscription
type SubscriptionInput struct {
	// List of optional collector endpoints to send data for
	// this subscription.
	// If no collector destinations are specified, the collector
	// destination is assumed to be the requester on the rpc channel.
	CollectorList []*Collector `protobuf:"bytes,1,rep,name=collector_list,json=collectorList" json:"collector_list,omitempty"`
}

func (m *SubscriptionInput) Reset()                    { *m = SubscriptionInput{} }
func (m *SubscriptionInput) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionInput) ProtoMessage()               {}
func (*SubscriptionInput) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *SubscriptionInput) GetCollectorList() []*Collector {
	if m != nil {
		return m.CollectorList
	}
	return nil
}

// Collector endpoints to send data specified as an ip+port combination.
type Collector struct {
	// IP address of collector endpoint
	Address string `protobuf:"bytes,1,opt,name=address" json:"address,omitempty"`
	// Transport protocol port number for the collector destination.
	Port uint32 `protobuf:"varint,2,opt,name=port" json:"port,omitempty"`
}

func (m *Collector) Reset()                    { *m = Collector{} }
func (m *Collector) String() string            { return proto.CompactTextString(m) }
func (*Collector) ProtoMessage()               {}
func (*Collector) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *Collector) GetAddress() string {
	if m != nil {
		return m.Address
	}
	return ""
}

func (m *Collector) GetPort() uint32 {
	if m != nil {
		return m.Port
	}
	return 0
}

// Data model path
type Path struct {
	// Data model path of interest
	// Path specification for elements of OpenConfig data models
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
	// Regular expression to be used in filtering state leaves
	Filter string `protobuf:"bytes,2,opt,name=filter" json:"filter,omitempty"`
	// If this is set to true, the target device will only send
	// updates to the collector upon a change in data value
	SuppressUnchanged bool `protobuf:"varint,3,opt,name=suppress_unchanged,json=suppressUnchanged" json:"suppress_unchanged,omitempty"`
	// Maximum time in ms the target device may go without sending
	// a message to the collector. If this time expires with
	// suppress-unchanged set, the target device must send an update
	// message regardless if the data values have changed.
	MaxSilentInterval uint32 `protobuf:"varint,4,opt,name=max_silent_interval,json=maxSilentInterval" json:"max_silent_interval,omitempty"`
	// Time in ms between collection and transmission of the
	// specified data to the collector platform. The target device
	// will sample the corresponding data (e.g,. a counter) and
	// immediately send to the collector destination.
	//
	// If sample-frequency is set to 0, then the network device
	// must emit an update upon every datum change.
	SampleFrequency uint32 `protobuf:"varint,5,opt,name=sample_frequency,json=sampleFrequency" json:"sample_frequency,omitempty"`
	// EOM needed for each walk cycle of this path?
	//   For periodic sensor, applicable for each complete reap
	//   For event sensor, applicable when initial dump is over
	//     (same as EOS)
	// This feature is not implemented currently.
	NeedEom bool `protobuf:"varint,6,opt,name=need_eom,json=needEom" json:"need_eom,omitempty"`
}

func (m *Path) Reset()                    { *m = Path{} }
func (m *Path) String() string            { return proto.CompactTextString(m) }
func (*Path) ProtoMessage()               {}
func (*Path) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

func (m *Path) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *Path) GetFilter() string {
	if m != nil {
		return m.Filter
	}
	return ""
}

func (m *Path) GetSuppressUnchanged() bool {
	if m != nil {
		return m.SuppressUnchanged
	}
	return false
}

func (m *Path) GetMaxSilentInterval() uint32 {
	if m != nil {
		return m.MaxSilentInterval
	}
	return 0
}

func (m *Path) GetSampleFrequency() uint32 {
	if m != nil {
		return m.SampleFrequency
	}
	return 0
}

func (m *Path) GetNeedEom() bool {
	if m != nil {
		return m.NeedEom
	}
	return false
}

// Configure subscription request additional features.
type SubscriptionAdditionalConfig struct {
	// limit the number of records sent in the stream
	LimitRecords int32 `protobuf:"varint,1,opt,name=limit_records,json=limitRecords" json:"limit_records,omitempty"`
	// limit the time the stream remains open
	LimitTimeSeconds int32 `protobuf:"varint,2,opt,name=limit_time_seconds,json=limitTimeSeconds" json:"limit_time_seconds,omitempty"`
	// EOS needed for this subscription?
	NeedEos bool `protobuf:"varint,3,opt,name=need_eos,json=needEos" json:"need_eos,omitempty"`
}

func (m *SubscriptionAdditionalConfig) Reset()                    { *m = SubscriptionAdditionalConfig{} }
func (m *SubscriptionAdditionalConfig) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionAdditionalConfig) ProtoMessage()               {}
func (*SubscriptionAdditionalConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *SubscriptionAdditionalConfig) GetLimitRecords() int32 {
	if m != nil {
		return m.LimitRecords
	}
	return 0
}

func (m *SubscriptionAdditionalConfig) GetLimitTimeSeconds() int32 {
	if m != nil {
		return m.LimitTimeSeconds
	}
	return 0
}

func (m *SubscriptionAdditionalConfig) GetNeedEos() bool {
	if m != nil {
		return m.NeedEos
	}
	return false
}

// 1. Reply data message sent out using out-of-band channel.
type SubscriptionReply struct {
	// Response message to a telemetry subscription creation or
	// get request.
	Response *SubscriptionResponse `protobuf:"bytes,1,opt,name=response" json:"response,omitempty"`
	// List of data models paths and filters
	// which are used in a telemetry operation.
	PathList []*Path `protobuf:"bytes,2,rep,name=path_list,json=pathList" json:"path_list,omitempty"`
}

func (m *SubscriptionReply) Reset()                    { *m = SubscriptionReply{} }
func (m *SubscriptionReply) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionReply) ProtoMessage()               {}
func (*SubscriptionReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

func (m *SubscriptionReply) GetResponse() *SubscriptionResponse {
	if m != nil {
		return m.Response
	}
	return nil
}

func (m *SubscriptionReply) GetPathList() []*Path {
	if m != nil {
		return m.PathList
	}
	return nil
}

// Response message to a telemetry subscription creation or get request.
type SubscriptionResponse struct {
	// Unique id for the subscription on the device. This is
	// generated by the device and returned in a subscription
	// request or when listing existing subscriptions
	SubscriptionId uint32 `protobuf:"varint,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
}

func (m *SubscriptionResponse) Reset()                    { *m = SubscriptionResponse{} }
func (m *SubscriptionResponse) String() string            { return proto.CompactTextString(m) }
func (*SubscriptionResponse) ProtoMessage()               {}
func (*SubscriptionResponse) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *SubscriptionResponse) GetSubscriptionId() uint32 {
	if m != nil {
		return m.SubscriptionId
	}
	return 0
}

// 2. Telemetry data send back on the same connection as the
//    subscription request.
type OpenConfigData struct {
	// router name:export IP address
	SystemId string `protobuf:"bytes,1,opt,name=system_id,json=systemId" json:"system_id,omitempty"`
	// line card / RE (slot number)
	ComponentId uint32 `protobuf:"varint,2,opt,name=component_id,json=componentId" json:"component_id,omitempty"`
	// PFE (if applicable)
	SubComponentId uint32 `protobuf:"varint,3,opt,name=sub_component_id,json=subComponentId" json:"sub_component_id,omitempty"`
	// Path specification for elements of OpenConfig data models
	Path string `protobuf:"bytes,4,opt,name=path" json:"path,omitempty"`
	// Sequence number, monotonically increasing for each
	// system_id, component_id, sub_component_id + path.
	SequenceNumber uint64 `protobuf:"varint,5,opt,name=sequence_number,json=sequenceNumber" json:"sequence_number,omitempty"`
	// timestamp (milliseconds since epoch)
	Timestamp uint64 `protobuf:"varint,6,opt,name=timestamp" json:"timestamp,omitempty"`
	// List of key-value pairs
	Kv []*KeyValue `protobuf:"bytes,7,rep,name=kv" json:"kv,omitempty"`
	// For delete. If filled, it indicates delete
	Delete []*Delete `protobuf:"bytes,8,rep,name=delete" json:"delete,omitempty"`
	// If filled, it indicates end of marker for the
	// respective path in the list.
	Eom []*Eom `protobuf:"bytes,9,rep,name=eom" json:"eom,omitempty"`
	// If filled, it indicates end of sync for complete subscription
	SyncResponse bool `protobuf:"varint,10,opt,name=sync_response,json=syncResponse" json:"sync_response,omitempty"`
}

func (m *OpenConfigData) Reset()                    { *m = OpenConfigData{} }
func (m *OpenConfigData) String() string            { return proto.CompactTextString(m) }
func (*OpenConfigData) ProtoMessage()               {}
func (*OpenConfigData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

func (m *OpenConfigData) GetSystemId() string {
	if m != nil {
		return m.SystemId
	}
	return ""
}

func (m *OpenConfigData) GetComponentId() uint32 {
	if m != nil {
		return m.ComponentId
	}
	return 0
}

func (m *OpenConfigData) GetSubComponentId() uint32 {
	if m != nil {
		return m.SubComponentId
	}
	return 0
}

func (m *OpenConfigData) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

func (m *OpenConfigData) GetSequenceNumber() uint64 {
	if m != nil {
		return m.SequenceNumber
	}
	return 0
}

func (m *OpenConfigData) GetTimestamp() uint64 {
	if m != nil {
		return m.Timestamp
	}
	return 0
}

func (m *OpenConfigData) GetKv() []*KeyValue {
	if m != nil {
		return m.Kv
	}
	return nil
}

func (m *OpenConfigData) GetDelete() []*Delete {
	if m != nil {
		return m.Delete
	}
	return nil
}

func (m *OpenConfigData) GetEom() []*Eom {
	if m != nil {
		return m.Eom
	}
	return nil
}

func (m *OpenConfigData) GetSyncResponse() bool {
	if m != nil {
		return m.SyncResponse
	}
	return false
}

// Simple Key-value, where value could be one of scalar types
type KeyValue struct {
	// Key
	Key string `protobuf:"bytes,1,opt,name=key" json:"key,omitempty"`
	// One of possible values
	//
	// Types that are valid to be assigned to Value:
	//	*KeyValue_DoubleValue
	//	*KeyValue_IntValue
	//	*KeyValue_UintValue
	//	*KeyValue_SintValue
	//	*KeyValue_BoolValue
	//	*KeyValue_StrValue
	//	*KeyValue_BytesValue
	Value isKeyValue_Value `protobuf_oneof:"value"`
}

func (m *KeyValue) Reset()                    { *m = KeyValue{} }
func (m *KeyValue) String() string            { return proto.CompactTextString(m) }
func (*KeyValue) ProtoMessage()               {}
func (*KeyValue) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

type isKeyValue_Value interface {
	isKeyValue_Value()
}

type KeyValue_DoubleValue struct {
	DoubleValue float64 `protobuf:"fixed64,5,opt,name=double_value,json=doubleValue,oneof"`
}
type KeyValue_IntValue struct {
	IntValue int64 `protobuf:"varint,6,opt,name=int_value,json=intValue,oneof"`
}
type KeyValue_UintValue struct {
	UintValue uint64 `protobuf:"varint,7,opt,name=uint_value,json=uintValue,oneof"`
}
type KeyValue_SintValue struct {
	SintValue int64 `protobuf:"zigzag64,8,opt,name=sint_value,json=sintValue,oneof"`
}
type KeyValue_BoolValue struct {
	BoolValue bool `protobuf:"varint,9,opt,name=bool_value,json=boolValue,oneof"`
}
type KeyValue_StrValue struct {
	StrValue string `protobuf:"bytes,10,opt,name=str_value,json=strValue,oneof"`
}
type KeyValue_BytesValue struct {
	BytesValue []byte `protobuf:"bytes,11,opt,name=bytes_value,json=bytesValue,proto3,oneof"`
}

func (*KeyValue_DoubleValue) isKeyValue_Value() {}
func (*KeyValue_IntValue) isKeyValue_Value()    {}
func (*KeyValue_UintValue) isKeyValue_Value()   {}
func (*KeyValue_SintValue) isKeyValue_Value()   {}
func (*KeyValue_BoolValue) isKeyValue_Value()   {}
func (*KeyValue_StrValue) isKeyValue_Value()    {}
func (*KeyValue_BytesValue) isKeyValue_Value()  {}

func (m *KeyValue) GetValue() isKeyValue_Value {
	if m != nil {
		return m.Value
	}
	return nil
}

func (m *KeyValue) GetKey() string {
	if m != nil {
		return m.Key
	}
	return ""
}

func (m *KeyValue) GetDoubleValue() float64 {
	if x, ok := m.GetValue().(*KeyValue_DoubleValue); ok {
		return x.DoubleValue
	}
	return 0
}

func (m *KeyValue) GetIntValue() int64 {
	if x, ok := m.GetValue().(*KeyValue_IntValue); ok {
		return x.IntValue
	}
	return 0
}

func (m *KeyValue) GetUintValue() uint64 {
	if x, ok := m.GetValue().(*KeyValue_UintValue); ok {
		return x.UintValue
	}
	return 0
}

func (m *KeyValue) GetSintValue() int64 {
	if x, ok := m.GetValue().(*KeyValue_SintValue); ok {
		return x.SintValue
	}
	return 0
}

func (m *KeyValue) GetBoolValue() bool {
	if x, ok := m.GetValue().(*KeyValue_BoolValue); ok {
		return x.BoolValue
	}
	return false
}

func (m *KeyValue) GetStrValue() string {
	if x, ok := m.GetValue().(*KeyValue_StrValue); ok {
		return x.StrValue
	}
	return ""
}

func (m *KeyValue) GetBytesValue() []byte {
	if x, ok := m.GetValue().(*KeyValue_BytesValue); ok {
		return x.BytesValue
	}
	return nil
}

// XXX_OneofFuncs is for the internal use of the proto package.
func (*KeyValue) XXX_OneofFuncs() (func(msg proto.Message, b *proto.Buffer) error, func(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error), func(msg proto.Message) (n int), []interface{}) {
	return _KeyValue_OneofMarshaler, _KeyValue_OneofUnmarshaler, _KeyValue_OneofSizer, []interface{}{
		(*KeyValue_DoubleValue)(nil),
		(*KeyValue_IntValue)(nil),
		(*KeyValue_UintValue)(nil),
		(*KeyValue_SintValue)(nil),
		(*KeyValue_BoolValue)(nil),
		(*KeyValue_StrValue)(nil),
		(*KeyValue_BytesValue)(nil),
	}
}

func _KeyValue_OneofMarshaler(msg proto.Message, b *proto.Buffer) error {
	m := msg.(*KeyValue)
	// value
	switch x := m.Value.(type) {
	case *KeyValue_DoubleValue:
		b.EncodeVarint(5<<3 | proto.WireFixed64)
		b.EncodeFixed64(math.Float64bits(x.DoubleValue))
	case *KeyValue_IntValue:
		b.EncodeVarint(6<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.IntValue))
	case *KeyValue_UintValue:
		b.EncodeVarint(7<<3 | proto.WireVarint)
		b.EncodeVarint(uint64(x.UintValue))
	case *KeyValue_SintValue:
		b.EncodeVarint(8<<3 | proto.WireVarint)
		b.EncodeZigzag64(uint64(x.SintValue))
	case *KeyValue_BoolValue:
		t := uint64(0)
		if x.BoolValue {
			t = 1
		}
		b.EncodeVarint(9<<3 | proto.WireVarint)
		b.EncodeVarint(t)
	case *KeyValue_StrValue:
		b.EncodeVarint(10<<3 | proto.WireBytes)
		b.EncodeStringBytes(x.StrValue)
	case *KeyValue_BytesValue:
		b.EncodeVarint(11<<3 | proto.WireBytes)
		b.EncodeRawBytes(x.BytesValue)
	case nil:
	default:
		return fmt.Errorf("KeyValue.Value has unexpected type %T", x)
	}
	return nil
}

func _KeyValue_OneofUnmarshaler(msg proto.Message, tag, wire int, b *proto.Buffer) (bool, error) {
	m := msg.(*KeyValue)
	switch tag {
	case 5: // value.double_value
		if wire != proto.WireFixed64 {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeFixed64()
		m.Value = &KeyValue_DoubleValue{math.Float64frombits(x)}
		return true, err
	case 6: // value.int_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &KeyValue_IntValue{int64(x)}
		return true, err
	case 7: // value.uint_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &KeyValue_UintValue{x}
		return true, err
	case 8: // value.sint_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeZigzag64()
		m.Value = &KeyValue_SintValue{int64(x)}
		return true, err
	case 9: // value.bool_value
		if wire != proto.WireVarint {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeVarint()
		m.Value = &KeyValue_BoolValue{x != 0}
		return true, err
	case 10: // value.str_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeStringBytes()
		m.Value = &KeyValue_StrValue{x}
		return true, err
	case 11: // value.bytes_value
		if wire != proto.WireBytes {
			return true, proto.ErrInternalBadWireType
		}
		x, err := b.DecodeRawBytes(true)
		m.Value = &KeyValue_BytesValue{x}
		return true, err
	default:
		return false, nil
	}
}

func _KeyValue_OneofSizer(msg proto.Message) (n int) {
	m := msg.(*KeyValue)
	// value
	switch x := m.Value.(type) {
	case *KeyValue_DoubleValue:
		n += proto.SizeVarint(5<<3 | proto.WireFixed64)
		n += 8
	case *KeyValue_IntValue:
		n += proto.SizeVarint(6<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.IntValue))
	case *KeyValue_UintValue:
		n += proto.SizeVarint(7<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(x.UintValue))
	case *KeyValue_SintValue:
		n += proto.SizeVarint(8<<3 | proto.WireVarint)
		n += proto.SizeVarint(uint64(uint64(x.SintValue<<1) ^ uint64((int64(x.SintValue) >> 63))))
	case *KeyValue_BoolValue:
		n += proto.SizeVarint(9<<3 | proto.WireVarint)
		n += 1
	case *KeyValue_StrValue:
		n += proto.SizeVarint(10<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.StrValue)))
		n += len(x.StrValue)
	case *KeyValue_BytesValue:
		n += proto.SizeVarint(11<<3 | proto.WireBytes)
		n += proto.SizeVarint(uint64(len(x.BytesValue)))
		n += len(x.BytesValue)
	case nil:
	default:
		panic(fmt.Sprintf("proto: unexpected type %T in oneof", x))
	}
	return n
}

// Message indicating delete for a particular path
type Delete struct {
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
}

func (m *Delete) Reset()                    { *m = Delete{} }
func (m *Delete) String() string            { return proto.CompactTextString(m) }
func (*Delete) ProtoMessage()               {}
func (*Delete) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

func (m *Delete) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Message indicating EOM for a particular path
type Eom struct {
	Path string `protobuf:"bytes,1,opt,name=path" json:"path,omitempty"`
}

func (m *Eom) Reset()                    { *m = Eom{} }
func (m *Eom) String() string            { return proto.CompactTextString(m) }
func (*Eom) ProtoMessage()               {}
func (*Eom) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

func (m *Eom) GetPath() string {
	if m != nil {
		return m.Path
	}
	return ""
}

// Message sent for a telemetry subscription cancellation request
type CancelSubscriptionRequest struct {
	// Subscription identifier as returned by the device when
	// subscription was requested
	SubscriptionId uint32 `protobuf:"varint,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
}

func (m *CancelSubscriptionRequest) Reset()                    { *m = CancelSubscriptionRequest{} }
func (m *CancelSubscriptionRequest) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionRequest) ProtoMessage()               {}
func (*CancelSubscriptionRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func (m *CancelSubscriptionRequest) GetSubscriptionId() uint32 {
	if m != nil {
		return m.SubscriptionId
	}
	return 0
}

// Reply to telemetry subscription cancellation request
type CancelSubscriptionReply struct {
	// Return code
	Code ReturnCode `protobuf:"varint,1,opt,name=code,enum=telemetry.ReturnCode" json:"code,omitempty"`
	// Return code string
	CodeStr string `protobuf:"bytes,2,opt,name=code_str,json=codeStr" json:"code_str,omitempty"`
}

func (m *CancelSubscriptionReply) Reset()                    { *m = CancelSubscriptionReply{} }
func (m *CancelSubscriptionReply) String() string            { return proto.CompactTextString(m) }
func (*CancelSubscriptionReply) ProtoMessage()               {}
func (*CancelSubscriptionReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{12} }

func (m *CancelSubscriptionReply) GetCode() ReturnCode {
	if m != nil {
		return m.Code
	}
	return ReturnCode_SUCCESS
}

func (m *CancelSubscriptionReply) GetCodeStr() string {
	if m != nil {
		return m.CodeStr
	}
	return ""
}

// Message sent for a telemetry get request
type GetSubscriptionsRequest struct {
	// Subscription identifier as returned by the device when
	// subscription was requested
	// --- or ---
	// 0xFFFFFFFF for all subscription identifiers
	SubscriptionId uint32 `protobuf:"varint,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
}

func (m *GetSubscriptionsRequest) Reset()                    { *m = GetSubscriptionsRequest{} }
func (m *GetSubscriptionsRequest) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionsRequest) ProtoMessage()               {}
func (*GetSubscriptionsRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{13} }

func (m *GetSubscriptionsRequest) GetSubscriptionId() uint32 {
	if m != nil {
		return m.SubscriptionId
	}
	return 0
}

// Reply to telemetry subscription get request
type GetSubscriptionsReply struct {
	// List of current telemetry subscriptions
	SubscriptionList []*SubscriptionReply `protobuf:"bytes,1,rep,name=subscription_list,json=subscriptionList" json:"subscription_list,omitempty"`
}

func (m *GetSubscriptionsReply) Reset()                    { *m = GetSubscriptionsReply{} }
func (m *GetSubscriptionsReply) String() string            { return proto.CompactTextString(m) }
func (*GetSubscriptionsReply) ProtoMessage()               {}
func (*GetSubscriptionsReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{14} }

func (m *GetSubscriptionsReply) GetSubscriptionList() []*SubscriptionReply {
	if m != nil {
		return m.SubscriptionList
	}
	return nil
}

// Message sent for telemetry agent operational states request
type GetOperationalStateRequest struct {
	// Per-subscription_id level operational state can be requested.
	//
	// Subscription identifier as returned by the device when
	// subscription was requested
	// --- or ---
	// 0xFFFFFFFF for all subscription identifiers including agent-level
	// operational stats
	// --- or ---
	// If subscription_id is not present then sent only agent-level
	// operational stats
	SubscriptionId uint32 `protobuf:"varint,1,opt,name=subscription_id,json=subscriptionId" json:"subscription_id,omitempty"`
	// Control verbosity of the output
	Verbosity VerbosityLevel `protobuf:"varint,2,opt,name=verbosity,enum=telemetry.VerbosityLevel" json:"verbosity,omitempty"`
}

func (m *GetOperationalStateRequest) Reset()                    { *m = GetOperationalStateRequest{} }
func (m *GetOperationalStateRequest) String() string            { return proto.CompactTextString(m) }
func (*GetOperationalStateRequest) ProtoMessage()               {}
func (*GetOperationalStateRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{15} }

func (m *GetOperationalStateRequest) GetSubscriptionId() uint32 {
	if m != nil {
		return m.SubscriptionId
	}
	return 0
}

func (m *GetOperationalStateRequest) GetVerbosity() VerbosityLevel {
	if m != nil {
		return m.Verbosity
	}
	return VerbosityLevel_DETAIL
}

// Reply to telemetry agent operational states request
type GetOperationalStateReply struct {
	// List of key-value pairs where
	//     key      = operational state definition
	//     value    = operational state value
	Kv []*KeyValue `protobuf:"bytes,1,rep,name=kv" json:"kv,omitempty"`
}

func (m *GetOperationalStateReply) Reset()                    { *m = GetOperationalStateReply{} }
func (m *GetOperationalStateReply) String() string            { return proto.CompactTextString(m) }
func (*GetOperationalStateReply) ProtoMessage()               {}
func (*GetOperationalStateReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{16} }

func (m *GetOperationalStateReply) GetKv() []*KeyValue {
	if m != nil {
		return m.Kv
	}
	return nil
}

// Message sent for a data encoding request
type DataEncodingRequest struct {
}

func (m *DataEncodingRequest) Reset()                    { *m = DataEncodingRequest{} }
func (m *DataEncodingRequest) String() string            { return proto.CompactTextString(m) }
func (*DataEncodingRequest) ProtoMessage()               {}
func (*DataEncodingRequest) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{17} }

// Reply to data encodings supported request
type DataEncodingReply struct {
	EncodingList []EncodingType `protobuf:"varint,1,rep,packed,name=encoding_list,json=encodingList,enum=telemetry.EncodingType" json:"encoding_list,omitempty"`
}

func (m *DataEncodingReply) Reset()                    { *m = DataEncodingReply{} }
func (m *DataEncodingReply) String() string            { return proto.CompactTextString(m) }
func (*DataEncodingReply) ProtoMessage()               {}
func (*DataEncodingReply) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{18} }

func (m *DataEncodingReply) GetEncodingList() []EncodingType {
	if m != nil {
		return m.EncodingList
	}
	return nil
}

func init() {
	proto.RegisterType((*SubscriptionRequest)(nil), "telemetry.SubscriptionRequest")
	proto.RegisterType((*SubscriptionInput)(nil), "telemetry.SubscriptionInput")
	proto.RegisterType((*Collector)(nil), "telemetry.Collector")
	proto.RegisterType((*Path)(nil), "telemetry.Path")
	proto.RegisterType((*SubscriptionAdditionalConfig)(nil), "telemetry.SubscriptionAdditionalConfig")
	proto.RegisterType((*SubscriptionReply)(nil), "telemetry.SubscriptionReply")
	proto.RegisterType((*SubscriptionResponse)(nil), "telemetry.SubscriptionResponse")
	proto.RegisterType((*OpenConfigData)(nil), "telemetry.OpenConfigData")
	proto.RegisterType((*KeyValue)(nil), "telemetry.KeyValue")
	proto.RegisterType((*Delete)(nil), "telemetry.Delete")
	proto.RegisterType((*Eom)(nil), "telemetry.Eom")
	proto.RegisterType((*CancelSubscriptionRequest)(nil), "telemetry.CancelSubscriptionRequest")
	proto.RegisterType((*CancelSubscriptionReply)(nil), "telemetry.CancelSubscriptionReply")
	proto.RegisterType((*GetSubscriptionsRequest)(nil), "telemetry.GetSubscriptionsRequest")
	proto.RegisterType((*GetSubscriptionsReply)(nil), "telemetry.GetSubscriptionsReply")
	proto.RegisterType((*GetOperationalStateRequest)(nil), "telemetry.GetOperationalStateRequest")
	proto.RegisterType((*GetOperationalStateReply)(nil), "telemetry.GetOperationalStateReply")
	proto.RegisterType((*DataEncodingRequest)(nil), "telemetry.DataEncodingRequest")
	proto.RegisterType((*DataEncodingReply)(nil), "telemetry.DataEncodingReply")
	proto.RegisterEnum("telemetry.ReturnCode", ReturnCode_name, ReturnCode_value)
	proto.RegisterEnum("telemetry.VerbosityLevel", VerbosityLevel_name, VerbosityLevel_value)
	proto.RegisterEnum("telemetry.EncodingType", EncodingType_name, EncodingType_value)
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConn

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion4

// Client API for OpenConfigTelemetry service

type OpenConfigTelemetryClient interface {
	// Request an inline subscription for data at the specified path.
	// The device should send telemetry data back on the same
	// connection as the subscription request.
	TelemetrySubscribe(ctx context.Context, in *SubscriptionRequest, opts ...grpc.CallOption) (OpenConfigTelemetry_TelemetrySubscribeClient, error)
	// Terminates and removes an exisiting telemetry subscription
	CancelTelemetrySubscription(ctx context.Context, in *CancelSubscriptionRequest, opts ...grpc.CallOption) (*CancelSubscriptionReply, error)
	// Get the list of current telemetry subscriptions from the
	// target. This command returns a list of existing subscriptions
	// not including those that are established via configuration.
	GetTelemetrySubscriptions(ctx context.Context, in *GetSubscriptionsRequest, opts ...grpc.CallOption) (*GetSubscriptionsReply, error)
	// Get Telemetry Agent Operational States
	GetTelemetryOperationalState(ctx context.Context, in *GetOperationalStateRequest, opts ...grpc.CallOption) (*GetOperationalStateReply, error)
	// Return the set of data encodings supported by the device for
	// telemetry data
	GetDataEncodings(ctx context.Context, in *DataEncodingRequest, opts ...grpc.CallOption) (*DataEncodingReply, error)
}

type openConfigTelemetryClient struct {
	cc *grpc.ClientConn
}

func NewOpenConfigTelemetryClient(cc *grpc.ClientConn) OpenConfigTelemetryClient {
	return &openConfigTelemetryClient{cc}
}

func (c *openConfigTelemetryClient) TelemetrySubscribe(ctx context.Context, in *SubscriptionRequest, opts ...grpc.CallOption) (OpenConfigTelemetry_TelemetrySubscribeClient, error) {
	stream, err := grpc.NewClientStream(ctx, &_OpenConfigTelemetry_serviceDesc.Streams[0], c.cc, "/telemetry.OpenConfigTelemetry/telemetrySubscribe", opts...)
	if err != nil {
		return nil, err
	}
	x := &openConfigTelemetryTelemetrySubscribeClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type OpenConfigTelemetry_TelemetrySubscribeClient interface {
	Recv() (*OpenConfigData, error)
	grpc.ClientStream
}

type openConfigTelemetryTelemetrySubscribeClient struct {
	grpc.ClientStream
}

func (x *openConfigTelemetryTelemetrySubscribeClient) Recv() (*OpenConfigData, error) {
	m := new(OpenConfigData)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

func (c *openConfigTelemetryClient) CancelTelemetrySubscription(ctx context.Context, in *CancelSubscriptionRequest, opts ...grpc.CallOption) (*CancelSubscriptionReply, error) {
	out := new(CancelSubscriptionReply)
	err := grpc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/cancelTelemetrySubscription", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openConfigTelemetryClient) GetTelemetrySubscriptions(ctx context.Context, in *GetSubscriptionsRequest, opts ...grpc.CallOption) (*GetSubscriptionsReply, error) {
	out := new(GetSubscriptionsReply)
	err := grpc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/getTelemetrySubscriptions", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openConfigTelemetryClient) GetTelemetryOperationalState(ctx context.Context, in *GetOperationalStateRequest, opts ...grpc.CallOption) (*GetOperationalStateReply, error) {
	out := new(GetOperationalStateReply)
	err := grpc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/getTelemetryOperationalState", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *openConfigTelemetryClient) GetDataEncodings(ctx context.Context, in *DataEncodingRequest, opts ...grpc.CallOption) (*DataEncodingReply, error) {
	out := new(DataEncodingReply)
	err := grpc.Invoke(ctx, "/telemetry.OpenConfigTelemetry/getDataEncodings", in, out, c.cc, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// Server API for OpenConfigTelemetry service

type OpenConfigTelemetryServer interface {
	// Request an inline subscription for data at the specified path.
	// The device should send telemetry data back on the same
	// connection as the subscription request.
	TelemetrySubscribe(*SubscriptionRequest, OpenConfigTelemetry_TelemetrySubscribeServer) error
	// Terminates and removes an exisiting telemetry subscription
	CancelTelemetrySubscription(context.Context, *CancelSubscriptionRequest) (*CancelSubscriptionReply, error)
	// Get the list of current telemetry subscriptions from the
	// target. This command returns a list of existing subscriptions
	// not including those that are established via configuration.
	GetTelemetrySubscriptions(context.Context, *GetSubscriptionsRequest) (*GetSubscriptionsReply, error)
	// Get Telemetry Agent Operational States
	GetTelemetryOperationalState(context.Context, *GetOperationalStateRequest) (*GetOperationalStateReply, error)
	// Return the set of data encodings supported by the device for
	// telemetry data
	GetDataEncodings(context.Context, *DataEncodingRequest) (*DataEncodingReply, error)
}

func RegisterOpenConfigTelemetryServer(s *grpc.Server, srv OpenConfigTelemetryServer) {
	s.RegisterService(&_OpenConfigTelemetry_serviceDesc, srv)
}

func _OpenConfigTelemetry_TelemetrySubscribe_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(SubscriptionRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(OpenConfigTelemetryServer).TelemetrySubscribe(m, &openConfigTelemetryTelemetrySubscribeServer{stream})
}

type OpenConfigTelemetry_TelemetrySubscribeServer interface {
	Send(*OpenConfigData) error
	grpc.ServerStream
}

type openConfigTelemetryTelemetrySubscribeServer struct {
	grpc.ServerStream
}

func (x *openConfigTelemetryTelemetrySubscribeServer) Send(m *OpenConfigData) error {
	return x.ServerStream.SendMsg(m)
}

func _OpenConfigTelemetry_CancelTelemetrySubscription_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CancelSubscriptionRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).CancelTelemetrySubscription(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/CancelTelemetrySubscription",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).CancelTelemetrySubscription(ctx, req.(*CancelSubscriptionRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenConfigTelemetry_GetTelemetrySubscriptions_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetSubscriptionsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).GetTelemetrySubscriptions(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/GetTelemetrySubscriptions",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).GetTelemetrySubscriptions(ctx, req.(*GetSubscriptionsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenConfigTelemetry_GetTelemetryOperationalState_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetOperationalStateRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).GetTelemetryOperationalState(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/GetTelemetryOperationalState",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).GetTelemetryOperationalState(ctx, req.(*GetOperationalStateRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _OpenConfigTelemetry_GetDataEncodings_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DataEncodingRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(OpenConfigTelemetryServer).GetDataEncodings(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/telemetry.OpenConfigTelemetry/GetDataEncodings",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(OpenConfigTelemetryServer).GetDataEncodings(ctx, req.(*DataEncodingRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _OpenConfigTelemetry_serviceDesc = grpc.ServiceDesc{
	ServiceName: "telemetry.OpenConfigTelemetry",
	HandlerType: (*OpenConfigTelemetryServer)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "cancelTelemetrySubscription",
			Handler:    _OpenConfigTelemetry_CancelTelemetrySubscription_Handler,
		},
		{
			MethodName: "getTelemetrySubscriptions",
			Handler:    _OpenConfigTelemetry_GetTelemetrySubscriptions_Handler,
		},
		{
			MethodName: "getTelemetryOperationalState",
			Handler:    _OpenConfigTelemetry_GetTelemetryOperationalState_Handler,
		},
		{
			MethodName: "getDataEncodings",
			Handler:    _OpenConfigTelemetry_GetDataEncodings_Handler,
		},
	},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "telemetrySubscribe",
			Handler:       _OpenConfigTelemetry_TelemetrySubscribe_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "oc.proto",
}

func init() { proto.RegisterFile("oc.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 1254 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x00, 0x00, 0x00, 0x02, 0xff, 0x94, 0x56, 0xcd, 0x6e, 0xdb, 0x46,
	0x17, 0x15, 0x25, 0xd9, 0x12, 0xaf, 0x7e, 0x42, 0x8d, 0xe3, 0x2f, 0xb2, 0xa3, 0xaf, 0x71, 0xe8,
	0x16, 0x71, 0x82, 0xd4, 0x28, 0x94, 0x45, 0x51, 0xa4, 0x40, 0x10, 0xcb, 0x74, 0xac, 0xc6, 0x95,
	0xdc, 0xa1, 0x9c, 0xb6, 0x2b, 0x82, 0x22, 0x27, 0x36, 0x11, 0xfe, 0x95, 0x33, 0x12, 0xc2, 0x4d,
	0x9e, 0xa0, 0xe8, 0x9b, 0x75, 0xdd, 0x97, 0xe8, 0x23, 0x74, 0x51, 0xcc, 0x90, 0x94, 0x46, 0x89,
	0x94, 0x34, 0x2b, 0x91, 0xe7, 0x9e, 0xb9, 0xf7, 0xcc, 0xbd, 0x67, 0x86, 0x82, 0x7a, 0xe4, 0x1c,
	0xc7, 0x49, 0xc4, 0x22, 0xa4, 0x32, 0xe2, 0x93, 0x80, 0xb0, 0x24, 0xd5, 0xff, 0x54, 0x60, 0xc7,
	0x9c, 0x4d, 0xa9, 0x93, 0x78, 0x31, 0xf3, 0xa2, 0x10, 0x93, 0xdf, 0x66, 0x84, 0x32, 0xd4, 0x87,
	0x2d, 0x2f, 0x8c, 0x67, 0xac, 0xab, 0x1c, 0x28, 0x47, 0x8d, 0x7e, 0xef, 0x78, 0xb1, 0xe4, 0x58,
	0xa6, 0x0f, 0x39, 0x07, 0x67, 0x54, 0xf4, 0x18, 0xd4, 0xd8, 0x66, 0x37, 0x96, 0xef, 0x51, 0xd6,
	0x2d, 0x1f, 0x54, 0x8e, 0x1a, 0xfd, 0x5b, 0xd2, 0xba, 0x4b, 0x9b, 0xdd, 0xe0, 0x3a, 0x67, 0x5c,
	0x78, 0x94, 0xa1, 0x09, 0x74, 0x6c, 0xd7, 0xf5, 0x78, 0x16, 0xdb, 0xb7, 0x9c, 0x28, 0x7c, 0xed,
	0x5d, 0x77, 0x2b, 0xa2, 0xda, 0x83, 0x0d, 0xd5, 0x9e, 0x2f, 0xf8, 0x03, 0x41, 0xc7, 0x9a, 0xfd,
	0x1e, 0xa2, 0x5f, 0x42, 0xe7, 0x03, 0x7d, 0xe8, 0x29, 0xb4, 0x9d, 0xc8, 0xf7, 0x89, 0xc3, 0xa2,
	0x24, 0x53, 0xa7, 0x08, 0x75, 0xb7, 0xa5, 0x3a, 0x83, 0x82, 0x80, 0x5b, 0x0b, 0x2e, 0xd7, 0xa9,
	0x7f, 0x07, 0xea, 0x22, 0x86, 0xba, 0x50, 0xb3, 0x5d, 0x37, 0x21, 0x94, 0x8a, 0xc6, 0xa8, 0xb8,
	0x78, 0x45, 0x08, 0xaa, 0x71, 0x94, 0xf0, 0x7d, 0x2b, 0x47, 0x2d, 0x2c, 0x9e, 0xf5, 0xbf, 0x14,
	0xa8, 0xf2, 0x5d, 0x8b, 0xa0, 0xcd, 0x6e, 0xf2, 0x35, 0xe2, 0x19, 0xfd, 0x0f, 0xb6, 0x5f, 0x7b,
	0x3e, 0x23, 0x89, 0x58, 0xa2, 0xe2, 0xfc, 0x0d, 0x7d, 0x0d, 0x88, 0xce, 0xe2, 0x98, 0x27, 0xb5,
	0x66, 0xa1, 0x73, 0x63, 0x87, 0xd7, 0xc4, 0x15, 0x8d, 0xa9, 0xe3, 0x4e, 0x11, 0xb9, 0x2a, 0x02,
	0xe8, 0x18, 0x76, 0x02, 0xfb, 0xad, 0x45, 0x3d, 0x9f, 0x84, 0xcc, 0xf2, 0x42, 0x46, 0x92, 0xb9,
	0xed, 0x77, 0xab, 0x42, 0x46, 0x27, 0xb0, 0xdf, 0x9a, 0x22, 0x32, 0xcc, 0x03, 0xe8, 0x21, 0x68,
	0xd4, 0x0e, 0x62, 0x9f, 0x58, 0xaf, 0x13, 0x3e, 0xeb, 0xd0, 0x49, 0xbb, 0x5b, 0x82, 0x7c, 0x2b,
	0xc3, 0xcf, 0x0a, 0x18, 0xed, 0x41, 0x3d, 0x24, 0xc4, 0xb5, 0x48, 0x14, 0x74, 0xb7, 0x45, 0xfd,
	0x1a, 0x7f, 0x37, 0xa2, 0x40, 0xff, 0x5d, 0x81, 0xde, 0xc7, 0x26, 0x83, 0x0e, 0xa1, 0xe5, 0x7b,
	0x81, 0xc7, 0xac, 0x84, 0x38, 0x51, 0xe2, 0x66, 0xed, 0xda, 0xc2, 0x4d, 0x01, 0xe2, 0x0c, 0x43,
	0x8f, 0x01, 0x65, 0x24, 0xe6, 0x05, 0xc4, 0xa2, 0xc4, 0x89, 0x42, 0x97, 0x8a, 0x76, 0x6c, 0x61,
	0x4d, 0x44, 0x26, 0x5e, 0x40, 0xcc, 0x0c, 0x97, 0xe4, 0xd0, 0xbc, 0x1d, 0xb9, 0x1c, 0xaa, 0xbf,
	0x5b, 0x9d, 0x3a, 0x26, 0xb1, 0x9f, 0xa2, 0xa7, 0x50, 0x4f, 0x08, 0x8d, 0xa3, 0x90, 0x92, 0xdc,
	0xc5, 0xf7, 0x36, 0xf8, 0x0a, 0xe7, 0x34, 0xbc, 0x58, 0xf0, 0x79, 0x5e, 0xd6, 0x9f, 0xc1, 0xed,
	0x75, 0xf9, 0xd0, 0x03, 0xb8, 0x45, 0x25, 0xdc, 0xf2, 0x5c, 0xa1, 0xa4, 0x85, 0xdb, 0x32, 0x3c,
	0x74, 0xf5, 0xbf, 0xcb, 0xd0, 0x1e, 0xc7, 0x24, 0xcc, 0xba, 0x77, 0x6a, 0x33, 0x1b, 0xdd, 0x05,
	0x95, 0xa6, 0x94, 0x91, 0xa0, 0x58, 0xa5, 0xe2, 0x7a, 0x06, 0x0c, 0x5d, 0x74, 0x1f, 0x9a, 0x4e,
	0x14, 0xc4, 0x51, 0x28, 0x86, 0xee, 0xe6, 0xae, 0x6b, 0x2c, 0xb0, 0xa1, 0x8b, 0x8e, 0x40, 0xa3,
	0xb3, 0xa9, 0xb5, 0x42, 0xab, 0x2c, 0x8a, 0x0f, 0x24, 0x66, 0xe1, 0xce, 0xaa, 0xe4, 0x4e, 0xae,
	0x3c, 0xf3, 0x01, 0xb1, 0xc2, 0x59, 0x30, 0x25, 0x89, 0x70, 0x49, 0x15, 0xb7, 0x0b, 0x78, 0x24,
	0x50, 0xd4, 0x03, 0x95, 0x4f, 0x8f, 0x32, 0x3b, 0x88, 0x85, 0x4b, 0xaa, 0x78, 0x09, 0xa0, 0x43,
	0x28, 0xbf, 0x99, 0x77, 0x6b, 0xa2, 0x7f, 0x3b, 0x52, 0xff, 0x5e, 0x92, 0xf4, 0x95, 0xed, 0xcf,
	0x08, 0x2e, 0xbf, 0x99, 0xa3, 0x87, 0xb0, 0xed, 0x12, 0x9f, 0x30, 0xd2, 0xad, 0x0b, 0x62, 0x47,
	0x22, 0x9e, 0x8a, 0x00, 0xce, 0x09, 0xe8, 0x00, 0x2a, 0xdc, 0x8d, 0xaa, 0xe0, 0xb5, 0x25, 0x9e,
	0x11, 0x05, 0x98, 0x87, 0xb8, 0xf1, 0x68, 0x1a, 0x3a, 0xd6, 0x62, 0xf4, 0x20, 0xac, 0xd2, 0xe4,
	0x60, 0x31, 0x17, 0xfd, 0x8f, 0x32, 0xd4, 0x0b, 0x09, 0x48, 0x83, 0xca, 0x1b, 0x92, 0xe6, 0x2d,
	0xe6, 0x8f, 0xe8, 0x10, 0x9a, 0x6e, 0x34, 0x9b, 0xfa, 0xc4, 0x9a, 0x73, 0x86, 0xd8, 0xb9, 0x72,
	0x5e, 0xc2, 0x8d, 0x0c, 0xcd, 0x96, 0xfd, 0x1f, 0x54, 0x2f, 0x64, 0x39, 0x83, 0x6f, 0xbc, 0x72,
	0x5e, 0xc2, 0x75, 0x2f, 0x64, 0x59, 0xf8, 0x1e, 0xc0, 0x6c, 0x19, 0xaf, 0xf1, 0xc6, 0x9c, 0x97,
	0xb0, 0x3a, 0x93, 0x09, 0x74, 0x49, 0xa8, 0x1f, 0x28, 0x47, 0x88, 0x13, 0xa8, 0x4c, 0x98, 0x46,
	0x91, 0x9f, 0x13, 0x54, 0xbe, 0x0d, 0x4e, 0xe0, 0xd8, 0x42, 0x01, 0x65, 0x49, 0x1e, 0xe7, 0xdb,
	0x54, 0xb9, 0x02, 0xca, 0x92, 0x2c, 0x7c, 0x1f, 0x1a, 0xd3, 0x94, 0x11, 0x9a, 0x13, 0x1a, 0x07,
	0xca, 0x51, 0xf3, 0xbc, 0x84, 0x41, 0x80, 0x82, 0x72, 0x52, 0x83, 0x2d, 0x11, 0xd4, 0x7b, 0xb0,
	0x9d, 0x75, 0x7a, 0xdd, 0x55, 0xa5, 0xef, 0x41, 0xc5, 0x88, 0x82, 0xb5, 0xa1, 0x53, 0xd8, 0x1b,
	0xd8, 0xa1, 0x43, 0xfc, 0x75, 0x1f, 0x91, 0xff, 0x6c, 0x7f, 0x0b, 0xee, 0xac, 0xcb, 0xc2, 0x4f,
	0xf1, 0x43, 0xa8, 0x3a, 0x91, 0x9b, 0x9d, 0xe0, 0x76, 0x7f, 0x57, 0x1a, 0x39, 0x26, 0x6c, 0x96,
	0x84, 0x83, 0xc8, 0x25, 0x58, 0x50, 0xf8, 0x05, 0xc1, 0x7f, 0x2d, 0xca, 0x8a, 0x3b, 0xb5, 0xc6,
	0xdf, 0x4d, 0x96, 0xe8, 0x27, 0x70, 0xe7, 0x05, 0x61, 0x72, 0x76, 0xfa, 0xd9, 0x22, 0xa7, 0xb0,
	0xfb, 0x61, 0x0e, 0x2e, 0x71, 0x08, 0x9d, 0x95, 0x0c, 0xd2, 0x17, 0xa6, 0xb7, 0xf1, 0xc6, 0x89,
	0xfd, 0x14, 0x6b, 0xf2, 0x32, 0x71, 0x91, 0xbc, 0x83, 0xfd, 0x17, 0x84, 0x8d, 0x63, 0x92, 0xd8,
	0xd9, 0x75, 0x6a, 0x32, 0x9b, 0x91, 0xcf, 0x95, 0x8a, 0xbe, 0x05, 0x75, 0x4e, 0x92, 0x69, 0x44,
	0x3d, 0x96, 0x8a, 0x56, 0xb4, 0xfb, 0x7b, 0x92, 0x92, 0x57, 0x45, 0xec, 0x82, 0xcc, 0x89, 0x8f,
	0x97, 0x5c, 0xfd, 0x19, 0x74, 0xd7, 0xd6, 0xe7, 0xdb, 0xcc, 0xce, 0xb2, 0xf2, 0xd1, 0xb3, 0xac,
	0xef, 0xc2, 0x0e, 0xbf, 0xbd, 0x8c, 0xd0, 0x89, 0x5c, 0x2f, 0xbc, 0xce, 0x95, 0xeb, 0x3f, 0x41,
	0x67, 0x15, 0xe6, 0x09, 0xbf, 0x87, 0x16, 0xc9, 0x81, 0x65, 0xcf, 0xda, 0xfd, 0x3b, 0xf2, 0xb1,
	0xce, 0xe3, 0x93, 0x34, 0x26, 0xb8, 0x59, 0xb0, 0x79, 0xab, 0x1e, 0xbd, 0x00, 0x58, 0x3a, 0x00,
	0x35, 0xa0, 0x66, 0x5e, 0x0d, 0x06, 0x86, 0x69, 0x6a, 0x25, 0xb4, 0x07, 0xbb, 0xa3, 0xb1, 0x65,
	0x5e, 0x9d, 0x98, 0x03, 0x3c, 0xbc, 0x9c, 0x0c, 0xc7, 0x23, 0xcb, 0x18, 0x4d, 0xf0, 0xaf, 0x9a,
	0x82, 0x3a, 0xd0, 0xba, 0x1a, 0xbd, 0x1c, 0x8d, 0x7f, 0x1e, 0x59, 0x06, 0xc6, 0x63, 0xac, 0x95,
	0x1f, 0xf5, 0xa1, 0xbd, 0xda, 0x10, 0x04, 0xb0, 0x7d, 0x6a, 0x4c, 0x9e, 0x0f, 0x2f, 0xb4, 0x12,
	0x52, 0x61, 0x6b, 0x62, 0x60, 0xd3, 0xd0, 0x14, 0xfe, 0x78, 0x82, 0x87, 0xc6, 0x99, 0x56, 0x7e,
	0xf4, 0x1c, 0x9a, 0xb2, 0x34, 0xd4, 0x02, 0xf5, 0x6a, 0x74, 0x6a, 0x9c, 0x0d, 0x47, 0xc6, 0xa9,
	0x56, 0x42, 0x35, 0xa8, 0xfc, 0xf2, 0xe3, 0x85, 0xa6, 0x70, 0xfc, 0x07, 0x73, 0x3c, 0xb2, 0x86,
	0xc6, 0xe4, 0x4c, 0x2b, 0xf3, 0xc4, 0x97, 0x78, 0x3c, 0x19, 0x3f, 0xd1, 0x2a, 0xfd, 0x7f, 0x2a,
	0xb0, 0xb3, 0xbc, 0xf2, 0x27, 0xc5, 0x96, 0x91, 0x09, 0x68, 0xb1, 0xff, 0xdc, 0x32, 0x53, 0x82,
	0xbe, 0xd8, 0x68, 0x24, 0xd1, 0xe0, 0x7d, 0x79, 0xbc, 0xab, 0x1f, 0x12, 0xbd, 0xf4, 0x8d, 0x82,
	0x3c, 0xb8, 0xeb, 0x88, 0x03, 0x36, 0x79, 0x2f, 0xb5, 0x48, 0x82, 0xbe, 0x94, 0xff, 0x08, 0x6d,
	0x3a, 0xce, 0xfb, 0xfa, 0x27, 0x58, 0xb1, 0x9f, 0xea, 0x25, 0xe4, 0xc0, 0xde, 0x35, 0x61, 0x6b,
	0xeb, 0x50, 0x24, 0xa7, 0xd8, 0x70, 0x20, 0xf7, 0x0f, 0x3e, 0xca, 0xc9, 0x8a, 0xf8, 0xd0, 0x93,
	0x8b, 0xbc, 0x6f, 0x58, 0xf4, 0xd5, 0x6a, 0x8e, 0x0d, 0x07, 0x6a, 0xff, 0xf0, 0x53, 0xb4, 0xac,
	0x1a, 0x06, 0xed, 0x9a, 0x30, 0xd9, 0xc0, 0x74, 0x65, 0x20, 0x6b, 0x1c, 0xbf, 0xdf, 0xdb, 0x18,
	0x17, 0x39, 0xa7, 0xdb, 0xe2, 0xaf, 0xf8, 0x93, 0x7f, 0x03, 0x00, 0x00, 0xff, 0xff, 0xc9, 0xe3,
	0x4f, 0x0d, 0x96, 0x0b, 0x00, 0x00,
}
