/*
Copyright The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by main. DO NOT EDIT.

package v1

import (
	"context"

	v1 "github.com/k3s-io/k3s/pkg/apis/k3s.cattle.io/v1"
	scheme "github.com/k3s-io/k3s/pkg/generated/clientset/versioned/scheme"
	metav1 "k8s.io/apimachinery/pkg/apis/meta/v1"
	types "k8s.io/apimachinery/pkg/types"
	watch "k8s.io/apimachinery/pkg/watch"
	gentype "k8s.io/client-go/gentype"
)

// ETCDSnapshotFilesGetter has a method to return a ETCDSnapshotFileInterface.
// A group's client should implement this interface.
type ETCDSnapshotFilesGetter interface {
	ETCDSnapshotFiles() ETCDSnapshotFileInterface
}

// ETCDSnapshotFileInterface has methods to work with ETCDSnapshotFile resources.
type ETCDSnapshotFileInterface interface {
	Create(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.CreateOptions) (*v1.ETCDSnapshotFile, error)
	Update(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.UpdateOptions) (*v1.ETCDSnapshotFile, error)
	// Add a +genclient:noStatus comment above the type to avoid generating UpdateStatus().
	UpdateStatus(ctx context.Context, eTCDSnapshotFile *v1.ETCDSnapshotFile, opts metav1.UpdateOptions) (*v1.ETCDSnapshotFile, error)
	Delete(ctx context.Context, name string, opts metav1.DeleteOptions) error
	DeleteCollection(ctx context.Context, opts metav1.DeleteOptions, listOpts metav1.ListOptions) error
	Get(ctx context.Context, name string, opts metav1.GetOptions) (*v1.ETCDSnapshotFile, error)
	List(ctx context.Context, opts metav1.ListOptions) (*v1.ETCDSnapshotFileList, error)
	Watch(ctx context.Context, opts metav1.ListOptions) (watch.Interface, error)
	Patch(ctx context.Context, name string, pt types.PatchType, data []byte, opts metav1.PatchOptions, subresources ...string) (result *v1.ETCDSnapshotFile, err error)
	ETCDSnapshotFileExpansion
}

// eTCDSnapshotFiles implements ETCDSnapshotFileInterface
type eTCDSnapshotFiles struct {
	*gentype.ClientWithList[*v1.ETCDSnapshotFile, *v1.ETCDSnapshotFileList]
}

// newETCDSnapshotFiles returns a ETCDSnapshotFiles
func newETCDSnapshotFiles(c *K3sV1Client) *eTCDSnapshotFiles {
	return &eTCDSnapshotFiles{
		gentype.NewClientWithList[*v1.ETCDSnapshotFile, *v1.ETCDSnapshotFileList](
			"etcdsnapshotfiles",
			c.RESTClient(),
			scheme.ParameterCodec,
			"",
			func() *v1.ETCDSnapshotFile { return &v1.ETCDSnapshotFile{} },
			func() *v1.ETCDSnapshotFileList { return &v1.ETCDSnapshotFileList{} }),
	}
}
