/*
Copyright 2018 The Kubernetes Authors.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Package create implements the `create` command
package create

import (
	"fmt"

	"github.com/spf13/cobra"

	createcluster "sigs.k8s.io/kind/cmd/kind/create/cluster"
)

// NewCommand returns a new cobra.Command for cluster creation
func NewCommand() *cobra.Command {
	cmd := &cobra.Command{
		Use:   "create",
		Short: "Creates one of [cluster]",
		Long:  "Creates one of local Kubernetes cluster (cluster)",
		RunE:  run,
	}
	cmd.AddCommand(createcluster.NewCommand())
	return cmd
}

func run(cmd *cobra.Command, args []string) error {
	fmt.Println("You likely want `kind create cluster`, please migrate!")
	fmt.Println()
	cmd.Usage()
	return nil
}
