# User Guide

## Creating a Cluster

Creating a Kubernetes cluster is as simple as:
```
$ kind create cluster
```

This will bootstrap a Kubernetes cluster using a pre-built 
[node image][node image] - you can find it on docker hub
[`kindest/node`][kindest/node]. 
If you desire to build the node image yourself see the 
[building image](#building-images) section.
To specify another image use the `--image` flag.

By default, the cluster will be given the name `kind-1`. "1," here, is the
default context name. 
Use the `--name` flag to assign the cluster a different context name.

**Note**: If you are running `kind` on MacOS or Windows then it is recommended
that you have at least 4GB of RAM and disk space (these are estimates for a
single node `kind` cluster) dedicated to the virtual machine (VM) running the
Docker engine otherwise the Kubernetes cluster might fail to start up.

To change the resource limits for the Docker engine on Mac, you'll need to open the
**Preferences** menu.
<img src="./images/docker-pref-1.png"/>

Now, go to the **Advanced** settings page, and change the
settings there, see [changing Docker's resource limits][Docker resource lims].
<img src="./images/docker-pref-2.png"/>

You may also try removing any unused data left by the Docker engine - e.g.,
`docker system prune`.


## Interacting With Your Cluster
After [creating a cluster](#creating-a-cluster), you can use [kubectl][kubectl]
to interact with it by using the configuration file generated by `kind`:
```
export KUBECONFIG="$(kind get kubeconfig-path)"
kubectl cluster-info
```

`kind get kubeconfig-path` returns the location of the generated confguration
file.
If you gave a non-default cluster context name to your cluster, then you can
specify the name by using the `--name` flag.

To see all the clusters you have created, you can use the `get clusters`
command.

For example, let's say you create two clusters:
```
$ kind create cluster # Default cluster context name is "1".
...
$ kind create cluster --name 2
```

When you list your `kind` clusters, you will see something like the following:
```
$ kind get clusters
2
1
```

Both of these clusters will have a kubeconfig file to go along with them:
```
$ kind get kubeconfig-path
/home/user/.kube/kind-config-1

$ kind get kubeconfig-path --name 2
/home/user/.kube/kind-config-2
```


## Deleting a Cluster

If you created a cluster with `kind create cluster` then deleting is equally
simple:
```
$ kind delete cluster
```

If the flag `--name` is not specified, `kind` will use the default cluster
context name "1" and delete that cluster.
Recall that cluster context names are prefixed with `kind-` so the default
cluster name is `kind-1`.

If you want the `create cluster` command to block until the control plane
reaches a ready status, you can use the `--wait` flag and specify a timeout.
To use `--wait` you must specify the units of the time to wait. For example, to
wait for 30 seconds, do `--wait 30s`, for 5 minutes do `--wait 5m`, etc.


## Building Images

`kind` runs a local Kubernetes cluster by using Docker containers as "nodes".
`kind` uses the [`node-image`][node image] to run Kubernetes artifacts, such
as `kubeadm` or `kubelet`.
The `node-image` in turn is built off the [`base-image`][base image], which
installs all the dependencies needed for Docker and Kubernetes to run in a
container.

See [building the base image](#building-the-base-image) for more advanced information.

Currently, `kind` supports three different ways to build a `node-image`: via
`apt`, or if you have the [Kubernetes][kubernetes] source in your host machine
(`$GOPATH/src/k8s.io/kubernetes`), by using `docker` or `bazel`.
To specify the build type use the flag `--type`.
`kind` will default to using the build type `docker` if none is specified.

```
$ kind build node-image --type apt
```

Similarly as for the base-image command, you can specify the name and tag of
the resulting node image using the flag `--image`.

If you previously changed the name and tag of the base image, you can use here
the flag `--base-image` to specify the name and tag you used.


## Advanced

### Building The Base Image
To build the `base-image` we use the `build` command:
```
$ kind build base-image
```

If you want to specify the path to the base image source files you can use the
`--source` flag.
If `--source` is not specified, `kind` has enbedded the contents of the in
default base image in [`pkg/build/base/sources`][pkg/build/base/sources] and
will use this to build it.

By default, the base image will be tagged as `kindest/base:latest`.
If you want to change this, you can use the `--image` flag.

```
$ kind build base-image --image base:v0.1.0
```


### Configuring Your `kind` Cluster
When creating your `kind` cluster, via `create cluster`, you can use a
configuration file to run specific commands before or after systemd or kubeadm
run.
To specify a configuration file when creating a cluster, use the `--config`
flag.
For a sample kind configuration file see [kind-example-config][kind-example-config].


### Exporting `kind`'s Logs
`kind` has the ability to export all `kind` related logs for you to explore.
To export all logs from the default cluster (context name "1"):
```
$ kind export logs
Exported logs to: /tmp/396758314
```

Like all other commands, if you want to perform the action on a cluster with a
different context name use the `--name` flag.

As you can see, `kind` placed all the logs for the cluster `kind-1` in a
temporary directory. If you want to specify a location then simply add the path
to the directory after the command:
```
$ kind export logs ./somedir  
Exported logs to: ./somedir
```

The structure of the logs will look more or less like this:
```
.
├── docker-info.txt
└── kind-1-control-plane/
    ├── containers
    ├── docker.log
    ├── inspect.json
    ├── journal.log
    ├── kubelet.log
    ├── kubernetes-version.txt
    └── pods/
```
The logs contain information about the Docker host, the containers running 
`kind`, the Kubernetes cluster itself, etc.

[node image]: ../design/node-image.md
[base image]: ../design/base-image.md
[kind-example-config]: ./kind-example-config.yaml
[pkg/build/base/sources]: ./../../pkg/build/base/sources
[kubernetes]: https://github.com/kubernetes/kubernetes
[kindest/node]: https://hub.docker.com/r/kindest/node/
[kubectl]: https://kubernetes.io/docs/reference/kubectl/overview/
[Docker resource lims]: https://docs.docker.com/docker-for-mac/#advanced
