// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

package pprofileotlp

import (
	"encoding/json"
	"strings"
	"testing"

	"github.com/stretchr/testify/assert"
)

var _ json.Unmarshaler = ExportRequest{}
var _ json.Marshaler = ExportRequest{}

var profilesRequestJSON = []byte(`
	{
		"resourceProfiles": [
			{
				"resource": {},
				"scopeProfiles": [
					{
						"scope": {},
						"profiles": [
							{
								"profileId": "",
								"profile": {
									"sample": [
										{
											"locationsStartIndex": "42"
										}
									],
									"periodType": {}
								}
							}
						]
					}
				]
			}
		]
	}`)

func TestRequestToPData(t *testing.T) {
	tr := NewExportRequest()
	assert.Equal(t, tr.Profiles().SampleCount(), 0)
	tr.Profiles().ResourceProfiles().AppendEmpty().ScopeProfiles().AppendEmpty().Profiles().AppendEmpty().Profile().Sample().AppendEmpty()
	assert.Equal(t, tr.Profiles().SampleCount(), 1)
}

func TestRequestJSON(t *testing.T) {
	tr := NewExportRequest()
	assert.NoError(t, tr.UnmarshalJSON(profilesRequestJSON))
	assert.Equal(t, uint64(42), tr.Profiles().ResourceProfiles().At(0).ScopeProfiles().At(0).Profiles().At(0).Profile().Sample().At(0).LocationsStartIndex())

	got, err := tr.MarshalJSON()
	assert.NoError(t, err)
	assert.Equal(t, strings.Join(strings.Fields(string(profilesRequestJSON)), ""), string(got))
}
