// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "pdata/internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	otlpcommon "go.opentelemetry.io/collector/pdata/internal/data/protogen/common/v1"
)

type EntityRef struct {
	orig  *otlpcommon.EntityRef
	state *State
}

func GetOrigEntityRef(ms EntityRef) *otlpcommon.EntityRef {
	return ms.orig
}

func GetEntityRefState(ms EntityRef) *State {
	return ms.state
}

func NewEntityRef(orig *otlpcommon.EntityRef, state *State) EntityRef {
	return EntityRef{orig: orig, state: state}
}

func CopyOrigEntityRef(dest, src *otlpcommon.EntityRef) {
	dest.SchemaUrl = src.SchemaUrl
	dest.Type = src.Type
	dest.IdKeys = CopyOrigStringSlice(dest.IdKeys, src.IdKeys)
	dest.DescriptionKeys = CopyOrigStringSlice(dest.DescriptionKeys, src.DescriptionKeys)
}

func GenerateTestEntityRef() EntityRef {
	orig := otlpcommon.EntityRef{}
	state := StateMutable
	tv := NewEntityRef(&orig, &state)
	FillTestEntityRef(tv)
	return tv
}

func FillTestEntityRef(tv EntityRef) {
	tv.orig.SchemaUrl = "https://opentelemetry.io/schemas/1.5.0"
	tv.orig.Type = "host"
	FillTestStringSlice(NewStringSlice(&tv.orig.IdKeys, tv.state))
	FillTestStringSlice(NewStringSlice(&tv.orig.DescriptionKeys, tv.state))
}
