// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"fmt"
	"sync"

	otlpprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
	"go.opentelemetry.io/collector/pdata/internal/proto"
)

var (
	protoPoolMapping = sync.Pool{
		New: func() any {
			return &otlpprofiles.Mapping{}
		},
	}
)

func NewOrigMapping() *otlpprofiles.Mapping {
	if !UseProtoPooling.IsEnabled() {
		return &otlpprofiles.Mapping{}
	}
	return protoPoolMapping.Get().(*otlpprofiles.Mapping)
}

func DeleteOrigMapping(orig *otlpprofiles.Mapping, nullable bool) {
	if orig == nil {
		return
	}

	if !UseProtoPooling.IsEnabled() {
		orig.Reset()
		return
	}

	orig.Reset()
	if nullable {
		protoPoolMapping.Put(orig)
	}
}

func CopyOrigMapping(dest, src *otlpprofiles.Mapping) {
	// If copying to same object, just return.
	if src == dest {
		return
	}
	dest.MemoryStart = src.MemoryStart
	dest.MemoryLimit = src.MemoryLimit
	dest.FileOffset = src.FileOffset
	dest.FilenameStrindex = src.FilenameStrindex
	dest.AttributeIndices = CopyOrigInt32Slice(dest.AttributeIndices, src.AttributeIndices)
	dest.HasFunctions = src.HasFunctions
	dest.HasFilenames = src.HasFilenames
	dest.HasLineNumbers = src.HasLineNumbers
	dest.HasInlineFrames = src.HasInlineFrames
}

func GenTestOrigMapping() *otlpprofiles.Mapping {
	orig := NewOrigMapping()
	orig.MemoryStart = uint64(13)
	orig.MemoryLimit = uint64(13)
	orig.FileOffset = uint64(13)
	orig.FilenameStrindex = int32(13)
	orig.AttributeIndices = GenerateOrigTestInt32Slice()
	orig.HasFunctions = true
	orig.HasFilenames = true
	orig.HasLineNumbers = true
	orig.HasInlineFrames = true
	return orig
}

// MarshalJSONOrig marshals all properties from the current struct to the destination stream.
func MarshalJSONOrigMapping(orig *otlpprofiles.Mapping, dest *json.Stream) {
	dest.WriteObjectStart()
	if orig.MemoryStart != uint64(0) {
		dest.WriteObjectField("memoryStart")
		dest.WriteUint64(orig.MemoryStart)
	}
	if orig.MemoryLimit != uint64(0) {
		dest.WriteObjectField("memoryLimit")
		dest.WriteUint64(orig.MemoryLimit)
	}
	if orig.FileOffset != uint64(0) {
		dest.WriteObjectField("fileOffset")
		dest.WriteUint64(orig.FileOffset)
	}
	if orig.FilenameStrindex != int32(0) {
		dest.WriteObjectField("filenameStrindex")
		dest.WriteInt32(orig.FilenameStrindex)
	}
	if len(orig.AttributeIndices) > 0 {
		dest.WriteObjectField("attributeIndices")
		dest.WriteArrayStart()
		dest.WriteInt32(orig.AttributeIndices[0])
		for i := 1; i < len(orig.AttributeIndices); i++ {
			dest.WriteMore()
			dest.WriteInt32(orig.AttributeIndices[i])
		}
		dest.WriteArrayEnd()
	}
	if orig.HasFunctions != false {
		dest.WriteObjectField("hasFunctions")
		dest.WriteBool(orig.HasFunctions)
	}
	if orig.HasFilenames != false {
		dest.WriteObjectField("hasFilenames")
		dest.WriteBool(orig.HasFilenames)
	}
	if orig.HasLineNumbers != false {
		dest.WriteObjectField("hasLineNumbers")
		dest.WriteBool(orig.HasLineNumbers)
	}
	if orig.HasInlineFrames != false {
		dest.WriteObjectField("hasInlineFrames")
		dest.WriteBool(orig.HasInlineFrames)
	}
	dest.WriteObjectEnd()
}

// UnmarshalJSONOrigMapping unmarshals all properties from the current struct from the source iterator.
func UnmarshalJSONOrigMapping(orig *otlpprofiles.Mapping, iter *json.Iterator) {
	for f := iter.ReadObject(); f != ""; f = iter.ReadObject() {
		switch f {
		case "memoryStart", "memory_start":
			orig.MemoryStart = iter.ReadUint64()
		case "memoryLimit", "memory_limit":
			orig.MemoryLimit = iter.ReadUint64()
		case "fileOffset", "file_offset":
			orig.FileOffset = iter.ReadUint64()
		case "filenameStrindex", "filename_strindex":
			orig.FilenameStrindex = iter.ReadInt32()
		case "attributeIndices", "attribute_indices":
			for iter.ReadArray() {
				orig.AttributeIndices = append(orig.AttributeIndices, iter.ReadInt32())
			}

		case "hasFunctions", "has_functions":
			orig.HasFunctions = iter.ReadBool()
		case "hasFilenames", "has_filenames":
			orig.HasFilenames = iter.ReadBool()
		case "hasLineNumbers", "has_line_numbers":
			orig.HasLineNumbers = iter.ReadBool()
		case "hasInlineFrames", "has_inline_frames":
			orig.HasInlineFrames = iter.ReadBool()
		default:
			iter.Skip()
		}
	}
}

func SizeProtoOrigMapping(orig *otlpprofiles.Mapping) int {
	var n int
	var l int
	_ = l
	if orig.MemoryStart != 0 {
		n += 1 + proto.Sov(uint64(orig.MemoryStart))
	}
	if orig.MemoryLimit != 0 {
		n += 1 + proto.Sov(uint64(orig.MemoryLimit))
	}
	if orig.FileOffset != 0 {
		n += 1 + proto.Sov(uint64(orig.FileOffset))
	}
	if orig.FilenameStrindex != 0 {
		n += 1 + proto.Sov(uint64(orig.FilenameStrindex))
	}
	if len(orig.AttributeIndices) > 0 {
		l = 0
		for _, e := range orig.AttributeIndices {
			l += proto.Sov(uint64(e))
		}
		n += 1 + proto.Sov(uint64(l)) + l
	}
	if orig.HasFunctions {
		n += 2
	}
	if orig.HasFilenames {
		n += 2
	}
	if orig.HasLineNumbers {
		n += 2
	}
	if orig.HasInlineFrames {
		n += 2
	}
	return n
}

func MarshalProtoOrigMapping(orig *otlpprofiles.Mapping, buf []byte) int {
	pos := len(buf)
	var l int
	_ = l
	if orig.MemoryStart != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.MemoryStart))
		pos--
		buf[pos] = 0x8
	}
	if orig.MemoryLimit != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.MemoryLimit))
		pos--
		buf[pos] = 0x10
	}
	if orig.FileOffset != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FileOffset))
		pos--
		buf[pos] = 0x18
	}
	if orig.FilenameStrindex != 0 {
		pos = proto.EncodeVarint(buf, pos, uint64(orig.FilenameStrindex))
		pos--
		buf[pos] = 0x20
	}
	l = len(orig.AttributeIndices)
	if l > 0 {
		endPos := pos
		for i := l - 1; i >= 0; i-- {
			pos = proto.EncodeVarint(buf, pos, uint64(orig.AttributeIndices[i]))
		}
		pos = proto.EncodeVarint(buf, pos, uint64(endPos-pos))
		pos--
		buf[pos] = 0x2a
	}
	if orig.HasFunctions {
		pos--
		if orig.HasFunctions {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x30
	}
	if orig.HasFilenames {
		pos--
		if orig.HasFilenames {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x38
	}
	if orig.HasLineNumbers {
		pos--
		if orig.HasLineNumbers {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x40
	}
	if orig.HasInlineFrames {
		pos--
		if orig.HasInlineFrames {
			buf[pos] = 1
		} else {
			buf[pos] = 0
		}
		pos--
		buf[pos] = 0x48
	}
	return len(buf) - pos
}

func UnmarshalProtoOrigMapping(orig *otlpprofiles.Mapping, buf []byte) error {
	var err error
	var fieldNum int32
	var wireType proto.WireType

	l := len(buf)
	pos := 0
	for pos < l {
		// If in a group parsing, move to the next tag.
		fieldNum, wireType, pos, err = proto.ConsumeTag(buf, pos)
		if err != nil {
			return err
		}
		switch fieldNum {

		case 1:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryStart", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.MemoryStart = uint64(num)

		case 2:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field MemoryLimit", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.MemoryLimit = uint64(num)

		case 3:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field FileOffset", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.FileOffset = uint64(num)

		case 4:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field FilenameStrindex", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.FilenameStrindex = int32(num)
		case 5:
			if wireType != proto.WireTypeLen {
				return fmt.Errorf("proto: wrong wireType = %d for field AttributeIndices", wireType)
			}
			var length int
			length, pos, err = proto.ConsumeLen(buf, pos)
			if err != nil {
				return err
			}
			startPos := pos - length
			var num uint64
			for startPos < pos {
				num, startPos, err = proto.ConsumeVarint(buf[:pos], startPos)
				if err != nil {
					return err
				}
				orig.AttributeIndices = append(orig.AttributeIndices, int32(num))
			}
			if startPos != pos {
				return fmt.Errorf("proto: invalid field len = %d for field AttributeIndices", pos-startPos)
			}

		case 6:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field HasFunctions", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.HasFunctions = num != 0

		case 7:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field HasFilenames", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.HasFilenames = num != 0

		case 8:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field HasLineNumbers", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.HasLineNumbers = num != 0

		case 9:
			if wireType != proto.WireTypeVarint {
				return fmt.Errorf("proto: wrong wireType = %d for field HasInlineFrames", wireType)
			}
			var num uint64
			num, pos, err = proto.ConsumeVarint(buf, pos)
			if err != nil {
				return err
			}

			orig.HasInlineFrames = num != 0
		default:
			pos, err = proto.ConsumeUnknown(buf, pos, wireType)
			if err != nil {
				return err
			}
		}
	}
	return nil
}
