// Copyright The OpenTelemetry Authors
// SPDX-License-Identifier: Apache-2.0

// Code generated by "internal/cmd/pdatagen/main.go". DO NOT EDIT.
// To regenerate this file run "make genpdata".

package internal

import (
	"strconv"
	"testing"

	"github.com/stretchr/testify/assert"
	"github.com/stretchr/testify/require"
	gootlpcollectorprofiles "go.opentelemetry.io/proto/slim/otlp/collector/profiles/v1development"
	"google.golang.org/protobuf/proto"

	"go.opentelemetry.io/collector/featuregate"
	otlpcollectorprofiles "go.opentelemetry.io/collector/pdata/internal/data/protogen/collector/profiles/v1development"
	"go.opentelemetry.io/collector/pdata/internal/json"
)

func TestCopyOrigExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				dest := NewOrigExportProfilesServiceResponse()
				CopyOrigExportProfilesServiceResponse(dest, src)
				assert.Equal(t, src, dest)
				CopyOrigExportProfilesServiceResponse(dest, dest)
				assert.Equal(t, src, dest)
			})
		}
	}
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesServiceResponseUnknown(t *testing.T) {
	iter := json.BorrowIterator([]byte(`{"unknown": "string"}`))
	defer json.ReturnIterator(iter)
	dest := NewOrigExportProfilesServiceResponse()
	UnmarshalJSONOrigExportProfilesServiceResponse(dest, iter)
	require.NoError(t, iter.Error())
	assert.Equal(t, NewOrigExportProfilesServiceResponse(), dest)
}

func TestMarshalAndUnmarshalJSONOrigExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				stream := json.BorrowStream(nil)
				defer json.ReturnStream(stream)
				MarshalJSONOrigExportProfilesServiceResponse(src, stream)
				require.NoError(t, stream.Error())

				iter := json.BorrowIterator(stream.Buffer())
				defer json.ReturnIterator(iter)
				dest := NewOrigExportProfilesServiceResponse()
				UnmarshalJSONOrigExportProfilesServiceResponse(dest, iter)
				require.NoError(t, iter.Error())

				assert.Equal(t, src, dest)
				DeleteOrigExportProfilesServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoOrigExportProfilesServiceResponseFailing(t *testing.T) {
	for name, buf := range genTestFailingUnmarshalProtoValuesExportProfilesServiceResponse() {
		t.Run(name, func(t *testing.T) {
			dest := NewOrigExportProfilesServiceResponse()
			require.Error(t, UnmarshalProtoOrigExportProfilesServiceResponse(dest, buf))
		})
	}
}

func TestMarshalAndUnmarshalProtoOrigExportProfilesServiceResponseUnknown(t *testing.T) {
	dest := NewOrigExportProfilesServiceResponse()
	// message Test { required int64 field = 1313; } encoding { "field": "1234" }
	require.NoError(t, UnmarshalProtoOrigExportProfilesServiceResponse(dest, []byte{0x88, 0x52, 0xD2, 0x09}))
	assert.Equal(t, NewOrigExportProfilesServiceResponse(), dest)
}

func TestMarshalAndUnmarshalProtoOrigExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		for _, pooling := range []bool{true, false} {
			t.Run(name+"/Pooling="+strconv.FormatBool(pooling), func(t *testing.T) {
				prevPooling := UseProtoPooling.IsEnabled()
				require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), pooling))
				defer func() {
					require.NoError(t, featuregate.GlobalRegistry().Set(UseProtoPooling.ID(), prevPooling))
				}()

				buf := make([]byte, SizeProtoOrigExportProfilesServiceResponse(src))
				gotSize := MarshalProtoOrigExportProfilesServiceResponse(src, buf)
				assert.Equal(t, len(buf), gotSize)

				dest := NewOrigExportProfilesServiceResponse()
				require.NoError(t, UnmarshalProtoOrigExportProfilesServiceResponse(dest, buf))

				assert.Equal(t, src, dest)
				DeleteOrigExportProfilesServiceResponse(dest, true)
			})
		}
	}
}

func TestMarshalAndUnmarshalProtoViaProtobufExportProfilesServiceResponse(t *testing.T) {
	for name, src := range genTestEncodingValuesExportProfilesServiceResponse() {
		t.Run(name, func(t *testing.T) {
			buf := make([]byte, SizeProtoOrigExportProfilesServiceResponse(src))
			gotSize := MarshalProtoOrigExportProfilesServiceResponse(src, buf)
			assert.Equal(t, len(buf), gotSize)

			goDest := &gootlpcollectorprofiles.ExportProfilesServiceResponse{}
			require.NoError(t, proto.Unmarshal(buf, goDest))

			goBuf, err := proto.Marshal(goDest)
			require.NoError(t, err)

			dest := NewOrigExportProfilesServiceResponse()
			require.NoError(t, UnmarshalProtoOrigExportProfilesServiceResponse(dest, goBuf))
			assert.Equal(t, src, dest)
		})
	}
}

func genTestFailingUnmarshalProtoValuesExportProfilesServiceResponse() map[string][]byte {
	return map[string][]byte{
		"invalid_field":                  {0x02},
		"PartialSuccess/wrong_wire_type": {0xc},
		"PartialSuccess/missing_value":   {0xa},
	}
}

func genTestEncodingValuesExportProfilesServiceResponse() map[string]*otlpcollectorprofiles.ExportProfilesServiceResponse {
	return map[string]*otlpcollectorprofiles.ExportProfilesServiceResponse{
		"empty":               NewOrigExportProfilesServiceResponse(),
		"PartialSuccess/test": {PartialSuccess: *GenTestOrigExportProfilesPartialSuccess()},
	}
}
