// Copyright 2020 OpenTelemetry Authors
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by "internal/data_generator/main.go". DO NOT EDIT.
// To regenerate this file run "go run internal/data_generator/main.go".

package data

import (
	otlpcommon "github.com/open-telemetry/opentelemetry-proto/gen/go/common/v1"
	otlpmetrics "github.com/open-telemetry/opentelemetry-proto/gen/go/metrics/v1"
	otlpresource "github.com/open-telemetry/opentelemetry-proto/gen/go/resource/v1"
)

// ResourceMetricsSlice logically represents a slice of ResourceMetrics.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetricsSlice struct {
	orig *[]*otlpmetrics.ResourceMetrics
}

// NewResourceMetricsSlice creates a ResourceMetricsSlice with "len" empty elements.
//
// es := NewResourceMetricsSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewResourceMetricsSlice(len int) ResourceMetricsSlice {
	if len == 0 {
		orig := []*otlpmetrics.ResourceMetrics(nil)
		return ResourceMetricsSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.ResourceMetrics, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.ResourceMetrics, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return ResourceMetricsSlice{&wrappers}
}

func newResourceMetricsSlice(orig *[]*otlpmetrics.ResourceMetrics) ResourceMetricsSlice {
	return ResourceMetricsSlice{orig}
}

// Len returns the number of elements in the slice.
func (es ResourceMetricsSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es ResourceMetricsSlice) Get(ix int) ResourceMetrics {
	return newResourceMetrics((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es ResourceMetricsSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es ResourceMetricsSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewResourceMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type ResourceMetrics struct {
	// Wrap OTLP otlpmetrics.ResourceMetrics.
	orig *otlpmetrics.ResourceMetrics
}

// NewResourceMetrics creates a new empty ResourceMetrics.
func NewResourceMetrics() ResourceMetrics {
	return ResourceMetrics{&otlpmetrics.ResourceMetrics{}}
}

func newResourceMetrics(orig *otlpmetrics.ResourceMetrics) ResourceMetrics {
	return ResourceMetrics{orig}
}

// Resource returns the resource associated with this ResourceMetrics.
func (ms ResourceMetrics) Resource() Resource {
	if ms.orig.Resource == nil {
		// No Resource available, initialize one to make all operations on Resource available.
		ms.orig.Resource = &otlpresource.Resource{}
	}
	return newResource(ms.orig.Resource)
}

// SetResource replaces the resource associated with this ResourceMetrics.
func (ms ResourceMetrics) SetResource(v Resource) {
	ms.orig.Resource = v.orig
}

// InstrumentationLibraryMetrics returns the InstrumentationLibraryMetrics associated with this ResourceMetrics.
func (ms ResourceMetrics) InstrumentationLibraryMetrics() InstrumentationLibraryMetricsSlice {
	return newInstrumentationLibraryMetricsSlice(&ms.orig.InstrumentationLibraryMetrics)
}

// SetInstrumentationLibraryMetrics replaces the InstrumentationLibraryMetrics associated with this ResourceMetrics.
func (ms ResourceMetrics) SetInstrumentationLibraryMetrics(v InstrumentationLibraryMetricsSlice) {
	ms.orig.InstrumentationLibraryMetrics = *v.orig
}

// InstrumentationLibraryMetricsSlice logically represents a slice of InstrumentationLibraryMetrics.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetricsSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetricsSlice struct {
	orig *[]*otlpmetrics.InstrumentationLibraryMetrics
}

// NewInstrumentationLibraryMetricsSlice creates a InstrumentationLibraryMetricsSlice with "len" empty elements.
//
// es := NewInstrumentationLibraryMetricsSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewInstrumentationLibraryMetricsSlice(len int) InstrumentationLibraryMetricsSlice {
	if len == 0 {
		orig := []*otlpmetrics.InstrumentationLibraryMetrics(nil)
		return InstrumentationLibraryMetricsSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.InstrumentationLibraryMetrics, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.InstrumentationLibraryMetrics, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return InstrumentationLibraryMetricsSlice{&wrappers}
}

func newInstrumentationLibraryMetricsSlice(orig *[]*otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetricsSlice {
	return InstrumentationLibraryMetricsSlice{orig}
}

// Len returns the number of elements in the slice.
func (es InstrumentationLibraryMetricsSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es InstrumentationLibraryMetricsSlice) Get(ix int) InstrumentationLibraryMetrics {
	return newInstrumentationLibraryMetrics((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es InstrumentationLibraryMetricsSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es InstrumentationLibraryMetricsSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// InstrumentationLibraryMetrics is a collection of metrics from a LibraryInstrumentation.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInstrumentationLibraryMetrics function to create new instances.
// Important: zero-initialized instance is not valid for use.
type InstrumentationLibraryMetrics struct {
	// Wrap OTLP otlpmetrics.InstrumentationLibraryMetrics.
	orig *otlpmetrics.InstrumentationLibraryMetrics
}

// NewInstrumentationLibraryMetrics creates a new empty InstrumentationLibraryMetrics.
func NewInstrumentationLibraryMetrics() InstrumentationLibraryMetrics {
	return InstrumentationLibraryMetrics{&otlpmetrics.InstrumentationLibraryMetrics{}}
}

func newInstrumentationLibraryMetrics(orig *otlpmetrics.InstrumentationLibraryMetrics) InstrumentationLibraryMetrics {
	return InstrumentationLibraryMetrics{orig}
}

// InstrumentationLibrary returns the instrumentationlibrary associated with this InstrumentationLibraryMetrics.
func (ms InstrumentationLibraryMetrics) InstrumentationLibrary() InstrumentationLibrary {
	if ms.orig.InstrumentationLibrary == nil {
		// No InstrumentationLibrary available, initialize one to make all operations on InstrumentationLibrary available.
		ms.orig.InstrumentationLibrary = &otlpcommon.InstrumentationLibrary{}
	}
	return newInstrumentationLibrary(ms.orig.InstrumentationLibrary)
}

// SetInstrumentationLibrary replaces the instrumentationlibrary associated with this InstrumentationLibraryMetrics.
func (ms InstrumentationLibraryMetrics) SetInstrumentationLibrary(v InstrumentationLibrary) {
	ms.orig.InstrumentationLibrary = v.orig
}

// Metrics returns the Metrics associated with this InstrumentationLibraryMetrics.
func (ms InstrumentationLibraryMetrics) Metrics() MetricSlice {
	return newMetricSlice(&ms.orig.Metrics)
}

// SetMetrics replaces the Metrics associated with this InstrumentationLibraryMetrics.
func (ms InstrumentationLibraryMetrics) SetMetrics(v MetricSlice) {
	ms.orig.Metrics = *v.orig
}

// MetricSlice logically represents a slice of Metric.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetricSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type MetricSlice struct {
	orig *[]*otlpmetrics.Metric
}

// NewMetricSlice creates a MetricSlice with "len" empty elements.
//
// es := NewMetricSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewMetricSlice(len int) MetricSlice {
	if len == 0 {
		orig := []*otlpmetrics.Metric(nil)
		return MetricSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.Metric, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.Metric, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return MetricSlice{&wrappers}
}

func newMetricSlice(orig *[]*otlpmetrics.Metric) MetricSlice {
	return MetricSlice{orig}
}

// Len returns the number of elements in the slice.
func (es MetricSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es MetricSlice) Get(ix int) Metric {
	return newMetric((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es MetricSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es MetricSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// MetricDescriptor is the descriptor of a metric.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetric function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Metric struct {
	// Wrap OTLP otlpmetrics.Metric.
	orig *otlpmetrics.Metric
}

// NewMetric creates a new empty Metric.
func NewMetric() Metric {
	return Metric{&otlpmetrics.Metric{}}
}

func newMetric(orig *otlpmetrics.Metric) Metric {
	return Metric{orig}
}

// MetricDescriptor returns the metricdescriptor associated with this Metric.
func (ms Metric) MetricDescriptor() MetricDescriptor {
	if ms.orig.MetricDescriptor == nil {
		// No MetricDescriptor available, initialize one to make all operations on MetricDescriptor available.
		ms.orig.MetricDescriptor = &otlpmetrics.MetricDescriptor{}
	}
	return newMetricDescriptor(ms.orig.MetricDescriptor)
}

// SetMetricDescriptor replaces the metricdescriptor associated with this Metric.
func (ms Metric) SetMetricDescriptor(v MetricDescriptor) {
	ms.orig.MetricDescriptor = v.orig
}

// Int64DataPoints returns the Int64DataPoints associated with this Metric.
func (ms Metric) Int64DataPoints() Int64DataPointSlice {
	return newInt64DataPointSlice(&ms.orig.Int64DataPoints)
}

// SetInt64DataPoints replaces the Int64DataPoints associated with this Metric.
func (ms Metric) SetInt64DataPoints(v Int64DataPointSlice) {
	ms.orig.Int64DataPoints = *v.orig
}

// DoubleDataPoints returns the DoubleDataPoints associated with this Metric.
func (ms Metric) DoubleDataPoints() DoubleDataPointSlice {
	return newDoubleDataPointSlice(&ms.orig.DoubleDataPoints)
}

// SetDoubleDataPoints replaces the DoubleDataPoints associated with this Metric.
func (ms Metric) SetDoubleDataPoints(v DoubleDataPointSlice) {
	ms.orig.DoubleDataPoints = *v.orig
}

// HistogramDataPoints returns the HistogramDataPoints associated with this Metric.
func (ms Metric) HistogramDataPoints() HistogramDataPointSlice {
	return newHistogramDataPointSlice(&ms.orig.HistogramDataPoints)
}

// SetHistogramDataPoints replaces the HistogramDataPoints associated with this Metric.
func (ms Metric) SetHistogramDataPoints(v HistogramDataPointSlice) {
	ms.orig.HistogramDataPoints = *v.orig
}

// SummaryDataPoints returns the SummaryDataPoints associated with this Metric.
func (ms Metric) SummaryDataPoints() SummaryDataPointSlice {
	return newSummaryDataPointSlice(&ms.orig.SummaryDataPoints)
}

// SetSummaryDataPoints replaces the SummaryDataPoints associated with this Metric.
func (ms Metric) SetSummaryDataPoints(v SummaryDataPointSlice) {
	ms.orig.SummaryDataPoints = *v.orig
}

// MetricDescriptor is the descriptor of a metric.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewMetricDescriptor function to create new instances.
// Important: zero-initialized instance is not valid for use.
type MetricDescriptor struct {
	// Wrap OTLP otlpmetrics.MetricDescriptor.
	orig *otlpmetrics.MetricDescriptor
}

// NewMetricDescriptor creates a new empty MetricDescriptor.
func NewMetricDescriptor() MetricDescriptor {
	return MetricDescriptor{&otlpmetrics.MetricDescriptor{}}
}

func newMetricDescriptor(orig *otlpmetrics.MetricDescriptor) MetricDescriptor {
	return MetricDescriptor{orig}
}

// Name returns the name associated with this MetricDescriptor.
func (ms MetricDescriptor) Name() string {
	return ms.orig.Name
}

// SetName replaces the name associated with this MetricDescriptor.
func (ms MetricDescriptor) SetName(v string) {
	ms.orig.Name = v
}

// Description returns the description associated with this MetricDescriptor.
func (ms MetricDescriptor) Description() string {
	return ms.orig.Description
}

// SetDescription replaces the description associated with this MetricDescriptor.
func (ms MetricDescriptor) SetDescription(v string) {
	ms.orig.Description = v
}

// Unit returns the unit associated with this MetricDescriptor.
func (ms MetricDescriptor) Unit() string {
	return ms.orig.Unit
}

// SetUnit replaces the unit associated with this MetricDescriptor.
func (ms MetricDescriptor) SetUnit(v string) {
	ms.orig.Unit = v
}

// Type returns the type associated with this MetricDescriptor.
func (ms MetricDescriptor) Type() MetricType {
	return MetricType(ms.orig.Type)
}

// SetType replaces the type associated with this MetricDescriptor.
func (ms MetricDescriptor) SetType(v MetricType) {
	ms.orig.Type = otlpmetrics.MetricDescriptor_Type(v)
}

// LabelsMap returns the Labels associated with this MetricDescriptor.
func (ms MetricDescriptor) LabelsMap() StringMap {
	return newStringMap(&ms.orig.Labels)
}

// SetLabelsMap replaces the Labels associated with this MetricDescriptor.
func (ms MetricDescriptor) SetLabelsMap(v StringMap) {
	ms.orig.Labels = *v.orig
}

// Int64DataPointSlice logically represents a slice of Int64DataPoint.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInt64DataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Int64DataPointSlice struct {
	orig *[]*otlpmetrics.Int64DataPoint
}

// NewInt64DataPointSlice creates a Int64DataPointSlice with "len" empty elements.
//
// es := NewInt64DataPointSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewInt64DataPointSlice(len int) Int64DataPointSlice {
	if len == 0 {
		orig := []*otlpmetrics.Int64DataPoint(nil)
		return Int64DataPointSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.Int64DataPoint, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.Int64DataPoint, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return Int64DataPointSlice{&wrappers}
}

func newInt64DataPointSlice(orig *[]*otlpmetrics.Int64DataPoint) Int64DataPointSlice {
	return Int64DataPointSlice{orig}
}

// Len returns the number of elements in the slice.
func (es Int64DataPointSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es Int64DataPointSlice) Get(ix int) Int64DataPoint {
	return newInt64DataPoint((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es Int64DataPointSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es Int64DataPointSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// Int64DataPoint is a single data point in a timeseries that describes the time-varying values of a int64 metric.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewInt64DataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type Int64DataPoint struct {
	// Wrap OTLP otlpmetrics.Int64DataPoint.
	orig *otlpmetrics.Int64DataPoint
}

// NewInt64DataPoint creates a new empty Int64DataPoint.
func NewInt64DataPoint() Int64DataPoint {
	return Int64DataPoint{&otlpmetrics.Int64DataPoint{}}
}

func newInt64DataPoint(orig *otlpmetrics.Int64DataPoint) Int64DataPoint {
	return Int64DataPoint{orig}
}

// LabelsMap returns the Labels associated with this Int64DataPoint.
func (ms Int64DataPoint) LabelsMap() StringMap {
	return newStringMap(&ms.orig.Labels)
}

// SetLabelsMap replaces the Labels associated with this Int64DataPoint.
func (ms Int64DataPoint) SetLabelsMap(v StringMap) {
	ms.orig.Labels = *v.orig
}

// StartTime returns the starttime associated with this Int64DataPoint.
func (ms Int64DataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this Int64DataPoint.
func (ms Int64DataPoint) SetStartTime(v TimestampUnixNano) {
	ms.orig.StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this Int64DataPoint.
func (ms Int64DataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this Int64DataPoint.
func (ms Int64DataPoint) SetTimestamp(v TimestampUnixNano) {
	ms.orig.TimeUnixNano = uint64(v)
}

// Value returns the value associated with this Int64DataPoint.
func (ms Int64DataPoint) Value() int64 {
	return ms.orig.Value
}

// SetValue replaces the value associated with this Int64DataPoint.
func (ms Int64DataPoint) SetValue(v int64) {
	ms.orig.Value = v
}

// DoubleDataPointSlice logically represents a slice of DoubleDataPoint.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPointSlice struct {
	orig *[]*otlpmetrics.DoubleDataPoint
}

// NewDoubleDataPointSlice creates a DoubleDataPointSlice with "len" empty elements.
//
// es := NewDoubleDataPointSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewDoubleDataPointSlice(len int) DoubleDataPointSlice {
	if len == 0 {
		orig := []*otlpmetrics.DoubleDataPoint(nil)
		return DoubleDataPointSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.DoubleDataPoint, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.DoubleDataPoint, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return DoubleDataPointSlice{&wrappers}
}

func newDoubleDataPointSlice(orig *[]*otlpmetrics.DoubleDataPoint) DoubleDataPointSlice {
	return DoubleDataPointSlice{orig}
}

// Len returns the number of elements in the slice.
func (es DoubleDataPointSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es DoubleDataPointSlice) Get(ix int) DoubleDataPoint {
	return newDoubleDataPoint((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es DoubleDataPointSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es DoubleDataPointSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// DoubleDataPoint is a single data point in a timeseries that describes the time-varying value of a double metric.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewDoubleDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type DoubleDataPoint struct {
	// Wrap OTLP otlpmetrics.DoubleDataPoint.
	orig *otlpmetrics.DoubleDataPoint
}

// NewDoubleDataPoint creates a new empty DoubleDataPoint.
func NewDoubleDataPoint() DoubleDataPoint {
	return DoubleDataPoint{&otlpmetrics.DoubleDataPoint{}}
}

func newDoubleDataPoint(orig *otlpmetrics.DoubleDataPoint) DoubleDataPoint {
	return DoubleDataPoint{orig}
}

// LabelsMap returns the Labels associated with this DoubleDataPoint.
func (ms DoubleDataPoint) LabelsMap() StringMap {
	return newStringMap(&ms.orig.Labels)
}

// SetLabelsMap replaces the Labels associated with this DoubleDataPoint.
func (ms DoubleDataPoint) SetLabelsMap(v StringMap) {
	ms.orig.Labels = *v.orig
}

// StartTime returns the starttime associated with this DoubleDataPoint.
func (ms DoubleDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this DoubleDataPoint.
func (ms DoubleDataPoint) SetStartTime(v TimestampUnixNano) {
	ms.orig.StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this DoubleDataPoint.
func (ms DoubleDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this DoubleDataPoint.
func (ms DoubleDataPoint) SetTimestamp(v TimestampUnixNano) {
	ms.orig.TimeUnixNano = uint64(v)
}

// Value returns the value associated with this DoubleDataPoint.
func (ms DoubleDataPoint) Value() float64 {
	return ms.orig.Value
}

// SetValue replaces the value associated with this DoubleDataPoint.
func (ms DoubleDataPoint) SetValue(v float64) {
	ms.orig.Value = v
}

// HistogramDataPointSlice logically represents a slice of HistogramDataPoint.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramDataPointSlice struct {
	orig *[]*otlpmetrics.HistogramDataPoint
}

// NewHistogramDataPointSlice creates a HistogramDataPointSlice with "len" empty elements.
//
// es := NewHistogramDataPointSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewHistogramDataPointSlice(len int) HistogramDataPointSlice {
	if len == 0 {
		orig := []*otlpmetrics.HistogramDataPoint(nil)
		return HistogramDataPointSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.HistogramDataPoint, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.HistogramDataPoint, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return HistogramDataPointSlice{&wrappers}
}

func newHistogramDataPointSlice(orig *[]*otlpmetrics.HistogramDataPoint) HistogramDataPointSlice {
	return HistogramDataPointSlice{orig}
}

// Len returns the number of elements in the slice.
func (es HistogramDataPointSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es HistogramDataPointSlice) Get(ix int) HistogramDataPoint {
	return newHistogramDataPoint((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es HistogramDataPointSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es HistogramDataPointSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// HistogramDataPoint is a single data point in a timeseries that describes the time-varying values of a Histogram.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramDataPoint struct {
	// Wrap OTLP otlpmetrics.HistogramDataPoint.
	orig *otlpmetrics.HistogramDataPoint
}

// NewHistogramDataPoint creates a new empty HistogramDataPoint.
func NewHistogramDataPoint() HistogramDataPoint {
	return HistogramDataPoint{&otlpmetrics.HistogramDataPoint{}}
}

func newHistogramDataPoint(orig *otlpmetrics.HistogramDataPoint) HistogramDataPoint {
	return HistogramDataPoint{orig}
}

// LabelsMap returns the Labels associated with this HistogramDataPoint.
func (ms HistogramDataPoint) LabelsMap() StringMap {
	return newStringMap(&ms.orig.Labels)
}

// SetLabelsMap replaces the Labels associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetLabelsMap(v StringMap) {
	ms.orig.Labels = *v.orig
}

// StartTime returns the starttime associated with this HistogramDataPoint.
func (ms HistogramDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetStartTime(v TimestampUnixNano) {
	ms.orig.StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetTimestamp(v TimestampUnixNano) {
	ms.orig.TimeUnixNano = uint64(v)
}

// Count returns the count associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Count() uint64 {
	return ms.orig.Count
}

// SetCount replaces the count associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetCount(v uint64) {
	ms.orig.Count = v
}

// Sum returns the sum associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Sum() float64 {
	return ms.orig.Sum
}

// SetSum replaces the sum associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetSum(v float64) {
	ms.orig.Sum = v
}

// Buckets returns the Buckets associated with this HistogramDataPoint.
func (ms HistogramDataPoint) Buckets() HistogramBucketSlice {
	return newHistogramBucketSlice(&ms.orig.Buckets)
}

// SetBuckets replaces the Buckets associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetBuckets(v HistogramBucketSlice) {
	ms.orig.Buckets = *v.orig
}

// ExplicitBounds returns the explicitbounds associated with this HistogramDataPoint.
func (ms HistogramDataPoint) ExplicitBounds() []float64 {
	return ms.orig.ExplicitBounds
}

// SetExplicitBounds replaces the explicitbounds associated with this HistogramDataPoint.
func (ms HistogramDataPoint) SetExplicitBounds(v []float64) {
	ms.orig.ExplicitBounds = v
}

// HistogramBucketSlice logically represents a slice of HistogramBucket.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramBucketSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramBucketSlice struct {
	orig *[]*otlpmetrics.HistogramDataPoint_Bucket
}

// NewHistogramBucketSlice creates a HistogramBucketSlice with "len" empty elements.
//
// es := NewHistogramBucketSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewHistogramBucketSlice(len int) HistogramBucketSlice {
	if len == 0 {
		orig := []*otlpmetrics.HistogramDataPoint_Bucket(nil)
		return HistogramBucketSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.HistogramDataPoint_Bucket, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.HistogramDataPoint_Bucket, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return HistogramBucketSlice{&wrappers}
}

func newHistogramBucketSlice(orig *[]*otlpmetrics.HistogramDataPoint_Bucket) HistogramBucketSlice {
	return HistogramBucketSlice{orig}
}

// Len returns the number of elements in the slice.
func (es HistogramBucketSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es HistogramBucketSlice) Get(ix int) HistogramBucket {
	return newHistogramBucket((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es HistogramBucketSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es HistogramBucketSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// HistogramBucket contains values for a histogram bucket.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramBucket function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramBucket struct {
	// Wrap OTLP otlpmetrics.HistogramDataPoint_Bucket.
	orig *otlpmetrics.HistogramDataPoint_Bucket
}

// NewHistogramBucket creates a new empty HistogramBucket.
func NewHistogramBucket() HistogramBucket {
	return HistogramBucket{&otlpmetrics.HistogramDataPoint_Bucket{}}
}

func newHistogramBucket(orig *otlpmetrics.HistogramDataPoint_Bucket) HistogramBucket {
	return HistogramBucket{orig}
}

// Count returns the count associated with this HistogramBucket.
func (ms HistogramBucket) Count() uint64 {
	return ms.orig.Count
}

// SetCount replaces the count associated with this HistogramBucket.
func (ms HistogramBucket) SetCount(v uint64) {
	ms.orig.Count = v
}

// Exemplar returns the exemplar associated with this HistogramBucket.
func (ms HistogramBucket) Exemplar() HistogramBucketExemplar {
	if ms.orig.Exemplar == nil {
		// No Exemplar available, initialize one to make all operations on HistogramBucketExemplar available.
		ms.orig.Exemplar = &otlpmetrics.HistogramDataPoint_Bucket_Exemplar{}
	}
	return newHistogramBucketExemplar(ms.orig.Exemplar)
}

// SetExemplar replaces the exemplar associated with this HistogramBucket.
func (ms HistogramBucket) SetExemplar(v HistogramBucketExemplar) {
	ms.orig.Exemplar = v.orig
}

// HistogramBucketExemplar are example points that may be used to annotate aggregated Histogram values.
// They are metadata that gives information about a particular value added to a Histogram bucket.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewHistogramBucketExemplar function to create new instances.
// Important: zero-initialized instance is not valid for use.
type HistogramBucketExemplar struct {
	// Wrap OTLP otlpmetrics.HistogramDataPoint_Bucket_Exemplar.
	orig *otlpmetrics.HistogramDataPoint_Bucket_Exemplar
}

// NewHistogramBucketExemplar creates a new empty HistogramBucketExemplar.
func NewHistogramBucketExemplar() HistogramBucketExemplar {
	return HistogramBucketExemplar{&otlpmetrics.HistogramDataPoint_Bucket_Exemplar{}}
}

func newHistogramBucketExemplar(orig *otlpmetrics.HistogramDataPoint_Bucket_Exemplar) HistogramBucketExemplar {
	return HistogramBucketExemplar{orig}
}

// Timestamp returns the timestamp associated with this HistogramBucketExemplar.
func (ms HistogramBucketExemplar) Timestamp() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this HistogramBucketExemplar.
func (ms HistogramBucketExemplar) SetTimestamp(v TimestampUnixNano) {
	ms.orig.TimeUnixNano = uint64(v)
}

// Value returns the value associated with this HistogramBucketExemplar.
func (ms HistogramBucketExemplar) Value() float64 {
	return ms.orig.Value
}

// SetValue replaces the value associated with this HistogramBucketExemplar.
func (ms HistogramBucketExemplar) SetValue(v float64) {
	ms.orig.Value = v
}

// Attachments returns the Attachments associated with this HistogramBucketExemplar.
func (ms HistogramBucketExemplar) Attachments() StringMap {
	return newStringMap(&ms.orig.Attachments)
}

// SetAttachments replaces the Attachments associated with this HistogramBucketExemplar.
func (ms HistogramBucketExemplar) SetAttachments(v StringMap) {
	ms.orig.Attachments = *v.orig
}

// SummaryDataPointSlice logically represents a slice of SummaryDataPoint.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryDataPointSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryDataPointSlice struct {
	orig *[]*otlpmetrics.SummaryDataPoint
}

// NewSummaryDataPointSlice creates a SummaryDataPointSlice with "len" empty elements.
//
// es := NewSummaryDataPointSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewSummaryDataPointSlice(len int) SummaryDataPointSlice {
	if len == 0 {
		orig := []*otlpmetrics.SummaryDataPoint(nil)
		return SummaryDataPointSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.SummaryDataPoint, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.SummaryDataPoint, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return SummaryDataPointSlice{&wrappers}
}

func newSummaryDataPointSlice(orig *[]*otlpmetrics.SummaryDataPoint) SummaryDataPointSlice {
	return SummaryDataPointSlice{orig}
}

// Len returns the number of elements in the slice.
func (es SummaryDataPointSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es SummaryDataPointSlice) Get(ix int) SummaryDataPoint {
	return newSummaryDataPoint((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es SummaryDataPointSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es SummaryDataPointSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// SummaryDataPoint is a single data point in a timeseries that describes the time-varying values of a Summary metric.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryDataPoint function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryDataPoint struct {
	// Wrap OTLP otlpmetrics.SummaryDataPoint.
	orig *otlpmetrics.SummaryDataPoint
}

// NewSummaryDataPoint creates a new empty SummaryDataPoint.
func NewSummaryDataPoint() SummaryDataPoint {
	return SummaryDataPoint{&otlpmetrics.SummaryDataPoint{}}
}

func newSummaryDataPoint(orig *otlpmetrics.SummaryDataPoint) SummaryDataPoint {
	return SummaryDataPoint{orig}
}

// LabelsMap returns the Labels associated with this SummaryDataPoint.
func (ms SummaryDataPoint) LabelsMap() StringMap {
	return newStringMap(&ms.orig.Labels)
}

// SetLabelsMap replaces the Labels associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetLabelsMap(v StringMap) {
	ms.orig.Labels = *v.orig
}

// StartTime returns the starttime associated with this SummaryDataPoint.
func (ms SummaryDataPoint) StartTime() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.StartTimeUnixNano)
}

// SetStartTime replaces the starttime associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetStartTime(v TimestampUnixNano) {
	ms.orig.StartTimeUnixNano = uint64(v)
}

// Timestamp returns the timestamp associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Timestamp() TimestampUnixNano {
	return TimestampUnixNano(ms.orig.TimeUnixNano)
}

// SetTimestamp replaces the timestamp associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetTimestamp(v TimestampUnixNano) {
	ms.orig.TimeUnixNano = uint64(v)
}

// Count returns the count associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Count() uint64 {
	return ms.orig.Count
}

// SetCount replaces the count associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetCount(v uint64) {
	ms.orig.Count = v
}

// Sum returns the sum associated with this SummaryDataPoint.
func (ms SummaryDataPoint) Sum() float64 {
	return ms.orig.Sum
}

// SetSum replaces the sum associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetSum(v float64) {
	ms.orig.Sum = v
}

// ValueAtPercentiles returns the PercentileValues associated with this SummaryDataPoint.
func (ms SummaryDataPoint) ValueAtPercentiles() SummaryValueAtPercentileSlice {
	return newSummaryValueAtPercentileSlice(&ms.orig.PercentileValues)
}

// SetValueAtPercentiles replaces the PercentileValues associated with this SummaryDataPoint.
func (ms SummaryDataPoint) SetValueAtPercentiles(v SummaryValueAtPercentileSlice) {
	ms.orig.PercentileValues = *v.orig
}

// SummaryValueAtPercentileSlice logically represents a slice of SummaryValueAtPercentile.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryValueAtPercentileSlice function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryValueAtPercentileSlice struct {
	orig *[]*otlpmetrics.SummaryDataPoint_ValueAtPercentile
}

// NewSummaryValueAtPercentileSlice creates a SummaryValueAtPercentileSlice with "len" empty elements.
//
// es := NewSummaryValueAtPercentileSlice(4)
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     // Here should set all the values for e.
// }
func NewSummaryValueAtPercentileSlice(len int) SummaryValueAtPercentileSlice {
	if len == 0 {
		orig := []*otlpmetrics.SummaryDataPoint_ValueAtPercentile(nil)
		return SummaryValueAtPercentileSlice{&orig}
	}
	// Slice for underlying orig.
	origs := make([]otlpmetrics.SummaryDataPoint_ValueAtPercentile, len)
	// Slice for wrappers.
	wrappers := make([]*otlpmetrics.SummaryDataPoint_ValueAtPercentile, len)
	for i := range origs {
		wrappers[i] = &origs[i]
	}
	return SummaryValueAtPercentileSlice{&wrappers}
}

func newSummaryValueAtPercentileSlice(orig *[]*otlpmetrics.SummaryDataPoint_ValueAtPercentile) SummaryValueAtPercentileSlice {
	return SummaryValueAtPercentileSlice{orig}
}

// Len returns the number of elements in the slice.
func (es SummaryValueAtPercentileSlice) Len() int {
	return len(*es.orig)
}

// Get the element at the given index.
//
// This function is used mostly for iterating over all the values in the slice:
// for i := 0; i < es.Len(); i++ {
//     e := es.Get(i)
//     ... // Do something with the element
// }
func (es SummaryValueAtPercentileSlice) Get(ix int) SummaryValueAtPercentile {
	return newSummaryValueAtPercentile((*es.orig)[ix])
}

// Remove the element at the given index from the slice.
// Elements after the removed one are shifted to fill the emptied space.
// The length of the slice is reduced by one.
func (es SummaryValueAtPercentileSlice) Remove(ix int) {
	(*es.orig)[ix] = (*es.orig)[len(*es.orig)-1]
	(*es.orig)[len(*es.orig)-1] = nil
	*es.orig = (*es.orig)[:len(*es.orig)-1]
}

// Resize the slice. This operation is equivalent with slice[from:to].
func (es SummaryValueAtPercentileSlice) Resize(from, to int) {
	*es.orig = (*es.orig)[from:to]
}

// SummaryValueAtPercentile represents the value at a given percentile of a distribution.
//
// This is a reference type, if passsed by value and callee modifies it the
// caller will see the modification.
//
// Must use NewSummaryValueAtPercentile function to create new instances.
// Important: zero-initialized instance is not valid for use.
type SummaryValueAtPercentile struct {
	// Wrap OTLP otlpmetrics.SummaryDataPoint_ValueAtPercentile.
	orig *otlpmetrics.SummaryDataPoint_ValueAtPercentile
}

// NewSummaryValueAtPercentile creates a new empty SummaryValueAtPercentile.
func NewSummaryValueAtPercentile() SummaryValueAtPercentile {
	return SummaryValueAtPercentile{&otlpmetrics.SummaryDataPoint_ValueAtPercentile{}}
}

func newSummaryValueAtPercentile(orig *otlpmetrics.SummaryDataPoint_ValueAtPercentile) SummaryValueAtPercentile {
	return SummaryValueAtPercentile{orig}
}

// Percentile returns the percentile associated with this SummaryValueAtPercentile.
func (ms SummaryValueAtPercentile) Percentile() float64 {
	return ms.orig.Percentile
}

// SetPercentile replaces the percentile associated with this SummaryValueAtPercentile.
func (ms SummaryValueAtPercentile) SetPercentile(v float64) {
	ms.orig.Percentile = v
}

// Value returns the value associated with this SummaryValueAtPercentile.
func (ms SummaryValueAtPercentile) Value() float64 {
	return ms.orig.Value
}

// SetValue replaces the value associated with this SummaryValueAtPercentile.
func (ms SummaryValueAtPercentile) SetValue(v float64) {
	ms.orig.Value = v
}
